/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import com.thunder.livesdk.helper.IPtotoPacket;
import com.thunder.livesdk.log.ThunderLog;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Marshallable
implements IPtotoPacket {
    public static final int kProtoPacketSize = 4096;
    protected ByteBuffer mBuffer = null;

    public Marshallable() {
        this.mBuffer = ByteBuffer.allocate(4096);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Marshallable(boolean bAllocBuff) {
        if (bAllocBuff) {
            this.mBuffer = ByteBuffer.allocate(4096);
            this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public Marshallable(int buffSize) {
        this.mBuffer = ByteBuffer.allocate(buffSize);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte[] marshall() {
        return this.mBuffer.array();
    }

    @Override
    public void marshall(ByteBuffer buf) {
        this.mBuffer = buf;
    }

    @Override
    public void unmarshall(byte[] buf) {
        this.mBuffer = ByteBuffer.wrap(buf);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void unmarshall(ByteBuffer buf) {
        this.mBuffer = buf;
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public void pushBool(Boolean val) {
        byte b = 0;
        if (val.booleanValue()) {
            b = 1;
        }
        this.check_capactiy(1);
        this.mBuffer.put(b);
    }

    public Boolean popBool() {
        byte b = this.mBuffer.get();
        return b == 1;
    }

    public void pushByte(byte val) {
        this.check_capactiy(1);
        this.mBuffer.put(val);
    }

    public byte popByte() {
        return this.mBuffer.get();
    }

    public void pushBytes(byte[] buf) {
        if (buf == null) {
            this.check_capactiy(2);
            this.mBuffer.putShort((short)0);
        } else if (buf.length > 65535) {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info("ysdk-Java", "pushBytes, buf overflow, size=" + buf.length);
            }
            this.check_capactiy(2);
            this.mBuffer.putShort((short)0);
        } else {
            this.check_capactiy(2 + buf.length);
            this.mBuffer.putShort((short)buf.length);
            this.mBuffer.put(buf);
        }
    }

    public byte[] popBytes() {
        short len = this.mBuffer.getShort();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
        }
        return buf;
    }

    public void pushBytes32(byte[] buf) {
        if (buf == null) {
            this.check_capactiy(4);
            this.mBuffer.putInt(0);
        } else {
            this.check_capactiy(4 + buf.length);
            this.mBuffer.putInt(buf.length);
            this.mBuffer.put(buf);
        }
    }

    public byte[] popBytes32() {
        int len = this.mBuffer.getInt();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
        }
        return buf;
    }

    public byte[] popAll() {
        int len = this.mBuffer.remaining();
        byte[] buf = new byte[len];
        this.mBuffer.get(buf);
        return buf;
    }

    public void pushShort(short val) {
        this.check_capactiy(2);
        this.mBuffer.putShort(val);
    }

    public short popShort() {
        return this.mBuffer.getShort();
    }

    public void pushInt(int val) {
        this.check_capactiy(4);
        this.mBuffer.putInt(val);
    }

    public void pushInt(long val) {
        this.check_capactiy(4);
        this.mBuffer.putInt((int)val);
    }

    public void pushFloat(float val) {
        this.check_capactiy(4);
        this.mBuffer.putFloat(val);
    }

    public float popFloat() {
        return this.mBuffer.getFloat();
    }

    public int popInt() {
        if (this.mBuffer.remaining() < 4) {
            return 0;
        }
        return this.mBuffer.getInt();
    }

    public long popInt2Long() {
        return (long)this.mBuffer.getInt() & 0xFFFFFFFFL;
    }

    public void pushInt64(long val) {
        this.check_capactiy(8);
        this.mBuffer.putLong(val);
    }

    public long popInt64() {
        return this.mBuffer.getLong();
    }

    public void pushString16(String val) {
        if (val == null) {
            this.check_capactiy(2);
            this.mBuffer.putShort((short)0);
            return;
        }
        this.check_capactiy(2 + val.getBytes().length);
        this.mBuffer.putShort((short)val.getBytes().length);
        if (val.getBytes().length > 0) {
            this.mBuffer.put(val.getBytes());
        }
    }

    public String popString16() {
        short len = this.mBuffer.getShort();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
            try {
                return new String(buf, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String popString16UTF8() {
        short len = this.mBuffer.getShort();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
            try {
                return new String(buf, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public void pushIntArray(int[] vals) {
        if (vals == null) {
            this.pushInt(0);
            return;
        }
        int len = vals.length;
        this.pushInt(len);
        for (int i = 0; i < len; ++i) {
            this.pushInt(vals[i]);
        }
    }

    public void pushIntArray(Integer[] vals) {
        if (vals == null) {
            this.pushInt(0);
            return;
        }
        int len = vals.length;
        this.pushInt(len);
        for (int i = 0; i < len; ++i) {
            this.pushInt(vals[i]);
        }
    }

    public void pushIntArray(long[] vals) {
        if (vals == null) {
            this.pushInt(0);
            return;
        }
        int len = vals.length;
        this.pushInt(len);
        for (int i = 0; i < len; ++i) {
            this.pushInt(vals[i]);
        }
    }

    public int[] popIntArray() {
        int len = this.popInt();
        int[] vals = new int[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.popInt();
        }
        return vals;
    }

    public long[] popIntArray2Long() {
        int len = this.popInt();
        long[] vals = new long[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.popInt2Long();
        }
        return vals;
    }

    public void pushShortArray(short[] vals) {
        if (vals == null) {
            this.pushInt(0);
            return;
        }
        int len = vals.length;
        this.pushInt(len);
        for (int i = 0; i < len; ++i) {
            this.pushShort(vals[i]);
        }
    }

    public short[] popShortArray() {
        int len = this.popInt();
        short[] vals = new short[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.popShort();
        }
        return vals;
    }

    public String popString32() {
        int len = this.mBuffer.getInt();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
            try {
                return new String(buf, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String popString16(String charsetName) {
        short len = this.mBuffer.getShort();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
            try {
                return new String(buf, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public void pushString32(String val) {
        if (val == null) {
            this.check_capactiy(4);
            this.mBuffer.putInt(0);
            return;
        }
        this.check_capactiy(4 + val.getBytes().length);
        this.mBuffer.putInt(val.getBytes().length);
        if (val.getBytes().length > 0) {
            this.mBuffer.put(val.getBytes());
        }
    }

    public void pushString32(String val, String charsetName) {
        if (val == null) {
            this.check_capactiy(4);
            this.mBuffer.putInt(0);
            return;
        }
        try {
            this.check_capactiy(4 + val.getBytes().length);
            this.mBuffer.putInt(val.getBytes(charsetName).length);
            if (val.getBytes().length > 0) {
                this.mBuffer.put(val.getBytes(charsetName));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String popString32(String charsetName) {
        int len = this.mBuffer.getInt();
        byte[] buf = null;
        if (len >= 0) {
            buf = new byte[len];
            this.mBuffer.get(buf);
            try {
                return new String(buf, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected void check_capactiy(int size) {
        if (this.mBuffer.capacity() - this.mBuffer.position() < size) {
            this.increase_capacity(size - (this.mBuffer.capacity() - this.mBuffer.position()));
        }
    }

    protected void increase_capacity(int minIncrement) {
        int capacity = this.mBuffer.capacity();
        if (capacity == 0) {
            return;
        }
        int size = 2 * capacity;
        if (minIncrement > capacity) {
            size = capacity + minIncrement;
        }
        ByteBuffer tempBuf = ByteBuffer.allocate(size);
        tempBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.mBuffer.limit(this.mBuffer.position());
        this.mBuffer.position(0);
        tempBuf.put(this.mBuffer);
        this.mBuffer = tempBuf;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info("ysdk-Java", "increase_capacity, size=" + size);
        }
    }

    public void pushMarshallable(Marshallable val) {
        if (val != null) {
            val.marshall(this.mBuffer);
        }
    }

    public Marshallable popMarshallable(Class<? extends Marshallable> MarshalClass) {
        Marshallable val = null;
        try {
            val = MarshalClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        val.unmarshall(this.mBuffer);
        return val;
    }

    private <K> void pushKey(K key, ELenType lenType) {
        if (key instanceof Byte) {
            this.pushByte((Byte)key);
        } else if (key instanceof Short) {
            this.pushShort((Short)key);
        } else if (key instanceof Integer) {
            this.pushInt((Integer)key);
        } else if (key instanceof Long) {
            this.pushInt64((Long)key);
        } else if (key instanceof String) {
            this.pushString16((String)key);
        } else if (key instanceof byte[]) {
            this.pushBytes((byte[])key);
        } else {
            throw new IllegalStateException("marshall Map but unknown key type: " + key.getClass().getName());
        }
    }

    private <K> K popKey(Class<K> keyClass, ELenType lenType, String charsetName) {
        Object key = null;
        if (keyClass == Byte.class) {
            key = (short)this.popByte();
        } else if (keyClass == Short.class) {
            key = this.popShort();
        } else if (keyClass == Integer.class) {
            key = this.popInt();
        } else if (keyClass == Long.class) {
            key = this.popInt64();
        } else if (keyClass == byte[].class) {
            if (lenType == ELenType.E_SHORT) {
                key = this.popBytes();
            } else if (lenType == ELenType.E_INT) {
                key = this.popBytes32();
            } else {
                ThunderLog.warn("ysdk-Java", "ysdk-Java", new Object[]{"invalid lenType=%d for popBytes", lenType});
            }
        } else if (keyClass == String.class) {
            if (lenType == ELenType.E_SHORT) {
                key = this.popString16(charsetName);
            } else if (lenType == ELenType.E_INT) {
                key = this.popString32(charsetName);
            } else {
                ThunderLog.warn("ysdk-Java", "invalid lenType=%d for popString", new Object[]{lenType});
            }
        } else {
            throw new IllegalStateException("unMarshall Map but unknown key type: " + keyClass.getName());
        }
        return (K)key;
    }

    private <T> void pushElem(T elem, Class<T> elemClass, ELenType lenType) {
        if (elemClass == Integer.class) {
            this.pushInt((Integer)elem);
        } else if (elemClass == Short.class) {
            this.pushShort((Short)elem);
        } else if (elemClass == Long.class) {
            this.pushInt64((Long)elem);
        } else if (elemClass == Byte.class) {
            this.pushByte((Byte)elem);
        } else if (elemClass == String.class) {
            if (lenType == ELenType.E_SHORT) {
                this.pushString16((String)elem);
            } else if (lenType == ELenType.E_INT) {
                this.pushString32((String)elem);
            } else {
                ThunderLog.warn("ysdk-Java", "invalid lenType=%d for pushString", new Object[]{lenType});
            }
        } else if (elemClass == byte[].class) {
            if (lenType == ELenType.E_SHORT) {
                this.pushBytes((byte[])elem);
            } else if (lenType == ELenType.E_INT) {
                this.pushBytes32((byte[])elem);
            } else {
                ThunderLog.warn("ysdk-Java", "invalid lenType=%d for pushBytes", new Object[]{lenType});
            }
        } else if (elem instanceof Marshallable) {
            ((Marshallable)elem).marshall(this.mBuffer);
        } else {
            throw new RuntimeException("unable to marshal element of class " + elemClass.getName());
        }
    }

    private <T> T popElem(Class<T> elemClass, ELenType lenType, String charsetName) {
        Object elem = null;
        if (elemClass == Integer.class) {
            elem = this.popInt();
        } else if (elemClass == Short.class) {
            elem = this.popShort();
        } else if (elemClass == Long.class) {
            elem = this.popInt64();
        } else if (elemClass == Byte.class) {
            elem = this.popByte();
        } else if (elemClass == String.class) {
            if (lenType == ELenType.E_SHORT) {
                elem = this.popString16(charsetName);
            } else if (lenType == ELenType.E_INT) {
                elem = this.popString32(charsetName);
            } else {
                ThunderLog.warn("ysdk-Java", "invalid lenType=%d for popString", new Object[]{lenType});
            }
        } else if (elemClass == byte[].class) {
            if (lenType == ELenType.E_SHORT) {
                elem = this.popBytes();
            } else if (lenType == ELenType.E_INT) {
                elem = this.popBytes32();
            } else {
                ThunderLog.warn("ysdk-Java", "invalid lenType=%d for popBytes", new Object[]{lenType});
            }
        } else {
            try {
                elem = elemClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (elem instanceof Marshallable) {
                ((Marshallable)elem).unmarshall(this.mBuffer);
            } else {
                ThunderLog.warn("ysdk-Java", "unmarshall invalid elemClass type=%s ", elemClass.getName());
            }
        }
        return (T)elem;
    }

    public <T> void pushCollection(Collection<T> data, Class<T> elemClass, ELenType lenType) {
        if (data == null || data.size() == 0) {
            this.pushInt(0);
        } else {
            this.pushInt(data.size());
            for (T elem : data) {
                this.pushElem(elem, elemClass, lenType);
            }
        }
    }

    public <T> void pushCollection(Collection<T> data, Class<T> elemClass) {
        this.pushCollection(data, elemClass, ELenType.E_NONE);
    }

    public <T> Collection<T> popCollection(Class<? extends Collection> container, Class<T> elemClass) {
        return this.popCollection(container, elemClass, ELenType.E_SHORT, "utf-8");
    }

    public <T> Collection<T> popCollection(Class<? extends Collection> container, Class<T> elemClass, ELenType lenType, String charsetName) {
        int size = this.popInt();
        Collection c = null;
        try {
            c = container.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        if (c == null) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            Object elem = null;
            elem = this.popElem(elemClass, lenType, charsetName);
            c.add(elem);
        }
        return c;
    }

    public <K, T> void pushMap(Map<K, T> data, Class<T> elemClass) {
        this.pushMap(data, elemClass, ELenType.E_SHORT, ELenType.E_SHORT);
    }

    public <K, T> void pushMap(Map<K, T> data, Class<T> elemClass, ELenType keyLenType, ELenType valueLenType) {
        if (data == null || data.size() == 0) {
            this.pushInt(0);
        } else {
            this.pushInt(data.size());
            for (Map.Entry<K, T> entry : data.entrySet()) {
                K key = entry.getKey();
                this.pushKey(key, keyLenType);
                T elem = entry.getValue();
                this.pushElem(elem, elemClass, valueLenType);
            }
        }
    }

    public <K, T> Map<K, T> popMap(Class<K> keyClass, Class<T> elemClass) {
        return this.popMap(keyClass, ELenType.E_SHORT, "utf-8", elemClass, ELenType.E_SHORT, "utf-8");
    }

    public <K, T> Map<K, T> popMap(Class<K> keyClass, ELenType keyLenType, String keyCharsetName, Class<T> elemClass, ELenType elemLenType, String elemCharsetName) {
        int size = this.popInt();
        TreeMap<Object, Object> out = new TreeMap<Object, Object>();
        for (int i = 0; i < size; ++i) {
            Object key = null;
            key = this.popKey(keyClass, keyLenType, keyCharsetName);
            Object elem = null;
            elem = this.popElem(elemClass, elemLenType, elemCharsetName);
            out.put(key, elem);
        }
        return out;
    }

    public static enum ELenType {
        E_SHORT,
        E_INT,
        E_NONE;

    }
}

