/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.thunder.livesdk.IThunderAudioFilePlayerEventCallback;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.log.ThunderLog;
import com.yy.audioengine.MainHandler;

public class ThunderAudioFilePlayer
implements Comparable<ThunderAudioFilePlayer> {
    private Object mCallbackLock = new Object();
    private Object mPlayerLock = new Object();
    private IThunderAudioFilePlayerCallback mCallback = null;
    private IThunderAudioFilePlayerEventCallback mEventCallback = null;
    private long nativeCtx = ThunderNative.createAudioFilePlayer(this);
    private boolean mIsDestroy = false;
    private String mFilePath = null;
    private boolean mIsMixStandard = false;
    @Deprecated
    private final int PLAY_EVENT_PLAYING = 2;
    public static final int AUDIO_PLAY_EVENT_OPEN = 1;
    public static final int AUDIO_PLAY_EVENT_PLAY = 2;
    public static final int AUDIO_PLAY_EVENT_STOP = 3;
    public static final int AUDIO_PLAY_EVENT_PAUSE = 4;
    public static final int AUDIO_PLAY_EVENT_RESUME = 5;
    public static final int AUDIO_PLAY_EVENT_END = 6;
    public static final int AUDIO_PLAY_EVENT_SEEK_COMPLETE = 7;
    public static final int AUDIO_PLAYER_STATUS_SUCCESS = 0;
    public static final int AUDIO_PLAYER_CREATE_FILE_DECODER_FAILED = -1;
    public static final int AUDIO_PLAYER_OPEN_FILE_DECODER_FAILED = -2;
    public static final int AUDIO_PLAYER_OPEN_FILE_FORMAT_NOT_SUPPORT = -3;
    public static final int AUDIO_PLAYER_OPEN_FILE_PATH_ERROR = -4;
    @Deprecated
    private final int AUDIO_PLAY_EVENT_VOLUME = 8;
    @Deprecated
    private final int AUDIO_PLAY_EVENT_ERROR = 9;
    private HandlerThread mPlayerQueueThread = new HandlerThread("PlayerQueueThread");
    private Handler mPlayerQueueHandler;

    public ThunderAudioFilePlayer() {
        this.mPlayerQueueThread.start();
        this.mPlayerQueueHandler = new Handler(this.mPlayerQueueThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPlayerEventCallback(IThunderAudioFilePlayerEventCallback callback) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerEventCallback");
        if (this.mIsDestroy) {
            return;
        }
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mEventCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void setPlayerNotify(IThunderAudioFilePlayerCallback callback) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerNotify");
        if (this.mIsDestroy) {
            return;
        }
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enableVolumeIndication(boolean enable, int interval) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enableVolumeNotify enable = %b, interval=%d ", enable, interval);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                ThunderLog.release("ycall-Java", "chorus: enableVolumeIndication mIsDestroy is null");
                return;
            }
            if (interval <= 0) {
                interval = 200;
            }
            ThunderNative.enableAudioFileVolumeCallback(this.nativeCtx, enable, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMixStandard(boolean standard) {
        String oval = String.valueOf(standard);
        ThunderNative.makeBehaviorEvent("af_player", "setMixStandard", oval, 2);
        Object object = this.mPlayerLock;
        synchronized (object) {
            this.mIsMixStandard = standard;
            if (this.mIsMixStandard && !this.mIsDestroy) {
                ThunderNative.enableAudioFileVolumeCallback(this.nativeCtx, true, 1000);
            }
        }
    }

    public synchronized boolean isMixStandard() {
        return this.mIsMixStandard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String path) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer open path = %s", path);
        this.mFilePath = path;
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy || path == null) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFileOpen(ThunderAudioFilePlayer.this.nativeCtx, ThunderAudioFilePlayer.this.mFilePath);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer close");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy || this.mFilePath == null) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFileClose(ThunderAudioFilePlayer.this.nativeCtx);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer play");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy || this.mFilePath == null) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFilePlay(ThunderAudioFilePlayer.this.nativeCtx);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer stop");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy || this.mFilePath == null) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFileStop(ThunderAudioFilePlayer.this.nativeCtx);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer pause");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFilePause(ThunderAudioFilePlayer.this.nativeCtx);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer resume");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFileResume(ThunderAudioFilePlayer.this.nativeCtx);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(final long timeMS) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer seek timems = %d ", timeMS);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy || this.mFilePath == null) {
                return;
            }
            if (this.mPlayerQueueHandler != null) {
                this.mPlayerQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderNative.audioFileSeek(ThunderAudioFilePlayer.this.nativeCtx, timeMS);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getTotalPlayTimeMS ");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return 0L;
            }
            return ThunderNative.audioFileGetTotalTime(this.nativeCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getCurrentPlayTimeMS ");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return 0L;
            }
            return ThunderNative.audioFileGetCurrentPlayTime(this.nativeCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayVolume volume = %d", volume);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if (volume < 0) {
                volume = 0;
            } else if (volume > 100) {
                volume = 100;
            }
            ThunderNative.audioFileSetPlayVolume(this.nativeCtx, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPlayerLocalVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerLocalVolume volume = %d", volume);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return -1;
            }
            return ThunderNative.audioFileSetPlayerLocalVolume(this.nativeCtx, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPlayerPublishVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerPublishVolume volume = %d", volume);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return -1;
            }
            return ThunderNative.audioFileSetPlayerPublishVolume(this.nativeCtx, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerLocalVolume() {
        Object object = this.mPlayerLock;
        synchronized (object) {
            return (int)ThunderNative.audioFileGetPlayerLocalVolume(this.nativeCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerPublishVolume() {
        Object object = this.mPlayerLock;
        synchronized (object) {
            return (int)ThunderNative.audioFileGetPlayerPublishVolume(this.nativeCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudioTrackCount() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getAudioTrackCount ");
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return 0;
            }
            return (int)ThunderNative.audioFileGetAudioTrackCount(this.nativeCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectAudioTrack(int audioTrack) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer selectAudioTrack audioTrack = %d", audioTrack);
        Object object = this.mPlayerLock;
        synchronized (object) {
            long ret;
            if (this.mIsDestroy) {
                return -1;
            }
            int trackCount = this.getAudioTrackCount();
            if (trackCount == 0 || audioTrack < 0) {
                return -1;
            }
            if (audioTrack >= trackCount) {
                audioTrack = trackCount - 1;
            }
            int n = (ret = ThunderNative.audioFileSelectAudioTrack(this.nativeCtx, audioTrack)) == 1L ? 0 : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSemitone(int val) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setSemitone val = %d", val);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if (val < -5) {
                val = -5;
            } else if (val > 5) {
                val = 5;
            }
            float tone = val;
            ThunderNative.audioFileSetSemitone(this.nativeCtx, tone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTempo(float tempo) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setTempo tempo=%f", Float.valueOf(tempo));
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if ((double)tempo < 0.5) {
                tempo = 0.5f;
            } else if (tempo > 2.0f) {
                tempo = 2.0f;
            }
            ThunderNative.audioFileSetTempo(this.nativeCtx, tempo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(int azimuth) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setTempo:(azimuth=%d)", azimuth);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            if (azimuth < -90) {
                azimuth = -90;
            } else if (azimuth > 90) {
                azimuth = 90;
            }
            ThunderNative.audioFileSetPosition(this.nativeCtx, azimuth, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLooping(int cycle) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setLooping cycle = %d", cycle);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return -1;
            }
            return (int)ThunderNative.audioFileSetLooping(this.nativeCtx, cycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePublish(boolean enable) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enablePublish: enable=%b", enable);
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mIsDestroy) {
                return;
            }
            ThunderNative.audioFileEnablePublish(this.nativeCtx, enable);
        }
    }

    public void onPlayEvent(final int event, final int errorCode) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer onPlayEvent event = %d, errorCode = %d", event, errorCode);
        MainHandler.getInstance().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ThunderAudioFilePlayer.this.mIsDestroy) {
                    return;
                }
                Object object = ThunderAudioFilePlayer.this.mCallbackLock;
                synchronized (object) {
                    if (ThunderAudioFilePlayer.this.mCallback != null) {
                        switch (event) {
                            case 6: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFilePlayEnd();
                                break;
                            }
                            case 1: 
                            case 9: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFilePlayError(errorCode);
                                break;
                            }
                            case 2: {
                                if (errorCode != 0) {
                                    ThunderAudioFilePlayer.this.mCallback.onAudioFilePlayError(errorCode);
                                    break;
                                }
                                ThunderAudioFilePlayer.this.mCallback.onAudioFilePlaying();
                                break;
                            }
                            case 4: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFilePause();
                                break;
                            }
                            case 5: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFileResume();
                                break;
                            }
                            case 3: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFileStop();
                                break;
                            }
                            case 7: {
                                ThunderAudioFilePlayer.this.mCallback.onAudioFileSeekComplete(errorCode);
                                break;
                            }
                        }
                    } else if (ThunderAudioFilePlayer.this.mEventCallback != null) {
                        ThunderAudioFilePlayer.this.mEventCallback.onAudioFileStateChange(event, errorCode);
                    }
                }
            }
        });
    }

    public synchronized void onAudioFileVolume(final long volume, final long currentMs, final long totalMs) {
        MainHandler.getInstance().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ThunderAudioFilePlayer.this.mIsDestroy) {
                    ThunderLog.release("ycall-Java", " chorus: onAudioFileVolume mIsDestroy is false");
                    return;
                }
                Object object = ThunderAudioFilePlayer.this.mCallbackLock;
                synchronized (object) {
                    if (ThunderAudioFilePlayer.this.mCallback != null) {
                        ThunderLog.release("ycall-Java", " chorus: volume[%d], currentMs[%d], totalMs[%d].", volume, currentMs, totalMs);
                        ThunderAudioFilePlayer.this.mCallback.onAudioFileVolume(volume, currentMs, totalMs);
                        if (ThunderAudioFilePlayer.this.isMixStandard()) {
                            ThunderNative.sendAudioFilePlayerInfo((int)volume, (int)currentMs, (int)totalMs);
                        }
                    } else if (ThunderAudioFilePlayer.this.mEventCallback != null) {
                        ThunderLog.release("ycall-Java", " evt chorus: volume[%d], currentMs[%d], totalMs[%d].", volume, currentMs, totalMs);
                        ThunderAudioFilePlayer.this.mEventCallback.onAudioFileVolume(volume, currentMs, totalMs);
                        if (ThunderAudioFilePlayer.this.isMixStandard()) {
                            ThunderNative.sendAudioFilePlayerInfo((int)volume, (int)currentMs, (int)totalMs);
                        }
                    } else {
                        ThunderLog.release("ycall-Java", " chorus: onAudioFileVolume mIsDestroy is null");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAudioFilePlayer() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer destroyAudioFilePlayer");
        Object object = this.mPlayerLock;
        synchronized (object) {
            try {
                if (this.mPlayerQueueHandler != null) {
                    this.mPlayerQueueHandler.removeCallbacksAndMessages(null);
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.mPlayerQueueThread.quitSafely();
                    } else {
                        this.mPlayerQueueThread.quit();
                    }
                    this.mPlayerQueueThread.join();
                    this.mPlayerQueueHandler = null;
                    this.mPlayerQueueThread = null;
                }
            }
            catch (Exception e) {
                ThunderLog.error("ycall-Java", "ThunderAudioFilePlayer destroyAudioFilePlayer, exception: " + e.getMessage());
            }
            this.setPlayerNotify(null);
            this.setPlayerEventCallback(null);
            ThunderNative.destroyAudioFilePlayer(this.nativeCtx);
            this.mIsDestroy = true;
            this.nativeCtx = 0L;
        }
    }

    protected void finalize() {
        this.destroyAudioFilePlayer();
    }

    @Override
    public int compareTo(ThunderAudioFilePlayer audioFilePlayer) {
        if (audioFilePlayer == null) {
            throw new NullPointerException();
        }
        if (this == audioFilePlayer) {
            return 0;
        }
        return 1;
    }

    @Deprecated
    public static interface IThunderAudioFilePlayerCallback {
        public void onAudioFilePlayEnd();

        public void onAudioFilePlayError(int var1);

        public void onAudioFilePlaying();

        public void onAudioFilePause();

        public void onAudioFileResume();

        public void onAudioFileStop();

        public void onAudioFileSeekComplete(int var1);

        public void onAudioFileVolume(long var1, long var3, long var5);
    }
}

