package com.thunder.livesdk.video.serviceConfig;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.videoplayer.decoder.VideoConstant;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.ThunderPublishInfo;
import com.thunder.livesdk.ThunderPublishVideoConfig;
import com.thunder.livesdk.ThunderConstant;
import com.thunder.livesdk.helper.ThunderNative;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;

/**
 * Created by Administrator on 2018/8/13.
 */

public class VideoConfigManager {
    private final static String TAG = "cfg_VideoConfigManage";

    //当前的mode
    private VideoLiveConfig mCurrentConfig = null;
    private int mCurrentVideoLevel = -1;

    public boolean mDisableHardEncode = false;
    public boolean mDisableHardDecode = false;
    private boolean mPreviewShareCtx = true;
    private boolean mUseClear = false;

    //配置中心拉取配置中包含的mode
    private HashMap<Integer, VideoLiveConfig> mVideoConfigsList = new HashMap<>();

    private int mCurMultiLianMaiUsers = 0;
    public void updateCurLianMaiUsers(int num) {
        mCurMultiLianMaiUsers = num;
    }

    
    private static class SingletonHolder {
        private static final VideoConfigManager INSTANCE = new VideoConfigManager();
    }

    public static VideoConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private VideoConfigManager() {

    }

    private VideoLiveConfig getVideoLiveConfigByPlayType(int playType) {
        synchronized (this) {
            return mVideoConfigsList.get(playType);
        }
    }

    /**
     * 从配置中心的解析列表获取预览配置
     * 当playType和mode完全匹配时，采用匹配项的值
     * 当mode不匹配时，会默认用配置中心中标明isDefault = 1的匹配项的值
     * 当mode不匹配且isDefault没指定，则用默认的参数544*960 1200 硬编
     *
     * @param playType 玩法
     * @param mode     开播模式
     * @return 编码配置参数
     */
    public CameraPreviewConfig getCameraPreviewConfigByType(int playType, int mode) {
        CameraPreviewConfig result = new CameraPreviewConfig();
        VideoLiveConfig videoConfig = getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.error(TAG, " getCameraPreviewConfigByType failed, return default!");
            return result;
        }
        for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
            if ((info.key == mode) || (mode == -1 && info.isDefault == 1)) {
                result.mCaptureFrameRate = info.previewFrameRate > 0 ? info.previewFrameRate : result.mCaptureFrameRate;
                result.mCaptureResolutionWidth =
                        info.previewWidth > 0 ? info.previewWidth : result.mCaptureResolutionWidth;
                result.mCaptureResolutionHeight =
                        info.previewHeight > 0 ? info.previewHeight : result.mCaptureResolutionHeight;

                mCurrentConfig = videoConfig;
                mCurrentVideoLevel = info.key;
                break;
            }
        }

if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG,
                "getCameraPreviewConfigByType playtype:" + playType + " mode:" + mode + "->" + result.toString());
}
        return result;
    }

    private int convertPlayType(int playType) {
        switch (playType) {
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_LIANMAI;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SCREENCAP:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SCREEN_CAPTURE;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_MULTI_INTERACT:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_MULIT_LIVE_LIANMAI;
                break;
            default:
                break;
        }
        return playType;
    }

    /**
     * 从配置中心的解析列表获取编码配置
     * 当playType和mode完全匹配时，采用匹配项的值
     * 当mode不匹配时，会默认用配置中心中标明isDefault = 1的匹配项的值
     * 当mode不匹配且isDefault没指定，则用默认的参数544*960 1200 硬编
     *
     * @param playType 玩法
     * @param mode     开播模式
     * @return 编码配置参数
     */
    public VideoEncoderConfig getVideoEncodeConfigByType(int playType, int mode) {
        VideoEncoderConfig result = new VideoEncoderConfig();
        VideoLiveConfig videoConfig = getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.warn(TAG, " getVideoEncodeConfigByType failed, return default!");
            return result;
        }

        if (playType != VideoLiveConfig.PlayType.MULIT_LIVE_LIANMAI || mCurMultiLianMaiUsers == 0) {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if ((info.key == mode) || (mode == -1 && info.isDefault == 1)) {
                    result.mEncodeWidth = info.width > 0 ? info.width : result.mEncodeWidth;
                    result.mEncodeHeight = info.height > 0 ? info.height : result.mEncodeHeight;
                    result.mBitRate = info.currate > 0 ? info.currate * 1000 : result.mBitRate;
                    result.mEncodeType = convertEncodeIdToType(info.encode_id);
                    result.mEncodeParameter = info.encode_param;
                    result.mMaxBitRate = info.maxrate * 1000;
                    result.mFrameRate = info.frameRate > 0 ? info.frameRate : result.mFrameRate;

                    mCurrentConfig = videoConfig;
                    mCurrentVideoLevel = info.key;
                    break;
                }
            }
        } else {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if ((mCurMultiLianMaiUsers >= info.minUsers) && (mCurMultiLianMaiUsers <= info.maxUsers)) {
                    result.mEncodeWidth = info.width > 0 ? info.width : result.mEncodeWidth;
                    result.mEncodeHeight = info.height > 0 ? info.height : result.mEncodeHeight;
                    result.mBitRate = info.currate > 0 ? info.currate * 1000 : result.mBitRate;
                    result.mEncodeType = convertEncodeIdToType(info.encode_id);
                    result.mEncodeParameter = info.encode_param;
                    result.mMaxBitRate = info.maxrate * 1000;
                    result.mFrameRate = info.frameRate > 0 ? info.frameRate : result.mFrameRate;

                    mCurrentConfig = videoConfig;
                    mCurrentVideoLevel = info.key;
                    break;
                }
            }
        }

        if (mDisableHardEncode) {
            if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                result.mEncodeParameter = "";
            } else if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                result.mEncodeParameter = "";
            }
        }

if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "getVideoEncodeConfigByType :" + playType + " mode:" + mode + "->" + result.toString());
}
        return result;
    }

    public void notifyVideoConfig(HashMap<Integer, VideoLiveConfig> configMap) {
        if (configMap.isEmpty()) {
            return;
        }
        synchronized (this) {
            mVideoConfigsList.clear();
            mVideoConfigsList.putAll(configMap);
        }
    }

    public void notifyBlackCodecConfig(String config) {
        if (config.isEmpty()) {
            return;
        }
        String[] blockEncode = config.split(",");
        for (int i = 0; i < blockEncode.length; ++i) {
            if (blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH264EncodeName())) {
                mDisableHardEncode = true;
            } else if (blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH265EncodeName())) {
                mDisableHardEncode = true;
            }
        }
    }

    public List<ResolutionModifyConfig> getCurrentModifyConfig() {
        if (mCurrentConfig == null) {
            return null;
        }

        List<ResolutionModifyConfig> modifyconfigs = null;
        for (int i = 0; i < mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo resolutionInfo = mCurrentConfig.resolutions.get(i);
            if (resolutionInfo.key == mCurrentVideoLevel) {
                modifyconfigs = new ArrayList<>(resolutionInfo.modifyConfig.size());
                for (int j = 0; j < resolutionInfo.modifyConfig.size(); ++j) {
                    VideoLiveConfig.ModifyInfo info = resolutionInfo.modifyConfig.get(j);
                    ResolutionModifyConfig tmp = new ResolutionModifyConfig(info.width,
                            info.height,
                            info.minCodeRate * 1000,
                            info.maxCodeRate * 1000,
                            info.minFrameRate,
                            info.maxFrameRate,
                            convertEncodeIdToType(info.encode_id),
                            info.encode_param);
                    modifyconfigs.add(tmp);
                }
            }
        }


        return modifyconfigs;
    }

    public VideoLiveConfig getCurrentVideoLiveConfig() {
        return mCurrentConfig;
    }

    public int getCurrentVideoLevel() {
        return mCurrentVideoLevel;
    }

    ;

    public int getCurrentIntervalSecs() {
        if (mCurrentConfig == null) {
            return 10;
        }
        return mCurrentConfig.intervalSecs;
    }

    public boolean checkLowDelayByType(int playType) {
        if (playType == VideoLiveConfig.PlayType.LIANMAI ||
                playType == VideoLiveConfig.PlayType.ACROSS ||
                playType == VideoLiveConfig.PlayType.MULIT_LIVE_LIANMAI) {
            return true;
        }
        return false;
    }

    public boolean checkMultiLianMaiModeByType(int playType) {
        if (playType == VideoLiveConfig.PlayType.MULIT_LIVE_LIANMAI) {
            return true;
        }
        return false;
    }

    public void resetCurrentVideoLiveConfig() {
        mCurrentConfig = null;
    }

    public int getCurrentBeautifyLevel() {
        return ThunderNative.getBeautifyLevel();
    }

    public boolean getAbroadNetWorkStrategy() {
        return ThunderNative.getAbroadNetWorkStrategy() == 0 ? false : true;
    }

    public boolean getPreviewShareCtxSupport() {
        return mPreviewShareCtx;
    }

    public boolean getUseClear() {
        return mUseClear;
    }
    public static int getAppCpuSupportMode() {
        return ThunderNative.getAppCpuSupportMode();
    }

    public void disableHardDecode(Boolean disable) {
        mDisableHardDecode = disable;
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "disableHardDecode " + mDisableHardEncode);
}
    }

    public void disableHardEncode(Boolean disable) {
        mDisableHardEncode = disable;
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "disableHardEncode " + mDisableHardEncode);
}
    }

    public int getDefaultPublishVideoMode(int playType) {
        int mode = -1;
        VideoLiveConfig tmpConfigs = getVideoLiveConfigByPlayType(playType);
        if (tmpConfigs == null) {
            ThunderLog.warn(TAG, " getDefaultPublishVideoMode configs == null ");
            return -1;
        }
        for (int i = 0; i < tmpConfigs.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = tmpConfigs.resolutions.get(i);
            if (info.isDefault == 1) {
                mode = info.key;
                break;
            }
        }
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, " getDefaultPublishVideoMode mode " + mode);
}
        return mode;
    }

    public int getPlayViewTypeFromStream(int streamType) {
        int decodeType = VideoConstant.DecoderType.SOFT_DEOCDER;
        if (mDisableHardDecode) {
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, " getPlayViewTypeFromStream soft decoder ");
}
            return decodeType;
        }
        if (streamType == VideoLiveConfig.StreamType.STREAM_TYPE_H265) {
            //判断当前机器是支持软解还是硬解
            int h265Mode = ThunderNative.getH265SupportMode();
            if (h265Mode == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_HW) {
                decodeType = VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
            } else {
if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  h265 mode " + h265Mode);
}
            }
        } else if (streamType == VideoLiveConfig.StreamType.STREAM_TYPE_H264) {
            int h264Mode = ThunderNative.getH264SupportMode();
            if (h264Mode == VideoLiveConfig.DecodeType.CODEC_DECODEC_H264_HW) {
                decodeType = VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
            } else {
if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  h264 mode " + h264Mode);
}
            }
        }
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, " getPlayViewTypeFromStream decodeType :" + decodeType + " streamType " + streamType);
}
        return decodeType;
    }

    public ThunderPublishVideoConfig getCurrentVideoConfig() {
        ThunderPublishVideoConfig result = new ThunderPublishVideoConfig();
        if (mCurrentConfig == null) {
            return result;
        }
        result.playType = mCurrentConfig.playType;
        result.mode = mCurrentVideoLevel;

        for (int i = 0; i < mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = mCurrentConfig.resolutions.get(i);
            if (info.key == mCurrentVideoLevel) {
                if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264 && mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                } else if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265 &&
                        mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                } else {
                    result.hardwareEncoder = false;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                }

                result.encodeBitrate = info.currate;
                result.encodeFrameRate = info.frameRate;
                result.encodeResolutionHeight = info.height;
                result.encodeResolutionWidth = info.width;

                break;
            }
        }

        return result;
    }

    public ThunderPublishInfo getCurrentPublishInfo() {
        ThunderPublishInfo result = new ThunderPublishInfo();
        if (mCurrentConfig == null) {
            return result;
        }
        result.playType = mCurrentConfig.playType;
        result.publishMode = mCurrentVideoLevel;

        for (int i = 0; i < mCurrentConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = mCurrentConfig.resolutions.get(i);
            if (info.key == mCurrentVideoLevel) {
                if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264 && mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                } else if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265 &&
                        mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                } else {
                    result.hardwareEncoder = false;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                }

                result.bitrate = info.currate;
                result.frameRate = info.frameRate;
                result.encodeHeight = info.height;
                result.encodeWidth = info.width;

                break;
            }
        }

        return result;
    }

    public ThunderPublishVideoConfig getRemoteVideoConfig(int playType, int publishMode) {
        ThunderPublishVideoConfig result = new ThunderPublishVideoConfig();
        result.playType = playType;
        result.mode = publishMode;
        result.encodeBitrate = 1200;
        result.encodeFrameRate = 24;
        result.encodeResolutionWidth = 544;
        result.encodeResolutionHeight = 960;
        VideoLiveConfig videoConfig = getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            return result;
        }
        if (playType != VideoLiveConfig.PlayType.MULIT_LIVE_LIANMAI || mCurMultiLianMaiUsers == 0) {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if ((info.key == publishMode) || (publishMode == -1 && info.isDefault == 1)) {

                if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264 && mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                } else if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265 &&
                        mDisableHardEncode == false) {
                    result.hardwareEncoder = true;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                } else {
                    result.hardwareEncoder = false;
                    result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                }
                result.encodeBitrate = info.currate;
                result.encodeMaxBitrate = info.maxrate;
                result.encodeFrameRate = info.frameRate;
                result.encodeResolutionHeight = info.height;
                result.encodeResolutionWidth = info.width;

                break;
                }
            }
        } else {
            for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
                VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
                if ((info.minUsers <= mCurMultiLianMaiUsers) && (info.maxUsers >= mCurMultiLianMaiUsers)) {
                    if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264 &&
                            mDisableHardEncode == false) {
                        result.hardwareEncoder = true;
                        result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                    } else if (info.encode_id == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265 &&
                            mDisableHardEncode == false) {
                        result.hardwareEncoder = true;
                        result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                    } else {
                        result.hardwareEncoder = false;
                        result.encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                    }
                    result.encodeBitrate = info.currate;
                    result.encodeMaxBitrate = info.maxrate;
                    result.encodeFrameRate = info.frameRate;
                    result.encodeResolutionHeight = info.height;
                    result.encodeResolutionWidth = info.width;
                    break;
                }
            }
        }

        return result;
    }

    public HashMap<Integer, String> getModeListByPlayType(int playType) {
        HashMap<Integer, String> modeList = new HashMap<Integer, String>();
        VideoLiveConfig videoConfig = getVideoLiveConfigByPlayType(playType);
        if (videoConfig == null) {
            ThunderLog.error(TAG, "getModeListByPlayType  config null");
            modeList.put(playType, String.valueOf(2));
            return modeList;
        }

        String modeString = "";
        for (int i = 0; i < videoConfig.resolutions.size(); ++i) {
            VideoLiveConfig.ResolutionInfo info = videoConfig.resolutions.get(i);
            modeList.put(info.key, info.description);
            modeString += info.key + ":" + info.description;
        }
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "getModeListByPlayType " + playType + " :" + modeString);
}

        return modeList;
    }

    private VideoEncoderType convertEncodeIdToType(int encodeId) {
        if (encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H264) {
            return VideoEncoderType.HARD_ENCODER_H264;
        } else if (encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_X264) {
            return VideoEncoderType.SOFT_ENCODER_X264;
        } else if (encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_HW_H265) {
            return VideoEncoderType.HARD_ENCODER_H265;
        } else if (encodeId == VideoLiveConfig.EncodeType.PHONE_CODEC_X265) {
            return VideoEncoderType.SOFT_ENCODER_H265;
        } else {
            return VideoEncoderType.SOFT_ENCODER_X264;
        }
    }
}
