package com.thunder.livesdk.video;

import java.util.Arrays;

/**
 * @author xipeitao
 * @description: 用于回调的视频帧相关的结构体
 * @date : 2020/11/18 7:05 PM
 */
public class VideoFrame {
    int width;  //视频数据宽
    int height; //视频数据高
    byte[] data;    //视频NV21数据
    int imageFormat;    //视频图片格式 {@link android.graphics.ImageFormat}
    byte[]  seiData;    //用于业务设置的sei。在onCaptureVideoFrame
    // 回调时，该字段为空。如果需要严格帧同步功能呢，则可以往其中填写数据。数据会在远端的onRecvMediaExtraInfo中回调，不能超过2048
    // 个字节。采集的数据不一定会编码，建议写入和视频帧绑定的数据。
    int rotation; // Rotation angle

    public VideoFrame(int width, int height, byte[] data, int imageFormat, byte[] seiData,
                      int rotation) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.imageFormat = imageFormat;
        this.seiData = seiData;
        this.rotation = rotation;
    }

    @Override
    public String toString() {
        return "VideoFrame{" +
                "width=" + width +
                ", height=" + height +
                ", data=" + Arrays.toString(data) +
                ", imageFormat=" + imageFormat +
                ", seiData=" + Arrays.toString(seiData) +
                ", rotation=" + rotation +
                '}';
    }

    public int getWidth() {
        return width;
    }


    public int getHeight() {
        return height;
    }


    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getImageFormat() {
        return imageFormat;
    }

    public void setSeiData(byte[] seiData) {
        this.seiData = seiData;
    }

    public int getRotation() {
        return rotation;
    }

}
