package com.thunder.livesdk.system;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class LifecycleEventDispatcher {
    private final static HashSet<WeakReference<ILifecycleCallbacks>> observers = new HashSet<>();

    private static AtomicInteger foregroundCounter = new AtomicInteger(0);

    private static int counter = 0; //正常情况下只会从主线程访问这个变量

    public static void registerCallback(ILifecycleCallbacks callback) {
        synchronized (observers) {
            observers.add(new WeakReference<>(callback));
            if(foregroundCounter.get() > 0)
            {
                callback.onForeground();
            }
        }
    }

    public static void removeCallback(ILifecycleCallbacks callback) {
        synchronized (observers) {
            //TODO: use a list ?
            WeakReference<ILifecycleCallbacks> rm = null;
            for (WeakReference<ILifecycleCallbacks> cb : observers) {
                if(callback == cb.get()){
                    rm = cb;
                }
            }

            if(null != rm)
                observers.remove(rm);
        }
    }

    public static void dispatchEvent(boolean isForeground) {
        int oldCount = counter;
        counter += isForeground ? 1 : -1;

        LcLogger.d("count:"+counter);

        synchronized (observers) {
            if (counter == 1 && oldCount == 0) {
                LcLogger.d("onForeground");
                if(observers.isEmpty()) foregroundCounter.incrementAndGet();
                for (WeakReference<ILifecycleCallbacks> cb : observers) {
                    if (null != cb.get()) {
                        cb.get().onForeground();
                    }else{
                        LcLogger.d("onForeground null ref");
                    }
                }
            } else if (counter == 0 && oldCount == 1) {
                LcLogger.d("onBackground");
                if(observers.isEmpty()) foregroundCounter.decrementAndGet();
                for (WeakReference<ILifecycleCallbacks> cb : observers) {
                    if (null != cb.get()) {
                        cb.get().onBackground();
                    }else{
                        LcLogger.d("onBackground null ref");
                    }
                }
            }
        }
    }
}
