package com.thunder.livesdk.helper;

/*
 * Created by xiaojun on 2017/11/21.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;

import com.thunder.livesdk.BuildConfig;
import com.thunder.livesdk.CustomTranscodingOptions;
import com.thunder.livesdk.IThunderLogCallback;
import com.thunder.livesdk.LiveTranscoding;
import com.thunder.livesdk.ThunderEngine;
import com.thunder.livesdk.ThunderRtcVideoTransParam;
import com.thunder.livesdk.ThunderAudioFilePlayer;
import com.thunder.livesdk.ThunderBoltImage;
import com.thunder.livesdk.ThunderVideoEncodeParamConfiguration;
import com.thunder.livesdk.ThunderVideoEncoderParam;
import com.thunder.livesdk.TranscodingImage;
import com.thunder.livesdk.TranscodingText;
import com.thunder.livesdk.TranscodingTimestamp;
import com.thunder.livesdk.ThunderDeviceInfo;
import com.thunder.livesdk.ThunderEventHandler;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.ThunderNotification;
import com.thunder.livesdk.ThunderNotificationInside;
import com.thunder.livesdk.ThunderPublishVideoConfig;
import com.thunder.livesdk.ThunderVideoEncodeParam;
import com.thunder.livesdk.ThunderVideoEncoderConfiguration;
import com.thunder.livesdk.audio.IAudioEncodedFrameObserver;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.video.CpuTool;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderPublishLowStreamVideoConfig;
import com.thunder.livesdk.video.serviceConfig.VideoConfigManager;
import com.thunder.livesdk.video.serviceConfig.VideoLiveConfig;
import com.thunder.livesdk.log.ThunderLog;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 与C++代码互调的JNI相关的代码
 */
public class ThunderNative {

    private static IThunderLogCallback s_logCallback = null;
    private static NotificationDispatcher s_notificationDispatcher = null;
    private static ReentrantLock s_notificationLock = null;

    /**
     * 标记是否已经加载视频插件 默认为true已加载
     */
    public static boolean mIsLoadVideoPlug = true;

    public static String mVideoPlugVersion = "";

    //用于控制日志打印条数
    private static int s_remoteVideoStatsNotificationCount = 0;
    private static int s_remoteAudioStatsNotificationCount = 0;

    /******************************** YYLive Events Begin *****************************************/
    //YYLive Base Events
    private static final int YYLIVE_SDK_INIT = 1;
    private static final int YYLIVE_SET_SCENE_ID = 2;
    private static final int YYLIVE_LOG_TEXT = 3;
    private static final int YYLIVE_UPDATE_TOKEN = 5;
    private static final int THUNDER_JOIN_ROOM = 6;
    private static final int YYLIVE_LEAVE_ROOM = 7;
    private static final int YYLIVE_SET_AREA_TYPE = 8;
    private static final int YYLIVE_SET_PLAY_VOLUME_INTERVAL = 9;
    private static final int YYLIVE_SET_CAPTURE_VOLUME_INTERVAL = 10;
    private static final int YYLIVE_SET_HTTPS_RESPONSE = 11;
    private static final int YYLIVE_SET_RECORD_AUDIO_PARAMS = 12;
    private static final int YYLIVE_SET_PLAY_AUDIO_PARAMS = 13;
    private static final int YYLIVE_SET_MIX_AUDIO_PARAMS = 14;

    private static final int THUNDER_SET_REMOTE_AUDIO_STREAM_VOLUME = 15;
    private static final int YYLIVE_SET_SPEAKER_VOLUME = 17;
    private static final int YYLIVE_H265_SUPPORT_MODE = 18;
    private static final int YYLIVE_ENABLE_WEBSDK_COMPATIBILITY = 19;
    private static final int YYLIVE_H264_SUPPORT_MODE = 20;
    private static final int THUNDER_VIDEO_FRAME_OBSERVER = 21;
    private static final int YYLIVE_SET_REMOTE_UID_VOICE_POSITION = 22;
    private static final int YYLIVE_INIT_MULTI_VIEW_LAYOUT = 23;
    private static final int THUNDER_SET_REMOTE_PLAY_TYPE = 24;

    private static final int YYLIVE_SET_MIC_VOLUME = 25;
    private static final int YYLIVE_CHANGE_SCREEN_LIVE_MODE = 26;
    private static final int YYLIVE_SET_ORIENTATION = 27;
    private static final int YYLIVE_GET_ORIENTATION = 28;

    private static final int THUNDER_START_VIDEO_CAPTURE = 30;
    private static final int YYLIVE_UPDATE_PUBLISH_ORIGIN_STREAM_URL = 31;
    private static final int THUNDER_SET_THUNDERBOLT_PUBLISH_GROUP = 32;
    private static final int YYLIVE_SET_LOCAL_VIDEO_MIRROR_MODE = 33;
    private static final int YYLIVE_GET_BEAUTIFY_LEVEL = 34;

    //YYLive Audio File Play Events
    private static final int YYLIVE_AUDIO_FILE_OPEN = 35;
    private static final int YYLIVE_AUDIO_FILE_CLOSE = 36;
    private static final int YYLIVE_AUDIO_FILE_PLAY = 37;
    private static final int YYLIVE_AUDIO_FILE_STOP = 38;
    private static final int YYLIVE_AUDIO_FILE_PAUSE = 39;
    private static final int YYLIVE_AUDIO_FILE_RESUME = 40;
    private static final int YYLIVE_AUDIO_FILE_SEEK = 41;
    private static final int YYLIVE_AUDIO_FILE_GET_TOTAL_TIME = 42;
    private static final int YYLIVE_AUDIO_FILE_GET_CURRENT_TIME = 43;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME = 44;
    private static final int YYLIVE_AUDIO_FILE_SET_SEMITONE = 45;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_PUBLISH = 46;

    private static final int YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR = 47;
    private static final int YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK = 48;
    private static final int YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION = 49;
    private static final int YYLIVE_CREATE_AUDIO_FILE_PLAYER = 50;
    private static final int YYLIVE_DESTROY_AUDIO_FILE_PLAYER = 51;
    private static final int YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK = 52;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK = 53;
    private static final int YYLIVE_AUDIO_FILE_SELECT_AUDIOTRACK = 54;
    private static final int YYLIVE_AUDIO_FILE_GET_AUDIOTRACK_COUNT = 55;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAYER_LOCAL_VOLUME = 56;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAYER_PUBLISH_VOLUME = 57;
    private static final int YYLIVE_AUDIO_FILE_GET_PLAYER_LOCAL_VOLUME = 58;
    private static final int YYLIVE_AUDIO_FILE_GET_PLAYER_PUBLISH_VOLUME = 59;
    private static final int YYLIVE_AUDIO_FILE_SET_LOOPING = 60;

    private static final int THUNDER_SEND_AUDIO_FILE_PLAYER_INFO = 61;
    //YYLive App Event
    private static final int YYLIVE_SEND_USER_APP_MSG_DATA = 62;
    private static final int THUNDER_SEND_MEDIA_EXTRA_INFO = 63;
    private static final int THUNDER_ENABLE_MIX_VIDEO_EXTRA_INFO = 64;
    private static final int THUNDER_SET_MEDIA_MODE = 65;
    private static final int THUNDER_SET_ROOM_MODE = 66;
    private static final int THUNDER_SET_USER_64BIT_UID = 67;
    private static final int THUNDER_SET_LOG_LEVEL = 68;
    private static final int THUNDER_SET_LOG_FILE_PATH = 69;
    private static final int THUNDER_ENABLE_LOG_CALLBACK = 70;
    private static final int THUNDER_UPDATE_PUBLISH_TRANSCODING_STREAM_URL = 71;
    private static final int THUNDER_SET_LIVE_TRANSCODING_TASK = 72;
    private static final int THUNDER_REMOVE_LIVE_TRANSCODING_TASK = 73;
    private static final int THUNDER_SET_REMOTE_VIDEO_CANVAS = 74;
    private static final int THUNDER_SET_REMOTE_VIDEO_CANVAS_MODE = 75;
    private static final int THUNDER_SET_LOCAL_VIDEO_CANVAS = 76;
    private static final int THUNDER_SET_Local_VIDEO_CANVAS_MODE = 77;
    private static final int THUNDER_SUBSCRIBE_USER = 78;
    private static final int THUNDER_SET_THUNDERBOLT_SUBSCRIBE_GROUP = 79;
    private static final int THUNDER_STOP_ALL_REMOTE_STREAMS = 80;
    private static final int THUNDER_STOP_REMOTE_AUDIO_STREAM = 81;
    private static final int THUNDER_STOP_REMOTE_VIDEO_STREAM = 82;

    private static final int THUNDER_SWITCH_FRONT_CAMERA          = 83;
    private static final int THUNDER_START_PUBLISH_AUDIO          = 84;
    private static final int THUNDER_START_PUSH_AUDIO_STREAM      = 85;
    private static final int THUNDER_SET_AUDIO_CONFIG             = 86;

    private static final int THUNDER_SET_AUDIO_PUBLISH_MODE       = 87;
    private static final int THUNDER_SET_CUSTOME_AUDIO_SOURCE     = 88;
    private static final int THUNDER_SET_PUB_WATERMARK            = 89;
    private static final int THUNDER_PUSH_CUSTOME_AUDIO_FRAME     = 90;
    private static final int THUNDER_START_VIDEO_ENCODE           = 91;
    private static final int THUNDER_START_PUBLISH_VIDEO_STREAM   = 92;
    private static final int THUNDER_START_PREVIEW                = 93;
    private static final int THUNDER_ATTACH_VIDEO_CAPTURE         = 94;
    private static final int THUNDER_SET_VIDEO_ENCODER_CONFIG     = 95;
    private static final int THUNDER_NOTIFY_NETWORK_STATE          = 96;
    private static final int THUNDER_APP_ENTER_FOREGROUND          = 97;
    private static final int THUNDER_APP_ENTER_BACKGROUND          = 98;
    private static final int THUNDER_ENABLE_LOUD_SPEAKER           = 99;
    private static final int THUNDER_GET_LOUDSPEAKER_ENABLED       = 100;
    private static final int THUNDER_ENABLE_IN_EAR_MONITOR         = 101;
    private static final int THUNDER_ENABLE_EQUALIZER              = 102;
    private static final int THUNDER_SET_EQ_GAINS                  = 103;
    private static final int THUNDER_ENABLE_COMPRESSOR             = 104;
    private static final int THUNDER_SET_COMPRESSOR_PARAM          = 105;
    private static final int THUNDER_ENABLE_REVERB                 = 106;
    private static final int THUNDER_SET_REVERB_PARAM              = 107;
    private static final int THUNDER_SET_LIMIT_PARAM               = 108;
    private static final int THUNDER_ENABLE_LIMITER                = 119;
    private static final int THUNDER_START_AUDIO_SAVER             = 110;
    private static final int THUNDER_STOP_AUDIO_SAVER              = 111;
    private static final int THUNDER_ENABLE_AUDIO_PLAY_SPECTRUM    = 112;
    private static final int THUNDER_SET_AUDIO_PLAY_SPECTRUM_INFO  = 113;
    private static final int THUNDER_ENABLE_VOICE_POSITION         = 114;
    private static final int THUNDER_SET_SOUND_EFFECT              = 115;
    private static final int THUNDER_SET_VOICE_CHANGER             = 116;
    private static final int THUNDER_SET_SID_AND_SUBSID            = 117;
    private static final int THUNDER_GET_CPU_RATE                  = 118;
    private static final int THUNDER_MAKE_BEHAVIOR_EVENT           = 120;
    private static final int THUNDER_PREFETCH_STREAMS              = 121;
    private static final int THUNDER_QUERY_STREAMS                 = 122;
    // private static final int THUNDER_NOTIFY_WIFI_INFO              = 123;
    private static final int THUNDER_GET_CONNECTION_STATUS         = 124;
    private static final int THUNDER_SET_VOICE_CHANGER_PITCH       = 125;
    private static final int THUNDER_ENABLE_HOWLING_DETECTOR       = 126;
    private static final int THUNDER_CUSTOMIZE_VIDEO_PUBLISH_CFG   = 127;
    private static final int THUNDER_ENABLE_LOCAL_DUANL_STREAM_MODE       = 128;
    private static final int THUNDER_SET_DEFAULT_REMOTE_VIDEO_STREAM_TYPE = 129;
    private static final int THUNDER_CHANGE_REMOTE_VIDEO_STREAM_TYPE      = 130;
    private static final int THUNDER_SET_EAR_MONITORING_VOLUME     = 131;
    private static final int THUNDER_ADAPT_TO_SYSTEM_KARAOKE       = 132;
    private static final int THUNDER_START_AUDIO_CAPTURE           = 133;
    private static final int THUNDER_START_AUDIO_ENCODE            = 134;
    private static final int THUNDER_ENABLE_ECHO_DETECTOR       = 135;
    private static final int THUNDER_IS_AUDIO_CAPTURE_ENABLED      = 136;
    private static final int THUNDER_ENABLE_AUDIO_MIC_DENOISE       = 137;
    private static final int THUNDER_IS_AUDIO_MIC_DENOISE_ENABLE    = 138;
    private static final int THUNDER_SET_CUSTOM_STREAM_NAME     = 140;
    private static final int THUNDER_SET_SUBSCRIBE_GROUP_IN_THUNDER = 141;
    private static final int THUNDER_SET_CUSTOM_PUBLISH_APPID = 142;
    private static final int THUNDER_START_INPUT_DEVICE_TEST       = 143;
    private static final int THUNDER_STOP_INPUT_DEVICE_TEST        = 144;
    private static final int THUNDER_START_OUTPUT_DEVICE_TEST      = 145;
    private static final int THUNDER_STOP_OUTPUT_DEVICE_TEST       = 146;
    private static final int THUNDER_ENABLE_AUDIO_AGC              = 147;
    private static final int THUNDER_START_AUDIO_RECORD            = 148;
    private static final int THUNDER_STOP_AUDIO_RECORD             = 149;
    private static final int YYLIVE_AUDIO_FILE_SET_TEMPO           = 150;
    private static final int YYLIVE_AUDIO_FILE_SET_POSITION        = 151;
    private static final int THUNDER_SWITCH_USER_ROLE              = 152;
    private static final int THUNDER_AUDIO_ENABLE_AI_DENOISE       = 153;
    private static final int THUNDER_ENABLE_LOCAL_SPEAKING_DETECTOR = 154;
    private static final int THUNDER_SET_VIDEO_ENCODER_PARAMETERS  = 155;
    private static final int THUNDER_SET_DEFAULT_TRANS_ID_IN_AUTO  = 156;
    private static final int THUNDER_SET_SUBSCRIBE_VIDEO_TRANS_ID  = 157;
    private static final int THUNDER_GET_PLAYING_VIDEO_TRANS_ID    = 158;
    private static final int THUNDER_SWITCH_AUDIENCE_MODE          = 159;

    private static final int YYLIVE_GET_ABROAD_NETWORK_STRATEGY    = 180;
    private static final int THUNDER_GET_HARD_DECODE_RENDER_CONFIG = 181;
    private static final int YYLIVE_ENABLE_VIDEO_PUBLISH_BUFFER_PROCESS  = 182;
    private static final int YYLIVE_SET_HARDWARE_DECODE_STATUS  = 183;
    private static final int THUNDER_SET_CRASH_EVENT = 184;
    private static final int YYLIVE_SET_VIDEO_COMMON_CONFIG_MODE = 185;
    private static final int THUNDER_SET_USE_TEXTURE_VIEW  = 186;

    private static final int YYLIVE_CAPTURE_REMOTE_SCREEN_SHOT = 190;
    private static final int YYLIVE_ENABLE_VIDEO_SET_PARAMETERS_PROCESS  = 191;

	private static final int THUNDER_SET_CAMERA_TORCH_ON = 200;
    private static final int THUNDER_IS_CAMERA_OPEN = 201;
    private static final int THUNDER_IS_FRONT_CAMERA = 202;
    private static final int THUNDER_IS_CAMERA_MANUAL_FOCUS_POSITION_SUPPORTED = 203;
    private static final int THUNDER_IS_CAMERA_MANUAL_EXPOSURE_POSITION_SUPPORTED = 204;
    private static final int THUNDER_IS_CAMERA_ZOOM_SUPPORTED = 205;
    private static final int THUNDER_GET_CAMERA_MAX_ZOOM_FACTOR = 206;
    private static final int THUNDER_SET_CAMERA_ZOOM_FACTOR = 207;
    private static final int THUNDER_IS_CAMERA_TORCH_SUPPORTED = 208;
    private static final int THUNDER_SET_CAMERA_FOCUS_POSITION = 209;
    private static final int THUNDER_SET_CAMERA_EXPOSURE_POSITION = 210;
    private static final int THUNDER_IS_CAMERA_AUTO_FOCUS_FACE_MODE_SUPPORTED = 211;
    private static final int THUNDER_SET_CAMERA_AUTO_FOCUS_FACE_MODE_ENABLED = 212;
    private static final int THUNDER_SEND_PRIVATE_MEDIA_EXTRA_DATA = 213;
    private static final int THUNDER_START_VIDEO_LOCAL_PREVIEW = 214;
    private static final int THUNDER_SUBSCRIBE_ROOM = 215;
    private static final int THUNDER_GET_USER_ROLE = 216;


    private static Boolean isInit = false;

    public native static void YYSetLoadVideoPlugState(boolean loadVideoPlugState);

    public native static void YYSetCFunctionPoints(long[] ptrs);

    private native static int YYLiveSdkInit(Context appContext, byte[] data, int dataValidLength);

    private native static void YYLiveSdkFini();

    /**
     * java对象字节流处理接口
     * @param event 对象标识
     * @param data java对象序列化字节流对象
     * @param dataValidLength 字节流有效长度
     * @return 处理返回值
     */
    private native static long YYLiveSdkProcess(int event, byte[] data, int dataValidLength);

    private native static String YYLiveSdkGetVersion();

    private native static int YYLiveSdkGetVersionInt();

    private native static long YYLiveObjectToPtr(Object obj);

    private native static void YYLiveRegisterAudioObserver(IAudioFrameObserver observer);

    private native static int YYLiveRegisterAudioEncodedObserver(IAudioEncodedFrameObserver observer);

    private native static Object ThunderGetVideoEncoderParamByGear(int playType, int publishMode);

    private native static Object ThunderGetAllVideoEncoderParam();

    private native static Object ThunderCaptureRemoteScreenShot(String uid);

    private native static int ThunderSetCaptureReplaceImage(Object bitmap);

    private native static Object ThunderCaptureLocalScreenShot();

    private native static String LiveEngineTranscodingCfgByMode(int mode);

    private static class YLESdkInit extends YLEBase {
        long appId;
        long sceneId;
        int areaType;
        int serverDomain;
        ThunderDeviceInfo info;
        YLESdkInit(long _addId, long _sceneId, int _areaType, int _serverDomain, ThunderDeviceInfo _info) {
            event = YYLIVE_SDK_INIT;
            appId = _addId;
            sceneId = _sceneId;
            areaType = _areaType;
            serverDomain = _serverDomain;
            info = _info;
        }

        @Override
        public byte[] marshall() {
            pushInt(appId);
            pushInt(sceneId);
            pushInt(areaType);
            pushInt(serverDomain);
            pushString16(info.osVersion);
            pushString16(info.manufacturer);
            pushString16(info.model);
            pushString16(info.deviceID);
            pushString16(info.appInfo);
            pushInt64(info.imsi);

            return super.marshall();
        }
    }


    public static void fini() {
        isInit = false;
        s_notificationLock.lock();
        try {
            s_notificationDispatcher = null;
        } finally {
            s_notificationLock.unlock();
        }

//		if (mGslbMethod != null) {
//			mGslbMethod.destroyService();
//			mGslbMethod = null;
//		}

        YYLiveSdkFini();
    }

    public static String getVersion() {
        return YYLiveSdkGetVersion();
    }

    public static void registerAudioFrameObserver(IAudioFrameObserver observer) {
        YYLiveRegisterAudioObserver(observer);
    }

    public static int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        return YYLiveRegisterAudioEncodedObserver(observer);
    }

    private static long YLEProcess(YLEBase e) {
        MshBuffer buffer = new MshBuffer(Marshallable.kProtoPacketSize, NativeByteBufferPool.get());
        //YLEBase填充buffer并返回buffer内存池持有的的byte[]对象
        byte[] refBytes = e.HPmarshall(buffer);
        //获取refBytes有效长度
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int validLen = byteBuffer.position();
        long ret = YYLiveSdkProcess(e.event(), refBytes, validLen);
        //复位byteBuffer游标
        byteBuffer.position(0);
        buffer.freeBuffer();
        return ret;
    }

    public static int initMultiPlayerViewLayout(ThunderMultiVideoViewParam params, int viewId, Object view) {
        return (int) YLEProcess(new YLEInitMultiPlayerViewLayout(params, viewId, view));
    }

    public static Bitmap captureRemoteScreenShot(String uid) {
        Object object = ThunderCaptureRemoteScreenShot(uid);
        if (object instanceof Bitmap) {
            return (Bitmap)object;
        } else {
            return null;
        }
    }

    public static int setCaptureReplaceImage(Bitmap bitmap)
    {
        return ThunderSetCaptureReplaceImage(bitmap);
    }

    public static Bitmap captureLocalScreenShot()
    {
        Object object = ThunderCaptureLocalScreenShot();
        if (object instanceof Bitmap) {
            return (Bitmap)object;
        } else {
            return null;
        }
    }

    public static int setParameters(String options) {
        return (int) YLEProcess(new YLESetParameters(options));
    }

    public static int setVideoPlayType(int remotePlayType, boolean checkJoined) {
        return (int) YLEProcess(new YLESetVideoPlayType(remotePlayType, checkJoined));
	}

    public static int onCrashEvent() {
        return (int) YLEProcess(new YLESetCrashEvent());
    }

    public static int setHardwareDecodeStatus(int mHardwareDecodeStatus){
        return (int) YLEProcess(new YLESetHardwareDecodeStatus(mHardwareDecodeStatus));
    }

    public static int setUseTextureView(boolean useTextureView){
        return (int) YLEProcess(new YLESetUseTextureView(useTextureView));
    }

    public static int enableVideoPublishBufferProcess(boolean bBufferMode){
        return (int) YLEProcess(new YLEEnableVideoPublishBufferProcess(bBufferMode));
    }

    public static int setVideoCommonConfigMode(int mode){
        return (int) YLEProcess(new YLESetVideoCommonConfigMode(mode));
    }

    public static void logText(int level, int module, String tag, String text) {
        YLEProcess(new YLELogText(level, module, tag, text));
    }

    public static int leaveRoom() {
        return (int) YLEProcess(new YLELeaveRoom());
    }


    public static int setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        return (int) YLEProcess(new YLESetPlayVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static int setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        return (int)YLEProcess(new YLESetCaptureVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static int getBeautifyLevel() {
        return (int) YLEProcess(new YLEGetBeautifyLevel());
    }

    public static int getAbroadNetWorkStrategy() {
        return (int) YLEProcess(new YLEGetAbroadNetWorkStrategy());
    }

    public static int enableWebSdkCompatibility(boolean enable) {
        return (int) YLEProcess(new YLEEnableWebSdkCompatibility(enable));
    }

    public static int setLocalVideoMirrorMode(int mode) {
        return (int) (YLEProcess(new YLESetLocalVideoMirrorMode(mode)));
    }

    public static int setRemoteAudioStreamVolume(String uid, int volume) {
        return (int) YLEProcess(new YLESetRemoteAudioStreamVolume(uid, volume));
    }

    public static int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        return (int) YLEProcess(new YLESetRemoteUidVoicePosition(uid, azimuth, gain));
    }

    public static int setSpeakerVolume(int volume) {
        return (int) YLEProcess(new YLESetSpeakerVolume(volume));
    }

    public static int getH265SupportMode() {
        return (int) YLEProcess(new YLEGetH265SupportMode());
    }

    public static int getH264SupportMode() {
        return (int) YLEProcess(new YLEGetH264SupportMode());
    }

    public static int getHardDecodeDirectRenderConfig() {
        return (int) YLEProcess(new YLEGetHardDecodeRenderMode());
    }

    public static int getAppCpuSupportMode() {
        return (int) YLEProcess(new YLEGetAppCpuSupportMode());
    }

    public static int setMicVolume(int volume) {
        return  (int) YLEProcess(new YLESetMicVolume(volume));
    }

    public static int setOrientation(int ori) {
        return (int) YLEProcess(new YLESetOrientation(ori));
    }

    public static int getOrientation() {
        return (int) YLEProcess(new YLEGetOrientation());
    }

    public static int setThunderboltPublishGroup(boolean bPublishGroup) {
        return (int) YLEProcess(new YLESetThunderboltPublishGroup(bPublishGroup));
    }

    public static void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        YLEProcess(new YLEChangeScreenLiveMode(bPicMode, bitmap));
    }

    public static long createAudioFilePlayer(Object obj) {
        return YLEProcess(new YLECreateAudioFilePlayer(obj));
    }

    public static long destroyAudioFilePlayer(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_DESTROY_AUDIO_FILE_PLAYER, ctx));
    }

    public static long sendAudioFilePlayerInfo(int volume, int currentMs, int totalMs) {
        return YLEProcess(new YLESendAudioFilePlayerInfo(volume, currentMs, totalMs));
    }

    public static long audioFileOpen(long ctx, String path) {
        return YLEProcess(new YLEAudioFileOpen(ctx, path));
    }

    public static void audioFileClose(long ctx) {
        YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_CLOSE, ctx));
    }

    public static void audioFilePlay(long ctx) {
        YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_PLAY, ctx));
    }

    public static void audioFileStop(long ctx) {
        YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_STOP, ctx));
    }

    public static void audioFilePause(long ctx) {
        YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_PAUSE, ctx));
    }

    public static void audioFileResume(long ctx) {
        YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_RESUME, ctx));
    }

    public static void audioFileSeek(long ctx, long timeMS) {
        YLEProcess(new YLEAudioFileSeek(ctx, timeMS));
    }

    public static long audioFileGetTotalTime(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_TOTAL_TIME, ctx));
    }

    public static long audioFileGetCurrentPlayTime(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_CURRENT_TIME, ctx));
    }

    public static void audioFileSetPlayVolume(long ctx, int volume) {
        YLEProcess(new YLEAudioFileSetPlayVolume(ctx, volume));
    }

    public static int audioFileSetPlayerLocalVolume(long ctx, int volume) {
        return (int)YLEProcess(new YLEAudioFileSetPlayerLocalVolume(ctx, volume));
    }

    public static int audioFileSetPlayerPublishVolume(long ctx, int volume) {
        return (int)YLEProcess(new YLEAudioFileSetPlayerPublishVolume(ctx, volume));
    }

    public static long audioFileGetPlayerLocalVolume(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_PLAYER_LOCAL_VOLUME, ctx));
    }

    public static long audioFileGetPlayerPublishVolume(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_PLAYER_PUBLISH_VOLUME, ctx));
    }

    public static long audioFileSetLooping(long ctx, int cycle) {
        return YLEProcess(new YLEAudioFileSetLooping(ctx, cycle));
    }

    public  static long audioFileSelectAudioTrack(long ctx, int audioTrack){
        return YLEProcess(new YLEAudioFileSelectAudioTrack(ctx, audioTrack));
    }

    public static long audioFileGetAudioTrackCount(long ctx) {
        return YLEProcess(new YLEAudioFileEventCommon(YYLIVE_AUDIO_FILE_GET_AUDIOTRACK_COUNT, ctx));
    }

    public static void audioFileSetSemitone(long ctx, float val) {
        YLEProcess(new YLEAudioFileSetSemitone(ctx, val));
    }

    public static void audioFileSetTempo(long ctx, float val) {
        YLEProcess(new YLEAudioFileSetTempo(ctx, val));
    }

    public static void audioFileSetPosition(long ctx, int azimuth, int elevation) {
        YLEProcess(new YLEAudioFileSetPosition(ctx, azimuth, elevation));
    }

    public static void audioFileEnablePublish(long ctx, boolean enable) {
        YLEProcess(new YLEAudioFileEnablePublish(ctx, enable));
    }

    public static void enableAudioFileVolumeCallback(long ctx, boolean enable, int interval) {
        YLEProcess(new YLEEnableAudioFileVolumeCallback(ctx, enable, interval));
    }

    public static void setExternalAudioProcessor(long eap) {
        YLEProcess(new YLEAudioSetExternalProcessor(eap));
    }

    public static void enableAudioDataIndication(boolean enable) {
        YLEProcess(new YLEEnableAudioDataIndication(enable));
    }

    public static int enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        return (int) YLEProcess(new YLEEnableCapturePcmDataCallBack(enable, sampleRate, channel));
    }

    public static boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        return (0 == YLEProcess(new YLEEnableRenderPcmDataCallBack(enable, sampleRate, channel)));
    }

    public static int sendUserAppMsgData(byte[] msgData) {
        return (int) YLEProcess(new YLESendUserAppMsgData(msgData));
    }

    public static int sendMediaExtraInfo(long timeStamp, byte[] extraInfo) {
        return (int) YLEProcess(new YLESendMediaExtraInfo(timeStamp,extraInfo));
    }

    public static int sendPrivateMediaExtraData(String extraData) {
        return (int) YLEProcess(new YLESendPrivateMediaExtraData(extraData));
    }

    public static int enableMixVideoExtraInfo(boolean enable) {
        return (int) YLEProcess(new YLEEnableMixVideoExtraInfo(enable));
    }

    public static void setHttpsBinaryResponse(String reqUrl,
                                              byte[] response,
                                              int statusCode,
                                              int errCode,
                                              int target) {
        if (isInit) {
            YLEProcess(new YLESetHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target));
        }
    }

    public static void setHttpsTextResponse(String reqUrl,
                                            String response,
                                            int statusCode,
                                            int errCode,
                                            int target) {
        if (isInit) {
            YLEProcess(new YLESetHttpsTextResponse(reqUrl, response, statusCode, errCode, target));
        }
    }

    public static int setPlaybackAudioFrameParameters(int sampleRate,
                                                       int channel,
                                                       int mode,
                                                       int samplesPerCall) {
        return (int) YLEProcess(new YLESetPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    public static ThunderVideoEncodeParam getVideoEncoderParamByGear(int playType, int publishMode) {
        Object object = ThunderGetVideoEncoderParamByGear(playType, publishMode);
        if (object instanceof ThunderVideoEncodeParam) {
            return (ThunderVideoEncodeParam)object;
        } else {
            return null;
        }
    }

    public static ArrayList<ThunderVideoEncodeParamConfiguration> getAllVideoEncoderParam() {
        Object object = ThunderGetAllVideoEncoderParam();
        return (ArrayList<ThunderVideoEncodeParamConfiguration>)object;
    }

    private static class YLEBase extends HPMarshaller {
        int event = 0;

        int event() {
            return event;
        }

        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLELogText extends YLEBase {
        private int level;
        private int module;
        private String tag;
        private String text;

        YLELogText(int _level, int _module, String _tag, String _text) {
            event = YYLIVE_LOG_TEXT;
            level = _level;
            module = _module;
            tag = _tag;
            text = _text;
        }

        @Override
        public byte[] marshall() {
            pushInt(level);
            pushInt(module);
            pushString16(tag);
            pushString32(text);
            return super.marshall();
        }
    }

    private static class YLELeaveRoom extends YLEBase {
        private int reverse;

        YLELeaveRoom() {
            event = YYLIVE_LEAVE_ROOM;
            reverse = 0;
        }

        @Override
        public byte[] marshall() {
            pushInt(reverse);
            return super.marshall();
        }
    }

    private static class YLESetPlayVolumeInterval extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetPlayVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            event = YYLIVE_SET_PLAY_VOLUME_INTERVAL;
            interval = _interval;
            moreThanThd = _moreThanThd;
            lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            pushInt(interval);
            pushInt(moreThanThd);
            pushInt(lessThanThd);
            return super.marshall();
        }
    }

    private static class YLESetCaptureVolumeInterval extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetCaptureVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            event = YYLIVE_SET_CAPTURE_VOLUME_INTERVAL;
            interval = _interval;
            moreThanThd = _moreThanThd;
            lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            pushInt(interval);
            pushInt(moreThanThd);
            pushInt(lessThanThd);
            return super.marshall();
        }
    }

    private static class YLEGetBeautifyLevel extends YLEBase {
        YLEGetBeautifyLevel() {
            event = YYLIVE_GET_BEAUTIFY_LEVEL;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetAbroadNetWorkStrategy extends YLEBase {
        YLEGetAbroadNetWorkStrategy() {
            event = YYLIVE_GET_ABROAD_NETWORK_STRATEGY;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEInitMultiPlayerViewLayout extends YLEBase {
        private Object multiParam;
        private int viewId;
        private  Object view;

        YLEInitMultiPlayerViewLayout(Object _multiParam, int _viewId, Object _view) {
            event = YYLIVE_INIT_MULTI_VIEW_LAYOUT;
            multiParam = _multiParam;
            viewId = _viewId;
            view = _view;
        }

        @Override
        public byte[] marshall() {
            pushInt64(YYLiveObjectToPtr(multiParam));
            pushInt(viewId);
            pushInt64(YYLiveObjectToPtr(view));
            return super.marshall();
        }
    }

    private static class YLESetVideoPlayType extends YLEBase {
        private int remotePlayType;
        private boolean checkJoined;

        YLESetVideoPlayType(int _remotePlayType, boolean _checkJoined) {
            event = THUNDER_SET_REMOTE_PLAY_TYPE;
            remotePlayType = _remotePlayType;
            checkJoined = _checkJoined;
        }

        @Override
        public byte[] marshall() {
            pushInt(remotePlayType);
            pushBool(checkJoined);
            return super.marshall();
        }
    }

    private static class YLESetCrashEvent extends YLEBase {
        YLESetCrashEvent() {
            event = THUNDER_SET_CRASH_EVENT;
        }

        @Override
        public byte[] marshall() { return super.marshall(); }
    }

    private static class YLESetParameters extends YLEBase {
        private String options;

        YLESetParameters(String options) {
            event = YYLIVE_ENABLE_VIDEO_SET_PARAMETERS_PROCESS;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            pushString16(options);
            return super.marshall();
        }
    }

   private static class YLEEnableVideoPublishBufferProcess extends YLEBase {
        private boolean bBufferMode;

        YLEEnableVideoPublishBufferProcess(boolean _bBufferMode) {
            event = YYLIVE_ENABLE_VIDEO_PUBLISH_BUFFER_PROCESS;
            bBufferMode = _bBufferMode;
        }

        @Override
        public byte[] marshall() {
            pushBool(bBufferMode);
            return super.marshall();
        }
    }

    private static class YLESetVideoCommonConfigMode extends YLEBase {
        private int mode;

        YLESetVideoCommonConfigMode(int _mode) {
            event = YYLIVE_SET_VIDEO_COMMON_CONFIG_MODE;
            mode = _mode;
        }

        @Override
        public byte[] marshall() {
            pushInt(mode);
            return super.marshall();
        }
    }

    private static class YLESetHardwareDecodeStatus extends YLEBase {
        private int mHardwareDecodeStatus;

        YLESetHardwareDecodeStatus(int _mHardwareDecodeStatus) {
            event = YYLIVE_SET_HARDWARE_DECODE_STATUS;
            mHardwareDecodeStatus = _mHardwareDecodeStatus;
        }

        @Override
        public byte[] marshall() {
            pushInt(mHardwareDecodeStatus);
            return super.marshall();
        }
    }


    private static class YLESetUseTextureView extends YLEBase {
        boolean mUseTextureView;

        YLESetUseTextureView(boolean _useTextureView) {
            event = THUNDER_SET_USE_TEXTURE_VIEW;
            mUseTextureView = _useTextureView;
        }

        @Override
        public byte[] marshall() {
            pushBool(mUseTextureView);
            return super.marshall();
        }
    }

    private static class YLEEnableWebSdkCompatibility extends YLEBase {
        private boolean enable;

        YLEEnableWebSdkCompatibility(boolean _enable) {
            event = YYLIVE_ENABLE_WEBSDK_COMPATIBILITY;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(enable);

            return super.marshall();
        }
    }

    private static class YLESetLocalVideoMirrorMode extends YLEBase {
        private int mode;

        YLESetLocalVideoMirrorMode(int _mode) {
            event = YYLIVE_SET_LOCAL_VIDEO_MIRROR_MODE;
            mode = _mode;
        }

        @Override
        public byte[] marshall() {
            pushInt(mode);

            return super.marshall();
        }
    }

    private static class YLESetRemoteAudioStreamVolume extends YLEBase {
        private String uid;
        private int volume;

        public YLESetRemoteAudioStreamVolume(String uid, int volume) {
            event = THUNDER_SET_REMOTE_AUDIO_STREAM_VOLUME;
            this.uid = uid;
            this.volume = volume;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushInt(volume);
            return super.marshall();
        }
    }

    private static class YLESetRemoteUidVoicePosition extends YLEBase {
        private String uid;
        private int azimuth;
        private int gain;

        public YLESetRemoteUidVoicePosition(String uid, int azimuth, int gain) {
            event = YYLIVE_SET_REMOTE_UID_VOICE_POSITION;
            this.uid = uid;
            this.azimuth = azimuth;
            this.gain = gain;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushInt(azimuth);
            pushInt(gain);
            return super.marshall();
        }
    }

    private static class YLESetSpeakerVolume extends YLEBase {
        private int volume;

        YLESetSpeakerVolume(int _volume) {
            event = YYLIVE_SET_SPEAKER_VOLUME;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt(volume);

            return super.marshall();
        }
    }

    private static class YLEGetH265SupportMode extends YLEBase {
        YLEGetH265SupportMode() {
            event = YYLIVE_H265_SUPPORT_MODE;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetH264SupportMode extends YLEBase {
        YLEGetH264SupportMode() {
            event = YYLIVE_H264_SUPPORT_MODE;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetHardDecodeRenderMode extends YLEBase {
        YLEGetHardDecodeRenderMode() {
            event = THUNDER_GET_HARD_DECODE_RENDER_CONFIG;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetAppCpuSupportMode extends YLEBase {
        YLEGetAppCpuSupportMode() {
            event = THUNDER_GET_CPU_RATE;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }


    private static class YLESetMicVolume extends YLEBase {
        private int volume;

        YLESetMicVolume(int _volume) {
            event = YYLIVE_SET_MIC_VOLUME;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt(volume);
            return super.marshall();
        }
    }

    private static class YLESetOrientation extends YLEBase {
        private int orientation;

        YLESetOrientation(int ori) {
            event = YYLIVE_SET_ORIENTATION;
            orientation = ori;
        }

        @Override
        public byte[] marshall() {
            pushInt(orientation);
            return super.marshall();
        }
    }

    private static class YLEGetOrientation extends YLEBase {
        YLEGetOrientation() {
            event = YYLIVE_GET_ORIENTATION;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetThunderboltPublishGroup extends YLEBase {
        private boolean isPublishGroup;

        YLESetThunderboltPublishGroup(boolean _isPublishGroup) {
            event = THUNDER_SET_THUNDERBOLT_PUBLISH_GROUP;
            isPublishGroup = _isPublishGroup;
        }

        @Override
        public byte[] marshall() {
            pushBool(isPublishGroup);
            return super.marshall();
        }
    }

    public static class YLEChangeScreenLiveMode extends YLEBase {
        private boolean bPicMode;
        private Object bitmap;

        public YLEChangeScreenLiveMode(boolean _bPicMode, Object _bitmap) {
            event = YYLIVE_CHANGE_SCREEN_LIVE_MODE;
            bPicMode = _bPicMode;
            bitmap = _bitmap;
        }

        @Override
        public byte[] marshall() {
            pushBool(bPicMode);
            pushInt64(YYLiveObjectToPtr(bitmap));
            return super.marshall();
        }
    }

    //YYLive System events
    private static class YLEEnterBackground extends YLEBase {
        private int reverse;

        YLEEnterBackground() {
            event = THUNDER_APP_ENTER_BACKGROUND;
            reverse = 0;
        }

        @Override
        public byte[] marshall() {
            pushInt(reverse);
            return super.marshall();
        }
    }

    private static class YLEEnterForeground extends YLEBase {
        private int reverse;

        YLEEnterForeground() {
            event = THUNDER_APP_ENTER_FOREGROUND;
            reverse = 0;
        }

        @Override
        public byte[] marshall() {
            pushInt(reverse);
            return super.marshall();
        }
    }

    private static class YLECreateAudioFilePlayer extends YLEBase {
        private Object obj;

        YLECreateAudioFilePlayer(Object _obj) {
            event = YYLIVE_CREATE_AUDIO_FILE_PLAYER;
            obj = _obj;
        }

        @Override
        public byte[] marshall() {
            pushInt64(YYLiveObjectToPtr(obj));

            return super.marshall();
        }
    }

    private static class YLEAudioFileOpen extends YLEBase {
        private long ctx;
        private String path;

        YLEAudioFileOpen(long _ctx, String _path) {
            event = YYLIVE_AUDIO_FILE_OPEN;
            path = _path;
            ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushString16(path);
            return super.marshall();
        }
    }

    private static class YLEAudioFileEventCommon extends YLEBase {
        private long ctx;

        YLEAudioFileEventCommon(int _event, long _ctx) {
            event = _event;
            ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);

            return super.marshall();
        }
    }

    private static class YLESendAudioFilePlayerInfo extends YLEBase {
        private int volume;
        private int currentMs;
        private int totalMs;

        YLESendAudioFilePlayerInfo(int _volume, int _currentMs, int _totalMs) {
            event = THUNDER_SEND_AUDIO_FILE_PLAYER_INFO;
            volume = _volume;
            currentMs = _currentMs;
            totalMs = _totalMs;
        }

        @Override
        public byte[] marshall() {
            pushInt(volume);
            pushInt(currentMs);
            pushInt(totalMs);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSeek extends YLEBase {
        private long ctx;
        private long timeMS;

        YLEAudioFileSeek(long _ctx, long _timeMS) {
            event = YYLIVE_AUDIO_FILE_SEEK;
            ctx = _ctx;
            timeMS = _timeMS;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(timeMS);

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayVolume extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayVolume(long _ctx, int _volume) {
            event = YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME;
            ctx = _ctx;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(volume);

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayerLocalVolume extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayerLocalVolume(long _ctx, int _volume) {
            event = YYLIVE_AUDIO_FILE_SET_PLAYER_LOCAL_VOLUME;
            ctx = _ctx;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(volume);

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayerPublishVolume extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayerPublishVolume(long _ctx, int _volume) {
            event = YYLIVE_AUDIO_FILE_SET_PLAYER_PUBLISH_VOLUME;
            ctx = _ctx;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(volume);

            return super.marshall();
        }
    }

    // TODO
    private static class YLEAudioFileSelectAudioTrack extends YLEBase {
        private long ctx;
        private int audioTrack;

        YLEAudioFileSelectAudioTrack(long _ctx, int _audioTrack) {
            ctx = _ctx;
            audioTrack = _audioTrack;
            event = YYLIVE_AUDIO_FILE_SELECT_AUDIOTRACK;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(audioTrack);

            return super.marshall();
        }
    }

    //

    private static class YLEAudioFileSetLooping extends YLEBase {
        private long ctx;
        private int cycle;

        YLEAudioFileSetLooping(long _ctx, int _cycle) {
            ctx = _ctx;
            cycle = _cycle;
            event = YYLIVE_AUDIO_FILE_SET_LOOPING;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(cycle);

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetSemitone extends YLEBase {
        private long ctx;
        private float val;

        YLEAudioFileSetSemitone(long _ctx, float _val) {
            event = YYLIVE_AUDIO_FILE_SET_SEMITONE;
            ctx = _ctx;
            val = _val;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushString16(String.valueOf(val * 1000000));

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetTempo extends YLEBase {
        private long ctx;
        private float val;

        YLEAudioFileSetTempo(long _ctx, float _val) {
            event = YYLIVE_AUDIO_FILE_SET_TEMPO;
            ctx = _ctx;
            val = _val;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            int value = (int)(val * 1000000);
            pushInt(value);

            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPosition extends YLEBase {
        private long ctx;
        private int azimuth;
        private int elevation;

        YLEAudioFileSetPosition(long _ctx, int  azim, int elev) {
            event = YYLIVE_AUDIO_FILE_SET_POSITION;
            ctx = _ctx;
            azimuth = azim;
            elevation = elev;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushInt(azimuth);
            pushInt(elevation);

            return super.marshall();
        }
    }

    private static class YLEAudioFileEnablePublish extends YLEBase {
        private long ctx;
        private boolean enable;

        YLEAudioFileEnablePublish(long _ctx, boolean _enable) {
            event = YYLIVE_AUDIO_FILE_ENABLE_PUBLISH;
            ctx = _ctx;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushBool(enable);

            return super.marshall();
        }
    }

    private static class YLEEnableAudioFileVolumeCallback extends YLEBase {
        private long ctx;
        private boolean enable;
        private int interval;

        YLEEnableAudioFileVolumeCallback(long _ctx, boolean _enable, int _interval) {
            event = YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK;
            ctx = _ctx;
            enable = _enable;
            interval = _interval;
        }

        @Override
        public byte[] marshall() {
            pushInt64(ctx);
            pushBool(enable);
            pushInt(interval);

            return super.marshall();
        }
    }

    private static class YLEAudioSetExternalProcessor extends YLEBase {
        private long eap;

        YLEAudioSetExternalProcessor(long _eap) {
            event = YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR;
            this.eap = _eap;
        }

        @Override
        public byte[] marshall() {
            pushInt64(eap);

            return super.marshall();
        }
    }

    private static class YLEEnableCapturePcmDataCallBack extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int room;

        YLEEnableCapturePcmDataCallBack(boolean enable, int sampleRate, int room) {
            event = YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.room = room;
        }

        @Override
        public byte[] marshall() {
            pushBool(enable);
            pushInt(sampleRate);
            pushInt(room);

            return super.marshall();
        }
    }

    private static class YLEEnableRenderPcmDataCallBack extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int room;

        YLEEnableRenderPcmDataCallBack(boolean enable, int sampleRate, int room) {
            event = YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.room = room;
        }

        @Override
        public byte[] marshall() {
            pushBool(enable);
            pushInt(sampleRate);
            pushInt(room);

            return super.marshall();
        }
    }

    private static class YLESendUserAppMsgData extends YLEBase {
        private byte[] msgData;

        YLESendUserAppMsgData(byte[] _msgData) {
            event = YYLIVE_SEND_USER_APP_MSG_DATA;
            msgData = _msgData;
        }

        @Override
        public byte[] marshall() {
            pushBytes(msgData);
            return super.marshall();
        }
    }

    private static class YLESendMediaExtraInfo extends YLEBase {
        private long timStamp =-1;
        private byte[] extraInfo;

        YLESendMediaExtraInfo(byte[] _extraInfo) {
            event = THUNDER_SEND_MEDIA_EXTRA_INFO;
            timStamp = -1;
            extraInfo = _extraInfo;
        }

        YLESendMediaExtraInfo(long _timeStamp, byte[] _extraInfo) {
            event = THUNDER_SEND_MEDIA_EXTRA_INFO;
            timStamp = _timeStamp;
            extraInfo = _extraInfo;
        }

        @Override
        public byte[] marshall() {
            pushInt64(timStamp);
            pushBytes(extraInfo);
            return super.marshall();
        }
    }

    private static class YLEEnableMixVideoExtraInfo extends YLEBase {
        private boolean enable;

        YLEEnableMixVideoExtraInfo(boolean enable) {
            event = THUNDER_ENABLE_MIX_VIDEO_EXTRA_INFO;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(enable);

            return super.marshall();
        }
    }

    private static class YLEEnableAudioDataIndication extends YLEBase {
        private boolean enable;

        YLEEnableAudioDataIndication(boolean enable) {
            event = YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(enable);

            return super.marshall();
        }
    }

    private static class YLESetHttpsBinaryResponse extends YLEBase {
        private String reqUrl;
        private byte[] response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsBinaryResponse(String _reqUrl,
                                  byte[] _response,
                                  int _statusCode,
                                  int _errCode,
                                  int _target) {
            event = YYLIVE_SET_HTTPS_RESPONSE;
            reqUrl = _reqUrl;
            response = _response;
            statusCode = _statusCode;
            errCode = _errCode;
            target = _target;
        }

        @Override
        public byte[] marshall() {
            pushString16(reqUrl);
            pushBytes(response);
            pushInt(statusCode);
            pushInt(errCode);
            pushInt(target);
            return super.marshall();
        }
    }

    private static class YLESetHttpsTextResponse extends YLEBase {
        private String reqUrl;
        private String response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsTextResponse(String _reqUrl,
                                String _response,
                                int _statusCode,
                                int _errCode,
                                int _target) {
            event = YYLIVE_SET_HTTPS_RESPONSE;
            reqUrl = _reqUrl;
            response = _response;
            statusCode = _statusCode;
            errCode = _errCode;
            target = _target;
        }

        @Override
        public byte[] marshall() {
            pushString16(reqUrl);
            pushString16(response);
            pushInt(statusCode);
            pushInt(errCode);
            pushInt(target);
            return super.marshall();
        }
    }

    private static class YLESetPlaybackAudioFrameParameters extends YLEBase {
        private int sampleRate;
        private int room;
        private int mode;
        private int samplesPerCall;

        YLESetPlaybackAudioFrameParameters(int _sampleRate, int _room, int _mode,
                                           int _samplesPerCall) {

            event = YYLIVE_SET_PLAY_AUDIO_PARAMS;
            sampleRate = _sampleRate;
            room = _room;
            mode = _mode;
            samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            pushInt(sampleRate);
            pushInt(room);
            pushInt(mode);
            pushInt(samplesPerCall);
            return super.marshall();
        }

    }

    /// transcoding
    private static class YLEUpdatePublishOriginStreamUrl extends YLEBase {
        private boolean bAdd;
        private String srcUrl;

        public YLEUpdatePublishOriginStreamUrl(boolean bAdd, String srcUrl) {
            event = YYLIVE_UPDATE_PUBLISH_ORIGIN_STREAM_URL;
            this.bAdd = bAdd;
            this.srcUrl = srcUrl;
        }

        @Override
        public byte[] marshall() {
            pushBool(bAdd);
            pushString16(srcUrl);
            return super.marshall();
        }
    }

    private static class YLEUpdatePublishTranscodingStreamUrl extends YLEBase {
        private String taskId;
        private boolean bAdd;
        private String transcodingUrl;

        public YLEUpdatePublishTranscodingStreamUrl(String taskId, boolean bAdd, String transcodingUrl) {
            event = THUNDER_UPDATE_PUBLISH_TRANSCODING_STREAM_URL;
            this.taskId = taskId;
            this.bAdd = bAdd;
            this.transcodingUrl = transcodingUrl;
        }

        @Override
        public byte[] marshall() {
            pushString16(taskId);
            pushBool(bAdd);
            pushString16(transcodingUrl);
            return super.marshall();
        }
    }

    private static class YLESetLiveTranscodingTask extends YLEBase
    {
        private String taskId;
        private LiveTranscoding transcoding;

        public YLESetLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
            event = THUNDER_SET_LIVE_TRANSCODING_TASK;
            this.taskId = taskId;
            this.transcoding = transcoding;
        }

        @Override
        public byte[] marshall() {
            pushString16(taskId);
            pushInt(transcoding.getTransCodingMode());
            CustomTranscodingOptions options = transcoding.getCustomTranscodingOptions();
            if (options != null)
            {
                pushInt(transcoding.getCustomTranscodingOptions().videoCodecType);
                pushInt(transcoding.getCustomTranscodingOptions().videoBitrate);
                pushInt(transcoding.getCustomTranscodingOptions().videoFps);
                pushInt(transcoding.getCustomTranscodingOptions().videoGop);
                pushInt(transcoding.getCustomTranscodingOptions().videoWidth);
                pushInt(transcoding.getCustomTranscodingOptions().videoHeight);
                pushInt(transcoding.getCustomTranscodingOptions().audioCodecType);
                pushInt(transcoding.getCustomTranscodingOptions().audioSample);
                pushInt(transcoding.getCustomTranscodingOptions().audioBitrate);
                pushInt(transcoding.getCustomTranscodingOptions().audioChannel);
            } else {
                pushInt(0);
                pushInt(0);
                pushInt(0);
                pushInt(0);
                pushInt(0);
                pushInt(0);
                pushInt(0);
                pushInt(44100);
                pushInt(64);
                pushInt(2);
            }

            if (transcoding.getUsers() == null || transcoding.getUsers().isEmpty()) {
                pushInt(0);
            }
            else
            {
                pushInt(transcoding.getUserCount());
                for (LiveTranscoding.TranscodingUser user : transcoding.getUsers()) {
                    pushString16(user.uid);
                    pushString16(user.roomId);
                    pushBool(user.bStandard);
                    pushInt(user.layoutX);
                    pushInt(user.layoutY);
                    pushInt(user.layoutW);
                    pushInt(user.layoutH);
                    pushInt(user.zOrder);
                    pushBool(user.bCrop);
                    pushInt(user.cropX);
                    pushInt(user.cropY);
                    pushInt(user.cropW);
                    pushInt(user.cropH);
                    pushString16(String.valueOf(user.alpha * 1000000));
                }
            }

            pushString16(transcoding.getAudioUrl());
            pushString16(transcoding.getLyricUrl());
            pushString16(transcoding.getMediaUrl());

            if ((!transcoding.getMediaUrl().isEmpty()) && (transcoding.getMediaStreamLayout() != null))
            {
                LiveTranscoding.MediaStreamLayout layout = transcoding.getMediaStreamLayout();
                pushInt(layout.layoutX);
                pushInt(layout.layoutY);
                pushInt(layout.layoutW);
                pushInt(layout.layoutH);
                pushInt(layout.zOrder);
                pushBool(layout.bCrop);
                pushInt(layout.cropX);
                pushInt(layout.cropY);
                pushInt(layout.cropW);
                pushInt(layout.cropH);
                pushString16(String.valueOf(layout.alpha * 1000000));
            }

            // 新增backgroundColor字段
            pushInt(transcoding.getBackgroundColor());

            // 新增backgroundImage字段
            TranscodingImage backgroundImage = transcoding.getBackgroundImage();
            if (backgroundImage != null && backgroundImage.url != null && !backgroundImage.url.isEmpty()) {
                pushString16(backgroundImage.url);
                pushInt(backgroundImage.scale);
            } else {
                pushString16("");
            }

            // 新增timestamp字段
            TranscodingTimestamp timestamp = transcoding.getTimestamp();
            if (timestamp != null && timestamp.format != null && !timestamp.format.isEmpty())
            {
                pushString16(timestamp.format);
                pushInt(timestamp.x);
                pushInt(timestamp.y);
                pushString16(timestamp.font);
                pushInt(timestamp.size);
                pushInt(timestamp.color);
                pushInt(timestamp.backgroundColor);
                pushString16(String.valueOf(timestamp.alpha * 1000000));
            } else {
                pushString16("");
            }

            // 新增mTextList字段
            ArrayList<TranscodingText> textList = transcoding.getTexts();
            if (textList == null || textList.isEmpty()) {
                pushInt(0);
            } else {
                pushInt((int)transcoding.getTextCount());
                for (TranscodingText text : textList) {
                    pushInt(text.x);
                    pushInt(text.y);
                    pushString16(text.content);
                    pushString16(text.font);
                    pushInt(text.size);
                    pushInt(text.color);
                    pushInt(text.backgroundColor);
                    pushString16(String.valueOf(text.alpha * 1000000));
                }
            }

            // 新增mImageList字段
            ArrayList<TranscodingImage> imageList = transcoding.getImages();
            if (imageList == null || imageList.isEmpty()) {
                pushInt(0);
            } else {
                pushInt((int)transcoding.getImageCount());
                for (TranscodingImage image : imageList) {
                    pushInt(image.x);
                    pushInt(image.y);
                    pushInt(image.width);
                    pushInt(image.height);
                    pushString16(image.url);
                    pushInt(image.scale);
                    pushString16(String.valueOf(image.alpha * 1000000));
                }
            }

            return super.marshall();
        }
    }

    private static class YLERemoveLiveTranscodingTask extends YLEBase {
        private String taskId;

        public YLERemoveLiveTranscodingTask(String taskId) {
            event = THUNDER_REMOVE_LIVE_TRANSCODING_TASK;
            this.taskId = taskId;
        }

        @Override
        public byte[] marshall() {
            pushString16(taskId);
            return super.marshall();
        }
    }

    private static class YLESetSidAndSubsid extends YLEBase {
        private int sid;
        private int subsid;

        public YLESetSidAndSubsid(int sid, int subsid) {
            event = THUNDER_SET_SID_AND_SUBSID;
            this.sid = sid;
            this.subsid = subsid;
        }

        @Override
        public byte[] marshall() {
            pushInt(sid);
            pushInt(subsid);
            return super.marshall();
        }
    }

    private static class YLEPrefetchStreams extends YLEBase {
        private String uid;
        private LinkedList<String> roomIds;

        YLEPrefetchStreams(String _uid, LinkedList<String> _roomIds) {
            event = THUNDER_PREFETCH_STREAMS;
            uid = _uid;
            roomIds = _roomIds;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            int size = roomIds.size();
            pushInt(size);
            for (int i = 0; i < size; i++) {
                pushString16(roomIds.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLEQueryStreams extends YLEBase {
        private LinkedList<String> roomIds;

        YLEQueryStreams(LinkedList<String> _roomIds) {
            event = THUNDER_QUERY_STREAMS;
            roomIds = _roomIds;
        }

        @Override
        public byte[] marshall() {
            int size = roomIds.size();
            pushInt(size);
            for (int i = 0; i < size; i++) {
                pushString16(roomIds.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLEMakeBehaviorEvent extends YLEBase {
        private String name;
        private String val;
        private String oval;
        private int level;

        YLEMakeBehaviorEvent(String name, String val, String oval, int level) {
            event = THUNDER_MAKE_BEHAVIOR_EVENT;
            this.name = name;
            this.val = val;
            this.oval = oval;
            this.level = level;
        }

        @Override
        public byte[] marshall() {
            pushString16(name);
            pushString16(val);
            pushString16(oval);
            pushInt(level);
            return super.marshall();
        }
    }

    /************************** new call ***********************/

    // new events
    public static int init(long appId,
                           long sceneId,
                           int areaType,
                           int serverDomain,
                           Context appContext,
                           ThunderDeviceInfo info,
                           NotificationDispatcher handlers) {
        if (s_notificationLock == null) {
            s_notificationLock = new ReentrantLock();
        }

        s_notificationLock.lock();
        try {
            s_notificationDispatcher = handlers;
        } finally {
            s_notificationLock.unlock();
        }

//		if (mGslbMethod == null) {
//			mGslbMethod = new GSLBMethod();
//			mGslbMethod.initService(appContext);
//		}

        YLESdkInit yle = new YLESdkInit(appId, sceneId, areaType, serverDomain, info);
        MshBuffer buffer = new MshBuffer(Marshallable.kProtoPacketSize, NativeByteBufferPool.get());
        byte[] refBytes = yle.HPmarshall(buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int validLen = byteBuffer.position();
        int ret = YYLiveSdkInit(appContext, refBytes, validLen);
        byteBuffer.position(0);
        buffer.freeBuffer();
        isInit = true;
        return ret;
    }

    // set log level
    public static int setLogLevel(int level) {
        return (int) YLEProcess(new YLESetLogLevel(level));
    }

    // set log filePath
    public static int setLogFilePath(String filePath) {
        return (int) YLEProcess(new YLESetLogFilePath(filePath));
    }

    // set log callback
    public static int setLogCallback(IThunderLogCallback callback) {
        s_logCallback = callback;
        return (int) YLEProcess(new YLEEnableLogCallback(callback != null));
    }

    // setSceneId
    public static void setSceneId(long sceneId) {
        YLEProcess(new YLESetSceneId(sceneId));
    }

    // update token
    public static int updateToken(byte[] token) {
        return (int) YLEProcess(new YLEUpdateToken(token));
    }

    // set media mode
    public static int setMediaMode(int mediaMode) {
        return (int) YLEProcess(new YLESetMediaMode(mediaMode));
    }

    // set room mode
    public static int setRoomMode(int roomMode) {
        return (int) YLEProcess(new YLESetRoomMode(roomMode));
    }

    // join room
    public static int joinRoom(byte[] token, String roomId, String uid) {
        return (int) YLEProcess(new YLEJoinLiveEngineRoom(token, roomId, uid));
    }

    // set remote video canvas
    public static int setRemoteVideoCanvas(Object view, int renderMode, String uid, int seatIndex) {
        return (int) YLEProcess(new YLESetRemoteVideoCanvas(view, renderMode, uid, seatIndex));
    }

    // set remote video canvas mode
    public static int setRemoteVideoCanvasMode(String uid, int renderMode, int mirrorMode) {
        return (int) YLEProcess(new YLESetRemoteVideoCanvasMode(uid, renderMode, mirrorMode));
    }

    // set local video canvas
    public static int setLocalVideoCanvas(Object view, int scaleMode) {
        return (int) YLEProcess(new YLESetLocalVideoCanvas(view, scaleMode));
    }

    // set local video canvas mode
    public static int setLocalVideoCanvasMode(int mode) {
        return (int) YLEProcess(new YLESetLocalVideoCanvasMode(mode));
    }

    // subscribe or unsubscribe user
    public static int subscribeUser(boolean bSubscribe, String roomId, String uid) {
        return (int) YLEProcess(new YLESubscribeUser(bSubscribe, roomId, uid));
    }

    // subscribe or unsubscribe room
    public static int subscribeRoom(boolean bSubscribe, String roomId) {
        return (int) YLEProcess(new YLESubscribeRoom(bSubscribe, roomId));
    }

    public static int getUserRole() {
        return (int) YLEProcess(new YLEGetUserRole());
    }

    //set subscribe group in thunderbolt mode
    public static int setThunderboltSubscribeGroup(boolean bSubscribe) {
        return (int) YLEProcess(new YLESetThunderboltSubscribeGroup(bSubscribe));
    }

    // stop(start) all remote streams(audio or video)
    public static int stopAllRemoteStreams(boolean bVideo, boolean bStop) {
        return (int) YLEProcess(new YLEStopAllRemoteStreams(bVideo, bStop));
    }

    // set local dual video stream mode
    public static int enableLocalDualStreamMode(boolean enabled) {
        return (int) YLEProcess(new YLEEnableLocalDualStreamMode(enabled));
    }

    // set default video stream type
    public static int setDefaultRemoteVideoStreamType(int type) {
        return (int) YLEProcess(new YLESetDefaultRemoteVideoStreamType(type));
    }

    // change remote video stream type
    public static int changeRemoteVideoStreamType(String uid, int type) {
        return (int) YLEProcess(new YLEChangeRemoteVideoStreamType(uid, type));
    }

    // set user role
    public static int switchUserRole(int role) {
        return (int) YLEProcess(new YLESwitchUserRole(role));
    }

    // stop(start) remote audio stream
    public static int stopRemoteAudioStream(String uid, boolean bStop) {
        return (int) YLEProcess(new YLEStopRemoteAudioStream(uid, bStop));
    }

    // stop(start) remote video stream
    public static int stopRemoteVideoStream(String uid, boolean bStop) {
        return (int) YLEProcess(new YLEStopRemoteVideoStream(uid, bStop));
    }

    // set area type
    public static int setAreaType(int areaType) {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(ThunderLog.kLogTagCall, "setAreaType %d", areaType);
}
        return (int) YLEProcess(new YLESetAreaType(areaType));
    }

    public static int getConnectionStatus() {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(ThunderLog.kLogTagCall, "getConnectionStatus");
}
        return (int) YLEProcess(new YLEGetConnectionStatus());
    }

    //开始/停止采集
    public static int startVideoCapture(boolean bStart) {
        return (int) YLEProcess(new YLEStartVideoCapture(bStart));
    }

    //开启/关闭预览
    public static int startLocalVideoPreview(boolean bStart) {
        return (int) YLEProcess(new YLEStartLocalVideoPreview(bStart));
    }

    // uid是否字符串类型（64位）
    public static int setUse64bitUid(boolean bUseStrUid) {
        return (int) YLEProcess(new YLESetUse64bitUid(bUseStrUid));
    }

    // 前后置摄像头
    public static int switchFrontCamera(boolean bFront) {
        return (int) YLEProcess(new YLESwitchFrontCamera(bFront));
    }

    public static boolean isCameraOpen() {
        return ((int)YLEProcess(new YLEIsCameraOpen()) == 0) ? false : true;
    }

    public static boolean isFrontCamera() {
        return ((int)YLEProcess(new YLEIsFrontCamera()) == 0) ? false : true;
    }

    //打开闪光灯
    public static int setCameraTorchOn(boolean isOn) {
        return (int)YLEProcess(new YLESetCameraTorchOn(isOn));
    }

    public static boolean isCameraManualFocusPositionSupported() {
        return ((int)YLEProcess(new YLEIsCameraManualFocusPositionSupported()) == 0) ? false : true;
    }

    public static boolean isCameraManualExposurePositionSupported() {
        return ((int)YLEProcess(new YLEIsCameraManualExposurePositionSupported()) == 0) ? false : true;
    }

    public static boolean isCameraZoomSupported() {
        return ((int)YLEProcess(new YLEIsCameraZoomSupported()) == 0) ? false : true;
    }

    public static float getCameraMaxZoomFactor() {
        long ret = YLEProcess(new YLEGetCameraMaxZoomFactor());
        return ret * 1.0f / 1000000;
    }

    public static int setCameraZoomFactor(float zoomFactor) {
        return (int)YLEProcess(new YLESetCameraZoomFactor(zoomFactor));
    }

    public static boolean isCameraTorchSupported() {
        return ((int)YLEProcess(new YLEIsCameraTorchSupported()) == 0) ? false : true;
    }

    public static int setCameraFocusPosition(float posX, float posY) {
        return (int) YLEProcess(new YLESetCameraFocusPosition(posX, posY));
    }

    public static int setCameraExposurePosition(float posX, float posY) {
        return (int)YLEProcess(new YLESetCameraExposurePosition(posX, posY));
    }

    public static boolean isCameraAutoFocusFaceModeSupported() {
        return ((int)YLEProcess(new YLEIsCameraAutoFocusFaceModeSupported()) == 0) ? false : true;
    }

    public static int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        return (int)YLEProcess(new YLESetCameraAutoFocusFaceModeEnabled(enable));
    }

    public static int startPushAudioStream(boolean bStart) {
        return (int) YLEProcess(new YLEStartPushAudioStream(bStart));
    }

    public static int isAudioCaptureEnabled() {
        return (int) YLEProcess(new YLEIsAudioCaptureEnabled());
    }

    public static int setAudioConfig(int profile, int commutMode, int scenarioMode) {
        return (int) YLEProcess(new YLESetAudioConfig(profile, commutMode, scenarioMode));
    }

    public static int startPublishAudio(boolean bStart) {
        return (int) YLEProcess(new YLEStartPublishAudio(bStart));
    }

    public static int startAudioCapture(boolean bStart) {
        return (int) YLEProcess(new YLEStartAudioCapture(bStart));
    }

    public static int startAudioEncode(boolean bStart) {
        return (int) YLEProcess(new YLEStartAudioEncode(bStart));
    }

    public static int setAudioPublishMode(int sourceType) {
        return (int) YLEProcess(new YLESetAudioPublishMode(sourceType));
    }

    public static int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {
        return (int) YLEProcess(new YLESetCustomAudioSource(enabled, sampleRate, channel));
    }

    public static int setPubWatermark(ThunderBoltImage watermark) {
        return (int) YLEProcess(new YLESetPubWatermark(watermark));
    }

    public static int pushCustomAudioFrame(byte[] data, long timeStamp) {
        return (int) YLEProcess(new YLEPushCustomAudioFrame(data, timeStamp));
    }

    public static int startVideoEncode(boolean bStart) {
        return (int) YLEProcess(new YLEStartVideoEncode(bStart));
    }

    public static int startPushVideoStream(boolean bStart) {
        return (int) YLEProcess(new YLEStartPushVideoStream(bStart));
    }

    public static int startPreview(boolean bStart) {
        return (int) YLEProcess(new YLEStartPreview(bStart));
    }

    public static int attachVideoCapture(Object capture, int captureType) {
        return (int) YLEProcess(new YLEAttachVideoCapture(capture, captureType));
    }

    public static int setVideoEncoderConfig(ThunderVideoEncoderConfiguration vidCfg) {
        return (int) YLEProcess(new YLESetVideoEncoderConfig(vidCfg.playType, vidCfg.publishMode));
    }

    public static int setVideoEncoderParameters(ThunderVideoEncoderParam videoEncoderParam, List<ThunderRtcVideoTransParam> rtcVideoTransParam) {
        return (int) YLEProcess(new YLESetVideoEncoderParameters(videoEncoderParam, rtcVideoTransParam));
    }

    public static int switchAudienceMode(int audienceMode) {
        return (int) YLEProcess(new YLESwitchAudienceMode(audienceMode));
    }

    public static int setRtcDefaultTransIdInAuto(int defaultTransIdInAuto) {
        return (int) YLEProcess(new YLESetRtcDefaultTransIdInAuto(defaultTransIdInAuto));
    }

    public static int setSubscribeVideoTransId(String uid, int subTransId) {
        return (int) YLEProcess(new YLESetSubscribeVideoTransId(uid, subTransId));
    }

    public static int getPlayingVideoTransId(String uid) {
        return (int) YLEProcess(new YLEGetPlayingVideoTransId(uid));
    }

    public static int setCustomVideoPublishConfig(ThunderPublishVideoConfig publishInfo) {
        return (int) YLEProcess(new YLESetCustomVideoPublishConfig(publishInfo.playType,
                publishInfo.mode, publishInfo.encodeResolutionWidth, publishInfo.encodeResolutionHeight,
                publishInfo.encodeBitrate, publishInfo.encodeFrameRate, publishInfo.lowStreamCfgs));
    }

    public static int setCustomStreamName(int streamType, String streamName)
    {
        return (int) YLEProcess(new YLESetCustomStreamName(streamType, streamName));
    }

    public static int setSubscribeGroupInThunder(boolean bSubscribe) {
        return (int) YLEProcess(new YLESetSubscribeGroupInThunder(bSubscribe));
    }

    public static int setCustomPublishAppid(int pubAppid) {
        return (int) YLEProcess(new YLESetCustomPublishAppid(pubAppid));
    }

    public static void notifyNetState(int state) {
        YLEProcess(new YLENotifyNetworkState(state));
    }

    public static void enterBackground() {
        YLEProcess(new YLEEnterBackground());
    }

    public static void enterForeground() {
        YLEProcess(new YLEEnterForeground());
    }

    public static int enableLoudSpeaker(boolean enable) {
        return (int) YLEProcess(new YLEEnableLoudSpeaker(enable));
    }

    public static boolean getLoudSpeakerEnabled() {
        return ((int) YLEProcess(new YLEGetLoudSpeakerEnabled()) == 0) ? true : false;
    }

    public static int adaptToSystemKaraoke(boolean enable) {
        return (int)YLEProcess(new YLEadaptToSystemKaraoke(enable));
    }

    public static int enableInEarMonitor(boolean enable) {
        return (int) YLEProcess(new YLEenableInEarMonitor(enable));
    }

    public static int setEarMonitoringVolume(int volume) {
        return (int) YLEProcess(new YLEsetEarMonitoringVolume(volume));
    }

    public static int enableEqualizer(boolean enable) {
        return (int) YLEProcess(new YLEEnableEqualizer(enable));
    }

    public static int setGqGains(final int[] gains) {
        return (int) YLEProcess(new YLESetEqGains(gains));
    }

    public static int enableCompressor(boolean enable) {
        return (int) YLEProcess(new YLEEnableCompressor(enable));
    }

    public static int setVoicePitch(float pitch) {
        return (int) YLEProcess(new YLESetVoicePitch(pitch));
    }

    public static int enableHowlingDetector(boolean enable) {
        return (int) YLEProcess(new YLEEnableHowlingDetector(enable));
    }

    public static int enableEchoDetector(boolean enable) {
        return (int) YLEProcess(new YLEEnableEchoDetector(enable));
    }

    public static int enableLocalSpeakingDetector(boolean enable) {
        return (int) YLEProcess(new YLEEnableLocalSpeakingDetector(enable));
    }

    public static int startInputDeviceTest() {
        return (int) YLEProcess(new YLEStartInputDeviceTest());
    }

    public static int stopInputDeviceTest() {
        return (int) YLEProcess(new YLEStopInputDeviceTest());
    }

    public static int startOutputDeviceTest(String filePath) {
        return (int) YLEProcess(new YLEStartOutputDeviceTest(filePath));
    }

    public static int stopOutputDeviceTest() {
        return (int) YLEProcess(new YLEStopOutputDeviceTest());
    }

    public static int enableMicDenoise(boolean enable) {
        return (int) YLEProcess(new YLEEnableMicDenoise(enable));
    }

    public static int enableAGC(boolean enable) {
        return (int) YLEProcess(new YLEEnableAudioAGC(enable));
    }

    public static int enableAIDenoise(boolean enable) {
        return (int) YLEProcess(new YLEEnableAIDenoise(enable));
    }

    public static boolean micDenoiseEnabled() {
        return ((int) YLEProcess(new YLEIsMicDenoiseEnable()) == 0) ? false : true;
    }

    public static int setCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime,
                                          int attackTime) {
        return (int) YLEProcess(new YLESetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime));
    }

    public static int enableReverb(boolean enable) {
        return (int) YLEProcess(new YLEEnableReverb(enable));
    }

    public static int setReverbExParameter(final float RoomSize, final float PreDelay, final float Reverberance,
                                            final float HfDamping, final float ToneLow, final float ToneHigh,
                                            final float WetGain, final float DryGain, final float StereoWidth) {
        return (int) YLEProcess(new YLESetReverbExParameter(RoomSize, PreDelay, Reverberance, HfDamping, ToneLow, ToneHigh, WetGain,
                DryGain, StereoWidth));
    }

    public static int setLimiterParameter(final float fCeiling, final float fThreshold, final float fPreGain,
                                           final float fRelease, final float fAttack, final float fLookahead,
                                           final float fLookaheadRatio, final float fRMS, final float fStLink) {
        return (int) YLEProcess(new YLESetLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead,
                fLookaheadRatio, fRMS, fStLink));
    }

    public static int enableLimiter(boolean enable) {
        return (int) YLEProcess(new YLEEnableLimiter(enable));
    }

    public static boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return (YLEProcess(new YLEStartAudioSaver(fileName, saverMode, fileMode)) == 0) ? true : false;
    }

    public static boolean stopAudioSaver() {
        return (YLEProcess(new YLEStopAudioSaver()) == 0) ? true : false;
    }

    public static int startAudioRecord(String fileName, int saverMode, int sampleRate, int quality) {
        return (int)YLEProcess(new YLEStartAudioRecord(fileName, saverMode, sampleRate, quality));
    }

    public static int stopAudioRecord() {
        return (int)YLEProcess(new YLEStopAudioRecord());
    }

    public static int enableAudioPlaySpectrum(boolean enable) {
        return (int) YLEProcess(new YLEEnableAudioPlaySpectrum(enable));
    }

    public static int setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        return (int) YLEProcess(new YLESetAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS));
    }

    public static int enableVoicePosition(boolean enable) {
        return (int) YLEProcess(new YLEEnableVoicePosition(enable));
    }

    public static boolean setSoundEffect(int soundEffectMode) {
        return  (0 == YLEProcess(new YLESetSoundEffect(soundEffectMode))) ? true : false;
    }

    public static boolean setVoiceChanger(int mode) {
        return (0 == YLEProcess(new YLESetVoiceChanger(mode))) ? true : false;
    }

    public static int setVideoFrameObserver(String uid, IVideoDecodeObserver observer) {
        return (int) YLEProcess(new YLEVideoFrameObserverStringUid(uid, observer));
    }

    public static int setRecordingAudioFrameParameters(int sampleRate,
                                                       int channel,
                                                       int mode,
                                                       int samplesPerCall) {
        return (int) YLEProcess(new YLESetRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    public static int setMixedAudioFrameParameters(int sampleRate,
                                                   int channel,
                                                   int samplesPerCall) {
        return (int) YLEProcess(new YLESetMixedAudioFrameParameters(sampleRate, channel, samplesPerCall));
    }

    public static int updatePublishOriginStreamUrl(boolean bAdd, String srcUrl) {
        return (int) YLEProcess(new YLEUpdatePublishOriginStreamUrl(bAdd, srcUrl));
    }

    public static int updatePublishTranscodingStreamUrl(String taskId, boolean bAdd, String transCodingUrl) {
        return (int) YLEProcess(new YLEUpdatePublishTranscodingStreamUrl(taskId, bAdd, transCodingUrl));
    }

    public static int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        return (int) YLEProcess(new YLESetLiveTranscodingTask(taskId, transcoding));
    }

    public static int removeLiveTranscodingTask(String taskId) {
        return (int) YLEProcess(new YLERemoveLiveTranscodingTask(taskId));
    }

    public static int setSidAndSubsid(int sid, int subsid) {
        return (int) YLEProcess(new YLESetSidAndSubsid(sid, subsid));
    }

    public static int makeBehaviorEvent(String name, String val, String oval, int level) {
        return (int) YLEProcess(new YLEMakeBehaviorEvent(name, val, oval, level));
    }

    public static int prefetchStreams(String uid, LinkedList<String> roomIds) {
        return (int) YLEProcess(new YLEPrefetchStreams(uid, roomIds));
    }

    public static int queryStreams(LinkedList<String> roomIds) {
        return (int) YLEProcess(new YLEQueryStreams(roomIds));
    }

    private static class YLESetLogLevel extends YLEBase {
        private int logLevel;

        public YLESetLogLevel(int logLevel) {
            event = THUNDER_SET_LOG_LEVEL;
            this.logLevel = logLevel;
        }

        @Override
        public byte[] marshall() {
            pushInt(logLevel);
            return super.marshall();
        }
    }

    private static class YLESetLogFilePath extends YLEBase {
        private String filePath;

        public YLESetLogFilePath(String filePath) {
            event = THUNDER_SET_LOG_FILE_PATH;
            this.filePath = filePath;
        }

        @Override
        public byte[] marshall() {
            pushString16(filePath);
            return super.marshall();
        }
    }

    private static class YLEEnableLogCallback extends YLEBase {
        private boolean bCallback;

        public YLEEnableLogCallback(boolean bCallback) {
            event = THUNDER_ENABLE_LOG_CALLBACK;
            this.bCallback = bCallback;
        }

        @Override
        public byte[] marshall() {
            pushBool(bCallback);
            return super.marshall();
        }
    }


    private static class YLESetSceneId extends YLEBase {
        private long sceneId;

        YLESetSceneId(long _sceneId) {
            event = YYLIVE_SET_SCENE_ID;
            sceneId = _sceneId;
        }

        @Override
        public byte[] marshall() {
            pushInt(sceneId);
            return super.marshall();
        }
    }

    private static class YLEUpdateToken extends YLEBase {
        byte[] token;

        YLEUpdateToken(byte[] _token) {
            event = YYLIVE_UPDATE_TOKEN;
            token = _token;
        }

        @Override
        public byte[] marshall() {
            pushBytes(token);
            return super.marshall();
        }
    }

    private static class YLESetMediaMode extends YLEBase {
        private int mediaMode;

        public YLESetMediaMode(int mediaMode) {
            event = THUNDER_SET_MEDIA_MODE;
            this.mediaMode = mediaMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(mediaMode);
            return super.marshall();
        }
    }

    private static class YLESetRoomMode extends YLEBase {
        private int roomMode;

        public YLESetRoomMode(int roomMode) {
            event = THUNDER_SET_ROOM_MODE;
            this.roomMode = roomMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(roomMode);
            return super.marshall();
        }
    }

    private static class YLEJoinLiveEngineRoom extends YLEBase {

        private byte[] token;
        private String roomId;
        private String uid;

        public YLEJoinLiveEngineRoom(byte[] token, String roomId, String uid) {

            event = THUNDER_JOIN_ROOM;
            this.token = token;
            this.roomId = roomId;
            this.uid = uid;
        }

        @Override
        public byte[] marshall() {
            pushBytes(token);
            pushString16(roomId);
            pushString16(uid);
            return super.marshall();
        }
    }

    private static class YLESetRemoteVideoCanvas extends YLEBase {
        private Object view;
        private int renderMode;
        private String uid;
        private int seatIndex;

        public YLESetRemoteVideoCanvas(Object view, int renderMode, String uid, int seatId) {
            event = THUNDER_SET_REMOTE_VIDEO_CANVAS;
            this.view = view;
            this.renderMode = renderMode;
            this.uid = uid;
            this.seatIndex = seatId;
        }

        @Override
        public byte[] marshall() {
            pushInt64(YYLiveObjectToPtr(view));
            pushInt(renderMode);
            pushString16(uid);
            pushInt(seatIndex);
            return super.marshall();
        }
    }

    private static class YLESetRemoteVideoCanvasMode extends YLEBase {

        private String uid;
        private int renderMode;
        private int mirrorMode;

        public YLESetRemoteVideoCanvasMode(String uid, int renderMode, int mirrorMode) {
            event = THUNDER_SET_REMOTE_VIDEO_CANVAS_MODE;
            this.uid = uid;
            this.renderMode = renderMode;
            this.mirrorMode = mirrorMode;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushInt(renderMode);
            pushInt(mirrorMode);
            return super.marshall();
        }
    }

    private static class YLESetLocalVideoCanvas extends YLEBase {
        private Object view;
        private int scaleMode;

        public YLESetLocalVideoCanvas(Object view, int scaleMode) {
            event = THUNDER_SET_LOCAL_VIDEO_CANVAS;
            this.view = view;
            this.scaleMode = scaleMode;
        }

        @Override
        public byte[] marshall() {
            pushInt64(YYLiveObjectToPtr(view));
            pushInt(scaleMode);
            return super.marshall();
        }
    }

    private static class YLESetLocalVideoCanvasMode extends YLEBase {
        private int mode;

        public YLESetLocalVideoCanvasMode(int mode) {
            event= THUNDER_SET_Local_VIDEO_CANVAS_MODE;
            this.mode = mode;
        }

        @Override
        public byte[] marshall() {
            pushInt(mode);
            return super.marshall();
        }
    }

    private static class YLESubscribeUser extends YLEBase {

        private boolean bSubscribe; //ture: subcribe, false:unSubsribe
        private String roomId;
        private String uid;

        public YLESubscribeUser(boolean bSubscribe, String roomId, String uid) {
            event = THUNDER_SUBSCRIBE_USER;
            this.bSubscribe = bSubscribe;
            this.roomId = roomId;
            this.uid = uid;
        }

        @Override
        public byte[] marshall() {
            pushBool(bSubscribe);
            pushString16(roomId);
            pushString16(uid);
            return super.marshall();
        }
    }

    private static class YLESubscribeRoom extends YLEBase {

        private boolean bSubscribe; //ture: subcribe, false:unSubsribe
        private String roomId;

        public YLESubscribeRoom(boolean bSubscribe, String roomId) {
            event = THUNDER_SUBSCRIBE_ROOM;
            this.bSubscribe = bSubscribe;
            this.roomId = roomId;
        }

        @Override
        public byte[] marshall() {
            pushBool(bSubscribe);
            pushString16(roomId);
            return super.marshall();
        }
    }

    private static class YLEGetUserRole extends YLEBase {
        public YLEGetUserRole() {
            event = THUNDER_GET_USER_ROLE;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetThunderboltSubscribeGroup extends YLEBase
    {
        private boolean bSubscribe;

        public YLESetThunderboltSubscribeGroup(boolean bSubscribe) {
            event = THUNDER_SET_THUNDERBOLT_SUBSCRIBE_GROUP;
            this.bSubscribe = bSubscribe;
        }

        @Override
        public byte[] marshall() {
            pushBool(bSubscribe);
            return super.marshall();
        }
    }

    private static class YLEStopAllRemoteStreams extends YLEBase {

        private boolean bVideo; // true:video stream; false:audio stream
        private boolean bStop; // true:mute all; false:start all

        public YLEStopAllRemoteStreams(boolean bVideo, boolean bStop) {
            event = THUNDER_STOP_ALL_REMOTE_STREAMS;
            this.bVideo = bVideo;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            pushBool(bVideo);
            pushBool(bStop);
            return super.marshall();
        }
    }

    private static class YLEEnableLocalDualStreamMode extends YLEBase {

        private boolean enbaled;// true :dual stream  False:single stream

        public YLEEnableLocalDualStreamMode(boolean enbaled) {
            event = THUNDER_ENABLE_LOCAL_DUANL_STREAM_MODE;
            this.enbaled = enbaled;
        }

        @Override
        public byte[] marshall() {
            pushBool(enbaled);
            return super.marshall();
        }
    }

    private static class YLESetDefaultRemoteVideoStreamType extends YLEBase {

        private int type;// video stream type

        public YLESetDefaultRemoteVideoStreamType(int type) {
            event = THUNDER_SET_DEFAULT_REMOTE_VIDEO_STREAM_TYPE;
            this.type = type;
        }

        @Override
        public byte[] marshall() {
            pushInt(type);
            return super.marshall();
        }
    }

    private static class YLEChangeRemoteVideoStreamType extends YLEBase {

        private int type; // video stream type
        private String uid; // remote video strUid

        public YLEChangeRemoteVideoStreamType(String uid, int type) {
            event = THUNDER_CHANGE_REMOTE_VIDEO_STREAM_TYPE;
            this.uid = uid;
            this.type = type;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushInt(type);
            return super.marshall();
        }
    }

    private static class YLESwitchUserRole extends YLEBase {

        private int role; // user role

        public YLESwitchUserRole(int role) {
            event = THUNDER_SWITCH_USER_ROLE;
            this.role = role;
        }

        @Override
        public byte[] marshall() {
            pushInt(role);
            return super.marshall();
        }
    }

    private static class YLEStopRemoteAudioStream extends YLEBase {
        private String uid;
        private boolean bStop;

        public YLEStopRemoteAudioStream(String uid, boolean bStop) {
            event = THUNDER_STOP_REMOTE_AUDIO_STREAM;
            this.uid = uid;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushBool(bStop);
            return super.marshall();
        }
    }

    private static class YLEStopRemoteVideoStream extends YLEBase {
        private String uid;
        private boolean bStop;

        public YLEStopRemoteVideoStream(String uid, boolean bStop) {
            event = THUNDER_STOP_REMOTE_VIDEO_STREAM;
            this.uid = uid;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushBool(bStop);
            return super.marshall();
        }
    }

    private static class YLESetAreaType extends YLEBase {
        private int areaType;

        YLESetAreaType(int _areaType) {
            event = YYLIVE_SET_AREA_TYPE;
            areaType = _areaType;
        }

        @Override
        public byte[] marshall() {
            pushInt(areaType);
            return super.marshall();
        }
    }

    private static class YLESetUse64bitUid extends YLEBase {
        private boolean bUser64bitUid;

        public YLESetUse64bitUid(boolean bUser64bitUid) {
            event = THUNDER_SET_USER_64BIT_UID;
            this.bUser64bitUid = bUser64bitUid;
        }

        @Override
        public byte[] marshall() {
            pushBool(bUser64bitUid);
            return super.marshall();
        }
    }

    private static class YLEStartVideoCapture extends YLEBase {
        private boolean bStart;

        public YLEStartVideoCapture(boolean bStart) {
            event = THUNDER_START_VIDEO_CAPTURE;
            this.bStart = bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(bStart);
            return super.marshall();
        }
    }

    private static class YLEStartLocalVideoPreview extends YLEBase {
        private boolean bStart;

        public YLEStartLocalVideoPreview(boolean bStart) {
            event = THUNDER_START_VIDEO_LOCAL_PREVIEW;
            this.bStart = bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(bStart);
            return super.marshall();
        }
    }

    private static class YLESwitchFrontCamera extends YLEBase {
        private boolean bFront;

        public YLESwitchFrontCamera(boolean _bFront) {
            event = THUNDER_SWITCH_FRONT_CAMERA;
            this.bFront = _bFront;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.bFront);
            return super.marshall();
        }
    }

    private static class YLEIsCameraOpen extends YLEBase {
        public YLEIsCameraOpen() {
            event = THUNDER_IS_CAMERA_OPEN;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsFrontCamera extends YLEBase {
        public YLEIsFrontCamera() {
            event = THUNDER_IS_FRONT_CAMERA;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraManualFocusPositionSupported extends YLEBase {
        public YLEIsCameraManualFocusPositionSupported() {
            event = THUNDER_IS_CAMERA_MANUAL_FOCUS_POSITION_SUPPORTED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraManualExposurePositionSupported extends YLEBase {
        public YLEIsCameraManualExposurePositionSupported() {
            event = THUNDER_IS_CAMERA_MANUAL_EXPOSURE_POSITION_SUPPORTED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraZoomSupported extends YLEBase {
        public YLEIsCameraZoomSupported() {
            event = THUNDER_IS_CAMERA_ZOOM_SUPPORTED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraTorchSupported extends YLEBase {
        public YLEIsCameraTorchSupported() {
            event = THUNDER_IS_CAMERA_TORCH_SUPPORTED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetCameraMaxZoomFactor extends YLEBase {
        public YLEGetCameraMaxZoomFactor() {
            event = THUNDER_GET_CAMERA_MAX_ZOOM_FACTOR;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetCameraZoomFactor extends YLEBase {
        private float zoomFactor;

        public YLESetCameraZoomFactor(float _zoomFactor) {
            event = THUNDER_SET_CAMERA_ZOOM_FACTOR;
            this.zoomFactor = _zoomFactor;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.zoomFactor * 1000000));
            return super.marshall();
        }
    }

    private static class YLESetCameraTorchOn extends YLEBase {
        private boolean isOn;

        public YLESetCameraTorchOn(boolean _isOn) {
            event = THUNDER_SET_CAMERA_TORCH_ON;
            this.isOn = _isOn;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.isOn);
            return super.marshall();
        }
    }

    private static class YLESetCameraFocusPosition extends YLEBase {
        private float posX;
        private float posY;

        public YLESetCameraFocusPosition(float _posX, float _posY) {
            event = THUNDER_SET_CAMERA_FOCUS_POSITION;
            this.posX = _posX;
            this.posY = _posY;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.posX * 1000000));
            pushString16(String.valueOf(this.posY * 1000000));
            return super.marshall();
        }
    }

    private static class YLESetCameraExposurePosition extends YLEBase {
        private float posX;
        private float posY;

        public YLESetCameraExposurePosition(float _posX, float _posY) {
            event = THUNDER_SET_CAMERA_EXPOSURE_POSITION;
            this.posX = _posX;
            this.posY = _posY;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.posX * 1000000));
            pushString16(String.valueOf(this.posY * 1000000));
            return super.marshall();
        }
    }

    private static class YLEIsCameraAutoFocusFaceModeSupported extends YLEBase {
        public YLEIsCameraAutoFocusFaceModeSupported() {
            event = THUNDER_IS_CAMERA_AUTO_FOCUS_FACE_MODE_SUPPORTED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetCameraAutoFocusFaceModeEnabled extends YLEBase {
        private boolean enable;

        public YLESetCameraAutoFocusFaceModeEnabled(boolean _enable) {
            event = THUNDER_SET_CAMERA_AUTO_FOCUS_FACE_MODE_ENABLED;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESendPrivateMediaExtraData extends YLEBase {
        private String extraData;

        YLESendPrivateMediaExtraData(String _extraData) {
            event = THUNDER_SEND_PRIVATE_MEDIA_EXTRA_DATA;
            extraData = _extraData;
        }

        @Override
        public byte[] marshall() {
            pushString16(extraData);
            return super.marshall();
        }
    }

    private static class YLEStartPublishAudio extends YLEBase {
        private boolean bStart;

        public YLEStartPublishAudio(boolean _bStart) {
            event = THUNDER_START_PUBLISH_AUDIO;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartAudioCapture extends YLEBase {
        private boolean bStart;

        public YLEStartAudioCapture(boolean _bStart) {
            event = THUNDER_START_AUDIO_CAPTURE;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartAudioEncode extends YLEBase {
        private boolean bStart;

        public YLEStartAudioEncode(boolean _bStart) {
            event = THUNDER_START_AUDIO_ENCODE;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartPushAudioStream extends YLEBase {
        private boolean bStart;

        public YLEStartPushAudioStream(boolean _bStart) {
            event = THUNDER_START_PUSH_AUDIO_STREAM;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLESetAudioPublishMode extends YLEBase {
        private int sourceType;

        public YLESetAudioPublishMode(int _sourceType) {
            event = THUNDER_SET_AUDIO_PUBLISH_MODE;
            this.sourceType = _sourceType;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.sourceType);
            return super.marshall();
        }
    }

    private static class YLESetAudioConfig extends YLEBase {
        private int profile;
        private int commutMode;
        private int scenarioMode;

        public YLESetAudioConfig(int _profile, int _commutMode, int _scenarioMode) {
            event = THUNDER_SET_AUDIO_CONFIG;
            this.profile = _profile;
            this.commutMode = _commutMode;
            this.scenarioMode = _scenarioMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.profile);
            pushInt(this.commutMode);
            pushInt(this.scenarioMode);
            return super.marshall();
        }
    }

    private static class YLESetCustomAudioSource extends YLEBase {
        private boolean bEnable;
        private int sampleRate;
        private int channel;

        public YLESetCustomAudioSource(boolean _bEnable, int _sampleRate, int _channel) {
            event = THUNDER_SET_CUSTOME_AUDIO_SOURCE;
            this.bEnable = _bEnable;
            this.sampleRate = _sampleRate;
            this.channel = _channel;
        }
        @Override
        public byte[] marshall() {
            pushBool(this.bEnable);
            pushInt(this.sampleRate);
            pushInt(this.channel);
            return super.marshall();
        }
    }

    private static class YLESetPubWatermark extends YLEBase {
        private int x = 0;
        private int y = 0;
        private int width = 0;
        private int height = 0;
        private String imageUrl = null;

        public YLESetPubWatermark(ThunderBoltImage image) {
            event = THUNDER_SET_PUB_WATERMARK;
            if (image != null) {
                this.x = image.x;
                this.y = image.y;
                this.width = image.width;
                this.height = image.height;
                this.imageUrl = image.url;
            }
        }

        @Override
        public byte[] marshall() {
            pushInt(x);
            pushInt(y);
            pushInt(width);
            pushInt(height);
            pushString16(imageUrl);
            return super.marshall();
        }
    }

    private static class YLEPushCustomAudioFrame extends YLEBase {
        private byte[] data;
        private long timeStamp;

        public YLEPushCustomAudioFrame(byte[] _data, long _timeStamp) {
            event = THUNDER_PUSH_CUSTOME_AUDIO_FRAME;
            this.data = _data;
            this.timeStamp = _timeStamp;
        }
        @Override
        public byte[] marshall() {
            pushBytes(this.data);
            pushInt64(this.timeStamp);
            return super.marshall();
        }
    }

    private static class YLEStartVideoEncode extends YLEBase {
        private boolean bEnable;

        public YLEStartVideoEncode(boolean _bEnable) {
            event = THUNDER_START_VIDEO_ENCODE;
            this.bEnable = _bEnable;
        }
        @Override
        public byte[] marshall() {
            pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEStartPushVideoStream extends YLEBase {
        private boolean bEnable;

        public YLEStartPushVideoStream(boolean _bEnable) {
            event = THUNDER_START_PUBLISH_VIDEO_STREAM;
            this.bEnable = _bEnable;
        }
        @Override
        public byte[] marshall() {
            pushBool(this.bEnable);
            return super.marshall();
        }
    }
    private static class YLEStartPreview extends YLEBase {
        private boolean bEnable;

        public YLEStartPreview(boolean _bEnable) {
            event = THUNDER_START_PREVIEW;
            this.bEnable = _bEnable;
        }
        @Override
        public byte[] marshall() {
            pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEAttachVideoCapture extends YLEBase {
        private Object capture;
        private int capType;

        public YLEAttachVideoCapture(Object _capture, int _type) {
            event = THUNDER_ATTACH_VIDEO_CAPTURE;
            this.capture = _capture;
            this.capType = _type;
        }
        @Override
        public byte[] marshall() {
            pushInt64(YYLiveObjectToPtr(this.capture));
            pushInt(this.capType);
            return super.marshall();
        }
    }

    private static class YLESetVideoEncoderConfig extends YLEBase {
        private int playType;
        private int publishMode;

        public YLESetVideoEncoderConfig(int _playType, int _publishMode) {
            event = THUNDER_SET_VIDEO_ENCODER_CONFIG;
            this.playType = _playType;
            this.publishMode = _publishMode;
        }
        @Override
        public byte[] marshall() {
            pushInt(this.playType);
            pushInt(this.publishMode);
            return super.marshall();
        }
    }

    private static class YLESetVideoEncoderParameters extends YLEBase {
        private ThunderVideoEncoderParam videoEncoderParam;
        private List<ThunderRtcVideoTransParam> thunderRtcVideoTransParam;

        public YLESetVideoEncoderParameters(ThunderVideoEncoderParam videoEncoderParam, List<ThunderRtcVideoTransParam> thunderRtcVideoTransParam) {
            event = THUNDER_SET_VIDEO_ENCODER_PARAMETERS;
            this.videoEncoderParam = videoEncoderParam;
            this.thunderRtcVideoTransParam = thunderRtcVideoTransParam;
        }
        @Override
        public byte[] marshall() {
            int count = 0;
            pushInt(videoEncoderParam.width);
            pushInt(videoEncoderParam.height);
            pushInt(videoEncoderParam.frameRate);
            pushInt(videoEncoderParam.bitrate);
            pushInt(videoEncoderParam.minBitrate);
            pushInt(videoEncoderParam.degradationStrategy);
            pushInt(videoEncoderParam.cameraOutputStrategy);

            count = (thunderRtcVideoTransParam != null) ? thunderRtcVideoTransParam.size() : 0;
            pushInt(count);
            if (thunderRtcVideoTransParam != null) {
                for (ThunderRtcVideoTransParam param : thunderRtcVideoTransParam) {
                    pushInt(param.rtcVideoTransId);
                    pushInt(param.width);
                    pushInt(param.height);
                    pushInt(param.frameRate);
                    pushInt(param.bitrate);
                    pushInt(param.codecType);
                    pushInt(param.audienceMode);
                }
            }
            return super.marshall();
        }
    }

    private static class YLESetSubscribeVideoTransId extends YLEBase {
        private String uid;
        private int subTransId;
        public YLESetSubscribeVideoTransId(String uid, int subTransId) {
            event = THUNDER_SET_SUBSCRIBE_VIDEO_TRANS_ID;
            this.uid = uid;
            this.subTransId = subTransId;
        }

        @Override
        public byte[] marshall() {
            pushString16(this.uid);
            pushInt(this.subTransId);
            return super.marshall();
        }
    }


    private static class YLEGetPlayingVideoTransId extends YLEBase {
        private String uid;
        public YLEGetPlayingVideoTransId(String uid) {
            event = THUNDER_GET_PLAYING_VIDEO_TRANS_ID;
            this.uid = uid;
        }

        @Override
        public byte[] marshall() {
            pushString16(this.uid);
            return super.marshall();
        }
    }

    private static class YLESwitchAudienceMode extends YLEBase {
        private int audienceMode;
        public YLESwitchAudienceMode(int audienceMode) {
            event = THUNDER_SWITCH_AUDIENCE_MODE;
            this.audienceMode = audienceMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.audienceMode);
            return super.marshall();
        }
    }

    private static class YLESetRtcDefaultTransIdInAuto extends YLEBase {
        private int defaultTransId;
        public YLESetRtcDefaultTransIdInAuto(int defaultTransId) {
            event = THUNDER_SET_DEFAULT_TRANS_ID_IN_AUTO;
            this.defaultTransId = defaultTransId;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.defaultTransId);
            return super.marshall();
        }
    }

    private static class YLESetCustomVideoPublishConfig extends YLEBase {
        private int playType;
        private int publishMode;
        private int width;
        private int height;
        private int bitrate;
        private int fps;
        private LinkedList<ThunderPublishLowStreamVideoConfig> lowCfgs;

        public YLESetCustomVideoPublishConfig(int _playType, int _publishMode,
                                              int _width, int _height, int _bitrate, int _fps,
                                              LinkedList<ThunderPublishLowStreamVideoConfig> _lowCfgs) {
            event = THUNDER_CUSTOMIZE_VIDEO_PUBLISH_CFG;
            this.playType = _playType;
            this.publishMode = _publishMode;
            this.width = _width;
            this.height = _height;
            this.bitrate = _bitrate;
            this.fps = _fps;
            this.lowCfgs = _lowCfgs;
        }
        @Override
        public byte[] marshall() {
            pushInt(this.playType);
            pushInt(this.publishMode);
            pushInt(this.width);
            pushInt(this.height);
            pushInt(this.bitrate);
            pushInt(this.fps);
            int size = lowCfgs.size();
            pushInt(size);
            for (ThunderPublishLowStreamVideoConfig cfg : lowCfgs) {
                pushInt(cfg.type);
                pushInt(cfg.encodeResolutionWidth);
                pushInt(cfg.encodeResolutionHeight);
                pushInt(cfg.encodeBitrate);
                pushInt(cfg.encodeFrameRate);
            }
            return super.marshall();
        }
    }

    private static class YLESetCameraZoomConfig extends YLEBase {
        private float zoomFactor;

        public YLESetCameraZoomConfig(float _zoomFactor) {
            event = THUNDER_SET_CAMERA_ZOOM_FACTOR;
            this.zoomFactor = _zoomFactor;
        }
        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.zoomFactor * 1000000));
            return super.marshall();
        }
    }

    private static class YLESetCustomStreamName extends YLEBase {
        private int streamType;
        private String streamName;

        public YLESetCustomStreamName(int streamType, String streamName) {
            event = THUNDER_SET_CUSTOM_STREAM_NAME;
            this.streamType = streamType;
            this.streamName = streamName;
        }

        @Override
        public byte[] marshall() {
            pushInt(streamType);
            pushString16(streamName);
            return super.marshall();
        }
    }

    private static class YLESetSubscribeGroupInThunder extends YLEBase {
        private boolean bSubscribe;

        public YLESetSubscribeGroupInThunder(boolean bSubscribe) {
            event = THUNDER_SET_SUBSCRIBE_GROUP_IN_THUNDER;
            this.bSubscribe = bSubscribe;
        }

        @Override
        public byte[] marshall() {
            pushBool(bSubscribe);
            return super.marshall();
        }
    }

    private static class YLESetCustomPublishAppid extends YLEBase {
        private int pubAppid;

        public YLESetCustomPublishAppid(int pubAppid) {
            event = THUNDER_SET_CUSTOM_PUBLISH_APPID;
            this.pubAppid = pubAppid;
        }

        @Override
        public byte[] marshall() {
            pushInt(pubAppid);
            return super.marshall();
        }
    }

    private static class YLENotifyNetworkState extends YLEBase {
        private int state;

        YLENotifyNetworkState(int _state) {
            event = THUNDER_NOTIFY_NETWORK_STATE;
            state = _state;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.state);

            return super.marshall();
        }
    }

    private static class YLEGetConnectionStatus extends YLEBase {
        YLEGetConnectionStatus() {
            event = THUNDER_GET_CONNECTION_STATUS;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

//audio devices=========================================================
    private static class YLEEnableLoudSpeaker extends YLEBase {
        private boolean bEnable;

        public YLEEnableLoudSpeaker(boolean _bEnable) {
            event = THUNDER_ENABLE_LOUD_SPEAKER;
            this.bEnable = _bEnable;
        }
        @Override
        public byte[] marshall() {
            pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEGetLoudSpeakerEnabled extends YLEBase {
        private int reverse;

        YLEGetLoudSpeakerEnabled() {
            event = THUNDER_GET_LOUDSPEAKER_ENABLED;
            reverse = 0;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEadaptToSystemKaraoke extends YLEBase {
        private boolean enable;

        YLEadaptToSystemKaraoke(boolean _enable) {
            event = THUNDER_ADAPT_TO_SYSTEM_KARAOKE;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEenableInEarMonitor extends YLEBase {
        private boolean enable;

        YLEenableInEarMonitor(boolean _enable) {
            event = THUNDER_ENABLE_IN_EAR_MONITOR;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEsetEarMonitoringVolume extends YLEBase {
        private int volume;

        YLEsetEarMonitoringVolume(int _volume) {
            event = THUNDER_SET_EAR_MONITORING_VOLUME;
            volume = _volume;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEEnableEqualizer extends YLEBase {
        private boolean enable;

        YLEEnableEqualizer(boolean _enable) {
            event = THUNDER_ENABLE_EQUALIZER;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetEqGains extends YLEBase {
        private float mPreamp;
        private float mBand0;
        private float mBand1;
        private float mBand2;
        private float mBand3;
        private float mBand4;
        private float mBand5;
        private float mBand6;
        private float mBand7;
        private float mBand8;
        private float mBand9;

        YLESetEqGains(int[] gains) {
            event = THUNDER_SET_EQ_GAINS;
            mPreamp = gains[0];
            mBand0 = gains[1];
            mBand1 = gains[2];
            mBand2 = gains[3];
            mBand3 = gains[4];
            mBand4 = gains[5];
            mBand5 = gains[6];
            mBand6 = gains[7];
            mBand7 = gains[8];
            mBand8 = gains[9];
            mBand9 = gains[10];
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.mPreamp * 1000000));
            pushString16(String.valueOf(this.mBand0 * 1000000));
            pushString16(String.valueOf(this.mBand1 * 1000000));
            pushString16(String.valueOf(this.mBand2 * 1000000));
            pushString16(String.valueOf(this.mBand3 * 1000000));
            pushString16(String.valueOf(this.mBand4 * 1000000));
            pushString16(String.valueOf(this.mBand5 * 1000000));
            pushString16(String.valueOf(this.mBand6 * 1000000));
            pushString16(String.valueOf(this.mBand7 * 1000000));
            pushString16(String.valueOf(this.mBand8 * 1000000));
            pushString16(String.valueOf(this.mBand9 * 1000000));
            return super.marshall();
        }
    }

    private static class YLEEnableCompressor extends YLEBase {
        private boolean enable;

        YLEEnableCompressor(boolean _enable) {
            event = THUNDER_ENABLE_COMPRESSOR;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetVoicePitch extends YLEBase {
        private float pitch;

        YLESetVoicePitch(float _pitch) {
            event = THUNDER_SET_VOICE_CHANGER_PITCH;
            pitch = _pitch;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.pitch * 1000000));
            return super.marshall();
        }
    }

    private static class YLEEnableHowlingDetector extends YLEBase {
        private boolean enable;

        YLEEnableHowlingDetector(boolean _enable) {
            event = THUNDER_ENABLE_HOWLING_DETECTOR;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableEchoDetector extends YLEBase {
        private boolean enable;

        YLEEnableEchoDetector(boolean _enable) {
            event = THUNDER_ENABLE_ECHO_DETECTOR;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableLocalSpeakingDetector extends YLEBase {
        private boolean enable;

        YLEEnableLocalSpeakingDetector(boolean _enable) {
            event = THUNDER_ENABLE_LOCAL_SPEAKING_DETECTOR;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEStartInputDeviceTest extends YLEBase {
        YLEStartInputDeviceTest() {
            event = THUNDER_START_INPUT_DEVICE_TEST;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEStopInputDeviceTest extends YLEBase {
        YLEStopInputDeviceTest() {
            event = THUNDER_STOP_INPUT_DEVICE_TEST;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEStartOutputDeviceTest extends YLEBase {
        private String filePath;
        YLEStartOutputDeviceTest(String _filePath) {
            event = THUNDER_START_OUTPUT_DEVICE_TEST;
            filePath = _filePath;
        }

        @Override
        public byte[] marshall() {
            pushString16(filePath);
            return super.marshall();
        }
    }

    private static class YLEStopOutputDeviceTest extends YLEBase {
        YLEStopOutputDeviceTest() {
            event = THUNDER_STOP_OUTPUT_DEVICE_TEST;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }


    private static class YLEIsAudioCaptureEnabled extends YLEBase {
        YLEIsAudioCaptureEnabled() {
            event = THUNDER_IS_AUDIO_CAPTURE_ENABLED;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEEnableMicDenoise extends YLEBase {
        private boolean enable;
        YLEEnableMicDenoise(boolean _enable) {
            event = THUNDER_ENABLE_AUDIO_MIC_DENOISE;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioAGC extends YLEBase {
        private boolean enable;
        YLEEnableAudioAGC(boolean _enable) {
            event = THUNDER_ENABLE_AUDIO_AGC;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableAIDenoise extends YLEBase {
        private boolean enable;
        YLEEnableAIDenoise(boolean _enable) {
            event = THUNDER_AUDIO_ENABLE_AI_DENOISE;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEIsMicDenoiseEnable extends YLEBase {
        YLEIsMicDenoiseEnable() {
            event = THUNDER_IS_AUDIO_MIC_DENOISE_ENABLE;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetCompressorParam extends YLEBase {
        private int mthreshold;
        private int mmakeupGain;
        private int mratio;
        private int mknee;
        private int mreleaseTime;
        private int mattackTime;

        YLESetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
            event = THUNDER_SET_COMPRESSOR_PARAM;
            mthreshold = threshold;
            mmakeupGain = makeupGain;
            mratio = ratio;
            mknee = knee;
            mreleaseTime = releaseTime;
            mattackTime = attackTime;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.mthreshold);
            pushInt(this.mmakeupGain);
            pushInt(this.mratio);
            pushInt(this.mknee);
            pushInt(this.mreleaseTime);
            pushInt(this.mattackTime);
            return super.marshall();
        }
    }

    private static class YLEEnableReverb extends YLEBase {
        private boolean enable;

        YLEEnableReverb(boolean _enable) {
            event = THUNDER_ENABLE_REVERB;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetReverbExParameter extends YLEBase {
        private float mRoomSize;
        private float mPreDelay;
        private float mReverberance;
        private float mHfDamping;
        private float mToneLow;
        private float mToneHigh;
        private float mWetGain;
        private float mDryGain;
        private float mStereoWidth;

        YLESetReverbExParameter(float RoomSize, float PreDelay, float Reverberance,
                                float HfDamping, float ToneLow, float ToneHigh,
                                float WetGain, float DryGain, float StereoWidth) {
            event = THUNDER_SET_REVERB_PARAM;
            mRoomSize = RoomSize;
            mPreDelay = PreDelay;
            mReverberance = Reverberance;
            mHfDamping = HfDamping;
            mToneLow = ToneLow;
            mToneHigh = ToneHigh;
            mWetGain = WetGain;
            mDryGain = DryGain;
            mStereoWidth = StereoWidth;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.mRoomSize * 1000000));
            pushString16(String.valueOf(this.mPreDelay * 1000000));
            pushString16(String.valueOf(this.mReverberance * 1000000));
            pushString16(String.valueOf(this.mHfDamping * 1000000));
            pushString16(String.valueOf(this.mToneLow * 1000000));
            pushString16(String.valueOf(this.mToneHigh * 1000000));
            pushString16(String.valueOf(this.mWetGain * 1000000));
            pushString16(String.valueOf(this.mDryGain * 1000000));
            pushString16(String.valueOf(this.mStereoWidth * 1000000));
            return super.marshall();
        }
    }

    private static class YLESetLimiterParameter extends YLEBase {
        private float m_fCeiling;
        private float m_fRelease;
        private float m_fLookaheadRatio;
        private float m_fThreshold;
        private float m_fAttack;
        private float m_fRMS;
        private float m_fPreGain;
        private float m_fLookahead;
        private float m_fStLink;

        YLESetLimiterParameter(float fCeiling, float fThreshold, float fPreGain,
                               float fRelease, float fAttack, float fLookahead,
                               float fLookaheadRatio, float fRMS, float fStLink) {
            event = THUNDER_SET_LIMIT_PARAM;
            m_fCeiling = fCeiling;
            m_fRelease = fRelease;
            m_fLookaheadRatio = fLookaheadRatio;
            m_fThreshold = fThreshold;
            m_fAttack = fAttack;
            m_fRMS = fRMS;
            m_fPreGain = fPreGain;
            m_fLookahead = fLookahead;
            m_fStLink = fStLink;
        }

        @Override
        public byte[] marshall() {
            pushString16(String.valueOf(this.m_fCeiling * 1000000));
            pushString16(String.valueOf(this.m_fRelease * 1000000));
            pushString16(String.valueOf(this.m_fLookaheadRatio * 1000000));
            pushString16(String.valueOf(this.m_fThreshold * 1000000));
            pushString16(String.valueOf(this.m_fAttack * 1000000));
            pushString16(String.valueOf(this.m_fRMS * 1000000));
            pushString16(String.valueOf(this.m_fPreGain * 1000000));
            pushString16(String.valueOf(this.m_fLookahead * 1000000));
            pushString16(String.valueOf(this.m_fStLink * 1000000));
            return super.marshall();
        }
    }

    private static class YLEEnableLimiter extends YLEBase {
        private boolean enable;

        YLEEnableLimiter(boolean _enable) {
            event = THUNDER_ENABLE_LIMITER;
            enable = _enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEStartAudioSaver extends YLEBase {
        private String fileName;
        private int saverMode;
        private int fileMode;

        YLEStartAudioSaver(String _fileName, int _saverMode, int _fileMode) {
            event = THUNDER_START_AUDIO_SAVER;
            fileName = _fileName;
            saverMode = _saverMode;
            fileMode = _fileMode;
        }

        @Override
        public byte[] marshall() {
            pushString16(this.fileName);
            pushInt(this.saverMode);
            pushInt(this.fileMode);
            return super.marshall();
        }
    }

    private static class YLEStopAudioSaver extends YLEBase {
        YLEStopAudioSaver() {
            event = THUNDER_STOP_AUDIO_SAVER;
        }
    }

    private static class YLEStartAudioRecord extends YLEBase {
        private String fileName;
        private int saverMode;
        private int sampleRate;
        private int quality;

        YLEStartAudioRecord(String _fileName, int _saverMode, int _sampleRate, int _quality) {
            event = THUNDER_START_AUDIO_RECORD;
            fileName = _fileName;
            saverMode = _saverMode;
            sampleRate = _sampleRate;
            quality = _quality;
        }

        @Override
        public byte[] marshall() {
            pushString16(this.fileName);
            pushInt(this.saverMode);
            pushInt(this.sampleRate);
            pushInt(this.quality);
            return super.marshall();
        }
    }

    private static class YLEStopAudioRecord extends YLEBase {
        YLEStopAudioRecord() {
            event = THUNDER_STOP_AUDIO_RECORD;
        }
    }

    private static class YLEEnableAudioPlaySpectrum extends YLEBase {
        private boolean enable;

        YLEEnableAudioPlaySpectrum(boolean enable) {
            event = THUNDER_ENABLE_AUDIO_PLAY_SPECTRUM;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetAudioPlaySpectrumInfo extends YLEBase {
        private int spectrumLen;
        private int notifyIntervalMS;

        YLESetAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
            event = THUNDER_SET_AUDIO_PLAY_SPECTRUM_INFO;
            this.spectrumLen = spectrumLen;
            this.notifyIntervalMS = notifyIntervalMS;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.spectrumLen);
            pushInt(this.notifyIntervalMS);

            return super.marshall();
        }
    }

    private static class YLEEnableVoicePosition extends YLEBase {
        private boolean enable;

        YLEEnableVoicePosition(boolean enable) {
            event = THUNDER_ENABLE_VOICE_POSITION;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            pushBool(this.enable);

            return super.marshall();
        }
    }

    private static class YLESetSoundEffect extends YLEBase {
        private int soundEffectMode;

        YLESetSoundEffect(int _soundEffectMode) {
            event = THUNDER_SET_SOUND_EFFECT;
            soundEffectMode = _soundEffectMode;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.soundEffectMode);
            return super.marshall();
        }
    }

    private static class YLESetVoiceChanger extends YLEBase {
        private int voiceChangerMode;

        YLESetVoiceChanger(int mode) {
            event = THUNDER_SET_VOICE_CHANGER;
            voiceChangerMode = mode;
        }

        @Override
        public byte[] marshall() {
            pushInt(this.voiceChangerMode);
            return super.marshall();
        }
    }

    private static class YLEVideoFrameObserverStringUid extends YLEBase {
        private Object observer;
        private String uid;

        YLEVideoFrameObserverStringUid(String _uid, Object _observer) {
            event = THUNDER_VIDEO_FRAME_OBSERVER;
            observer = _observer;
            uid = _uid;
        }

        @Override
        public byte[] marshall() {
            pushString16(uid);
            pushInt64(YYLiveObjectToPtr(observer));
            return super.marshall();
        }
    }

    private static class YLESetRecordingAudioFrameParameters extends YLEBase {
        private int sampleRate;
        private int room;
        private int mode;
        private int samplesPerCall;

        YLESetRecordingAudioFrameParameters(int _sampleRate, int _room, int _mode,
                                            int _samplesPerCall) {

            event = YYLIVE_SET_RECORD_AUDIO_PARAMS;
            sampleRate = _sampleRate;
            room = _room;
            mode = _mode;
            samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            pushInt(sampleRate);
            pushInt(room);
            pushInt(mode);
            pushInt(samplesPerCall);
            return super.marshall();
        }

    }

    private static class YLESetMixedAudioFrameParameters extends YLEBase {
        private int sampleRate;
        private int channel;
        private int samplesPerCall;

        YLESetMixedAudioFrameParameters(int _sampleRate, int _channel,
                                            int _samplesPerCall) {

            event = YYLIVE_SET_MIX_AUDIO_PARAMS;
            sampleRate = _sampleRate;
            channel = _channel;
            samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            pushInt(sampleRate);
            pushInt(channel);
            pushInt(samplesPerCall);
            return super.marshall();
        }

    }

    /************************** new call end ***********************/

    /********************************* YYLive Events End ******************************************/

    /****************************** YYLive Notifications Begin ************************************/
    private static class YLNBase extends Marshallable {
        Object notification;

        /**
         * 关闭父类mBuffer分配 子类在super.unmarshall(buf)会通过ByteBuffer.wrap(buf)创建mBuffer
         */
        public YLNBase() {
            super(false);
        }

        public Object get() {
            return notification;
        }
    }

    // new notify
    private static class YLNFirstVideoFrameSend extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderFirstVideoFrameSend(popInt());
        }
    }

    private static class YLNFirstAudioFrameSend extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderFirstAudioFrameSend(popInt());
        }
    }

    private static class YLNJoinRoomSuccess extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderJoinRoomSuccess(popString16(), popString16(), popInt());
        }
    }

    private static class YLNLeaveRoom extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderLeaveRoom();
        }
    }

    private static class YLNRemoteVideoPlay extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteVideoPlay(popString16(), popInt(), popInt(), popInt());
        }
    }

    // app authenticate result
    private static class YLNBizAuthRes extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderBizAuthStreamRes(popBool(), popInt(), popInt());
        }
    }

    // sdk auth authenticate result
    private static class YLNSdkAuthRes extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderSdkAuthRes(popInt());
        }
    }

    private static class YLNUserBanned extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderUserBanned(popBool());
        }
    }

    private static class YLNTokenRequest extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderTokenRequest();
        }
    }

    private static class YLNTokenWillExpire extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderTokenWillExpire(popString16());
        }
    }

    private static class YLNAudioCaptureVolume extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            notification = new ThunderNotification.ThunderAudioCaptureVolume(popInt(), popInt(), popInt());
        }
    }

    private static class YLNAudioPlayVolume extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int size = popInt();
            HashSet<ThunderEventHandler.AudioVolumeInfo> playVolumes = new HashSet<>();
            if (size > 0)
            {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.AudioVolumeInfo audioPlayVolume = new ThunderEventHandler.AudioVolumeInfo();
                    audioPlayVolume.uid = popString16();
                    audioPlayVolume.originalVolume = popInt();
                    audioPlayVolume.volume = popInt();
                    audioPlayVolume.pts = popInt();
                    playVolumes.add(audioPlayVolume);
                }
            }
            int totalVolume = popInt();
            notification = new ThunderNotification.ThunderAudioPlayVolume(totalVolume, playVolumes);
        }
    }

    private static class YLNAudioPlayData extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioPlayData(popString16(), popInt(),
                    popInt(), popInt(), popInt(), popBytes32());
        }
    }

    private static class YLNAudioPlaySpectrumData extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioPlaySpectrumData(popBytes32());
        }
    }

    private static class YLNAudioCapturePcmData extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioCapturePcmData(popBytes32(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNUserAppMsgData extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderUserAppMsgData(popInt(), popString16UTF8(), popString16());
        }
    }

    private static class YLNAppMsgDataFailStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAppMsgDataFailStatus(popInt());
        }
    }

    private static class YLNAudioRenderPcmData extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            byte[] data = popBytes32();
            int dataSize = popInt();
            int duration = popInt();
            int sampleRate = popInt();
            int channel = popInt();
            notification = new ThunderNotification.ThunderAudioRenderPcmData(dataSize, data, duration, sampleRate, channel);
        }
    }

    private static class YLNHttpsRequest extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderHttpsRequest(popString16(), popInt());
        }
    }

    private static class YLNRemoteVideoStopped extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteVideoStopped(popString16(), popString16(), popBool());
        }
    }

    private static class YLNRemoteAudioStopped extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteAudioStopped(popString16(), popString16(), popBool());
        }
    }

    private static class YLNVideoSizeChange extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderVideoSizeChange(popString16(), popInt(), popInt());
        }
    }

    private static class YLNVideoCaptureExposureChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderVideoCaptureExposureChanged(popInt(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNVideoCaptureFocusChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderVideoCaptureFocusChanged(popInt(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNConnectionStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderConnectionStatus(popInt());
        }
    }

    private static class YLNConnectionLost extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderConnectionLost();
        }
    }

    private static class YLNRoomStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.RoomStats(popInt(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNNetworkStateChange extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderNetworkStateChange(popInt());
        }
    }

    // todo 确认参数中bool
    private static class YLNPublishStreamToCdnStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderPublishStreamToCdnStatus(popString16(), popInt());
        }
    }

    private static class YLNUserJoined extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderUserJoined(popString16(), popInt());
        }
    }

    private static class YLNUserOffline extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderUserOffline(popString16(), popInt());
        }
    }

    private static class YLNNetworkQuality extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderNetworkQuality(popString16(), popInt(), popInt());
        }
    }

    private static class YLNAudioExtraInfo extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioExtraInfo(popString16(), popBytes());
        }
    }

    private static class YLNAudioExtraFailStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioExtraFailStatus(popInt());
        }
    }

    private static class YLNVideoExtraInfo extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderVideoExtraInfo(popString16(), popBytes());
        }
    }

    private static class YLNMixVideoExtraInfo extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String mUid = popString16();
            ArrayList<ThunderEventHandler.MixVideoInfo> mixVideoExtraInfos = new ArrayList<>();
            int size = popInt();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.MixVideoInfo extraInfo = new ThunderEventHandler.MixVideoInfo();
                    extraInfo.uid = popString16();
                    extraInfo.width = popInt();
                    extraInfo.height = popInt();   //此用户视频原始高
                    extraInfo.cropX = popInt();    //混画时裁剪原始视频的起始x坐标
                    extraInfo.cropY = popInt();    //混画时裁剪原始视频的起始y坐标
                    extraInfo.cropW = popInt();    //混画时裁剪原始视频的宽
                    extraInfo.cropH = popInt();     //混画时裁剪原始视频的高
                    extraInfo.layoutX = popInt();  //此用户视频在混画画布中的起始x坐标
                    extraInfo.layoutY = popInt();  //此用户视频在混画画布中的起始y坐标
                    extraInfo.layoutW = popInt();  //此用户视频在混画画布中的宽度
                    extraInfo.layoutH = popInt();  //此用户视频在混画画布中的高度
                    extraInfo.zOrder = popInt();   //此用户视频帧在混画中的图层编号，取值范围为 [0, 100] 中的整型，最小值为 0，表示该区域图像位于最下层
                    extraInfo.alpha = ((float) popInt()) / 100; //此用户视频帧在混画中的透明度。取值范围为 [0.0, 1.0]。0.0 表示该区域图像完全透明，而 1.0 表示该区域图像完全不透明。
                    mixVideoExtraInfos.add(extraInfo);
                }
            }
            notification = new ThunderNotification.ThunderMixVideoExtraInfo(mUid, mixVideoExtraInfos);
        }
    }

    private static class YLNMixAudioExtraInfo extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String mUid = popString16();
            ArrayList<ThunderEventHandler.MixAudioInfo> mixAudioExtraInfos = new ArrayList<>();
            int size = popInt();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.MixAudioInfo audioExtra = new ThunderEventHandler.MixAudioInfo();
                    audioExtra.uid = popString16();
                    audioExtra.volume = popInt();
                    mixAudioExtraInfos.add(audioExtra);
                }
            }
            notification = new ThunderNotification.ThunderMixAudioExtraInfo(mUid, mixAudioExtraInfos);
        }
    }

    private static class YLNAudioCaptureStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            notification = new ThunderNotification.ThunderAudioCaptureStatus(popInt());
        }
    }

    private static class YLNVideoCaptureStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            notification = new ThunderNotification.ThunderVideoCaptureStatus(popInt());
        }
    }

    private static class YLNOnVideoConfig extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            HashMap<Integer, VideoLiveConfig> configMap = new HashMap<Integer, VideoLiveConfig>();
            int configSize = popInt();
            for (int i = 0; i < configSize; ++i) {
                int key = popInt();
                VideoLiveConfig videoConfig = new VideoLiveConfig();
                videoConfig.entEncode = popInt();
                videoConfig.bframeswitch = popInt();
                videoConfig.intervalSecs = popInt();
                int resolutionSize = popInt();
                ArrayList<VideoLiveConfig.ResolutionInfo> resolutionList =
                        new ArrayList<VideoLiveConfig.ResolutionInfo>();
                for (int j = 0; j < resolutionSize; ++j) {
                    VideoLiveConfig.ResolutionInfo resolutionInfo = videoConfig.new ResolutionInfo();
                    resolutionInfo.key = popInt();
                    resolutionInfo.isDefault = popInt();
                    resolutionInfo.width = popInt();
                    resolutionInfo.height = popInt();
                    resolutionInfo.frameRate = popInt();
                    resolutionInfo.bframeNum = popInt();
                    resolutionInfo.encode_id = popInt();
                    resolutionInfo.encode_param = popString16();
                    resolutionInfo.previewWidth = popInt();
                    resolutionInfo.previewHeight = popInt();
                    resolutionInfo.previewFrameRate = popInt();
                    resolutionInfo.codeRate = popInt();
                    resolutionInfo.maxrate = popInt();
                    resolutionInfo.minrate = popInt();
                    resolutionInfo.currate = popInt();
                    resolutionInfo.description = popString16();
                    resolutionInfo.transcoding = popInt();

                    int modifySize = popInt();
                    ArrayList<VideoLiveConfig.ModifyInfo> modifyList = new ArrayList<VideoLiveConfig.ModifyInfo>();
                    for (int k = 0; k < modifySize; ++k) {
                        VideoLiveConfig.ModifyInfo modifyInfo = videoConfig.new ModifyInfo();
                        modifyInfo.width = popInt();
                        modifyInfo.height = popInt();
                        modifyInfo.maxCodeRate = popInt();
                        modifyInfo.minCodeRate = popInt();
                        modifyInfo.encode_id = popInt();
                        modifyInfo.encode_param = popString16();
                        modifyInfo.maxFrameRate = popInt();
                        modifyInfo.minFrameRate = popInt();
                        modifyList.add(modifyInfo);
                    }
                    resolutionInfo.modifyConfig = modifyList;
                    resolutionList.add(resolutionInfo);
                }
                videoConfig.resolutions = resolutionList;

                configMap.put(key, videoConfig);
            }

            VideoConfigManager.instance().notifyVideoConfig(configMap);
        }
    }

    private static class YLNOnBlackCodecConfig extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);

            VideoConfigManager.instance().notifyBlackCodecConfig(popString16());
        }
    }

    private static class YLNLocalVideoStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderLocalVideoStats(popInt(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt());
        }
    }

	 private static class YLNLocalAudioStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderLocalAudioStats(popInt(), popInt(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNRemoteVideoStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.RemoteVideoStats(popString16(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(),
                    popInt(), popInt());
        }
    }

    private static class YLNRemoteAudioStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.RemoteAudioStats(popString16(), popInt(), popInt(),
                    popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt(), popInt());
        }
    }

    private static class YLNRemoteAudioStateChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteAudioStateChanged(popString16(), popInt(),
                    popInt(), popInt());
        }
    }

    private static class YLNRemoteVideoStateChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteVideoStateChanged(popString16(), popInt(),
                    popInt(), popInt());
        }
    }

    private  static class YLNPrivateCallBack extends YLNBase{
        @Override
        public void unmarshall(byte[] buf)
        {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderPrivateCallBack(popInt(), popString16());
        }
    }

    private static class YLNRemoteAudioPlay extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderRemoteAudioPlay(popString16(), popInt());
        }
    }

    private static class YLNLocalAudioStatusChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.LocalAudioStatusChanged(popInt(), popInt());
        }
    }

    private static class YLNLocalAudioPublishStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.LocalAudioPublishStatus(popInt());
        }
    }

    private static class YLNLocalVideoStatusChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.LocalVideoStatusChanged(popInt(), popInt());
        }
    }

    private static class YLNLocalVideoPublishStatus extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.LocalVideoPublishStatus(popInt());
        }
    }

    private static class YLNDeviceStats extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int cpuTotal = popInt();
            int cpuApp = popInt();
            int memTotal = popInt();
            int memApp = popInt();

            if (CpuTool.OS_VERSION.compareTo("8.0") >= 0)
            {
                notification = new ThunderNotification.ThunderDeviceStats(cpuTotal / 100.0, CpuTool.getAppCpuRateAverage(), memTotal / 100.0, memApp / 100.0);
            }
            else
            {
                notification = new ThunderNotification.ThunderDeviceStats(cpuTotal / 100.0, cpuApp / 100.0, memTotal / 100.0, memApp / 100.0);
            }
        }
    }

    private static class YLNUserRoleChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderUserRoleChanged(popInt(), popInt());
        }
    }

    private static class YLNAudioRouteChanged extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioRouteChanged(popInt());
        }
    }

    private static class YLNHowlingDetectResult extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderHowlingDetectResult(popBool());
        }
    }

    private static class YLNEchoDetectResult extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderEchoDetectResult(popBool());
        }
    }

    private static class YLNAudioInputDeviceTestVolume extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioInputDeviceTestVolume(popInt());
        }
    }

    private static class YLNAudioOutputDeviceTestVolume extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            notification = new ThunderNotification.ThunderAudioOutputDeviceTestVolume(popInt());
        }
    }

    private static class YLNAudioRecordState extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int errorCode = popInt();
            int duration = popInt();
            notification = new ThunderNotification.ThunderAudioRecordState(errorCode, duration);
        }
    }

    private static class YLNLocalSpeakingState extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int state = popInt();
            notification = new ThunderNotification.ThunderLocalSpeakingState(state);
        }
    }

    private static class YLNRemoteVideoTransId extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String roomId = new String();
            String uid = new String();
            int size = 0;
            ArrayList<ThunderRtcVideoTransParam> videoTransParams = new ArrayList<>();

            roomId = popString16();
            uid = popString16();
            size = popInt();
            for (int i= 0; i < size; ++i) {
                ThunderRtcVideoTransParam param = new ThunderRtcVideoTransParam();
                param.rtcVideoTransId = popInt();
                param.width = popInt();
                param.height = popInt();
                param.frameRate = popInt();
                param.bitrate = popInt();
                param.codecType = popInt();
                param.audienceMode = popInt();
                videoTransParams.add(param);
            }
            notification = new ThunderNotification.ThunderRemoteVideoTransId(roomId, uid, videoTransParams);
        }
    }

    private static class YLNSetSubscribeVideoTransIdResult extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String uid = new String();
            int bizTransId = 0;
            int realTransId = 0;

            uid = popString16();
            bizTransId = popInt();
            realTransId = popInt();
            notification = new ThunderNotification.ThunderSetSubscribeVideoTransIdResult(uid, bizTransId, realTransId);
        }
    }

    private static class YLNSwitchVideoTransIdResult extends YLNBase {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String uid = new String();
            int dstTransId = 0;
            int currTransId = 0;
            int status = 0;

            uid = popString16();
            dstTransId = popInt();
            currTransId = popInt();
            status = popInt();
            notification = new ThunderNotification.ThunderSwitchVideoTransIdResult(uid, dstTransId, currTransId, status);
        }
    }
    // new notify end

    public interface NotificationDispatcher {
        void registerNotificationHandler(Handler handler);

        void unregisterNotificationHandler(Handler handler);

        Object[] collectNotificationHandlers();
    }

    private static int s_audioCaptureVolumeNotificationCount = 0;
    private static int s_audioPlayVolumeNotificationCount = 0;
    private static int s_playRuntimeNotificationCount = 0;
    private static int s_publishRuntimeNotificationCount = 0;
    private static int s_audioExtraInfoNotificationCount = 0;

    /* C++ 代码通知回调函数 */
    public static void notificationCallback(int type, byte[] data) {


        s_notificationLock.lock();

        try {
            if (s_notificationDispatcher == null) {
                return;
            }

            YLNBase yln;

            switch (type) {
                case ThunderNotification.kThunderNotification_FirstVideoFrameSend:
                    yln = new YLNFirstVideoFrameSend();
                    break;
                case ThunderNotification.kThunderNotification_FirstAudioFrameSend:
                    yln = new YLNFirstAudioFrameSend();
                    break;
                case ThunderNotification.kThunderNotification_JoinRoomSuccess:
                    yln = new YLNJoinRoomSuccess();
                    break;
                case ThunderNotification.kThunderNotification_LeaveRoom:
                    yln = new YLNLeaveRoom();
                    break;
                case ThunderNotification.kThunderNotification_RemoteVideoPlay:
                    yln = new YLNRemoteVideoPlay();
                    break;
                case ThunderNotification.kThunderNotification_BizAuthRes:
                    yln = new YLNBizAuthRes();
                    break;
                case ThunderNotification.kThunderNotification_SdkAuthRes:
                    yln = new YLNSdkAuthRes();
                    break;
                case ThunderNotification.kThunderNotification_UserBanned:
                    yln = new YLNUserBanned();
                    break;
                case ThunderNotification.kThunderNotification_TokenRequest:
                    yln = new YLNTokenRequest();
                    break;
                case ThunderNotification.kThunderNotification_TokenWillExpire:
                    yln = new YLNTokenWillExpire();
                    break;
                case ThunderNotification.kThunderNotification_AudioCaptureVolume:
                    yln = new YLNAudioCaptureVolume();
                    break;
                case ThunderNotification.kThunderNotification_AudioPlayVolume:
                    yln = new YLNAudioPlayVolume();
                    break;
                case ThunderNotification.kThunderNotification_AudioPlayData:
                    yln = new YLNAudioPlayData();
                    break;
                case ThunderNotification.kThunderNotification_AudioPlaySpectrumData:
                    yln = new YLNAudioPlaySpectrumData();
                    break;
                case ThunderNotification.kThunderNotification_AudioCapturePcmData:
                    yln = new YLNAudioCapturePcmData();
                    break;
                case ThunderNotification.kThunderNotification_UserAppMsgData:
                    yln = new YLNUserAppMsgData();
                    break;
                case ThunderNotification.kThunderNotification_AppMsgDataFailStatus:
                    yln = new YLNAppMsgDataFailStatus();
                    break;
                case ThunderNotification.kThunderNotification_AudioRenderPcmData:
                    yln = new YLNAudioRenderPcmData();
                    break;
                case ThunderNotification.kThunderNotification_HttpsRequest:
                    yln = new YLNHttpsRequest();
                    break;
                case ThunderNotification.kThunderNotification_RemoteVideoStopped:
                    yln = new YLNRemoteVideoStopped();
                    break;
                case ThunderNotification.kThunderNotification_RemoteAudioStopped:
                    yln = new YLNRemoteAudioStopped();
                    break;
                case ThunderNotification.kThunderNotification_VideoSizeChange:
                    yln = new YLNVideoSizeChange();
                    break;
                case ThunderNotification.kThunderNotification_CameraExposureChanged:
                    yln = new YLNVideoCaptureExposureChanged();
                    break;
                case ThunderNotification.kThunderNotification_CameraFocuseChanged:
                    yln = new YLNVideoCaptureFocusChanged();
                    break;
                case ThunderNotification.kThunderNotification_ConnectionStatus:
                    yln = new YLNConnectionStatus();
                    break;
                case ThunderNotification.kThunderNotification_ConnectionLost:
                    yln = new YLNConnectionLost();
                    break;
                case ThunderNotification.kThunderNotification_RoomStats:
                    yln = new YLNRoomStats();
                    break;
                case ThunderNotification.kThunderNotification_NetworkStateChange:
                    yln = new YLNNetworkStateChange();
                    break;
                case ThunderNotification.kThunderNotification_PublishStreamToCdnStatus:
                    yln = new YLNPublishStreamToCdnStatus();
                    break;
                case ThunderNotification.kThunderNotification_UserJoined:
                    yln = new YLNUserJoined();
                    break;
                case ThunderNotification.kThunderNotification_UserOffline:
                    yln = new YLNUserOffline();
                    break;
                case ThunderNotification.kThunderNotification_NetworkQuality:
                    yln = new YLNNetworkQuality();
                    break;
                case ThunderNotification.kThunderNotification_AudioExtraInfo:
                    yln = new YLNAudioExtraInfo();
                    break;
                case ThunderNotification.kThunderNotification_AudioExtraFailStatus:
                    yln = new YLNAudioExtraFailStatus();
                    break;
                case ThunderNotification.kThunderNotification_VideoExtraInfo:
                    yln = new YLNVideoExtraInfo();
                    break;
                case ThunderNotification.kThunderNotification_MixVideoExtraInfo:
                    yln = new YLNMixVideoExtraInfo();
                    break;
                case ThunderNotification.kThunderNotification_MixAudioExtraInfo:
                    yln = new YLNMixAudioExtraInfo();
                    break;
                case ThunderNotification.kThunderNotification_AudioCaptureStatus:
                    yln = new YLNAudioCaptureStatus();
                    break;
                case ThunderNotification.kThunderNotification_VideoCaptureStatus:
                    yln = new YLNVideoCaptureStatus();
                    break;
                case ThunderNotification.kThunderAPINotification_LocalVideoStats:
                    yln = new YLNLocalVideoStats();
                    break;
				 case ThunderNotification.kThunderAPINotification_LocalAudioStats:
                    yln = new YLNLocalAudioStats();
                    break;
                case ThunderNotification.kThunderAPINotification_RemoteVideoStats:
                    yln = new YLNRemoteVideoStats();
                    break;
                case ThunderNotification.kThunderAPINotification_RemoteAudioStats:
                    yln = new YLNRemoteAudioStats();
                    break;
                case ThunderNotification.kThunderNotification_RemoteAudioStateChanged:
                    yln = new YLNRemoteAudioStateChanged();
                    break;
                case ThunderNotification.kThunderNotification_RemoteVideoStateChanged:
                    yln = new YLNRemoteVideoStateChanged();
                    break;
                case ThunderNotification.kThunderNotification_RemoteAudioPlay:
                    yln = new YLNRemoteAudioPlay();
                    break;
                case ThunderNotification.kThunderAPINotification_LocalAudioStatusChanged:
                    yln = new YLNLocalAudioStatusChanged();
                    break;
                case ThunderNotification.kThunderAPINotification_LocalAudioPublishStatus:
                    yln = new YLNLocalAudioPublishStatus();
                    break;
                case ThunderNotification.kThunderAPINotification_LocalVideoStatusChanged:
                    yln = new YLNLocalVideoStatusChanged();
                    break;
                case ThunderNotification.kThunderAPINotification_LocalVideoPublishStatus:
                    yln = new YLNLocalVideoPublishStatus();
                    break;
                case ThunderNotification.kThunderNotification_PrivateCallBack:
                    yln = new YLNPrivateCallBack();
                    break;
                case ThunderNotification.kThunderAPINotification_DeviceStats:
                    yln = new YLNDeviceStats();
                    break;
                case ThunderNotification.kThunderNotification_UserRoleChanged:
                    yln = new YLNUserRoleChanged();
                    break;
                case ThunderNotification.kThunderNotification_RemoteVideoTransId:
                    yln = new YLNRemoteVideoTransId();
                    break;
                case ThunderNotification.kThunderNotification_SetSubscribeVideoTransIdResult:
                    yln = new YLNSetSubscribeVideoTransIdResult();
                    break;
                case ThunderNotification.kThunderNotification_SwitchVideoTransIdResult:
                    yln = new YLNSwitchVideoTransIdResult();
                    break;
                // argo
                case ThunderNotification.kThunderNotification_OnVideoConfig:
                    yln = new YLNOnVideoConfig();
                    break;
                case ThunderNotification.kThunderNotification_OnBlackCodecConfig:
                    if (BuildConfig.__YY_VIDEO_SUPPORT__) {
                        if (mIsLoadVideoPlug) {
                            yln = new YLNOnBlackCodecConfig();
                        } else {
                            ThunderLog.warn(ThunderLog.kLogTagCallback, "VideoPlug is not load. cur type = %d",
                                    type);
                            return;
                        }
                    } else {
                        ThunderLog.warn(ThunderLog.kLogTagCallback, "video unsupported type %d",
                                type);
                        return;
                    }
                    break;
                case ThunderNotification.kThunderAPINotification_AudioRouteChanged:
                    yln = new YLNAudioRouteChanged();
                    break;
                case ThunderNotification.kThunderAPINotification_HowlingDetectResult:
                    yln = new YLNHowlingDetectResult();
                    break;
                case ThunderNotification.kThunderAPINotification_EchoDetectResult:
                    yln = new YLNEchoDetectResult();
                    break;
                case ThunderNotification.kThunderNotification_AudioInputDeviceTestVolume:
                    yln = new YLNAudioInputDeviceTestVolume();
                    break;
                case ThunderNotification.kThunderNotification_AudioOutputDeviceTestVolume:
                    yln = new YLNAudioOutputDeviceTestVolume();
                    break;
                case ThunderNotification.kThunderNotification_AudioRecordState:
                    yln = new YLNAudioRecordState();
                    break;
                case ThunderNotification.kThunderNotification_LocalSpeakingState:
                    yln = new YLNLocalSpeakingState();
                    break;
                default:
                    ThunderLog.warn(ThunderLog.kLogTagCallback, "unknown notification type %d", type);
                    return;
            }

            yln.unmarshall(data);

            // 发送非内部消息到 handler
            if (type < ThunderNotificationInside.kThunderAPINotification_Start_Tag) {
                Object[] handlers = s_notificationDispatcher.collectNotificationHandlers();
                if (handlers != null) {
                    for (Object handler : handlers) {
                        Message msg = Message.obtain();
                        msg.what = type;
                        msg.obj = yln.get();

                        ((Handler) handler).sendMessage(msg);
                    }
                }
            }
            //通知日志
            switch (type) {
                case ThunderNotification.kThunderNotification_FirstVideoFrameSend: {
                    ThunderNotification.ThunderFirstVideoFrameSend notification =
                            (ThunderNotification.ThunderFirstVideoFrameSend) yln.get();
                    ThunderLog.release(ThunderLog.kLogTagCallback,
                            "kThunderNotification_FirstVideoFrameSend mElapsedTime= %d", notification.getElapsedTime());
                    break;
                }
                case ThunderNotification.kThunderAPINotification_RemoteVideoStats: {
                    ThunderNotification.RemoteVideoStats notification =
                            (ThunderNotification.RemoteVideoStats) yln.get();
                    if (s_remoteVideoStatsNotificationCount++ % 10 == 0) {
if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(ThunderLog.kLogTagCallback,
                                "kThunderAPINotification_RemoteVideoStats: uid %s delay %d width %d height %d receivedBitrate %d " +
                                        "decoderFrameRate %d renderFrameRate %d packetLossRate %d rxStreamType %d frozenTime %d frozenRate %d" +
                                        "codecType %d decodedType %d",
                                notification.getUid(), notification.getDelay(), notification.getWidth(), notification.getHeight(),
                                notification.getReceivedBitrate(), notification.getDecoderFrameRate(), notification.getRenderFrameRate(),
                                notification.getPacketLossRate(), notification.getRxStreamType(), notification.getFrozenTime(),
                                notification.getFrozenRate(), notification.getCodecType(), notification.getDecodedType());
}
                    }
                    break;
                }
                case ThunderNotification.kThunderAPINotification_RemoteAudioStats: {
                    ThunderNotification.RemoteAudioStats notification =
                            (ThunderNotification.RemoteAudioStats) yln.get();
                    if (s_remoteAudioStatsNotificationCount++ % 10 == 0) {
if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(ThunderLog.kLogTagCallback,
                                "kThunderAPINotification_RemoteAudioStats: uid %s quality %d networkTransportDelay %d jitterBufferDelay %d totalDelay %d frameLossRate %d " +
                                        "numChannels %d receivedSampleRate %d receivedBitrate %d frozenTime %d frozenRate %d",
                                notification.getUid(), notification.getQuality(), notification.getNetworkTransportDelay(), notification.getJitterBufferDelay(),
                                notification.getTotalDelay(), notification.getFrameLossRate(), notification.getNumChannels(), notification.getReceivedSampleRate(),
                                notification.getReceivedBitrate(), notification.getFrozenTime(), notification.getFrozenRate());
}
                    }
                    break;
                }
                default: {
                    // ThunderLog.warn(ThunderLog.kLogTagCallback, "unknown notification type=%d", type);
                    break;
                }
            }
        } finally {
            s_notificationLock.unlock();
        }
    }

    /******************************* YYLive Notifications End *************************************/

    /* C++ 代码日志回调 */
    public static void logCallback(int level, byte[] tag, byte[] msg) {
        if (tag == null || msg == null || s_logCallback == null) {
            return;
        }
        s_logCallback.onThunderLogWithLevel(level, new String(tag), new String(msg));
    }

    public static void audioFilePlayCallback(Object obj, int event, int errorCode) {
        if (obj instanceof ThunderAudioFilePlayer) {
            ThunderAudioFilePlayer player = (ThunderAudioFilePlayer) obj;
            player.onPlayEvent(event, errorCode);
        }
    }

    public static void audioFilePlayVolumeCallback(Object obj, int volume, int currentMs, int totalMs) {
        if (obj instanceof ThunderAudioFilePlayer) {
            ThunderAudioFilePlayer player = (ThunderAudioFilePlayer) obj;
            player.onAudioFileVolume(volume, currentMs, totalMs);
        }
    }



    /* C++ GSLB DNS 回调 */
//	public static void dnsSetPreResolveHosts(byte[] msg) {
//		if (msg == null || mGslbMethod == null) {
//			return;
//		}
//		mGslbMethod.dnsSetPreResolveHosts(new String(msg));
//	}
//
//	public static byte[] dnsGetByNameWithHost(byte[] msg) {
//		String ret = new String();
//		if (msg == null || mGslbMethod == null) {
//			return ret.getBytes();
//		}
//		return mGslbMethod.dnsGetByNameWithHost(new String(msg));
//	}
}
