package com.thunder.livesdk.audio;

import java.nio.ByteBuffer;

public interface IAudioEncodedFrameObserver {
  /**
   * Callback on original audio encoded data
   *
   * @param data             data
   * @param dataLen          data len
   * @param codec            codec
   * @param channels         Quantity of channels (crossed data for stereo); 1: single track, 2: dual track
   * @param captureTimestamp timestamp of capture
   * @param samplesPerSec    Sampling rate
   * @return
   */
  void onAudioEncodedFrame(ByteBuffer data,
                           int dataLen,
                           int codec,
                           int channels,
                           long captureTimestamp,
                           int samplesPerSec);
}