package com.thunder.livesdk;

public interface ThunderVideoFrameConsumer {

    /**
     * Receive video frames in ByteArray type
     *
     * @param data      Data in Byte Array type
     * @param format    Pixel format: 
     *                  RGBA:  public static final int THUNDER_PIXEL_FORMAT_RGBA = 0;
     *                  I420:  public static final int THUNDER_PIXEL_FORMAT_I420 = 1;
     *                  NV21   public static final int THUNDER_PIXEL_FORMAT_NV21 = 2;
     * @param width     Width of video frame
     * @param height    Height of video frame
     * @param rotation  Clockwise rotation angle of video frame If rotation angle is defined, media engine will rotate image. 
     *                 You may set angle value to 0, 90, 180 or 270 degrees as needed. If it is set to other values, the system will automatically ignore
     * @param timestamp Timestamp of transmitted video frame Developer must set a timestamp for each video frame
     */
    void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp);

    /**
     * 推送原始视频数据 texture 纹理模式
     * @param textureID 视频帧所使用的 Texture ID
     * @param textureFormat 传入 texture 传入的格式
     * @param width 纹理的宽度
     * @param height 纹理的高度
     * @param rotation 旋转角度
     * @param timeStamp 传入的视频帧的时间戳，以毫秒为单位。不正确的时间戳会导致丢帧或者音视频不同步
     * @param transform 传入一个 4x4 的纹理矩阵，典型值是传入一个单位矩阵
     */
    void consumeTextureFrame(int textureID, int textureFormat, int width, int height,
                             int rotation, long timeStamp,float[] transform);

    /**
     * 新的推流接口
     * @param frame {@link ThunderExternalVideoFrame}
     */
    void consumeVideoFrame(ThunderExternalVideoFrame frame);
}