package com.thunder.livesdk;

public final class ThunderRtcConstant {
    public ThunderRtcConstant() {
    }

    public static final class DecoderType {
        public static final int THUNDER_FORCE_SOFT_DECODE = 0; //force hard decode
        public static final int THUNDER_FORCE_HARD_DECODE = 1; //force soft decode
        public static final int THUNDER_FORCE_CANCEL = 2; //cancel force setting
        public DecoderType() {
        }
    }

    public static final class RoomConfig {
        public static final int THUNDER_ROOMCONFIG_LIVE = 0; //Live streaming (high quality, without interaction mode) (shifted to medium quality and strong interaction mode when connecting microphones)
        public static final int THUNDER_ROOMCONFIG_COMMUNICATION = 1; //Communication (medium quality and strong interaction mode)
        public static final int THUNDER_ROOMCONFIG_GAME = 3; //Game (low quality and strong interaction mode)
        public static final int THUNDER_ROOMCONFIG_MULTIAUDIOROOM = 4; //Multi-person voice room (medium quality, economic traffic and strong interaction mode)
        public static final int THUNDER_ROOMCONFIG_CONFERENCE = 5; // Conference (medium quality, strong interaction mode, applicable to frequent enabling/disabling of microphones, with smooth sound in enabling/disabling microphones)

        public RoomConfig() {
        }
    }

    public static final class AudioConfig {
        public static final int THUNDER_AUDIO_CONFIG_DEFAULT = 0; //Default settings. which is 1 in communication mode, and 2 in live mode.
        public static final int THUNDER_AUDIO_CONFIG_SPEECH_STANDARD = 1; //Specify the sampling rate of 16 KHz, audio encoding, single track and encoding rate of 18 kbps SILK
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_STANDARD_STEREO = 2;
        //Specify the sampling rate of 44.1 KHz, music encoding, dual track and encoding rate of 24 kbps. The encode is long in time delay, EAAC+
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_STANDARD = 3;
        //Specify the sampling rate of 44.1 KHz, music encoding, dual track and encoding rate of 40 kbps. The encode is low in time delay, ELD AAC
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO = 4;
        //Specify the sampling rate of 44.1KHz, music encoding, dual track and encoding rate of 128kbps, AAC LC
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO_192 = 5;
        //Specify the sampling rate of 44.1KHz, music encoding, dual track, and encoding rate of around 192kbps
        public static final int THUNDER_AUDIO_CONFIG_SPEECH_STANDARD_PRO =6;
        // opus 16k，18kbps，single channel
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_STANDARD_PRO = 7;
        //opus 48k，40kbps，single channel
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO_PRO = 8;
        //opus 48k，128kbps，double channel
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO_192_PRO = 9;
        //opus 48k，192kbps，double channel
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_OPUS_48K_PRIVATE = 10;
        //opus-private 48k，128kbps，double channel
    }

    public static final class CommutMode {
        public static final int THUNDER_COMMUT_MODE_DEFAULT = 0; //=1 by default
        public static final int THUNDER_COMMUT_MODE_HIGH = 1; //High interactive mode
        public static final int THUNDER_COMMUT_MODE_LOW = 2; //Low interactive mode
    }

    public static final class ScenarioMode {
        public static final int THUNDER_SCENARIO_MODE_DEFAULT = 0; //=1 by default
        public static final int THUNDER_SCENARIO_MODE_STABLE_FIRST = 1; //Fluent priority: applicable for stable education
        public static final int THUNDER_SCENARIO_MODE_QUALITY_FIRST = 2; //Tone quality priority: applicable for show field with a few or without interaction
    }

    @Deprecated
    /**
     * Please use ThunderLogLevel{@link ThunderLogLevel}
     */
    public static final class LogLevel {
        public static final int THUNDER_LOG_LEVEL_TRACE = 0;
        public static final int THUNDER_LOG_LEVEL_DEBUG = 1;
        public static final int THUNDER_LOG_LEVEL_INFO = 2;
        public static final int THUNDER_LOG_LEVEL_WARN = 3;
        public static final int THUNDER_LOG_LEVEL_ERROR = 4;

        public LogLevel() {
        }
    }

    public static final class AreaType {
        public static final int THUNDER_AREA_DEFAULT = 0; //Default value (domestic)
        public static final int THUNDER_AREA_FOREIGN = 1; //Overseas
        public static final int THUNDER_AREA_RESERVED = 2; //yy-reserved
        public static final int THUNDER_AREA_PRIVATE = 10; //thunder-yylive
    }

    public static final class AuthResult {
        public static final int THUNDER_AUTHRES_SUCCUSS = 0;     //Authentication succeeded
        public static final int THUNDER_AUTHRES_ERR_SERVER_INTERNAL = 10000; //Internal server error, try again
        public static final int THUNDER_AUTHRES_ERR_NO_TOKEN = 10001; //Without token, [ThunderEngine updateToken:] needs calling:
        public static final int THUNDER_AUTHRES_ERR_TOKEN_ERR = 10002; //Token authentication failed (incorrect digital signature), which may be caused by incorrect appSecret
        public static final int THUNDER_AUTHRES_ERR_APPID = 10003; //appid in token is inconsistent with appid when authentication is executed
        public static final int THUNDER_AUTHRES_ERR_UID = 10004; //uid in token is inconsistent with uid when authentication is executed
        public static final int THUNDER_AUTHRES_ERR_TOKEN_EXPIRE = 10005; //token has expired
        public static final int THUNDER_AUTHRES_ERR_NO_APP = 10006; //App does not exist, which is not registered in the management background
        public static final int THUNDER_AUTHRES_ERR_TOKEN_WILL_EXPIRE = 10007; //token is about to expire
        public static final int THUNDER_AUTHRES_ERR_BAND = 10008; //The user is baned
    }

    public static final class UserOfflineReason {
        public static final int THUNDER_OFFLINE_QUIT = 1;                // The user is offline actively
        public static final int THUNDER_OFFLINE_DROPPED = 2;
        // The packet could not be received for long time, lost connection due to timeout. Note: Because SDK uses unreliable channel, the counterpart may leave our side actively. So it is misjudged as timeout offline
        public static final int THUNDER_OFFLINE_BECOME_AUDIENCE = 3;     // User status is switched from anchor to audience (live mode)
    }

    public static final class NetworkQuality {
        public static final int THUNDER_QUALITY_UNKNOWN = 0;        // Unknown quality
        public static final int THUNDER_QUALITY_EXCELLENT = 1;        // Excellent network quality
        public static final int THUNDER_QUALITY_GOOD = 2;        // Good network quality
        public static final int THUNDER_QUALITY_POOR = 3;        // The network quality is poor, but the communication is not affected even the user can feel its defects.
        public static final int THUNDER_QUALITY_BAD = 4;        // The network quality is bad, and the communication can be barely made but is not smooth
        public static final int THUNDER_QUALITY_VBAD = 5;        // The network quality is very bad, the communication cannot be made basically
        public static final int THUNDER_QUALITY_DOWN = 6;        // The network has been disconnected, and the communication cannot be made at all
    }

    public static final class SourceType {
        public static final int THUNDER_PUBLISH_MODE_MIC = 0; //Microphone
        public static final int THUNDER_PUBLISH_MODE_FILE = 1; //Files
        public static final int THUNDER_PUBLISH_MODE_MIX = 2; //File + Microphone
        public static final int THUNDER_PUBLISH_MODE_NONE = 10; // Stop all uplink audio data

        public SourceType() {
        }
    }

    public static final class SoundEffectMode {
        public static final int THUNDER_SOUND_EFFECT_MODE_NONE = 0; //Disable mode
        public static final int THUNDER_SOUND_EFFECT_MODE_VALLEY = 1; //VALLEY mode
        public static final int THUNDER_SOUND_EFFECT_MODE_RANDB = 2; //R&B mode
        public static final int THUNDER_SOUND_EFFECT_MODE_KTV = 3; //KTV mode
        public static final int THUNDER_SOUND_EFFECT_MODE_CHARMING = 4; // CHARMING mode
        public static final int THUNDER_SOUND_EFFECT_MODE_POP = 5; // Pop mode
        public static final int THUNDER_SOUND_EFFECT_MODE_HIPHOP = 6; // Hip-hop mode
        public static final int THUNDER_SOUND_EFFECT_MODE_ROCK = 7; // Rock mode
        public static final int THUNDER_SOUND_EFFECT_MODE_CONCERT = 8; // Concert mode
        public static final int THUNDER_SOUND_EFFECT_MODE_STUDIO = 9; // Studio mode

        public SoundEffectMode() {
        }
    }

    public static final class VoiceChangerMode {
        public static final int THUNDER_VOICE_CHANGER_MODE_NONE = 0; //Disable mode
        public static final int THUNDER_VOICE_CHANGER_MODE_ETHEREAL = 1; //Ethereal
        public static final int THUNDER_VOICE_CHANGER_MODE_THRILLER = 2; //Thriller
        public static final int THUNDER_VOICE_CHANGER_MODE_LUBAN = 3; //Luban
        public static final int THUNDER_VOICE_CHANGER_MODE_LORIE = 4; // Lorie
        public static final int THUNDER_VOICE_CHANGER_MODE_UNCLE = 5; // Uncle
        public static final int THUNDER_VOICE_CHANGER_MODE_DIEFAT = 6; // Die-fat
        public static final int THUNDER_VOICE_CHANGER_MODE_BADBOY = 7; // Bad boy
        public static final int THUNDER_VOICE_CHANGER_MODE_WRACRAFT = 8; // Wracraft
        public static final int THUNDER_VOICE_CHANGER_MODE_HEAVYMETAL = 9; // Heavy metal
        public static final int THUNDER_VOICE_CHANGER_MODE_COLD = 10; // Cold
        public static final int THUNDER_VOICE_CHANGER_MODE_HEAVYMECHINERY = 11; // Heavy machinery
        public static final int THUNDER_VOICE_CHANGER_MODE_TRAPPEDBEAST = 12; // Trapped breast
        public static final int THUNDER_VOICE_CHANGER_MODE_POWERCURRENT = 13; // Power current

        public VoiceChangerMode() {
        }
    }

    public static final class AudioSaverMode {
        public static final int THUNDER_AUDIO_SAVER_ONLY_CAPTURE = 0;
        //Only save all upstream audio data in channel. Uplink audio data: Audio data of the anchor and accompany that have been set as uplink can be saved
        public static final int THUNDER_AUDIO_SAVER_ONLY_RENDER = 1; //Save audio data beyond the anchor, e.g. Audio data of the accompany and audience
        public static final int THUNDER_AUDIO_SAVER_BOTH = 2; //Save all audio data

        public AudioSaverMode() {
        }
    }

    public static final class AudioSaverWfMode {
        public static final int THUNDER_AUDIO_SAVER_FILE_APPEND = 0; //Open another text file and write data at end of the file
        public static final int THUNDER_AUDIO_SAVER_FILE_OVERRIDE = 1; //Open a text file, and the data written will override the file

        public AudioSaverWfMode() {
        }
    }

    /**
     * @brief 音频录音音质档位
     */
    public static final class AudioSaverQuality {
        public static final int THUNDER_AUDIO_SAVER_QUALITY_LOW = 0; // 低音质 20kbps
        public static final int THUNDER_AUDIO_SAVER_QUALITY_MEDIUM = 1; // 中音质 32kbps
        public static final int THUNDER_AUDIO_SAVER_QUALITY_HIGH = 2; // 高音质 52kbps
    }

    public static final class ThunderAudioRawFrameOperationMode {

        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_READ_ONLY = 1;  //Read-only mode. The user can only get original audio data from AudioFrame
        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_WRITE_ONLY = 2;
        //Write-only mode. The user replaces the data in AudioFrame to Thunder SDK for encoding and transmission
        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_READ_WRITE = 3;
        //Read/write mode. The user obtains and modifies data from AudioFrame, and return it to Thunder SDK for encoding and transmission.

        public ThunderAudioRawFrameOperationMode() {

        }
    }

    public static final class ExternalVideoPixelFormat {

        public static final int THUNDER_PIXEL_FORMAT_RGBA = 0;
        public static final int THUNDER_PIXEL_FORMAT_I420 = 1;
        public static final int THUNDER_PIXEL_FORMAT_NV21 = 2;

        public ExternalVideoPixelFormat() {
        }
    }

    public static final class ThunderNetworkType {
        public static final int THUNDER_NETWORK_TYPE_UNKNOWN = 0; //Unknown network connection type
        public static final int THUNDER_NETWORK_TYPE_DISCONNECTED = 1; //The network has been disconnected
        public static final int THUNDER_NETWORK_TYPE_CABLE = 2; //Cable network
        public static final int THUNDER_NETWORK_TYPE_WIFI = 3; //Wi-Fi (hotspot included)
        public static final int THUNDER_NETWORK_TYPE_MOBILE = 4; //Mobile network. 2G, 3G and 4G network cannot be differentiated
        public static final int THUNDER_NETWORK_TYPE_MOBILE_2G = 5; //2G mobile network
        public static final int THUNDER_NETWORK_TYPE_MOBILE_3G = 6; //3G mobile network
        public static final int THUNDER_NETWORK_TYPE_MOBILE_4G = 7; //4G mobile network
        // todo Add 5G
    }

    public static final class ThunderConnectionStatus {
        public static final int THUNDER_CONNECTION_STATUS_CONNECTING = 0; //Connecting
        public static final int THUNDER_CONNECTION_STATUS_CONNECTED = 1; //Connected
        public static final int THUNDER_CONNECTION_STATUS_DISCONNECTED = 2; //Disconnected
    }

    public static final class ThunderVideoCaptureOrientation {
        public static final int THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT = 0;  //rotate 0 degrees
        public static final int THUNDER_VIDEO_CAPTURE_ORIENTATION_LANDSCAPE = 1;  //rotate 90 degrees
        public static final int THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT_UPSIDEDOWN = 2;  //rotate 180 degrees
        public static final int THUNDER_VIDEO_CAPTURE_ORIENTATION_LANDSCAPE_UPSIDEDOWN = 3;  //rotate 270 degrees
    }

    public static final class ThunderVideoMirrorMode {
        public static final int THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR = 0;   //The preview other than stream publishing is mirrored
        public static final int THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR = 1;   //Both preview and stream publishing are not mirrored
        public static final int THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR = 2;   //Neither preview and stream publishing is not mirrored
        public static final int THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR = 3;   //Preview is not mirrored, but publish is mirrored
    }

    /**
     * @brief remote video mirror mode
     */
    public static final class ThunderRemoteMirrorMode {
        public static final int THUNDER_REMOTE_MIRROR_MODE_DISABLED = 0;   //The remote video is not mirrored (default)
        public static final int THUNDER_REMOTE_MIRROR_MODE_ENABLED = 1;   //The remote video is mirrored
    }

    public static final class ThunderPublishCDNErrorCode {
        public static final int THUNDER_PUBLISH_CDN_ERR_SUCCESS = 0;  //Stream publishing succeeded
        public static final int THUNDER_PUBLISH_CDN_ERR_TOCDN_FAILED = 1;
        //Publishing stream to external server (CDN) is failed. 1. Check whether url is correct, 2. Check whether the token in the URL is valid (generally, token is required during cdn stream publishing and can be ignored if it doe not exist).
        public static final int THUNDER_PUBLISH_CDN_ERR_THUNDERSERVER_FAILED = 2;
        //Publishing the stream to thunder internal server is failed. 1. Check the anchor uplink network, 2. Contact us to locate internal transmission faults.
        public static final int THUNDER_PUBLISH_CDN_ERR_THUNDERSERVER_STOP = 3; // Stop stream publishing
    }

    public static final class ThunderSendMediaExtraInfoFailedStatus {
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_DATA_EMPTY = 1; //Extra information is null
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_DATA_TOO_LARGE = 2;
        //The data to be sent each time is too large. No more than 200 bytes when only publishing audio, and no more than 2048 bytes when publishing video
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_FREQUENCY_TOO_HIGHT = 3; //The sending frequency is too high, which cannot exceed 100ms each time
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_NOT_IN_ANCHOR_SYSTEM = 4; //Not an anchor system
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_NO_JOIN_MEDIA = 5; //Channel not to be joined
        public static final int THUNDER_SEND_MEDIA_EXTRA_INFO_FAILED_NO_PUBLISH_SUCCESS = 6; //Publishing failed
    }

    public static final class ThunderAudioDeviceStatus {
        public static final int THUNDER_AUDIO_DEVICE_STATUS_INIT_CAPTURE_SUCCESS = 0; // Callback on successful initialization of audio capture device
        public static final int THUNDER_AUDIO_DEVICE_STATUS_INIT_CAPTURE_ERROR_OR_NO_PERMISSION = 1; // Callback on initialization failure of audio capture. It may be caused by no permission
        public static final int THUNDER_AUDIO_DEVICE_STATUS_RELEASE_CAPTURE_SUCCESS = 2; // Callback on successful release of audio capture device
    }

    public static final class ThunderVideoCaptureStatus {
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_SUCCESS = 0;  // Succeeded
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_AUTHORIZED = 1;  // Authorize
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_NOT_DETERMINED = 2;  // No permission given
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_RESTRICTED = 3;  // Occupied
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_DENIED = 4;  // No permission
        public static final int THUNDER_VIDEO_CAPTURE_STATUS_CLOSE = 5;  // Close
    }

    // 本地音频状态定义
    public static final class LocalAudioStreamStatus {
        public static final int THUNDER_LOCAL_AUDIO_STREAM_STATUS_STOPPED = 0; // 本地音频默认初始状态
        public static final int THUNDER_LOCAL_AUDIO_STREAM_STATUS_CAPTURING = 1; // 本地音频录制设备启动成功
        public static final int THUNDER_LOCAL_AUDIO_STREAM_STATUS_ENCODING = 2; // 本地音频首帧编码成功
        public static final int THUNDER_LOCAL_AUDIO_STREAM_STATUS_SENDING = 3; // 本地音频首帧发送成功
        public static final int THUNDER_LOCAL_AUDIO_STREAM_STATUS_FAILED = 4; // 本地音频启动失败
    }

    // 本地音频开/停播状态定义
    public static final class ThunderLocalAudioPublishStatus {
        public static final int THUNDER_LOCAL_AUDIO_PUBLISH_STATUS_STOP = 0; // 停止推送本地音频流
        public static final int THUNDER_LOCAL_AUDIO_PUBLISH_STATUS_START = 1; // 开始推送本地音频流
    }

    // 本地音频错误原因定义
    public static final class LocalAudioStreamErrorReason {
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_OK = 0; // 状态正常
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_UNKNOWN = 1; // 本地音频错误原因未知
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_CAPTURE_FAILURE = 2; // 本地音频采集失败
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_ENCODE_FAILURE = 3; // 本地音频编码失败
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_DEVICE_NO_PERMISSION = 12; // 没有权限启动本地音频录制设备,"已废弃".建议使用"THUNDER_LOCAL_AUDIO_STREAM_ERROR_CAPTURE_FAILURE"枚举
        public static final int THUNDER_LOCAL_AUDIO_STREAM_ERROR_DEVICE_BUSY = 13; // 本地音频录制设备已经在使用中,"已废弃".建议使用"THUNDER_LOCAL_AUDIO_STREAM_ERROR_CAPTURE_FAILURE"枚举
    }

    // 本地视频流状态
    public static final class LocalVideoStreamStatus {
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_STOPPED = 0; // 本地视频默认初始状态
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_CAPTURING = 1; // 本地视频采集设备启动成功
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_PREVIEWING = 2; // 本地视频预览成功
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_ENCODING = 3; // 本地视频首帧编码成功
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_SENDING = 4; // 本地视频首帧发送成功
        public static final int THUNDER_LOCAL_VIDEO_STREAM_STATUS_FAILED = 5; // 本地视频启动失败
    }

    // 本地视频开/停播状态定义
    public static final class ThunderLocalVideoPublishStatus {
        public static final int THUNDER_LOCAL_VIDEO_PUBLISH_STATUS_STOP = 0; // 停止推送本地视频流
        public static final int THUNDER_LOCAL_VIDEO_PUBLISH_STATUS_START = 1; // 开始推送本地视频流
    }

    // 本地视频流状态错误原因
    public static final class LocalVideoStreamErrorReason {
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_OK = 0; // 本地视频状态正常
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_FAILURE = 1; // 出错原因不明确
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_DEVICE_DENIED = 2; // 没有权限启动本地视频采集设备
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_DEVICE_RESTRICTED = 3; // 本地视频采集设备正在使用中
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_CAPTURE_FAILURE = 4; // 本地视频采集失败，建议检查采集设备是否正常工作
        public static final int THUNDER_LOCAL_VIDEO_STREAM_ERROR_ENCODE_FAILURE = 5; // 本地视频编码失败
    }

    /**
     * Default bracket for transcoding output
     * <p>
     * The default bracket for audios is unified as: 
     * "encode": 1,
     * "bitrate": 128,
     * "sample": 44100,
     * "channel": 2
     */
    public static final class LiveTranscodingMode {
        /**
         * "bitrate": 150,
         * "fps": 15,
         * "gop": 30,
         * "height": 180,
         * "width": 320
         */
        public static final int TRANSCODING_MODE_320X180 = 1;

        /**
         * "encode": 100,
         * "bitrate": 200,
         * "fps": 15,
         * "gop": 30,
         * "height": 240,
         * "width": 320
         */
        public static final int TRANSCODING_MODE_320X240 = 2;

        /**
         * "encode": 100,
         * "bitrate": 500,
         * "fps": 15,
         * "gop": 30,
         * "height": 360,
         * "width": 640
         */
        public static final int TRANSCODING_MODE_640X360 = 3;

        /**
         * "encode": 100,
         * "bitrate": 500,
         * "fps": 15,
         * "gop": 30,
         * "height": 480,
         * "width": 640
         */
        public static final int TRANSCODING_MODE_640X480 = 4;

        /**
         * "encode": 100,
         * "bitrate": 1000,
         * "fps": 24,
         * "gop": 48,
         * "height": 544,
         * "width": 960
         */
        public static final int TRANSCODING_MODE_960X544 = 5;

        /**
         * "encode": 100,
         * "bitrate": 1600,
         * "fps": 24,
         * "gop": 48,
         * "height": 720,
         * "width": 1280
         */
        public static final int TRANSCODING_MODE_1280X720 = 6;

        /**
         * "encode": 100,
         * "bitrate": 4500,
         * "fps": 24,
         * "gop": 48,
         * "height": 1080,
         * "width": 1920
         */
        public static final int TRANSCODING_MODE_1920X1080 = 7;
    }

    public static final class ThunderLogLevel {
        public static final int THUNDERLOG_LEVEL_TRACE = 0;
        public static final int THUNDERLOG_LEVEL_DEBUG = 1;
        public static final int THUNDERLOG_LEVEL_INFO = 2;
        public static final int THUNDERLOG_LEVEL_WARN = 3;
        public static final int THUNDERLOG_LEVEL_ERROR = 4;
        public static final int THUNDERLOG_LEVEL_RELEASE = 10;
    }

    public static final class ThunderCameraPosition {
        public static final int THUNDERCAMERA_POSITION_FRONT = 0;
        public static final int THUNDERCAMERA_POSITION_BACK = 1;
    }

    public static final class ThunderPublishOrientation {
        public static final int THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT = 0;
        public static final int THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE = 1;
    }

    public static final class ThunderVideoEncodeType {
        public static final int THUNDERVIDEO_ENCODE_TYPE_H264 = 1;
        public static final int THUNDERVIDEO_ENCODE_TYPE_H265 = 2;
    }

    /**
     * @since 3.0.0
     * @deprecated use {@link ThunderVideoRenderMode} instead
     * @brief scale mode of view
     */
    public static final class ThunderVideoViewScaleMode {
        public static final int THUNDERVIDEOVIEW_SCALE_MODE_FILL = 0;
        public static final int THUNDERVIDEOVIEW_SCALE_MODE_ASPECT_FIT = 1;
        public static final int THUNDERVIDEOVIEW_SCALE_MODE_CLIP_TO_BOUNDS = 2;
    }


    public static final class ThunderPublishPlayType {
        public static final int THUNDERPUBLISH_PLAY_SINGLE = 0;  // Single publishing
        public static final int THUNDERPUBLISH_PLAY_INTERACT = 1;  // Microphone-connection video publishing
        public static final int THUNDERPUBLISH_PLAY_SCREENCAP = 2;  // Screen recording publishing
        public static final int THUNDERPUBLISH_PLAY_MULTI_INTERACT  = 3;  // Multiple-microphone connection video publishing
    }

    public static final class ThunderRtcRemotePlayType {
        public static final int THUNDER_REMOTE_PLAY_NORMAL = 0;  // common audience view
        public static final int THUNDER_REMOTE_PLAY_MULTI = 1;  // Multiple interaction view
    }

    /**
     @brief Broadcast brackets
     */
    public static final class ThunderPublishVideoMode {
        public static final int THUNDERPUBLISH_VIDEO_MODE_DEFAULT = -1;        /*! Undefined. The broadcast definition is determined by configuration*/
        public static final int THUNDERPUBLISH_VIDEO_MODE_NORMAL = 1;          /*! Ordinary */
        public static final int THUNDERPUBLISH_VIDEO_MODE_HIGHQULITY = 2;      /*! High definition */
        public static final int THUNDERPUBLISH_VIDEO_MODE_SUPERQULITY = 3;     /*! Ultra definition */
        public static final int THUNDERPUBLISH_VIDEO_MODE_BLUERAY_2M = 4;      /*! Blue ray 2M */
        public static final int THUNDERPUBLISH_VIDEO_MODE_BLUERAY_4M = 5;      /*! Blue ray 4M */
        public static final int THUNDERPUBLISH_VIDEO_MODE_BLUERAY_6M = 6;      /*! Blue ray 6M */
        public static final int THUNDERPUBLISH_VIDEO_MODE_BLUERAY_8M = 7;      /*! Blue ray 8M */
        public static final int THUNDERPUBLISH_VIDEO_MODE_FLUENCY = 8;          /*! Fluent. 200k bit rate is only for vipkid */
    }

    public static final class ThunderVideoViewType {
        public static final int THUNDERVIDEO_VIEW_PREVIEW = 1;    /* Preview */
        public static final int THUNDERVIDEO_VIEW_PLAYVIEW = 2; /* Play view */
    }

    public static final class ThunderRtcProfile {
        public static final int THUNDER_PROFILE_DEFAULT = 0;
        public static final int THUNDER_PROFILE_NORMAL = 1;
        public static final int THUNDER_PROFILE_ONLY_AUDIO = 2;
    }

    public static final class ThunderVideoRenderMode {
        public static final int THUNDER_RENDER_MODE_FILL = 0;
        public static final int THUNDER_RENDER_MODE_ASPECT_FIT = 1;
        public static final int THUNDER_RENDER_MODE_CLIP_TO_BOUNDS = 2;
        public static final int THUNDER_RENDER_MODE_ORIGINAL = 3;
    }

    public static final class ThunderExternalVideoRenderMode {
        public static final int THUNDER_RENDER_MODE_ASPECT_FIT = 0;
        public static final int THUNDER_RENDER_MODE_CLIP_TO_BOUNDS = 1;
    }

    // video capture type
    public static final class LiveEngineCaptureType {
        public static final int THUNDER_CAPTURE_TYPE_DEFAULT_CAMERA = 0; // Camera
        public static final int THUNDER_CAPTURE_TYPE_SCREEN_RECORD = 1; // Screen recording
        public static final int THUNDER_CAPTURE_TYPE_EXTERNAL_SOURCE = 2; // External stream publishing yuv
    }

    /**
     * @brief 视频流类型
     */
    public static final class ThunderVideoStreamType {
        public static final int THUNDER_VIDEO_STREAM_TYPE_HIGH = 0; // 高码率、高分辨率视频，即大流
        public static final int THUNDER_VIDEO_STREAM_TYPE_LOW = 1; // 低码率、低分辨率视频，即小流
    }

    /**
     * @brief IP地址类型
     */
    public static final class ThunderIPType {
        public static final int THUNDER_IPTYPE_NONE = 0;// 未知
        public static final int THUNDER_IPTYPE_IPV4 = 1;// ipv4
        public static final int THUNDER_IPTYPE_IPV6 = 2;// ipv6
    }

    /**
     * @brief 网络栈类型
     */
    public static final class ThunderIPStack {
        public static final int THUNDER_IPSTACK_NONE = 0; // 未知
        public static final int THUNDER_IPSTACK_IPV4 = 1; // ipv4 only
        public static final int THUNDER_IPSTACK_IPV6 = 2; // ipv6 only
        public static final int THUNDER_IPSTACK_DUAL = 3; // 双栈
    }

    /**
     * @brief User role
     */
    public static final class ThunderUserRole {
        public static final int THUNDER_USER_ROLE_ANCHOR = 1; // Host(default), with the permission to send and receive media streams
        public static final int THUNDER_USER_ROLE_AUDIENCE = 2; // Audience, with the permission to receive media streams
    }

    /**
     * @brief 图片水印缩放类型
     */
    public static final class TranscodingImageScaleType {
        public final static int TRANSCODING_IMAGESCALE_RATIO_TYPE = 0; // 等比例缩放裁剪
        public final static int TRANSCODING_IMAGESCALE_STRETCH_TYPE = 1; // 拉伸铺满整块画布
    }

    /**
     * @brief 水印个数限制
     */
    public static final class TranscodingWatermarkCountType {
        public final static int TRANSCODING_WATERMARK_TEXT_MAX = 3; // Number of text watermark
        public final static int TRANSCODING_WATERMARK_IMAGE_MAX = 4; // Number of image watermark
    }

    /**
     * @brief Authentication media stream type
     */
    public static final class LiveBizAuthStreamType {
        public final static int LIVE_BIZ_AUTH_STREAM_VIDEO = 1; // Video stream
        public final static int LIVE_BIZ_AUTH_STREAM_AUDIO = 2; // Audio stream
    };

    // 弱网时视频降级策略
    public static final class ThunderDegradationStrategy {
        public static int THUNDER_DEGRADATION_QUALITY = 0; // 弱网时,画质优先,降低编码帧率保证视频质量
        public static int THUNDER_DEGRADATION_SMOOTHLY = 1; // 弱网时,流畅优先,降低视频质量保证编码帧率
    }

    // 视频采集策略
    public static final class ThunderCameraCaptureOutputStrategy {
        public static int THUNDER_CAPTURE_OUTPUT_AUTO = 0; // 自动调整采集参数,由sdk根据设备性能自行决定采集输出策略
        public static int THUNDER_CAPTURE_OUTPUT_PERFORMANCE = 1; // 设备性能优先,以接近setVideoEncoderParameters设定的分辨率采集视频,保证设备的性能
        public static int THUNDER_CAPTURE_OUTPUT_PREVIEW = 2; // 视频预览质量优先,sdk选择更高的采集分辨率参数提高视频预览质量
    }

    // param audio device
    /**
     * Reverb parameters
     */
    public static final class ReverbExParameter {
        /**
         * Room size; range: [0~100]
         */
        public float mRoomSize = 0;
        /**
         * Pre-delay; range: [0~200]
         */
        public float mPreDelay = 0;
        /**
         * Reverberation level; range: [0~100]
         */
        public float mReverberance = 0;
        /**
         * High frequency factor; range: [0~100]
         */
        public float mHfDamping = 0;
        /**
         * Low frequency; range: [0~100]
         */
        public float mToneLow = 0;
        /**
         * High frequency; range: [0~100]
         */
        public float mToneHigh = 0;
        /**
         * Wet gain; range: [-20~10]
         */
        public float mWetGain = 0;
        /**
         * Dry gain; range: [-20~10]
         */
        public float mDryGain = 0;
        /**
         * Stereo width; range: [0~100]
         */
        public float mStereoWidth = 0;
    }

    /**
     * Compressor parameter type
     */
    public static final class CompressorParam {
        /**
         * Threshold; range: [-40~0]
         */
        public int mThreshold = 0;
        /**
         * Gain
         */
        public int mMakeupGain = 0;
        /**
         * Scale
         */
        public int mRatio = 0;
        /**
         * Slope
         */
        public int mKnee = 0;
        /**
         * Release time; range: Over 0
         */
        public int mReleaseTime = 0;
        /**
         * Launch time; range: Over 0
         */
        public int mAttackTime = 0;
    }

    /**
     * Limiter parameter type
     */
    public static final class LimterParam {
        /*
         *  -30 ~ 0
         */
        public float fCeiling = 0;
        /*
         *  -10 ~ 0
         */
        public float fThreshold = 0;
        /*
         *   0 ~ 30
         */
        public float fPreGain = 0;
        /*
         *   0 ~ 1000
         */
        public float fRelease = 0;
        /*
         *   0 ~ 1000
         */
        public float fAttack = 0;
        /*
         *   0 ~ 8
         */
        public float fLookahead = 0;
        /*
         * 0.5 ~ 2
         */
        public float fLookaheadRatio = 0;
        /*
         *   0 ~ 100
         */
        public float fRMS = 0;
        /*
         *   0 ~ 1
         */
        public float fStLink = 0;
    }

    public static final class ThunderRet {

        public static final int THUNDER_RET_SUCCESS = 0; // Processing succeeded
        public static final int THUNDER_RET_NOT_INITIALIZED = -1; // Not initialized
        public static final int THUNDER_RET_WRONG_INIT_STATUS = -2; // A wrong initialization status. Before the initialization or destroying is finished, this error will be returned back when this interface is called.
        public static final int THUNDER_RET_NO_JOIN_ROOM = -3; // Not joining a room  [If the interface only can be called after joining room, the error will be returned if the interface is called before joining room]
        public static final int THUNDER_RET_ALREADY_JOIN_ROOM = -4; // Already joining a room  [If the interface only can be called before joining room, the error will be returned if it is called after joining room]
        public static final int THUNDER_RET_WRONG_JOIN_STATUS = -5; // A wrong joining status. Before room joining or room quitting is finished, this error will be returned back when this interface is called.
        public static final int THUNDER_RET_NOT_IN_THUNDER = -6; // Not in a Thunder mode (This error will be returned back only if an interface called by Thunder is called in a ThunderBolt mode)
        public static final int THUNDER_RET_NOT_IN_THUNDERBOLT = -7; // Not in a ThunderBolt mode (This error will be returned back only if an interface called by ThunderBolt is called in a Thunder mode)
        public static final int THUNDER_RET_INVALID_UID = -8; // Invalid uid
        public static final int THUNDER_RET_INVALID_ROOMID = -9; // Invalid roomId
        public static final int THUNDER_RET_INVALID_URL = -10; // Invalid url
        public static final int THUNDER_RET_INVALID_TASKID = -11; // Invalid task
        public static final int THUNDER_RET_CAPACITY_LIMIT = -12; // SDK capacity limit (super-threshold of a stream publishing address)
        public static final int THUNDER_RET_INVALID_ARGUMENT = -13; // Invalid parameters (when necessary parameters are null or illegal)
        public static final int THUNDER_RET_START_AUDIO_CAPTURE_ERR = -14; // Error in starting audio capture
        public static final int THUNDER_RET_NO_START_AUDIO_CAPTURE = -15; // Not starting audio capture. In the case of not enabling capture, this error will be returned when external data is pushed.
        public static final int THUNDER_RET_ALREADY_START_AUDIO_CAPTURE = -16; // Already starting audio capture. This error will be returned when resetting is executed during capturing.
        public static final int THUNDER_RET_NO_START_AUDIO_PUBLISH = -17; // Not starting audio publishing. In the case of not starting publishing, this error will be returned when external data is pushed.
        public static final int THUNDER_RET_ALREADY_START_AUDIO_ENCODE = -18; // Already starting audio capture. This error will be returned when parameters are reset during capturing.
        public static final int THUNDER_RET_ALREADY_START_AUDIO_PUBLISH = -19; // Already starting audio publishing. This error will be returned when parameters are reset during capturing.
        public static final int THUNDER_RET_NOT_ON_FRONT_CAMERA = -20; // This error will be returned if a camera mirror is set on a rear camera.
        public static final int THUNDER_RET_NOT_ON_MULTI_TYPE = -21; // When a multi-user microphone connection layout is set, this error will be returned if a remote play type is set before users join a room.
        public static final int THUNDER_RET_INVALID_SEATINDEX = -22; // This error will be returned when the preset seat number for multi-user microphone connection exceeds a layout setting range.
        public static final int THUNDER_RET_WRONG_AUDIO_CAPTURE_TYPE = -23; // Wrong audio capture type
        public static final int THUNDER_RET_ALREADY_START_CUSTOM_AUDIO = -24; // Already starting stream publishing of external audios
        public static final int THUNDER_RET_CALL_TOO_FREQUENT = -25; // Too frequent calling of interfaces
        public static final int THUNDER_RET_NOT_CUSTOM_AUDIO_SOURCE = -26; // 不是外部音频推流源
        public static final int THUNDER_RET_INVALID_VIDEO_STREAM_TYPE = -27; // 错误的视频流类型
        public static final int THUNDER_RET_ALREADY_START_VIDEO_PUBLISH = -28; // 已启动视频开播，设置双流模式开播必须在开播之前
        public static final int THUNDER_RET_START_AUDIO_ENCODE_ERR = -29; // Error starting audio encoding
        public static final int THUNDER_RET_ALREADY_START_VIDEO_CAPTURE = -30; // Video capture has started
        public static final int THUNDER_RET_LOCAL_USER_ROLE_ERR = -31;// 用户角色错误，只有用户角色为主播才能发布音视频流
        public static final int THUNDER_RET_NOT_SUPPORT_IN_LOWLANTENCY = -32; // 不支持在低延迟模式下调用

        // Video mixing related [-101 ~ -200]
        public static final int THUNDER_RET_INVALID_TRANSCODING_MODE = 101; // Invalid transcodingMode

        // Subscription related 【-201 ~ -300】
        public static final int THUNDER_RET_ALREADY_SUBSCRIBE_ALL_ROOM = -201; // Users who have subscribed to the whole room cannot unsubscribe or subscribe to a single user by using the addsubscribe and removesubscribe interfaces
        public static final int THUNDER_RET_NO_SUBSCRIBE_ROOM = -202; // There is no subscription to this room
        public static final int THUNDER_RET_NO_SUBSCRIBE_UID = -203; // This user is not in the subscription room

        // Warning codes returned asynchronously [-1001 ~ -2000]

        // Error codes returned asynchronously [-2001 ~ -3000]
        public static final int THUNDER_NOTIFY_JOIN_FAIL = -2001; // Notifying that room joining fails when SDK does not receive services due to network (SDK will execute room quitting operation if the room joining fails)

        // Error codes used in the audio library [-3001 ~ -4000]
        public static final int THUNDER_RET_AUDIO_ENGINE_ERROR = -3001; // Returning an audio engine error. It is required to check logs for specific reasons.
        public static final int THUNDER_RET_AUDIO_DISABLE_VOICE_POSITION = -3002; // Not enabling voice stereo of remote users.
        public static final int THUNDER_RET_AUDIO_PUBLISH_MODE_NONE = -3003; // When SourceType is THUNDER_PUBLISH_MODE_NONE and is used to publish, this error will be returned.

        // Error codes used in the video library [-4001 ~ -5000]
        public static final int THUNDER_RET_VIDEO_ENGINE_ERROR = -4001; // Returning a video engine error. It is required to check logs for specific reasons.
        public static final int THUNDER_RET_INVALID_VIDEO_SOURCE= -4002; // 无效的视频源， 当外部推流时不支持设置固定画面推流

        // Error codes used in the transmission library [-5001 ~ -6000]
        public static final int THUNDER_RET_TRANS_ENGINE_ERROR = -5001; // Returning a transfer engine error. It is required to check logs for specific reasons.

        // Error codes used in the configuration library (argo) [-6001 ~ -7000]
        public static final int THUNDER_RET_ARGO_ENGINE_ERROR = -6001; // Returning a configuration engine error. It is required to check logs for specific reasons.

        // Error codes used in the SEVICE library [-7001 ~ -8000]
        public static final int THUNDER_RET_SERVICE_ENGINE_ERROR = -7001; // Returning a SERVICE engine error. It is required to check logs for specific reasons.

        // Error codes used in the LOG library [-8001 ~ -9000]
        public static final int THUNDER_RET_LOG_ENGINE_ERROR = -8001; // Returning a log engine error. It is required to check logs for specific reasons.

        // Error codes used in the Java [-9001 ~ -9999]
        public static final int THUNDER_RET_ALREADY_EXIST = -9001; // Returning a call error. It
        // is required to check Incompatible interface
    }

    public static final class ThunderVideoCodecType {
        public static final int VIDEO_CODEC_UNKNOW  = 0;
        public static final int VIDEO_CODEC_VP8     = 1;
        public static final int VIDEO_CODEC_H264    = 2;
        public static final int VIDEO_CODEC_H265    = 3;
    }

    public static final class ThunderVideoEncodedType {
        public static final int VIDEO_ENCODED_TYPE_UNKNOWN = 0; // 未知
        public static final int VIDEO_ENCODED_TYPE_HARD = 1; // 硬编
        public static final int VIDEO_ENCODED_TYPE_SOFT = 2; // 软编
    }

    public static final class ThunderVideoDecodedType {
        public static final int VIDEO_DECODED_TYPE_UNKNOWN = 0; // Unknown decode type
        public static final int VIDEO_DECODED_TYPE_HARD = 1; // Hard decode type
        public static final int VIDEO_DECODED_TYPE_SOFT = 2; // Soft decode type
    }

    // Quality adaptability of local videos since last statistics (based on target frame rate and target bit rate)
    public static final class ThunderVideoQualityAdapt {
        public static final int ADAPT_NONE  = 0; // The quality of local video is constant
        public static final int ADAPT_UP_BANDWIDTH = 1; // The quality of local video has been improved because of higher network bandwidth
        public static final int ADAPT_DOWN_BANDWIDTH  = 2; // The quality of local video becomes worse because of lower network bandwidth
    }

    // 远端音频流状态信息：state定义
    public static final class RemoteAudioState {
        public static final int THUNDER_REMOTE_AUDIO_STATE_STOPPED = 0; // 远端音频流默认初始状态。 在 THUNDER_REMOTE_AUDIO_REASON_LOCAL_STOPPED(4) 或 THUNDER_REMOTE_AUDIO_REASON_REMOTE_STOPPED(6)  的情况下，会报告该状态
        public static final int THUNDER_REMOTE_AUDIO_STATE_STARTING = 1; // 本地用户已接收远端音频首包
        public static final int THUNDER_REMOTE_AUDIO_STATE_DECODING = 2; // 远端音频流正在解码，正常播放
        public static final int THUNDER_REMOTE_AUDIO_STATE_FROZEN = 3; // 远端音频流卡顿。在 THUNDER_REMOTE_AUDIO_REASON_NETWORK_CONGESTION(2) 的情况下，会报告该状态
        public static final int THUNDER_REMOTE_AUDIO_STATE_FAILED = 4; // 远端音频流播放失败。在THUNDER_REMOTE_AUDIO_REASON_INTERNAL(1)，THUNDER_REMOTE_AUDIO_REASON_PLAY_DEVICE_START_FAILED(8)，
                                                                       // THUNDER_REMOTE_AUDIO_REASON_FORMAT_NOT_SUPPORT(9)的情况下，会报告该状态
    }

    // 远端音频流状态信息：reason定义
    public static final class RemoteAudioReason {
        public static final int THUNDER_REMOTE_AUDIO_REASON_OK = 0; // 状态正常
        public static final int THUNDER_REMOTE_AUDIO_REASON_INTERNAL = 1; // 内部原因
        public static final int THUNDER_REMOTE_AUDIO_REASON_NETWORK_CONGESTION = 2; // 网络阻塞
        public static final int THUNDER_REMOTE_AUDIO_REASON_NETWORK_RECOVERY = 3; // 网络恢复正常
        public static final int THUNDER_REMOTE_AUDIO_REASON_LOCAL_STOPPED = 4; // 本地用户停止接收远端音频流或本地用户禁用音频模块
        public static final int THUNDER_REMOTE_AUDIO_REASON_LOCAL_STARTED = 5; // 本地用户恢复接收远端音频流或本地用户启用音频模块
        public static final int THUNDER_REMOTE_AUDIO_REASON_REMOTE_STOPPED = 6; // 远端用户停止发送音频流或远端用户禁用音频模块
        public static final int THUNDER_REMOTE_AUDIO_REASON_REMOTE_STARTED = 7; // 远端用户恢复发送音频流或远端用户启用音频模块
        public static final int THUNDER_REMOTE_AUDIO_REASON_PLAY_DEVICE_START_FAILED = 8; // 音频播放设备启动失败
        public static final int THUNDER_REMOTE_AUDIO_REASON_FORMAT_NOT_SUPPORT = 9; // 音频编码标准不支持导致解码失败
    }

    // 远端视频流状态
    public static final class RemoteVideoState {
        public static final int THUNDER_REMOTE_VIDEO_STATE_STOPPED = 0; // 远端视频默认初始状态。在 THUNDER_REMOTE_VIDEO_REASON_LOCAL_STOPPED(4) 或 THUNDER_REMOTE_VIDEO_REASON_REMOTE_STOPPED(6) 的情况下，会报告该状态
        public static final int THUNDER_REMOTE_VIDEO_STATE_STARTING = 1; // 本地用户已接收远端视频首包
        public static final int THUNDER_REMOTE_VIDEO_STATE_DECODING = 2; // 远端视频流正在解码
        public static final int THUNDER_REMOTE_VIDEO_STATE_RENDERING = 3; // 远端视频流正在渲染
        public static final int THUNDER_REMOTE_VIDEO_STATE_FROZEN = 4; // 远端视频流卡顿。在 THUNDER_REMOTE_VIDEO_REASON_NETWORK_CONGESTION(2) 的情况下，会报告该状态
        public static final int THUNDER_REMOTE_VIDEO_STATE_FAILED = 5; // Failed to play remote video. In the case of THUNDER_REMOTE_VIDEO_REASON_CODEC_UNKNOWN(8), the status will be reported
    }

    // 远端视频流状态改变的原因
    public static final class RemoteVideoReason {
        public static final int THUNDER_REMOTE_VIDEO_REASON_OK = 0; // 状态正常
        public static final int THUNDER_REMOTE_VIDEO_REASON_INTERNAL = 1; // 内部原因
        public static final int THUNDER_REMOTE_VIDEO_REASON_NETWORK_CONGESTION = 2; // 网络阻塞
        public static final int THUNDER_REMOTE_VIDEO_REASON_NETWORK_RECOVERY = 3; // 网络恢复正常
        public static final int THUNDER_REMOTE_VIDEO_REASON_LOCAL_STOPPED = 4; // 本地用户停止接收远端视频流或本地用户禁用视频模块
        public static final int THUNDER_REMOTE_VIDEO_REASON_LOCAL_STARTED = 5; // 本地用户恢复接收远端视频流或本地用户启动视频模块
        public static final int THUNDER_REMOTE_VIDEO_REASON_REMOTE_STOPPED = 6; // 远端用户停止发送视频流或远端用户禁用视频模块
        public static final int THUNDER_REMOTE_VIDEO_REASON_REMOTE_STARTED = 7; // 远端用户恢复发送视频流或远端用户启用视频模块
        public static final int THUNDER_REMOTE_VIDEO_REASON_CODEC_UNKNOWN = 8; // Unknown video codec
    }

    // 本地文件播放事件的各种状态
    public static final class ThunderAudioFilePlayerEvent {
        public static final int AUDIO_PLAY_EVENT_OPEN = 1; // 打开文件
        public static final int AUDIO_PLAY_EVENT_PLAY = 2; // 开始播放
        public static final int AUDIO_PLAY_EVENT_STOP = 3; // 停止播放
        public static final int AUDIO_PLAY_EVENT_PAUSE = 4; // 暂停播放
        public static final int AUDIO_PLAY_EVENT_RESUME = 5; // 恢复播放
        public static final int AUDIO_PLAY_EVENT_END = 6; // 播放完毕
        public static final int AUDIO_PLAY_EVENT_SEEK_COMPLETE = 7; // 快进播放
    }

    // 本地文件播放事件的错误码
    public static final class ThunderAudioFilePLayerErrorCode {
        public static final int AUDIO_PLAYER_OPEN_FILE_PATH_ERROR = -4; // 文件路径错误
        public static final int AUDIO_PLAYER_OPEN_FILE_FORMAT_NOT_SUPPORT = -3; // 文件格式不支持
        public static final int AUDIO_PLAYER_OPEN_FILE_DECODER_FAILED = -2; // 文件格式解码出错
        public static final int AUDIO_PLAYER_CREATE_FILE_DECODER_FAILED = -1; // 文件格式解析出错
        public static final int AUDIO_PLAYER_STATUS_SUCCESS = 0; // 成功
    }

    /**
     * @brief 当前语音路由的设备
     */
    public static final class ThunderAudioOutputRouting  {
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_DEFAULT = -1; // 使用默认的语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_HEADSET = 0; // 使用耳机为语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_EARPIECE = 1; // 使用听筒为语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_HEADSETNOMIC = 2; // 使用不带麦的耳机为语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_SPEAKERPHONE = 3; // 使用手机的扬声器为语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_LOUDSPEAKER = 4; // 使用外接的扬声器为语音路由
        public static final int THUNDER_AUDIO_OUTPUT_ROUTING_HEADSETBLUETOOTH = 5; // 使用蓝牙耳机为语音路由
    }

    public static final class ThunderAudioCodecType {
        public static final int AUDIO_CODEC_UNKNOW = 0;
        public static final int AUDIO_CODEC_EAAC_PLUS = 1; // eAAC+
        public static final int AUDIO_CODEC_AAC = 2; // AAC
    }

    public static final class ThunderAudioSample
    {
        public static final int AUDIO_SAMPLE_32000 = 32000; // 32kHz
        public static final int AUDIO_SAMPLE_44100 = 44100; // 44.1kHz
        public static final int AUDIO_SAMPLE_48000 = 48000; // 48kHz
    }

    /**
     * @brief 音频录音状态码
     */
    public static final class ThunderAudioRecordStateCode  {
        public static final int THUNDER_AUDIO_RECORD_ERROR_NONE = 0; // 音频录音正常
        public static final int THUNDER_AUDIO_RECORD_COMPLETED = 1; // 音频录音完成
        public static final int THUNDER_AUDIO_RECORD_INITIALIZED = 2; // 音频录音已经初始化
        public static final int THUNDER_AUDIO_RECORD_NO_INITIALIZED = 3; // 音频录音未初始化
        public static final int THUNDER_AUDIO_RECORD_ENCODER_ERROR = 4; // 音频录音编码异常
        public static final int THUNDER_AUDIO_RECORD_FILE_PATH_INVALID = 5; //音频录音路径异常
    }

    /**
     * @brief  本地说话状态码
     */
    public static final class ThunderLocalSpeakingState  {
        public static final int THUNDER_LOCAL_SPEAKING_STATE_BEGAN = 0; // 说话开始
        public static final int THUNDER_LOCAL_SPEAKING_STATE_ENDED = 1; // 说话结束
    }

    // 私有回调key
    public static final class ThunderPrivateCallbackKey
    {
        public static final int THUNDER_PRIVATE_PUBLISH_LAG = 1;
        public static final int THUNDER_VIDEO_FRAME_PROCESS_TIME = 2;
        public static final int THUNDER_PRIVATE_MEDIA_EXTRA_DATA = 3;
        public static final int THUNDER_SEND_PRIVATE_MEDIA_EXTRA_DATA_FAILED_STATUS = 4;
    }

    /**
     * @brief 切换转码档位结果
     */
    public static final class ThunderSwitchVideoTransIdResult {
        public int dstTransId; // 目标转码档位，当目标转码档位为255自动档时，currentTransId为实际档位
        public int currentTransId; // 当前处于的转码档位
        public int status; // 切换状态，详见{@link ThunderSwitchVideoTransIdStatus}
    }

    /**
     * @brief 切换转码档位状态值
     */
    public static final class ThunderSwitchVideoTransIdStatus {
        public static final int THUNDER_SWITCH_VIDEO_TRANSID_SUCCESS = 0; // 切换成功
        public static final int THUNDER_SWITCH_VIDEO_TRANSID_TIMEOUT = 1; // 切换超时
    }

    /**
     * @brief 观众网流模式
     */
    public static final class ThunderAudienceMode {
        public static final int THUNDER_AUDIENCE_MODE_ORIGINAL = 0; // 原流模式
        public static final int THUNDER_AUDIENCE_MODE_MIX = 1; // 混流模式
    }
}
