package com.thunder.livesdk;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * Created by xiongxiong on 2017/10/31.
 */

public class ThunderNotification {

    /********* new notify *************/
    public static final int kThunderNotification_FirstVideoFrameSend = 0,
    kThunderNotification_FirstAudioFrameSend = 1,
    kThunderNotification_JoinRoomSuccess = 2,
    kThunderNotification_LeaveRoom = 3,
    kThunderNotification_RemoteVideoPlay = 4,
    kThunderNotification_BizAuthRes = 5,
    kThunderNotification_SdkAuthRes = 6,
    kThunderNotification_UserBanned = 7,
    kThunderNotification_TokenRequest = 8,
    kThunderNotification_TokenWillExpire = 9,
    kThunderNotification_AudioCaptureVolume = 10,
    kThunderNotification_AudioPlayVolume = 11,
    kThunderNotification_AudioPlayData = 12,
    kThunderNotification_AudioPlaySpectrumData = 13,
    kThunderNotification_AudioCapturePcmData = 14,
    kThunderNotification_UserAppMsgData = 15,
    kThunderNotification_AppMsgDataFailStatus = 16,
    kThunderNotification_AudioRenderPcmData = 17,
    kThunderNotification_HttpsRequest = 18,
    kThunderNotification_RemoteVideoStopped = 19,
    kThunderNotification_RemoteAudioStopped = 20,
    kThunderNotification_VideoSizeChange = 21,
    kThunderNotification_ConnectionStatus = 22,
    kThunderNotification_ConnectionLost = 23,
    kThunderNotification_RoomStats = 24,
    kThunderNotification_NetworkStateChange = 25,
    kThunderNotification_PublishStreamToCdnStatus = 26,
    kThunderNotification_UserJoined = 27,
    kThunderNotification_UserOffline = 28,
    kThunderNotification_NetworkQuality = 29,
    kThunderNotification_AudioExtraInfo = 30,
    kThunderNotification_AudioExtraFailStatus = 31,
    kThunderNotification_VideoExtraInfo = 32,
    kThunderNotification_MixVideoExtraInfo = 33,
    kThunderNotification_MixAudioExtraInfo = 34,
    kThunderNotification_AudioCaptureStatus = 35,
    kThunderNotification_VideoCaptureStatus = 36,
    kThunderAPINotification_LocalVideoStats = 37,
    kThunderAPINotification_RemoteVideoStats = 38,
	kThunderAPINotification_LocalAudioStats = 39,
	kThunderAPINotification_RemoteAudioStats = 40,
    kThunderNotification_RemoteAudioStateChanged = 41,
    kThunderNotification_RemoteAudioPlay = 42,
    kThunderNotification_RemoteVideoStateChanged = 43,
    kThunderAPINotification_LocalAudioStatusChanged = 44,
    kThunderAPINotification_DeviceStats = 45,
    kThunderAPINotification_LocalVideoStatusChanged = 46,
    kThunderAPINotification_AudioRouteChanged = 47,
    kThunderAPINotification_HowlingDetectResult = 48,
    kThunderAPINotification_EchoDetectResult = 49,
    kThunderNotification_AudioInputDeviceTestVolume = 50,
    kThunderNotification_AudioOutputDeviceTestVolume = 51,
    kThunderNotification_CameraFocuseChanged = 52,
    kThunderNotification_CameraExposureChanged = 53,
    kThunderNotification_PrivateCallBack = 54,
    kThunderNotification_AudioRecordState = 55,
    kThunderNotification_UserRoleChanged = 56,
    kThunderNotification_LocalSpeakingState = 57,
    kThunderNotification_RemoteVideoTransId = 58,
    kThunderNotification_SetSubscribeVideoTransIdResult = 59,
    kThunderNotification_SwitchVideoTransIdResult = 60,
    kThunderAPINotification_LocalAudioPublishStatus = 61,
    kThunderAPINotification_LocalVideoPublishStatus = 62,


    //argo inner use
    kThunderNotification_OnVideoConfig = 1000,
    kThunderNotification_OnBlackCodecConfig = 1001;


    public static class ThunderFirstVideoFrameSend {
        private int mElapsedTime;

        public ThunderFirstVideoFrameSend(int elapsedTime) {
            this.mElapsedTime = elapsedTime;
        }
        public int getElapsedTime() {
            return mElapsedTime;
        }
    }

    public static class ThunderFirstAudioFrameSend {
        private int mElapsedTime;

        public ThunderFirstAudioFrameSend(int elapsedTime) {
            this.mElapsedTime = elapsedTime;
        }

        public int getElapsedTime() {
            return mElapsedTime;
        }
    }

    public static class ThunderJoinRoomSuccess {
        private String mRoomName;
        private String mUid;
        private int mElapsedTime;

        public ThunderJoinRoomSuccess(String mRoomName, String mUid, int mElapsedTime) {
            this.mRoomName = mRoomName;
            this.mUid = mUid;
            this.mElapsedTime = mElapsedTime;
        }

        public String getmRoomName() {
            return mRoomName;
        }

        public String getmUid() {
            return mUid;
        }

        public int getmElapsedTime() {
            return mElapsedTime;
        }
    }

    public static class ThunderLeaveRoom {
        public ThunderLeaveRoom() {
        }
    }

    public static class ThunderRemoteVideoPlay {
        private String mUid;
        private int mWith;
        private int mHeigh;
        private int mElapsedTime;
        public ThunderRemoteVideoPlay(String mUid, int mWith, int mHeigh, int mElapsedTime) {
            this.mUid = mUid;
            this.mWith = mWith;
            this.mHeigh = mHeigh;
            this.mElapsedTime = mElapsedTime;
        }
        public String getmUid() {
            return mUid;
        }

        public int getmWith() {
            return mWith;
        }

        public int getmHeigh() {
            return mHeigh;
        }

        public int getmElapsedTime() {
            return mElapsedTime;
        }
    }

    public static class ThunderBizAuthRes {
        /**
         * 开播鉴权or播放鉴权
         */
        private boolean bPublish;
        private int mResult;

        public ThunderBizAuthRes(boolean bPublish, int mResult) {
            this.bPublish = bPublish;
            this.mResult = mResult;
        }

        public boolean isbPublish() {
            return bPublish;
        }
        public int getmResult() {
            return mResult;
        }
    }

    public static class ThunderBizAuthStreamRes {
        /**
         * 开播鉴权or播放鉴权
         */
        private boolean bPublish;
        private int mResult;
        private int mStreamType; // refer to LiveBizAuthStreamType

        public ThunderBizAuthStreamRes(boolean bPublish, int mResult, int mStreamType) {
            this.bPublish = bPublish;
            this.mResult = mResult;
            this.mStreamType = mStreamType;
        }

        public boolean isbPublish() {
            return bPublish;
        }
        public int getmStreamType() {
            return mStreamType;
        }
        public int getmResult() {
            return mResult;
        }
    }

    public static class ThunderSdkAuthRes {
        /**
         * 鉴权成功
         */
        public static final int THUNDER_SDK_AUTHRES_SUCCUSS = 0;

        /**
         * 服务器内部错误，可以重试
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_SERVER_INTERNAL = 10000;

        /**
         * 没有带token，需要调用{@link ThunderEngine#updateToken(byte[])}
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_NO_TOKEN = 10001;

        /**
         * token校验失败（数字签名不对），可能使用的appSecret不对
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_TOKEN_ERR = 10002;

        /**
         * token中appid跟鉴权时带的appid不一致
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_APPID = 10003;

        /**
         * token中uid跟鉴权时带的uid不一致
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_UID = 10004;

        /**
         * token已过期
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_TOKEN_EXPIRE = 10005;

        /**
         * app不存在，没有在管理后台注册
         */
        public static final int THUNDER_SDK_AUTHRES_ERR_NO_APP = 10006;

        private int mResult;

        public ThunderSdkAuthRes(int mResult) {
            this.mResult = mResult;
        }

        public int getmResult() {
            return mResult;
        }
    }

    public static class ThunderUserBanned {
        private boolean bBanned;

        public ThunderUserBanned(boolean bBanned) {
            this.bBanned = bBanned;
        }

        public boolean isbBanned() {
            return bBanned;
        }
    }

    public static class ThunderTokenRequest {
        public ThunderTokenRequest() {
        }
    }

    public static class ThunderTokenWillExpire {
        private String token;

        public ThunderTokenWillExpire(String token) {
            this.token = token;
        }

        public String getToken() {
            return token;
        }
    }

    public static class ThunderAudioCaptureVolume {
        /**
         * 音频上行总音量能量值, 取值范围[0, 100]
         */
        private int mVolume;

        /**
         * 采集时间戳
         */
        private int mCpt;

        /**
         * 仅麦克风采集能量值 [0, 100]
         */
        private int mMicVolume;

        public ThunderAudioCaptureVolume(int volulme, int cpt, int micVolume) {
            mVolume = volulme;
            mCpt = cpt;
            mMicVolume = micVolume;
        }

        public int getmVolume() {
            return mVolume;
        }

        public int getmCpt() {
            return mCpt;
        }

        public int getmMicVolume() {
            return mMicVolume;
        }
    }


    public static class AudioPlayVolume
    {
        private String uid;
        private int volume;
        private long pts;

        public AudioPlayVolume(String uid, int volume, long pts) {
            this.uid = uid;
            this.volume = volume;
            this.pts = pts;
        }
    }
    public static class ThunderAudioPlayVolume
    {
        private int totalVolume;
        private HashSet<ThunderEventHandler.AudioVolumeInfo> volumes = new HashSet<>();

        public ThunderAudioPlayVolume(int totalVolume, HashSet<ThunderEventHandler.AudioVolumeInfo> volumes) {
            this.totalVolume = totalVolume;
            this.volumes = volumes;
        }

        public int getTotalVolume() {
            return totalVolume;
        }

        public HashSet<ThunderEventHandler.AudioVolumeInfo> getVolumes() {
            return volumes;
        }
    }

    public static class ThunderAudioPlayData {
        private String uid;
        private int duration;
        private int cpt;
        private int pts;
        private int frameType;
        private byte[] data;

        public ThunderAudioPlayData(String uid, int duration, int cpt, int pts, int frameType, byte[] data) {
            this.uid = uid;
            this.duration = duration;
            this.cpt = cpt;
            this.pts = pts;
            this.frameType = frameType;
            this.data = data;
        }

        public String getUid() {
            return uid;
        }

        public int getDuration() {
            return duration;
        }

        public int getCpt() {
            return cpt;
        }

        public int getPts() {
            return pts;
        }

        public int getFrameType() {
            return frameType;
        }

        public byte[] getData() {
            return data;
        }
    }

    public static class ThunderAudioPlaySpectrumData {
        private byte[] data;

        public ThunderAudioPlaySpectrumData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return data;
        }
    }

    public static class ThunderAudioCapturePcmData {
        private int len;
        private byte[] data;
        private int sampleRate;
        private int channel;

        public ThunderAudioCapturePcmData(byte[] data, int len, int sampleRate, int channel) {
            this.data = data;
            this.len = len;
            this.sampleRate = sampleRate;
            this.channel = channel;
        }

        public int getLen() {
            return len;
        }

        public byte[] getData() {
            return data;
        }

        public int getSampleRate() {
            return sampleRate;
        }

        public int getChannel() {
            return channel;
        }
    }

    public static class ThunderUserAppMsgData {
        private int len;
        String msgData;
        String uid;

        public ThunderUserAppMsgData(int len, String msgData, String uid) {
            this.len = len;
            this.msgData = msgData;
            this.uid = uid;
        }

        public int getLen() {
            return len;
        }

        public String getMsgData() {
            return msgData;
        }

        public String getUid() {
            return uid;
        }
    }

    public static class ThunderAppMsgDataFailStatus {
        private int status;

        public ThunderAppMsgDataFailStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }
    }

    public static class ThunderAudioRenderPcmData {
        private int len;
        private byte[] data;
        private int duration;
        private int sampleRate;
        private int channel;

        public ThunderAudioRenderPcmData(int len, byte[] data, int duration, int sampleRate, int channel) {
            this.len = len;
            this.data = data;
            this.duration = duration;
            this.sampleRate = sampleRate;
            this.channel = channel;
        }

        public int getLen() {
            return len;
        }

        public byte[] getData() {
            return data;
        }

        public int getDuration() {
            return duration;
        }

        public int getSampleRate() {
            return sampleRate;
        }

        public int getChannel() {
            return channel;
        }
    }

    public static class ThunderHttpsRequest {
        private String url;
        private int target;

        public ThunderHttpsRequest(String url, int target) {
            this.url = url;
            this.target = target;
        }

        public String getUrl() {
            return url;
        }

        public int getTarget() {
            return target;
        }
    }

    public static class ThunderRemoteVideoStopped {
        private String roomId;
        private String uid;
        private boolean bStop;

        public ThunderRemoteVideoStopped(String roomId, String uid, boolean bStop) {
            this.roomId = roomId;
            this.uid = uid;
            this.bStop = bStop;
        }

        public String getRoomId() {
            return roomId;
        }

        public String getUid() {
            return uid;
        }

        public boolean isbStop() {
            return bStop;
        }
    }

    public static class ThunderRemoteAudioStopped {
        private String roomId;
        private String uid;
        private boolean bStop;

        public ThunderRemoteAudioStopped(String roomId, String uid, boolean bStop) {
            this.roomId = roomId;
            this.uid = uid;
            this.bStop = bStop;
        }

        public String getRoomId() {
            return roomId;
        }

        public String getUid() {
            return uid;
        }

        public boolean isbStop() {
            return bStop;
        }
    }

    public static class ThunderVideoSizeChange {
        private String uid;
        private int width;
        private int height;

        public ThunderVideoSizeChange(String uid, int width, int height) {
            this.uid = uid;
            this.width = width;
            this.height = height;
        }

        public String getUid() {
            return uid;
        }

        public int getWidth() {
            return width;
        }

        public int getHeight() {
            return height;
        }
    }

    public static class ThunderVideoCaptureFocusChanged {
        private int posX;
        private int posY;
        private int width;
        private int height;

        public ThunderVideoCaptureFocusChanged(int posX, int posY, int width, int height) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
        }

        public int getPosX() {return posX;}
        public int getPosY() {return posY;}
        public int getWidth() {return width;}
        public int getHeight() {return height;}
    }

    public static class ThunderVideoCaptureExposureChanged {
        private int posX;
        private int posY;
        private int width;
        private int height;

        public ThunderVideoCaptureExposureChanged(int posX, int posY, int width, int height) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
        }

        public int getPosX() {return posX;}
        public int getPosY() {return posY;}
        public int getWidth() {return width;}
        public int getHeight() {return height;}
    }

    public static class ThunderConnectionStatus {
        public static final int CONNETING = 0; // 正在连接
        public static final int CONNETED = 1; // 连接成功
        public static final int DISCONNECT = 2; // 连接断开

        private int status;

        public ThunderConnectionStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }
    }

    public static class ThunderConnectionLost {
        public ThunderConnectionLost() {
        }
    }

    public static class RoomStats {

        public int totalDuration; // 加入频道后累计通话时长,单位为秒
        public int txBitrate; //链路发送码率，单位bps
        public int rxBitrate; //链路接收码率，单位bps
        public int txBytes; // 加入频道后累计发送字节数
        public int rxBytes; // 加入频道后累计接收字节数
        public int txAudioBytes; // 加入频道后累计发送音频字节数
        public int rxAudioBytes; // 加入频道后累计接收音频字节数
        public int txVideoBytes; // 加入频道后累计发送视频字节数
        public int rxVideoBytes; // 加入频道后累计接收视频字节数
        public int txAudioBitrate;  //音频包的发送码率，单位bps
        public int rxAudioBitrate;  //音频包的接收码率，单位bps
        public int txVideoBitrate;  //视频包的发送码率，单位bps
        public int rxVideoBitrate;  //视频包的接收码率，单位bps
        public int lastmileDelay;  // 本地客户端到边缘服务器的延迟（毫秒)，音频和视频延时中的较大值
        public int txPacketLossRate; // 本地客户端到边缘服务器的上行丢包率（%）
        public int rxPacketLossRate; // 本地客户端到边缘服务器的下行丢包率（%）
        public int serverIpType;// 连接的媒体服务器ip类型, 见ThunderRtcConstant.ThunderIPType
        public int localIpStack;// 本地网络栈类型, 见ThunderRtcConstant.ThunderIPStack

        public RoomStats(int totalDuration,int txBitrate, int rxBitrate, int txBytes, int rxBytes,
                         int txAudioBytes, int rxAudioBytes, int txVideoBytes, int rxVideoBytes,
                         int txAudioBitrate, int rxAudioBitrate, int txVideoBitrate, int rxVideoBitrate,
                         int lastmileDelay, int txPacketLossRate, int rxPacketLossRate, int serverIpType, int localIpStack) {
            this.totalDuration = totalDuration;
            this.txBitrate = txBitrate;
            this.rxBitrate = rxBitrate;
            this.txBytes = txBytes;
            this.rxBytes = rxBytes;
            this.txAudioBytes = txAudioBytes;
            this.rxAudioBytes = rxAudioBytes;
            this.txVideoBytes = txVideoBytes;
            this.rxVideoBytes = rxVideoBytes;
            this.txAudioBitrate = txAudioBitrate;
            this.rxAudioBitrate = rxAudioBitrate;
            this.txVideoBitrate = txVideoBitrate;
            this.rxVideoBitrate = rxVideoBitrate;
            this.lastmileDelay = lastmileDelay;
            this.txPacketLossRate = txPacketLossRate;
            this.rxPacketLossRate = rxPacketLossRate;
            this.serverIpType = serverIpType;
            this.localIpStack = localIpStack;
        }
    }

    public static class ThunderNetworkStateChange {
        private int status;

        public ThunderNetworkStateChange(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }
    }

    public static class ThunderPublishStreamToCdnStatus {
        private String url;
        private int errorCode;

        public ThunderPublishStreamToCdnStatus(String url, int errorCode) {
            this.url = url;
            this.errorCode = errorCode;
        }

        public String getUrl() {
            return url;
        }

        public int getErrorCode() {
            return errorCode;
        }
    }

    public static class ThunderUserJoined {
        private String uid;
        private int elapsedTime;

        public ThunderUserJoined(String uid, int elapsedTime) {
            this.uid = uid;
            this.elapsedTime = elapsedTime;
        }

        public String getUid() {
            return uid;
        }

        public int getElapsedTime() {
            return elapsedTime;
        }
    }

    public static class ThunderUserOffline {
        private String uid;
        private int reason;

        public ThunderUserOffline(String uid, int reason) {
            this.uid = uid;
            this.reason = reason;
        }

        public String getUid() {
            return uid;
        }

        public int getReason() {
            return reason;
        }
    }

    public static class ThunderNetworkQuality {
        private String uid;
        private int txQuality;
        private int rxQuality;

        public ThunderNetworkQuality(String uid, int txQuality, int rxQuality) {
            this.uid = uid;
            this.txQuality = txQuality;
            this.rxQuality = rxQuality;
        }

        public String getUid() {
            return uid;
        }

        public int getTxQuality() {
            return txQuality;
        }

        public int getRxQuality() {
            return rxQuality;
        }
    }

    public static class ThunderAudioExtraInfo {
        private String uid;
        private byte[] extraInfo;

        public ThunderAudioExtraInfo(String uid, byte[] extraInfo) {
            this.uid = uid;
            this.extraInfo = extraInfo;
        }

        public String getUid() {
            return uid;
        }

        public byte[] getExtraInfo() {
            return extraInfo;
        }
    }

    public static class ThunderAudioExtraFailStatus {
        private int status;

        public ThunderAudioExtraFailStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }
    }

    public static class ThunderVideoExtraInfo {
        private String uid;
        private byte[] extraInfo;

        public ThunderVideoExtraInfo(String uid, byte[] extraInfo) {
            this.uid = uid;
            this.extraInfo = extraInfo;
        }

        public String getUid() {
            return uid;
        }

        public byte[] getExtraInfo() {
            return extraInfo;
        }
    }

    public static class ThunderMixVideoExtraInfo {
        private String mUid;
        private ArrayList<ThunderEventHandler.MixVideoInfo> mixVideoExtraInfos = new ArrayList<>();

        public ThunderMixVideoExtraInfo(String mUid, ArrayList<ThunderEventHandler.MixVideoInfo> mixExtraInfos) {
            this.mUid = mUid;
            this.mixVideoExtraInfos = mixExtraInfos;
        }

        public String getmUid() {
            return mUid;
        }

        public ArrayList<ThunderEventHandler.MixVideoInfo> getMixExtraInfos() {
            return mixVideoExtraInfos;
        }
    }

    public static class ThunderMixAudioExtraInfo {
        private String mUid;
        private ArrayList<ThunderEventHandler.MixAudioInfo> mixAudioExtraInfos = new ArrayList<>();

        public ThunderMixAudioExtraInfo(String mUid, ArrayList<ThunderEventHandler.MixAudioInfo> mixAudioExtraInfos) {
            this.mUid = mUid;
            this.mixAudioExtraInfos = mixAudioExtraInfos;
        }

        public String getmUid() {
            return mUid;
        }

        public ArrayList<ThunderEventHandler.MixAudioInfo> getMixAudioExtraInfos() {
            return mixAudioExtraInfos;
        }
    }

    public static class ThunderAudioCaptureStatus {
        private int mStatus;

        public ThunderAudioCaptureStatus(int status) {
            mStatus = status;
        }

        public int getStatus() {
            return mStatus;
        }

    }

    public static class ThunderVideoCaptureStatus {
        private int mStatus;

        public ThunderVideoCaptureStatus(int status) {
            mStatus = status;
        }

        public int getStatus() {
            return mStatus;
        }

    }

    public static class ThunderLocalVideoStats
    {
        private int mSendBitRate;
        private int mSendFrameRate;
        private int mRenderOutputFrameRate;
        private int mTargetBitRate;
        private int mTargetFrameRate;
        private int mQualityAdaptIndication;
        private int mEncoderOutputFrameRate;
        private int mEncodedBitrate;
        private int mEncodedFrameWidth;
        private int mEncodedFrameHeight;
        private int mEncodedFrameCount;
        private int mEncodedType;
        private int mCodecType;
        private int mConfigBitRate;
        private int mConfigFrameRate;
        private int mConfigWidth;
        private int mConfigHeight;

        public ThunderLocalVideoStats(int sendBitR, int sendFrameR, int renderOutFrameR, int targetBitR, int targetFrameR,
                                      int qulityAdapt, int encodeFrameR, int encodeBitR, int encodeWidth,
                               int encodeHeight, int encodedFrameCount, int encodedType, int codecType, int configBitRate,
                               int configFrameRate, int configWidth, int configHeight) {
            mSendBitRate = sendBitR;
            mSendFrameRate = sendFrameR;
            mRenderOutputFrameRate = renderOutFrameR;
            mTargetBitRate = targetBitR;
            mTargetFrameRate = targetFrameR;
            mQualityAdaptIndication = qulityAdapt;
            mEncoderOutputFrameRate = encodeFrameR;
            mEncodedBitrate = encodeBitR;
            mEncodedFrameWidth = encodeWidth;
            mEncodedFrameHeight = encodeHeight;
            mEncodedFrameCount = encodedFrameCount;
            mEncodedType = encodedType;
            mCodecType = codecType;
            mConfigBitRate = configBitRate;
            mConfigFrameRate = configFrameRate;
            mConfigWidth = configWidth;
            mConfigHeight = configHeight;
        }

        /**
         * 当前视频发送码率
         */
        public int getSendBitrate() {
            return mSendBitRate;
        }

        /**
         * 当前视频发送帧率
         */
        public int getSendFrameRate() {
            return mSendFrameRate;
        }

        /**
         * 本地预览输出帧率
         */
        public int getRenderOutputFrameRate() {
            return mRenderOutputFrameRate;
        }

        /**
         * 编码器目标码率
         */
        public int getTargetBitrate() {
            return mTargetBitRate;
        }

        /**
         * 编码器目标帧率
         */
        public int getTargetFrameRate() {
            return mTargetFrameRate;
        }

        /**
         * 视频发送帧数
         */
        public int getEncodedFrameCount() {
            return mEncodedFrameCount;
        }

        /**
         * 视频自适应情况
         */
        public int getQualityAdaptIndicat() {
            return mQualityAdaptIndication;
        }

        /**
         * 编码器输出帧率
         */
        public int getEncodeFrameRate() {
            return mEncoderOutputFrameRate;
        }

        /**
         * 单位kbps / 主播编码码率
         */
        public int getBitrate() {
            return mEncodedBitrate;
        }

        /**
         * 当前视频分辨率 - 宽
         */
        public int getWidth() {
            return mEncodedFrameWidth;
        }

        /**
         * 当前视频分辨率 - 高
         */
        public int getHeight() {
            return mEncodedFrameHeight;
        }

        /**
         * 编码形式
         */
        public int getEncodedType() {
            return mEncodedType;
        }

        /**
         * 当前视频编码类型
         */
        public int getCodec() {
            return mCodecType;
        }

        /**
         * 单位kbps / 视频开播码率
         */
        public int getConfigBitRate() {
            return mConfigBitRate;
        }

        /**
         * 视频开播帧率
         */
        public int getConfigFrameRate() {
            return mConfigFrameRate;
        }

        /**
         * 视频开播分辨率 - 宽
         */
        public int getConfigHeight() {
            return mConfigHeight;
        }

        /**
         * 视频开播分辨率 - 高
         */
        public int getConfigWidth() {
            return mConfigWidth;
        }
    }

    public static class ThunderLocalAudioStats {
        private int mEncodedBitrate;
        private int mNumChannels;
        private int mSendSampleRate;
        private int mSendBitrate;
        private int mEnableVad;

        public ThunderLocalAudioStats(int encodedBitrate, int channels, int sampleRate, int sendBitRate, int enableVad) {
            mEncodedBitrate = encodedBitrate;
            mNumChannels = channels;
            mSendSampleRate = sampleRate;
            mSendBitrate = sendBitRate;
            mEnableVad = enableVad;
        }

        /**
         * 编码类型
         */
        public int getEncodedBitrate() {
            return mEncodedBitrate;
        }


        /**
         * 声道数
         */
        public int getNumChannels() {
            return mNumChannels;
        }

        /**
         * 采样率
         */
        public int getSampleRate() {
            return mSendSampleRate;
        }

        /**
         * 发送码率
         */
        public int getSendBitRate() {
            return mSendBitrate;
        }

        /**
         * 发送的音频流采用vad，0：不开启；1：开启
         */
        public int getEnableVad() {
            return mEnableVad;
        }
    }

    public static class RemoteVideoStats
    {
        private String mUid;
        private int mDelay;
        private int mWidth;
        private int mHeight;
        private int mReceivedBitrate;
        private int mDecoderFrameRate;
        private int mRenderFrameRate;
        private int mPacketLossRate;
        private int mRxStreamType;
        private int mFrozenTime;
        private int mFrozenRate;
        private int mCodecType;
        private int mDecodedType;

        public RemoteVideoStats(String uid, int delay, int width, int height, int receivedBitrate,
                                int decoderFrameRate, int renderFrameRate, int packetLossRate,
                                int rxStreamType, int frozenTime, int frozenRate, int codecType,
                                int decodedType) {
            mUid = uid;
            mDelay = delay;
            mWidth = width;
            mHeight = height;
            mReceivedBitrate = receivedBitrate;
            mDecoderFrameRate = decoderFrameRate;
            mRenderFrameRate = renderFrameRate;
            mPacketLossRate = packetLossRate;
            mRxStreamType = rxStreamType;
            mFrozenTime = frozenTime;
            mFrozenRate = frozenRate;
            mCodecType = codecType;
            mDecodedType = decodedType;
        }

        /**
         * 远端用户id
         */
        public String getUid() {
            return mUid;
        }

        /**
         * 远端视频推流到播放的延时
         */
        public int getDelay() {
            return mDelay;
        }

        /**
         * 远端视频宽
         */
        public int getWidth() {
            return mWidth;
        }

        /**
         * 远端视频高
         */
        public int getHeight() {
            return mHeight;
        }

        /**
         * 接收码率，单位为Kbps
         */
        public int getReceivedBitrate() {
            return mReceivedBitrate;
        }

        /**
         * 远端视频解码器的输出帧率，单位为fps
         */
        public int getDecoderFrameRate() {
            return mDecoderFrameRate;
        }

        /**
         * 远端视频渲染器的输出帧率，单位为fps
         */
        public int getRenderFrameRate() {
            return mRenderFrameRate;
        }

        /**
         * 远端视频在网络对抗之后的丢包率(%)
         */
        public int getPacketLossRate() { return mPacketLossRate; }

        /**
         * 视频流类型，大流或小流
         */
        public int getRxStreamType() {
            return mRxStreamType;
        }

        /**
         * 远端用户在加入频道后发生视频卡顿的累计时长(ms)
         */
        public int getFrozenTime() { return mFrozenTime; }

        /**
         * 远端用户在加入频道后发生视频卡顿的累计时长占视频总有效时长的百分比(%)
         */
        public int getFrozenRate() { return mFrozenRate; }

        /**
         * 编码类型，h264/h265/vp8
         */
        public int getCodecType() { return mCodecType; }

        /**
         * 解码形式，软解/硬解
         */
        public int getDecodedType() { return mDecodedType; }
    }

    public static class RemoteAudioStats
    {
        private String mUid;
        private int mQuality;
        private int mNetworkTransportDelay;
        private int mJitterBufferDelay;
        private int mTotalDelay;
        private int mFrameLossRate;
        private int mNumChannels;
        private int mReceivedSampleRate;
        private int mReceivedBitrate;
        private int mFrozenTime;
        private int mFrozenRate;

        public RemoteAudioStats(String uid, int quality, int networkTransportDelay, int jitterBufferDelay, int totalDelay,
                                int frameLossRate, int numChannels, int receivedSampleRate, int receivedBitrate,
                                int frozenTime, int frozenRate) {
            mUid = uid;
            mQuality = quality;
            mNetworkTransportDelay = networkTransportDelay;
            mJitterBufferDelay = jitterBufferDelay;
            mTotalDelay = totalDelay;
            mFrameLossRate = frameLossRate;
            mNumChannels = numChannels;
            mReceivedSampleRate = receivedSampleRate;
            mReceivedBitrate = receivedBitrate;
            mFrozenTime = frozenTime;
            mFrozenRate = frozenRate;
        }

        /**
         * 远端用户id
         */
        public String getUid() {
            return mUid;
        }

        /**
         * 远端用户发送的音频流质量
         */
        public int getQuality() {
            return mQuality;
        }

        /**
         * 音频发送端到接收端的网络延迟
         */
        public int getNetworkTransportDelay() { return mNetworkTransportDelay; }

        /**
         * 主播采集音频到观众播放的总延迟
         */
        public int getTotalDelay() {
            return mTotalDelay;
        }

        /**
         * 接收端到网络抖动缓冲的延迟
         */
        public int getJitterBufferDelay() {
            return mJitterBufferDelay;
        }

        /**
         * 远端音频流的丢帧率（%）
         */
        public int getFrameLossRate() { return mFrameLossRate; }

        /**
         * 声道数
         */
        public int getNumChannels() { return mNumChannels; }

        /**
         * 远端音频的采样率（Hz）
         */
        public int getReceivedSampleRate() {
            return mReceivedSampleRate;
        }

        /**
         * 统计周期内远端音频的平均码率
         */
        public int getReceivedBitrate() { return mReceivedBitrate; }

        /**
         * 远端用户加入频道后发生音频卡顿的累计时长（ms）
         */
        public int getFrozenTime() {
            return mFrozenTime;
        }

        /**
         * 远端用户加入频道后发生音频卡顿的累计时长占音频总有效时长的百分比（%）
         */
        public int getFrozenRate() { return mFrozenRate; }
    }

    /**
     * 远端音频流状态信息
     */
    public static class ThunderRemoteAudioStateChanged {
        private String uid;
        private int state;
        private int reason;
        private int elapsedTime;

        public ThunderRemoteAudioStateChanged(String uid, int state, int reason, int elapsedTime) {
            this.uid = uid;
            this.state = state;
            this.reason = reason;
            this.elapsedTime = elapsedTime;
        }

        public String getUid() {
            return uid;
        }

        public int getState() {
            return state;
        }

        public int getReason() {
            return reason;
        }

        public int getElapsedTime() {
            return elapsedTime;
        }
    }

    /**
     * 远端视频流状态信息
     */
    public static class ThunderRemoteVideoStateChanged {
        private String mUid;
        private int mState;
        private int mReason;
        private int mElapsedTime;

        public ThunderRemoteVideoStateChanged(String uid, int state, int reason, int elapsedTime) {
            this.mUid = uid;
            this.mState = state;
            this.mReason = reason;
            this.mElapsedTime = elapsedTime;
        }

        public String getUid() {
            return mUid;
        }

        public int getState() {
            return mState;
        }

        public int getReason() {
            return mReason;
        }

        public int getElapsedTime() {
            return mElapsedTime;
        }
    }

    /**
     * 私有回调
     */
    public static class ThunderPrivateCallBack{
        private int mKey;
        private String mJsonStr;

        public ThunderPrivateCallBack(int key, String jsonStr)
        {
            this.mKey = key;
            this.mJsonStr = jsonStr;
        }

        public int getmKey() {
            return mKey;
        }

        public String getmJsonStr() {
            return mJsonStr;
        }
    }

    public static class ThunderRemoteAudioPlay {
        private String uid;
        private int elapsedTime;

        public ThunderRemoteAudioPlay(String uid, int elapsedTime) {
            this.uid = uid;
            this.elapsedTime = elapsedTime;
        }

        public String getUid() {
            return uid;
        }

        public int getElapsedTime() {
            return elapsedTime;
        }
    }

    public static class LocalAudioStatusChanged {
        private int mStaus;
        private int mErrorReason;


        public LocalAudioStatusChanged(int staus, int errorReason) {
            mStaus = staus;
            mErrorReason = errorReason;
        }

        /**
         * 本地音频状态
         */
        public int getLocalAudioStreamStatus() {
            return mStaus;
        }

        /**
         * 当音频状态为THUNDER_LOCAL_AUDIO_STREAM_STATUS_FAILED时，通过errorReason错误码检索具体原因
         */
        public int getLocalAudioStreamErrorReason() {
            return mErrorReason;
        }
    }

    public static class LocalAudioPublishStatus {
        private int mStaus;


        public LocalAudioPublishStatus(int staus) {
            mStaus = staus;
        }

        /**
         * 本地音频开/停播状态
         */
        public int getLocalAudioPublishStatus() {
            return mStaus;
        }
    }

    public static class LocalVideoStatusChanged {
        private int mStatus;
        private int mError;


        public LocalVideoStatusChanged(int status, int error) {
            mStatus = status;
            mError = error;
        }

        /**
         * 本地视频状态
         */
        public int getLocalVideoStreamStatus() {
            return mStatus;
        }

        /**
         * 当视频状态为THUNDER_LOCAL_VIDEO_STREAM_STATUS_FAILED时，通过error错误码检索具体原因
         */
        public int getLocalVideoStreamError() {
            return mError;
        }
    }

    public static class LocalVideoPublishStatus {
        private int mStatus;


        public LocalVideoPublishStatus(int status) {
            mStatus = status;
        }

        /**
         * 本地视频开/停播状态
         */
        public int getLocalVideoPublishStatus() {
            return mStatus;
        }
    }

    public static class ThunderDeviceStats {
        private double cpuTotalUsage;
        private double cpuAppUsage;
        private double memoryAppUsage;
        private double memoryTotalUsage;


        public ThunderDeviceStats(double cpuTotalUsage, double cpuAppUsage, double memoryTotalUsage, double memoryAppUsage) {
            this.cpuTotalUsage = cpuTotalUsage;
            this.cpuAppUsage = cpuAppUsage;
            this.memoryTotalUsage = memoryTotalUsage;
            this.memoryAppUsage = memoryAppUsage;
        }

        /**
         * 当前系统的 CPU 使用率(%)
         */
        public double getCpuTotalUsage() {
            return cpuTotalUsage;
        }

        /**
         * 当前App的 CPU 使用率(%)
         */
        public double getCpuAppUsage() {
            return cpuAppUsage;
        }

        /**
         * 当前 App 的内存占比 (%)
         */
        public double getMemoryAppUsage() {
            return memoryAppUsage;
        }

        /**
         * 当前系统的内存占比 (%)
         */
        public double getMemoryTotalUsage() {
            return memoryTotalUsage;
        }
    }

    public static class ThunderAudioRouteChanged {
        private int routing;
        public ThunderAudioRouteChanged(int routing) {
            this.routing = routing;

        }

        /**
         * 当前语音路由的设备
         */
        public int getRouting() {
            return routing;
        }
    }

    public static class ThunderUserRoleChanged {
        private int mOldRole;
        private int mNewRole;


        public ThunderUserRoleChanged(int oldRole, int newRole) {
            mOldRole = oldRole;
            mNewRole = newRole;
        }

        /**
         * 切换前角色
         */
        public int getOldRole() {
            return mOldRole;
        }

        /**
         * 切换后角色
         */
        public int getNewRole() {
            return mNewRole;
        }
    }

    public static class ThunderHowlingDetectResult {
        private boolean value;
        public ThunderHowlingDetectResult(boolean value) {
            this.value = value;
        }

        /**
         * 漏回声检测结果
         */
        public boolean getValue() {
            return value;
        }
    }

    public static class ThunderEchoDetectResult {
        private boolean value;
        public ThunderEchoDetectResult(boolean value) {
            this.value = value;

        }

        /**
         * 漏回声检测结果
         */
        public boolean getValue() {
            return value;
        }
    }

    public static class ThunderAudioInputDeviceTestVolume {
        private int volume;
        public ThunderAudioInputDeviceTestVolume(int volume) {
            this.volume = volume;
        }

        /**
         * 采集音量回调
         */
        public int getVolume() {
            return volume;
        }
    }

    public static class ThunderAudioOutputDeviceTestVolume {
        private int volume;
        public ThunderAudioOutputDeviceTestVolume(int volume) {
            this.volume = volume;
        }

        /**
         * 播放音量回调
         */
        public int getVolume() {
            return volume;
        }
    }

    public static class ThunderAudioRecordState {
        private int errorCode;
        private int duration;
        public ThunderAudioRecordState(int errorCode, int duration) {
            this.errorCode = errorCode;
            this.duration = duration;
        }

        /**
         * 音频录音的错误状态
         */
        public int getErrorCode() {
            return errorCode;
        }

        /**
         * 音频录音时长
         */
        public int getDuration() {
            return duration;
        }
    }

    public static class ThunderLocalSpeakingState {
        private int state;

        public ThunderLocalSpeakingState(int state) {
            this.state = state;
        }

        /**
         * 说话状态
         */
        public int getState() {
            return state;
        }
    }

    public static class ThunderRemoteVideoTransId {
        private String roomId;
        private String uid;
        private ArrayList<ThunderRtcVideoTransParam> params;
        public ThunderRemoteVideoTransId(String roomId,
                                         String uid,
                                         ArrayList<ThunderRtcVideoTransParam> params) {
            this.roomId = roomId;
            this.uid = uid;
            this.params = params;
        }

        public String getRoomId() {
            return roomId;
        }

        public String getUid() {
            return uid;
        }

        public ArrayList<ThunderRtcVideoTransParam> getParams() {
            return params;
        }
    }

    public static class ThunderSetSubscribeVideoTransIdResult {
        private String uid;
        private int bizTransId;
        private int realTransId;
        public ThunderSetSubscribeVideoTransIdResult(String uid, int bizTransId, int realTransId) {
            this.uid = uid;
            this.bizTransId = bizTransId;
            this.realTransId = realTransId;
        }

        public String getUid() {
            return uid;
        }

        public int getBizTransId() {
            return bizTransId;
        }

        public int getRealTransId() {
            return realTransId;
        }
    }

    public static class ThunderSwitchVideoTransIdResult {
        private String uid;
        private int dstTransId;
        private int currTransId;
        private int status;
        public ThunderSwitchVideoTransIdResult(String uid,
                                               int dstTransId,
                                               int currTransId,
                                               int status) {
            this.uid = uid;
            this.dstTransId = dstTransId;
            this.currTransId = currTransId;
            this.status = status;
        }

        public String getUid() {
            return uid;
        }

        public int getDstTransId() {
            return dstTransId;
        }

        public int getCurrTransId() {
            return currTransId;
        }

        public int getStatus() {
            return status;
        }
    }
}
