/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import java.io.IOException;
import java.io.OutputStream;

public class RpcRshOutputStream
extends OutputStream {
    public static final String TRACE_PREFIX = "RpcRshOutputStream";
    private OutputStream rshStream = null;
    private ServerStats stats = null;

    public RpcRshOutputStream(OutputStream outputstream, ServerStats stats) {
        if (outputstream == null) {
            throw new NullPointerError("null RPC outputstream passed to RpcRshOutputStream constructor");
        }
        this.stats = stats;
        this.rshStream = outputstream;
    }

    public void write(int b) throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null rsh stream in RpcRshOutputStream.write()");
        }
        this.rshStream.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null rsh stream in RpcRshOutputStream.write()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcRshOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)bytes.length) {
            this.stats.largestSend.set(bytes.length);
        }
        this.rshStream.write(bytes);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null rsh stream in RpcRshOutputStream.write()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcRshOutputStream.write()");
        }
        if (this.stats != null && this.stats.largestSend.get() < (long)len) {
            this.stats.largestSend.set(len);
        }
        this.rshStream.write(bytes, offset, len);
    }

    public void flush() throws IOException {
        this.rshStream.flush();
    }

    public void close() throws IOException {
        this.rshStream.close();
    }

    public String toString() {
        return "RpcRshOutputStream[" + this.rshStream + ']';
    }

    protected OutputStream getRshStream() {
        return this.rshStream;
    }

    protected void setRshStream(OutputStream rshStream) {
        this.rshStream = rshStream;
    }
}

