/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelistSummary
extends ServerResource
implements IChangelistSummary {
    protected static final String CHANGE_KEY = "Change";
    protected static final String NEW_KEY = "new";
    protected static final String CLIENT_KEY = "Client";
    protected static final String USER_KEY = "User";
    protected static final String STATUS_KEY = "Status";
    protected static final String DATE_KEY = "Date";
    protected static final String DESCRIPTION_KEY = "Description";
    protected static final String JOBS_KEY = "Jobs";
    protected static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected int id = -1;
    protected String clientId = null;
    protected String username = null;
    protected ChangelistStatus status = null;
    protected Date date = null;
    protected String description = null;
    protected boolean shelved = false;
    protected IChangelistSummary.Visibility visibility = null;

    public ChangelistSummary() {
    }

    public ChangelistSummary(boolean complete, boolean completable, boolean refreshable, boolean updateable, IServer server) {
        super(refreshable, updateable, server);
    }

    public ChangelistSummary(int id, String clientId, String username, ChangelistStatus status, Date date, String description, boolean shelved) {
        this.id = id;
        this.clientId = clientId;
        this.username = username;
        this.status = status;
        this.date = date;
        this.description = description;
        this.shelved = shelved;
    }

    public ChangelistSummary(IChangelistSummary summary) {
        if (summary != null) {
            this.id = summary.getId();
            this.clientId = summary.getClientId();
            this.username = summary.getUsername();
            this.status = summary.getStatus();
            this.date = summary.getDate();
            this.description = summary.getDescription();
            this.shelved = summary.isShelved();
        }
    }

    public ChangelistSummary(Map<String, Object> map, boolean summaryOnly) {
        this(map, summaryOnly, null);
    }

    public ChangelistSummary(Map<String, Object> map, boolean summaryOnly, IServer server) {
        if (map != null) {
            if (summaryOnly) {
                try {
                    this.id = new Integer((String)map.get("change"));
                    this.clientId = (String)map.get("client");
                    this.username = (String)map.get("user");
                    this.status = ChangelistStatus.fromString((String)map.get("status"));
                    this.date = (String)map.get("time") == null ? null : new Date(Long.parseLong((String)map.get("time")) * 1000L);
                    this.description = (String)map.get("desc");
                    this.shelved = map.containsKey("shelved");
                    if (map.containsKey("changeType")) {
                        this.visibility = IChangelistSummary.Visibility.fromString(((String)map.get("changeType")).toUpperCase());
                    }
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in ChangelistSummary constructor: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            } else {
                this.server = server;
                this.refreshable = true;
                this.updateable = true;
                try {
                    String idString = (String)map.get(CHANGE_KEY);
                    if (idString != null && idString.equalsIgnoreCase(NEW_KEY)) {
                        this.id = 0;
                    } else {
                        try {
                            this.id = new Integer(idString);
                        }
                        catch (Exception exc) {
                            Log.exception(exc);
                            this.id = -1;
                        }
                    }
                    this.clientId = (String)map.get(CLIENT_KEY);
                    this.username = (String)map.get(USER_KEY);
                    this.status = ChangelistStatus.fromString((String)map.get(STATUS_KEY));
                    String dateStr = (String)map.get(DATE_KEY);
                    if (dateStr == null) {
                        this.date = new Date();
                    } else {
                        try {
                            this.date = new SimpleDateFormat(DATE_FORMAT).parse(dateStr);
                        }
                        catch (ParseException pe) {
                            Log.error("Date parse error in Changelist constructor: " + pe.getLocalizedMessage());
                        }
                    }
                    this.description = (String)map.get(DESCRIPTION_KEY);
                    if (map.containsKey("Type")) {
                        this.visibility = IChangelistSummary.Visibility.fromString(((String)map.get("Type")).toUpperCase());
                    }
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in ChangelistSummary constructor: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public ChangelistStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ChangelistStatus status) {
        this.status = status;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String setDescription(String description) {
        String oldDesc = this.description;
        this.description = description;
        return oldDesc;
    }

    @Override
    public boolean isShelved() {
        return this.shelved;
    }

    @Override
    public void setShelved(boolean shelved) {
        this.shelved = shelved;
    }

    @Override
    public IChangelistSummary.Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(IChangelistSummary.Visibility visibility) {
        this.visibility = visibility;
    }
}

