/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.palantir.javaformat.java.FormatterService;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.gradle.api.artifacts.Configuration;

public class JavaFormatExtension {
    private final Configuration configuration;
    private final Supplier<FormatterService> memoizedService;

    public JavaFormatExtension(Configuration configuration) {
        this.configuration = configuration;
        this.memoizedService = Suppliers.memoize(this::serviceLoadInternal);
    }

    public FormatterService serviceLoad() {
        return this.memoizedService.get();
    }

    private FormatterService serviceLoadInternal() {
        URL[] jarUris = (URL[])this.configuration.getFiles().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to convert URI to URL: " + file, e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(jarUris, FormatterService.class.getClassLoader());
        return (FormatterService)Iterables.getOnlyElement(ServiceLoader.load(FormatterService.class, classLoader));
    }
}

