/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.javaformat.java.FormatterService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.gradle.api.artifacts.Configuration;

public final class PalantirJavaFormatStep {
    private static final String IMPL_CLASS = "com.palantir.javaformat.java.Formatter";
    private static final String NAME = "palantir-java-format";

    private PalantirJavaFormatStep() {
    }

    public static FormatterStep create(Configuration palantirJavaFormat, JavaFormatExtension extension) {
        PalantirJavaFormatStep.ensureImplementationNotDirectlyLoadable();
        Supplier memoizedService = Suppliers.memoize(extension::serviceLoad);
        return FormatterStep.createLazy((String)NAME, () -> PalantirJavaFormatStep.lambda$create$0(palantirJavaFormat, (java.util.function.Supplier)memoizedService), State::createFormat);
    }

    private static void ensureImplementationNotDirectlyLoadable() {
        try {
            PalantirJavaFormatStep.class.getClassLoader().loadClass(IMPL_CLASS);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        throw new RuntimeException("Expected not be be able to load com.palantir.javaformat.java.Formatter via main class loader but was able to. Please ensure that `buildscript.configurations.classpath` doesn't depend on `com.palantir.javaformat:palantir-java-format`.");
    }

    private static /* synthetic */ State lambda$create$0(Configuration palantirJavaFormat, java.util.function.Supplier memoizedService) throws Exception {
        return new State(palantirJavaFormat.getFiles(), memoizedService);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String stepName = "palantir-java-format";
        private final FileSignature jarsSignature;
        private final transient java.util.function.Supplier<FormatterService> memoizedFormatter;

        State(Iterable<File> jars, java.util.function.Supplier<FormatterService> memoizedFormatter) throws IOException {
            this.jarsSignature = FileSignature.signAsSet(jars);
            this.memoizedFormatter = memoizedFormatter;
        }

        FormatterFunc createFormat() {
            return arg_0 -> ((FormatterService)this.memoizedFormatter.get()).formatSourceReflowStringsAndFixImports(arg_0);
        }
    }
}

