/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.collect.Iterables;
import com.palantir.javaformat.java.FormatterService;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import org.gradle.api.artifacts.Configuration;

public class JavaFormatExtension {
    private final Configuration configuration;

    public JavaFormatExtension(Configuration configuration) {
        this.configuration = configuration;
    }

    public FormatterService serviceLoad() {
        URL[] jarUris = (URL[])this.configuration.getFiles().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to convert URI to URL: " + file, e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(jarUris, FormatterService.class.getClassLoader());
        return (FormatterService)Iterables.getOnlyElement(ServiceLoader.load(FormatterService.class, classLoader));
    }
}

