/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.FailuresReportGenerator;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.JunitReportCreator;
import com.palantir.gradle.junit.TaskTimer;
import com.palantir.gradle.junit.Tasks;
import com.palantir.gradle.junit.XmlUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import javax.xml.transform.TransformerException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;

public class JunitReportsFinalizer
extends DefaultTask {
    private Task styleTask;
    private TaskTimer taskTimer;
    private FailuresSupplier failuresSupplier;
    private final RegularFileProperty targetFile = this.getProject().getObjects().fileProperty();
    private final DirectoryProperty reportDir = this.getProject().getObjects().directoryProperty();

    public static void registerFinalizer(Task task, TaskTimer timer, FailuresSupplier failuresSupplier, Provider<Directory> reportDir) {
        JunitReportsFinalizer finalizer = Tasks.createTask(task.getProject().getTasks(), task.getName() + "CircleFinalizer", JunitReportsFinalizer.class);
        if (finalizer == null) {
            return;
        }
        finalizer.setStyleTask(task);
        finalizer.setTaskTimer(timer);
        finalizer.setFailuresSupplier(failuresSupplier);
        finalizer.getTargetFile().set(reportDir.map(dir -> dir.file(task.getProject().getName() + "-" + task.getName() + ".xml")));
        finalizer.getReportDir().set(reportDir);
        task.finalizedBy(new Object[]{finalizer});
    }

    @Inject
    public JunitReportsFinalizer() {
    }

    @Input
    public final Task getStyleTask() {
        return this.styleTask;
    }

    public final void setStyleTask(Task styleTask) {
        this.styleTask = styleTask;
    }

    @Input
    public final TaskTimer getTaskTimer() {
        return this.taskTimer;
    }

    public final void setTaskTimer(TaskTimer taskTimer) {
        this.taskTimer = taskTimer;
    }

    @Input
    public final FailuresSupplier getFailuresSupplier() {
        return this.failuresSupplier;
    }

    public final void setFailuresSupplier(FailuresSupplier failuresSupplier) {
        this.failuresSupplier = failuresSupplier;
    }

    @Input
    public final RegularFileProperty getTargetFile() {
        return this.targetFile;
    }

    @Input
    public final DirectoryProperty getReportDir() {
        return this.reportDir;
    }

    @TaskAction
    public final void createCircleReport() throws IOException, TransformerException {
        if (!this.styleTask.getDidWork()) {
            this.setDidWork(false);
            return;
        }
        try {
            File rootDir = this.getProject().getRootProject().getProjectDir();
            String projectName = this.getProject().getName();
            List<Failure> failures = this.failuresSupplier.getFailures();
            long taskTimeNanos = this.taskTimer.getTaskTimeNanos(this.styleTask);
            Document report = JunitReportCreator.reportToXml(FailuresReportGenerator.failuresReport(rootDir, projectName, this.styleTask.getName(), taskTimeNanos, failures));
            File target = (File)this.targetFile.getAsFile().get();
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(target.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                XmlUtils.write(writer, report);
            }
        }
        catch (RuntimeException e) {
            RuntimeException modified;
            try {
                modified = this.failuresSupplier.handleInternalFailure(((File)this.reportDir.getAsFile().get()).toPath(), e);
            }
            catch (RuntimeException x) {
                e.addSuppressed(x);
                throw e;
            }
            throw modified;
        }
    }
}

