/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import org.immutables.value.Value;

@BugPattern(name="ImmutablesStyleCollision", linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", severity=BugPattern.SeverityLevel.ERROR, summary="Immutables @Value.Style inline annotation should not be present alongside a Style meta-annotation, as there is no Style merging. You should either modify the meta-annotation, or add the meta-annotation's fields to your inline @Value.Style declaration.")
public final class ImmutablesStyleCollision
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> INLINE_STYLE_ANNOTATION = Matchers.hasAnnotation(Value.Style.class);
    private static final Matcher<ClassTree> STYLE_META_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasAnnotation(Value.Style.class));
    private static final Matcher<ClassTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{INLINE_STYLE_ANNOTATION, STYLE_META_ANNOTATION});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

