/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(name="ExtendsErrorOrThrowable", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.ERROR, summary="Class should not extend Error or Throwable directly. While allowed by java it can lead to surprising behaviour if users end up catching Error or Throwable.")
public final class ExtendsErrorOrThrowable
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> IS_ERROR_SUBCLASS = Matchers.isSubtypeOf(Error.class);
    private static final Matcher<Tree> IS_THROWABLE = Matchers.isSameType(Throwable.class);
    private static final Matcher<Tree> IS_ERROR_OR_THROWABLE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType(Error.class), Matchers.isSameType(Throwable.class)});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.CLASS) {
            return Description.NO_MATCH;
        }
        if (!IS_ERROR_SUBCLASS.matches((Tree)tree, state) && !IS_THROWABLE.matches(tree.getExtendsClause(), state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix(ExtendsErrorOrThrowable.buildFix(tree, state)).build();
    }

    private static Optional<SuggestedFix> buildFix(ClassTree tree, VisitorState state) {
        if (IS_ERROR_OR_THROWABLE.matches(tree.getExtendsClause(), state)) {
            Type exceptionType = (Type)Suppliers.typeFromClass(RuntimeException.class).get(state);
            String prettyExceptionType = SuggestedFixes.prettyType((Type)exceptionType, (VisitorState)state);
            return Optional.of(SuggestedFix.replace((Tree)tree.getExtendsClause(), (String)prettyExceptionType));
        }
        return Optional.empty();
    }
}

