/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.concurrent.ExecutorService;

@BugPattern(name="ExecutorSubmitRunnableFutureIgnored", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.ERROR, summary="Uncaught exceptions from ExecutorService.submit are not logged by the uncaught exception handler because it is assumed that the returned future is used to watch for failures.\nWhen the returned future is ignored, using ExecutorService.execute is preferred because failures are recorded.")
public final class ExecutorSubmitRunnableFutureIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf(ExecutorService.class.getName()).named("submit").withParameters(new String[]{Runnable.class.getName()});

    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description description = super.matchMethodInvocation(methodInvocationTree, state);
        if (Description.NO_MATCH.equals(description)) {
            return description;
        }
        return this.buildDescription(methodInvocationTree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)methodInvocationTree, (String)"execute", (VisitorState)state)).build();
    }
}

