/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="DangerousThrowableMessageSafeArg", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="It is unsafe to create a SafeArg of Throwable.getMessage, SafeLoggable.getLogMessage may be used.")
public final class DangerousThrowableMessageSafeArg
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> SAFEARG_FACTORY_METHOD = MethodMatchers.staticMethod().onClass("com.palantir.logsafe.SafeArg").named("of").withParameters(new String[]{String.class.getName(), Object.class.getName()});
    private static final Matcher<ExpressionTree> THROWABLE_MESSAGE_METHOD = MethodMatchers.instanceMethod().onDescendantOf(Throwable.class.getName()).named("getMessage");
    private static final Matcher<ExpressionTree> THROWABLE_MATCHER = MoreMatchers.isSubtypeOf(Throwable.class);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SAFEARG_FACTORY_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        ExpressionTree safeValueArgument = args.get(1);
        if (THROWABLE_MESSAGE_METHOD.matches((Tree)safeValueArgument, state)) {
            return this.buildDescription(tree).setMessage("Do not use throwable messages as SafeArg values. SafeLoggable.getLogMessage is guaranteed to be safe.").build();
        }
        if (THROWABLE_MATCHER.matches((Tree)safeValueArgument, state)) {
            return this.buildDescription(tree).setMessage("Do not use throwables as SafeArg values. Throwables must be logged without an Arg wrapper as the last parameter, otherwise unsafe data may be leaked from the unsafe message or the unsafe message of a cause.").build();
        }
        return Description.NO_MATCH;
    }
}

