/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import javax.annotation.Nullable;

@BugPattern(name="BracesRequired", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING, summary="Braces are required for readability")
public final class BracesRequired
extends BugChecker
implements BugChecker.DoWhileLoopTreeMatcher,
BugChecker.ForLoopTreeMatcher,
BugChecker.EnhancedForLoopTreeMatcher,
BugChecker.IfTreeMatcher,
BugChecker.WhileLoopTreeMatcher {
    public Description matchIf(IfTree tree, VisitorState state) {
        this.check(tree.getThenStatement(), state);
        StatementTree elseStatement = tree.getElseStatement();
        if (elseStatement != null && elseStatement.getKind() != Tree.Kind.IF) {
            this.check(elseStatement, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchDoWhileLoop(DoWhileLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchForLoop(ForLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    private void check(@Nullable StatementTree tree, VisitorState state) {
        if (tree != null && tree.getKind() != Tree.Kind.BLOCK && tree.getKind() != Tree.Kind.EMPTY_STATEMENT) {
            state.reportMatch(this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)("{" + state.getSourceForNode((Tree)tree) + "}"))).build());
        }
    }
}

