package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;

import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;

import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;

import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

public class RPCSendBroadcast extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCSendBroadcast";

    public RPCSendBroadcast(long roomId,
                            String content,
                            RichCompletion completion) {
        this.roomId = roomId;
        this.content = content;
        this.completion = completion;
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_SendBroadcastReq req = new ChatRoomProto.PCS_SendBroadcastReq();
        req.appKey = Uint32.toUInt(HMRContext.getAppId());
        req.roomId = Uint32.toUInt(roomId);
        req.uid  = Uint64.toUInt(HMR.getMe().getId());
        req.content = this.content;

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    @Override
    public String getFunctionName() {
        return "SendBroadcast";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_auther";
    }


    private final long roomId;
    private final String content;
    private final RichCompletion completion;
}
