/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.subtle.RewindableReadableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

final class ReadableByteChannelDecrypter
implements ReadableByteChannel {
    @GuardedBy(value="this")
    boolean attemptedMatching = false;
    @GuardedBy(value="this")
    ReadableByteChannel matchingChannel = null;
    @GuardedBy(value="this")
    RewindableReadableByteChannel ciphertextChannel;
    PrimitiveSet<StreamingAead> primitives;
    byte[] associatedData;

    public ReadableByteChannelDecrypter(PrimitiveSet<StreamingAead> primitives, ReadableByteChannel ciphertextChannel, byte[] associatedData) {
        this.primitives = primitives;
        this.ciphertextChannel = new RewindableReadableByteChannel(ciphertextChannel);
        this.associatedData = (byte[])associatedData.clone();
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (dst.remaining() == 0) {
            return 0;
        }
        if (this.matchingChannel != null) {
            return this.matchingChannel.read(dst);
        }
        if (this.attemptedMatching) {
            throw new IOException("No matching key found for the ciphertext in the stream.");
        }
        this.attemptedMatching = true;
        List<PrimitiveSet.Entry<StreamingAead>> entries = this.primitives.getRawPrimitives();
        for (PrimitiveSet.Entry<StreamingAead> entry : entries) {
            try {
                ReadableByteChannel attemptedChannel = entry.getPrimitive().newDecryptingChannel(this.ciphertextChannel, this.associatedData);
                int retValue = attemptedChannel.read(dst);
                if (retValue > 0) {
                    this.matchingChannel = attemptedChannel;
                    this.ciphertextChannel.disableRewinding();
                } else if (retValue == 0) {
                    this.ciphertextChannel.rewind();
                    this.attemptedMatching = false;
                }
                return retValue;
            }
            catch (IOException e) {
                this.ciphertextChannel.rewind();
            }
            catch (GeneralSecurityException e) {
                this.ciphertextChannel.rewind();
            }
        }
        throw new IOException("No matching key found for the ciphertext in the stream.");
    }

    @Override
    public synchronized void close() throws IOException {
        this.ciphertextChannel.close();
    }

    @Override
    public synchronized boolean isOpen() {
        return this.ciphertextChannel.isOpen();
    }
}

