/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.subtle.Base64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonKeysetWriter
implements KeysetWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final OutputStream outputStream;

    private JsonKeysetWriter(OutputStream stream) {
        this.outputStream = stream;
    }

    public static KeysetWriter withOutputStream(OutputStream stream) {
        return new JsonKeysetWriter(stream);
    }

    public static KeysetWriter withFile(File file) throws IOException {
        return new JsonKeysetWriter(new FileOutputStream(file));
    }

    public static KeysetWriter withPath(String path) throws IOException {
        return JsonKeysetWriter.withFile(new File(path));
    }

    public static KeysetWriter withPath(Path path) throws IOException {
        return JsonKeysetWriter.withFile(path.toFile());
    }

    @Override
    public void write(Keyset keyset) throws IOException {
        try {
            this.outputStream.write(this.toJson(keyset).toString(4).getBytes(UTF_8));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        finally {
            this.outputStream.close();
        }
    }

    @Override
    public void write(EncryptedKeyset keyset) throws IOException {
        try {
            this.outputStream.write(this.toJson(keyset).toString(4).getBytes(UTF_8));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        finally {
            this.outputStream.close();
        }
    }

    private long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private JSONObject toJson(Keyset keyset) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("primaryKeyId", this.toUnsignedLong(keyset.getPrimaryKeyId()));
        JSONArray keys = new JSONArray();
        for (Keyset.Key key : keyset.getKeyList()) {
            keys.put((Object)this.toJson(key));
        }
        json.put("key", (Object)keys);
        return json;
    }

    private JSONObject toJson(Keyset.Key key) throws JSONException {
        return new JSONObject().put("keyData", (Object)this.toJson(key.getKeyData())).put("status", (Object)key.getStatus().name()).put("keyId", this.toUnsignedLong(key.getKeyId())).put("outputPrefixType", (Object)key.getOutputPrefixType().name());
    }

    private JSONObject toJson(KeyData keyData) throws JSONException {
        return new JSONObject().put("typeUrl", (Object)keyData.getTypeUrl()).put("value", (Object)Base64.encode(keyData.getValue().toByteArray())).put("keyMaterialType", (Object)keyData.getKeyMaterialType().name());
    }

    private JSONObject toJson(EncryptedKeyset keyset) throws JSONException {
        return new JSONObject().put("encryptedKeyset", (Object)Base64.encode(keyset.getEncryptedKeyset().toByteArray())).put("keysetInfo", (Object)this.toJson(keyset.getKeysetInfo()));
    }

    private JSONObject toJson(KeysetInfo keysetInfo) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("primaryKeyId", this.toUnsignedLong(keysetInfo.getPrimaryKeyId()));
        JSONArray keyInfos = new JSONArray();
        for (KeysetInfo.KeyInfo keyInfo : keysetInfo.getKeyInfoList()) {
            keyInfos.put((Object)this.toJson(keyInfo));
        }
        json.put("keyInfo", (Object)keyInfos);
        return json;
    }

    private JSONObject toJson(KeysetInfo.KeyInfo keyInfo) throws JSONException {
        return new JSONObject().put("typeUrl", (Object)keyInfo.getTypeUrl()).put("status", (Object)keyInfo.getStatus().name()).put("keyId", keyInfo.getKeyId()).put("outputPrefixType", (Object)keyInfo.getOutputPrefixType().name());
    }
}

