/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp.login;

import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.duowan.hago.party.api.HagoParty;
import com.duowan.hago.party.api.login.callback.ILoginCallback;
import com.duowan.hago.party.imp.R;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.account.AccountModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoginChecker {
    public static final String LOGIN_TAG = "HagoParty_Login";
    private static boolean showDialog = true;
    private static DialogLinkManager dialogLinkManager;
    private static boolean sIsLoginChecking;
    private static boolean sCanceledByUser;

    public static void ensureLogin(final Context activity, final Runnable callbackCommand) {
        if (AccountModel.getInstance().getAccountInfo().uuid > 0L) {
            callbackCommand.run();
        } else if (!sIsLoginChecking) {
            LoginChecker.mackCheckStart(activity);
            MLog.error((Object)LOGIN_TAG, (String)"need login first!", (Object[])new Object[0]);
            HagoParty.INSTANCE.login().onLoginIn("", new ILoginCallback(){

                public void onSuccess(@NotNull String authorizationCode) {
                    long uid = -1L;
                    if (AccountModel.getInstance().getAccountInfo() != null) {
                        uid = AccountModel.getInstance().getAccountInfo().uuid;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LoginChecker.LOGIN_TAG, (String)"login success with authorizationCode:, account:%s", (Object[])new Object[]{authorizationCode, String.valueOf(uid)});
                    }
                    if (!sCanceledByUser) {
                        callbackCommand.run();
                    }
                    LoginChecker.markCheckEnd();
                }

                public void onFail(int errCode, @Nullable String msg) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LoginChecker.LOGIN_TAG, (String)"login fail:%d, msg:%s!", (Object[])new Object[]{errCode, msg});
                    }
                    LoginChecker.markCheckEnd();
                    Toast.makeText((Context)activity, (CharSequence)ResourceUtils.getString((int)R.string.login_error), (int)0).show();
                }
            });
        } else {
            MLog.error((Object)LOGIN_TAG, (String)"is LoginChecking, not handle this request!", (Object[])new Object[0]);
        }
    }

    private static void mackCheckStart(Context activity) {
        sIsLoginChecking = true;
        if (showDialog) {
            dialogLinkManager = new DialogLinkManager(activity);
            ProgressDialog dialog = new ProgressDialog("", true, true, null, new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)LoginChecker.LOGIN_TAG, (String)"check login cancel by user!", (Object[])new Object[0]);
                    }
                    sCanceledByUser = true;
                }
            });
            dialogLinkManager.showDialog((BaseDialog)dialog);
        }
    }

    private static void markCheckEnd() {
        sIsLoginChecking = false;
        sCanceledByUser = false;
        if (dialogLinkManager != null && dialogLinkManager.isDialogShowing()) {
            dialogLinkManager.dismissDialog();
            dialogLinkManager = null;
        }
    }

    static {
        sIsLoginChecking = false;
        sCanceledByUser = false;
    }
}

