/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.plugins.micup.R;

public class StepProgressView
extends YYView {
    private int mColor;
    private int mProgressHeight;
    private int mBarTextColor;
    private int mBarTextSize;
    private int mBarRadius;
    private int mBarWidth;
    private int mTextPaddingHor;
    private int mTextPaddingVer;
    private int mProgressLeftTopRaduis;
    private int mMaxValue;
    private int mValue;
    private RectF mBarRectF = new RectF();
    private Paint mMainPaint;
    private Paint mTextPaint;
    private Paint mMaskPaint;
    private Bitmap mMaskBitmap;
    private Bitmap mSrcBitmap;
    private Canvas mSrcCanvas;

    public StepProgressView(Context context) {
        super(context);
        this.initPaint();
    }

    public StepProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.StepProgressView);
        this.mColor = ta.getColor(R.styleable.StepProgressView_step_color, -1);
        this.mProgressHeight = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_progress_height, ResolutionUtils.dip2Px((float)3.0f));
        this.mBarTextColor = ta.getColor(R.styleable.StepProgressView_step_bar_textColor, Color.parseColor((String)"#008aff"));
        this.mBarTextSize = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_bar_textSize, ResolutionUtils.spToPx((float)10.0f));
        this.mBarRadius = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_bar_radius, ResolutionUtils.dip2Px((float)2.0f));
        this.mBarWidth = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_bar_width, 0);
        this.mTextPaddingHor = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_bar_textPaddingHor, 0);
        this.mTextPaddingVer = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_bar_textPaddingVer, 0);
        this.mMaxValue = ta.getInteger(R.styleable.StepProgressView_step_maxValue, 10);
        this.mValue = ta.getInteger(R.styleable.StepProgressView_step_value, 0);
        this.mProgressLeftTopRaduis = ta.getDimensionPixelSize(R.styleable.StepProgressView_step_progrese_left_top_radius, 0);
        ta.recycle();
        this.initPaint();
    }

    public void setMaxValue(int value) {
        this.mMaxValue = value;
        this.invalidate();
    }

    public void setValue(int value) {
        this.mValue = value;
        this.invalidate();
    }

    private void initPaint() {
        this.mMainPaint = new Paint();
        this.mMainPaint.setAntiAlias(true);
        this.mMainPaint.setColor(this.mColor);
        this.mMainPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.mBarTextColor);
        this.mTextPaint.setTextSize((float)this.mBarTextSize);
        this.mTextPaint.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setFilterBitmap(false);
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public void invalidate() {
        this.mMaskBitmap = null;
        this.mSrcCanvas = null;
        this.mSrcBitmap = null;
        super.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getMeasuredWidth() <= 0 || this.getMeasuredHeight() <= 0) {
            return;
        }
        this.resetSrcBitmap();
        int progressWidth = this.getMeasuredWidth() * this.mValue / this.mMaxValue;
        int progressTop = (this.getMeasuredHeight() - this.mProgressHeight) / 2;
        this.mSrcCanvas.drawRect(0.0f, (float)progressTop, (float)progressWidth, (float)(progressTop + this.mProgressHeight), this.mMainPaint);
        String barString = this.getBarString();
        int textWidth = (int)this.mTextPaint.measureText(barString);
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        int textHeight = (int)(fontMetrics.descent - fontMetrics.ascent);
        int barWidth = this.mBarWidth > 0 ? this.mBarWidth : textWidth + this.mTextPaddingHor * 2;
        int barHeight = textHeight + this.mTextPaddingVer * 2;
        int barStart = progressWidth - barWidth / 2;
        if (barStart < 0) {
            barStart = 0;
        } else if (barStart + barWidth > this.getMeasuredWidth()) {
            barStart = this.getMeasuredWidth() - barWidth;
        }
        int barTop = (this.getMeasuredHeight() - barHeight) / 2;
        this.mBarRectF.left = barStart;
        this.mBarRectF.top = barTop;
        this.mBarRectF.right = barWidth + barStart;
        this.mBarRectF.bottom = barHeight + barTop;
        this.mSrcCanvas.drawRoundRect(this.mBarRectF, (float)this.mBarRadius, (float)this.mBarRadius, this.mMainPaint);
        int textX = barStart + barWidth / 2 - textWidth / 2;
        int textY = (int)((float)(this.getMeasuredHeight() / 2) + (Math.abs(fontMetrics.ascent) - fontMetrics.descent) / 2.0f);
        this.mSrcCanvas.drawText(barString, (float)textX, (float)textY, this.mTextPaint);
        this.mSrcCanvas.drawBitmap(this.getMaskBitmap(), 0.0f, (float)progressTop, this.mMaskPaint);
        canvas.drawBitmap(this.mSrcBitmap, 0.0f, 0.0f, null);
    }

    private void resetSrcBitmap() {
        if (this.mSrcBitmap == null || this.mSrcCanvas == null) {
            this.mSrcBitmap = BitmapUtils.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mSrcCanvas = new Canvas(this.mSrcBitmap);
        } else {
            this.mSrcCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    private Bitmap getMaskBitmap() {
        if (this.mMaskBitmap == null) {
            int maskWidth = this.getMeasuredWidth() + this.mProgressLeftTopRaduis;
            int maskHeight = this.getMeasuredHeight() + this.mProgressLeftTopRaduis;
            Bitmap maskBitmap = BitmapUtils.createBitmap((int)maskWidth, (int)maskHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskBitmapCanvas = new Canvas(maskBitmap);
            Paint maskBitmapPaint = new Paint();
            maskBitmapPaint.setAntiAlias(true);
            maskBitmapPaint.setStyle(Paint.Style.FILL);
            maskBitmapPaint.setColor(-16777216);
            maskBitmapCanvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)maskWidth, (float)maskHeight), (float)this.mProgressLeftTopRaduis, (float)this.mProgressLeftTopRaduis, maskBitmapPaint);
            this.mMaskBitmap = maskBitmap;
        }
        return this.mMaskBitmap;
    }

    private String getBarString() {
        return StringUtils.format((String)"%d/%d", (Object[])new Object[]{this.mValue, this.mMaxValue});
    }
}

