/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import androidx.annotation.NonNull;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.result.MicUpRepository;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import java.util.ArrayList;
import java.util.List;

public final class MicUpViewMode
extends ViewModel
implements ISharePage {
    private static final int HEADER_COUNT = 3;
    private final MicUpRepository mMicUpRepository;
    private MutableLiveData<Boolean> isAudienceLiveData = new MutableLiveData();
    private MutableLiveData<ResultInfo> mMyResultInfoLiveData = new MutableLiveData();
    private MutableLiveData<List<ResultInfo>> mResultInfoLiveData = new MutableLiveData();
    private MutableLiveData<List<ResultInfo>> mAudienceHeaderLiveData = new MutableLiveData();
    private MutableLiveData<List<ResultInfo>> mAudienceRankLiveData = new MutableLiveData();
    private MutableLiveData<List<BaseShareChannel>> mShareChannelLiveData = new MutableLiveData();

    public MicUpViewMode() {
        FeatureLog.i((String)"FTMicUpResult", (String)"invoke MicUpViewMode construct\u3002", (Object[])new Object[0]);
        this.mMicUpRepository = new MicUpRepository();
    }

    public MutableLiveData<Boolean> isAudience() {
        return this.isAudienceLiveData;
    }

    public void isAudience(boolean isAudience) {
        this.isAudienceLiveData.setValue((Object)isAudience);
    }

    public void fetchData(@NonNull String roomId, int term) {
        FeatureLog.i((String)"FTMicUpResult", (String)"fetch data roomId: %s,term: %s", (Object[])new Object[]{roomId, term});
        this.mMicUpRepository.fetchResult(roomId, term, new MicUpRepository.OnResultCallback(){

            @Override
            public void onSuccess(List<ResultInfo> data) {
                FeatureLog.i((String)"FTMicUpResult", (String)"fetch data on success: %s", (Object[])new Object[]{data});
                if (((Boolean)MicUpViewMode.this.isAudienceLiveData.getValue()).booleanValue()) {
                    ArrayList<ResultInfo> header = new ArrayList<ResultInfo>();
                    ArrayList<ResultInfo> others = new ArrayList<ResultInfo>();
                    for (int i = 0; i < data.size(); ++i) {
                        if (i < 3) {
                            header.add(data.get(i));
                            continue;
                        }
                        others.add(data.get(i));
                    }
                    MicUpViewMode.this.mAudienceHeaderLiveData.setValue(header);
                    MicUpViewMode.this.mAudienceRankLiveData.setValue(others);
                } else {
                    for (ResultInfo resultInfo : data) {
                        if (resultInfo.uid != AccountUtil.getUid()) continue;
                        MicUpViewMode.this.mMyResultInfoLiveData.setValue((Object)resultInfo);
                        break;
                    }
                }
                MicUpViewMode.this.mResultInfoLiveData.setValue(data);
            }

            @Override
            public void onFail() {
                FeatureLog.e((String)"FTMicUpResult", (String)"fetch result error", (Object[])new Object[0]);
            }
        });
    }

    public MutableLiveData<ResultInfo> getMyResultInfo() {
        return this.mMyResultInfoLiveData;
    }

    public MutableLiveData<List<ResultInfo>> getResultInfoLiveData() {
        return this.mResultInfoLiveData;
    }

    public MutableLiveData<List<ResultInfo>> getAudienceHeaderLiveData() {
        return this.mAudienceHeaderLiveData;
    }

    public MutableLiveData<List<ResultInfo>> getAudienceRankLiveData() {
        return this.mAudienceRankLiveData;
    }

    public MutableLiveData<List<BaseShareChannel>> getShareChannelLiveData() {
        this.loadShareConfig();
        return this.mShareChannelLiveData;
    }

    private void loadShareConfig() {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class) != null) {
            IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
            List shareChannelList = shareService.getChannelsByPage((ISharePage)this);
            this.mShareChannelLiveData.setValue((Object)shareChannelList);
        }
    }

    public String getPageName() {
        return "mic_up_result_page";
    }

    public boolean isCloseBtnInBottom() {
        return true;
    }
}

