/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.leadsing;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.channel.plugins.micup.panel.leadsing.BaseMicUpLeadSingView;
import com.yy.hiyo.channel.plugins.micup.panel.widget.MicUpHeartView;
import com.yy.hiyo.channel.plugins.micup.panel.widget.MicUpPanelCircleView;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MicUpLeadSingView
extends BaseMicUpLeadSingView
implements View.OnClickListener,
IMicUpView {
    private MicUpUICallback mUICallback;
    private CountDownTimer mCountDownTimer;
    private CircleImageView mAvatarView;
    private YYTextView mSongNameView;
    private RecycleImageView mCopyRightView;
    private YYTextView mSingerNameView;
    private MicUpHeartView mMicUpHeartView;
    private YYTextView mFirstLyricView;
    private YYTextView mSecondLyricView;
    private MicUpPanelCircleView mFunctionView;
    private int mTotalWaitTime = 7000;
    private static final int ANIMATION_INTERVAL = 100;
    private boolean mDelayedShowProgress = false;

    public MicUpLeadSingView(Context context, MicUpUICallback uiCallback) {
        this(context, null, uiCallback);
    }

    public MicUpLeadSingView(Context context, AttributeSet attrs, MicUpUICallback uiCallback) {
        this(context, attrs, 0, uiCallback);
    }

    public MicUpLeadSingView(Context context, AttributeSet attrs, int defStyleAttr, MicUpUICallback uiCallback) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundResource(R.drawable.bg_mic_up_incomplete_panel);
        this.mUICallback = uiCallback;
    }

    @Override
    protected void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_mic_up_lead_sing_channel, (ViewGroup)this);
        this.mAvatarView = (CircleImageView)this.findViewById(R.id.iv_avatar);
        this.mSongNameView = (YYTextView)this.findViewById(R.id.tv_song_name);
        this.mCopyRightView = (RecycleImageView)this.findViewById(R.id.iv_copyright);
        this.mSingerNameView = (YYTextView)this.findViewById(R.id.tv_singer_name);
        this.mMicUpHeartView = (MicUpHeartView)this.findViewById(R.id.view_life_container);
        RecycleImageView rulesView = (RecycleImageView)this.findViewById(R.id.iv_rules);
        this.mFirstLyricView = (YYTextView)this.findViewById(R.id.tv_first_lyric);
        this.mSecondLyricView = (YYTextView)this.findViewById(R.id.tv_second_lyric);
        this.mFunctionView = (MicUpPanelCircleView)this.findViewById(R.id.iv_function);
        rulesView.setOnClickListener((View.OnClickListener)this);
        this.mCopyRightView.setOnClickListener((View.OnClickListener)this);
        this.mFunctionView.setOnClickListener(this);
        this.mFunctionView.setClickable(false);
    }

    @UiThread
    public void updateSongInfo(@NonNull SongInfo songInfo) {
        if (songInfo == null) {
            FeatureLog.e((String)"FTMicUpPanel", (String)"updateSongInfo songInfo == null.", (Object[])new Object[0]);
            return;
        }
        int duration = songInfo.duration * 1000;
        if (duration > 0) {
            this.mTotalWaitTime = duration;
        }
        ImageLoader.loadImage((ImageView)this.mAvatarView, (String)songInfo.avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
        this.mSongNameView.setText((CharSequence)songInfo.musicName);
        this.mSingerNameView.setText((CharSequence)songInfo.singer);
        this.mFirstLyricView.setText((CharSequence)"");
        this.mSecondLyricView.setText((CharSequence)"");
        List<String> preLyrics = songInfo.preLyric;
        if (FP.empty(preLyrics)) {
            return;
        }
        int size = preLyrics.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                String firstLyric = preLyrics.get(0);
                this.mFirstLyricView.setText((CharSequence)firstLyric);
                continue;
            }
            if (i != 1) break;
            String secondLyric = preLyrics.get(1);
            this.mSecondLyricView.setText((CharSequence)secondLyric);
        }
    }

    @UiThread
    public void updateLeftLifeValue(int leftLifeValue) {
        this.mMicUpHeartView.setLeftLifeValue(leftLifeValue);
        if (leftLifeValue <= 0) {
            this.mDelayedShowProgress = true;
            this.updateLeadSingStatus(2, 0);
        } else {
            this.updateLeadSingStatus(0, 0);
        }
    }

    @UiThread
    public void updateLeadSingStatus(int status, int progress) {
        if (status == 0) {
            this.mFunctionView.updateBackground(0);
            this.mFunctionView.setTag(0);
            this.mFunctionView.setClickable(false);
            this.mFunctionView.setProgressVisibility(false);
            this.mFunctionView.playSvga(() -> this.updateLeadSingStatus(1, 0));
        } else if (status == 1) {
            if (this.mUICallback == null || this.mUICallback.getState() != 1) {
                return;
            }
            this.mFunctionView.setTag(1);
            this.showGetTip();
            this.mFunctionView.setClickable(true);
            this.mFunctionView.updateBackground(R.drawable.icon_mic_up_get);
            this.startWaitGetSongTimer();
        } else if (status == 2) {
            this.mFunctionView.setTag(2);
            this.mFunctionView.updateBackground(R.drawable.icon_mic_up_out);
            this.mFunctionView.setClickable(false);
            if (this.mDelayedShowProgress) {
                this.mFunctionView.setProgressVisibility(false);
                this.postDelayed(this::startWaitGetSongTimer, 3000L);
                this.mDelayedShowProgress = false;
            } else {
                this.startWaitGetSongTimer();
            }
        }
    }

    private void startWaitGetSongTimer() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        this.mCountDownTimer = new CountDownTimer(this.mTotalWaitTime + 50, 100L){

            public void onTick(long millisUntilFinished) {
                if (MicUpLeadSingView.this.mFunctionView != null) {
                    MicUpLeadSingView.this.mFunctionView.setProgressVisibility(true);
                    int progress = (int)((long)MicUpLeadSingView.this.mTotalWaitTime - millisUntilFinished);
                    MicUpLeadSingView.this.mFunctionView.updateProgress(progress, MicUpLeadSingView.this.mTotalWaitTime);
                }
            }

            public void onFinish() {
                MicUpLeadSingView.this.hidePopWindow();
            }
        }.start();
    }

    private void showGetTip() {
        boolean needShow = SettingFlags.getBoolean((String)"key_micup_first_play_get_guide", (boolean)true);
        if (needShow) {
            this.showHorizontalPopWindow((View)this.mFunctionView, R.string.short_tips_tap_get);
        }
    }

    @UiThread
    public void setMaxRound(int maxRound) {
        this.setMaxProgress(maxRound);
    }

    @UiThread
    public void setCurrentRound(int current) {
        this.setProgress(current);
    }

    @SuppressLint(value={"MissingPermission"})
    private void startVibrator() {
        Vibrator vibrator = SystemServiceUtils.getVibrator((Context)this.getContext());
        if (vibrator != null) {
            long duration = 200L;
            if (Build.VERSION.SDK_INT >= 26) {
                vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
            } else {
                vibrator.vibrate(duration);
            }
        }
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.iv_copyright) {
            this.showVerticalPopWindow((View)this.mCopyRightView, R.string.tips_mic_up_copy_right);
        } else if (viewId == R.id.iv_rules) {
            if (this.mUICallback != null) {
                this.mUICallback.onGameRuleClick();
            }
        } else if (viewId == R.id.iv_function) {
            int tag;
            if (this.mFunctionView != null && (tag = ((Integer)this.mFunctionView.getTag()).intValue()) == 1) {
                this.startVibrator();
                this.mFunctionView.setClickable(false);
            }
            if (this.mUICallback != null) {
                this.mUICallback.onGetClick();
            }
        }
    }

    @UiThread
    public void enableClickGet() {
        if (this.mFunctionView != null) {
            this.mFunctionView.setClickable(true);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        this.mDelayedShowProgress = false;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.hidePopWindow();
        super.onDetachedFromWindow();
    }
}

