/*
 * Decompiled with CFR 0.152.
 */
package com.yy.location.inner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.text.TextUtils;
import androidx.annotation.RequiresPermission;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.location.ILocationChangedListener;
import com.yy.location.ILocationServiceFactory;
import com.yy.location.LocationAbnormalCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import com.yy.location.inner.LocationCallback;
import com.yy.location.inner.LocationHandler;
import com.yy.location.inner.LocationServiceAdapter;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 F2\u00020\u0001:\u0001FB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u000eJ\b\u0010&\u001a\u00020$H\u0002J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u000eH\u0002J\b\u0010(\u001a\u00020$H\u0002J\u0012\u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0002J\u0006\u0010+\u001a\u00020$J\b\u0010,\u001a\u00020$H\u0002J\u0010\u0010-\u001a\u0004\u0018\u00010\u00122\u0006\u0010.\u001a\u00020\bJ\b\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u00020$2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0012\u00104\u001a\u00020$2\b\u00102\u001a\u0004\u0018\u000103H\u0002J \u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020$H\u0007J\u0006\u0010<\u001a\u00020\bJ\u0006\u0010=\u001a\u00020$J\u0012\u0010=\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010>\u001a\u00020$H\u0002J\b\u0010?\u001a\u00020$H\u0002J\u0006\u0010@\u001a\u00020$J\u0010\u0010A\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\nJ\b\u0010D\u001a\u00020$H\u0003J\u0012\u0010E\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001b\u0010\u0017R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/yy/location/inner/LocationHandler;", "", "mContext", "Landroid/content/Context;", "locationFactory", "Lcom/yy/location/ILocationServiceFactory;", "(Landroid/content/Context;Lcom/yy/location/ILocationServiceFactory;)V", "isLocationFailedWithoutPermission", "", "mAbnormalCallback", "Lcom/yy/location/LocationAbnormalCallback;", "mChangedListener", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/lang/ref/SoftReference;", "Lcom/yy/location/ILocationChangedListener;", "mLocationCallback", "Lcom/yy/location/inner/LocationCallback;", "mLocationInfo", "Lcom/yy/location/LocationInfo;", "mLocationInfoCache", "mLocationServiceAdapter", "Lcom/yy/location/inner/LocationServiceAdapter;", "getMLocationServiceAdapter", "()Lcom/yy/location/inner/LocationServiceAdapter;", "mLocationServiceAdapter$delegate", "Lkotlin/Lazy;", "mNativeLocationServiceAdapter", "getMNativeLocationServiceAdapter", "mNativeLocationServiceAdapter$delegate", "mStartLocationTime", "", "mStartRunnable", "Ljava/lang/Runnable;", "nativeLocationCallback", "timeoutRunnable", "addLocationListener", "", "listener", "checkAndReport", "checkListener", "checkLocationInfo", "checkLocationInfoValid", "info", "clearCache", "destroyLocation", "getLocationInfo", "lastCache", "getLocationPath", "", "handleLocationCallBack", "location", "Landroid/location/Location;", "handleLocationCallBackInner", "inflateCity", "latitude", "", "longitude", "locationBuilder", "Lcom/yy/location/LocationInfo$Builder;", "initAndStart", "isLocationFailed", "notifyCacheLocation", "notifyLocationChanged", "readFromFile", "release", "removeLocationListener", "setAbnormalCallback", "abnormalCallback", "startLocation", "writeToFile", "Companion", "location_debug"})
public final class LocationHandler {
    private final Lazy mLocationServiceAdapter$delegate;
    private final Lazy mNativeLocationServiceAdapter$delegate;
    private final ConcurrentLinkedQueue<SoftReference<ILocationChangedListener>> mChangedListener;
    private LocationInfo mLocationInfo;
    private LocationInfo mLocationInfoCache;
    private boolean isLocationFailedWithoutPermission;
    private long mStartLocationTime;
    private LocationAbnormalCallback mAbnormalCallback;
    private final Runnable timeoutRunnable;
    private final LocationCallback nativeLocationCallback;
    private final LocationCallback mLocationCallback;
    @SuppressLint(value={"MissingPermission"})
    private final Runnable mStartRunnable;
    private final Context mContext;
    private final ILocationServiceFactory locationFactory;
    @NotNull
    public static final String TAG = "LocationHandler";
    public static final long CACHE_VALID_TIME = 172800000L;
    public static final int RETRY_INTERVAL = 20000;
    public static final long TIMEOUT_THRESHOLD = 15000L;
    public static final Companion Companion = new Companion(null);

    private final LocationServiceAdapter getMLocationServiceAdapter() {
        Lazy lazy = this.mLocationServiceAdapter$delegate;
        LocationHandler locationHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocationServiceAdapter)lazy.getValue();
    }

    private final LocationServiceAdapter getMNativeLocationServiceAdapter() {
        Lazy lazy = this.mNativeLocationServiceAdapter$delegate;
        LocationHandler locationHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocationServiceAdapter)lazy.getValue();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void initAndStart() {
        this.startLocation();
        this.mStartLocationTime = System.currentTimeMillis();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    private final void startLocation() {
        YYTaskExecutor.removeTask((Runnable)this.mStartRunnable);
        this.getMLocationServiceAdapter().startRequest(this.mLocationCallback);
        YYTaskExecutor.execute((Runnable)this.timeoutRunnable, (long)15000L);
    }

    private final void handleLocationCallBackInner(Location location) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(this, location){
                final /* synthetic */ LocationHandler this$0;
                final /* synthetic */ Location $location;

                public final void run() {
                    LocationHandler.access$handleLocationCallBack(this.this$0, this.$location);
                }
                {
                    this.this$0 = locationHandler;
                    this.$location = location;
                }
            });
        } else {
            this.handleLocationCallBack(location);
        }
    }

    private final void handleLocationCallBack(Location location) {
        boolean success = false;
        if (location != null) {
            LocationInfo.Builder locationBuilder;
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"my location: %s", (Object[])new Object[]{location});
            } else {
                MLog.info((Object)TAG, (String)"my location: lat:%s, lng:%s", (Object[])new Object[]{location.getLatitude(), location.getLongitude()});
            }
            double latitude = location.getLatitude();
            double longtitude = location.getLongitude();
            if (RuntimeContext.sIsDebuggable) {
                List mLocationArray;
                String string = SettingFlags.getStringValue((String)"wemeet_lgd_lat");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SettingFlags.getStringVa\u2026EMEET_LONGITUDE_LATITUDE)");
                String strLgdLat = string;
                if (!TextUtils.isEmpty((CharSequence)strLgdLat) && (mLocationArray = StringsKt.split$default((CharSequence)strLgdLat, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)).size() == 2) {
                    String strLgd = (String)mLocationArray.get(0);
                    String strlat = (String)mLocationArray.get(1);
                    if (!TextUtils.isEmpty((CharSequence)strlat) && !TextUtils.isEmpty((CharSequence)strlat)) {
                        longtitude = StringUtils.parseDouble((String)strLgd);
                        latitude = StringUtils.parseDouble((String)strlat);
                    }
                }
            }
            LocationInfo.Builder builder = locationBuilder = new LocationInfo.Builder().ofLatitude(latitude).ofLongitude(longtitude).ofSpeed(location.getSpeed()).ofAltitude(location.getAltitude()).ofBearing(location.getBearing()).ofTime(location.getTime());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"locationBuilder");
            this.inflateCity(latitude, longtitude, builder);
            this.isLocationFailedWithoutPermission = false;
            this.mLocationInfo = locationBuilder.build();
            this.checkAndReport();
            success = true;
        }
        if (!success) {
            this.isLocationFailedWithoutPermission = true;
            MLog.warn((Object)TAG, (String)"location failed, isLocationFailedWithoutPermission", (Object[])new Object[0]);
            this.writeToFile(null);
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mStartRunnable);
            this.writeToFile(this.mLocationInfo);
            this.notifyLocationChanged();
        }
        this.destroyLocation();
    }

    private final void inflateCity(double latitude, double longitude, LocationInfo.Builder locationBuilder) {
        try {
            Geocoder geocoder = new Geocoder(this.mContext, Locale.getDefault());
            List addressList = geocoder.getFromLocation(latitude, longitude, 1);
            List list = addressList;
            if (list != null && (list = (Address)CollectionsKt.firstOrNull((List)list)) != null) {
                List list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                List $this$apply = list2;
                boolean bl3 = false;
                locationBuilder.ofCity($this$apply.getLocality()).ofGeocoderCity($this$apply.getLocality());
                locationBuilder.ofProvince($this$apply.getAdminArea());
                locationBuilder.ofCountry($this$apply.getCountryName()).ofGeocoderCountry($this$apply.getCountryName());
                locationBuilder.ofAdCode($this$apply.getPostalCode());
                locationBuilder.ofAddress($this$apply.getFeatureName());
                MLog.info((Object)TAG, (String)("getGeocoderCity " + $this$apply.getLocality() + ' ' + $this$apply.getCountryName()), (Object[])new Object[0]);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)"geocoder.getFromLocation() error", (Object[])new Object[0]);
        }
    }

    private final void notifyLocationChanged() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ LocationHandler this$0;

            public final void run() {
                for (SoftReference sListener : LocationHandler.access$getMChangedListener$p(this.this$0)) {
                    ILocationChangedListener listener;
                    if (sListener.get() == null) continue;
                    ILocationChangedListener iLocationChangedListener = listener = (ILocationChangedListener)sListener.get();
                    if (iLocationChangedListener == null) continue;
                    iLocationChangedListener.onLocationChanged(LocationHandler.access$getMLocationInfo$p(this.this$0), false);
                }
            }
            {
                this.this$0 = locationHandler;
            }
        });
    }

    public final void notifyCacheLocation() {
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ LocationHandler this$0;

            public final void run() {
                LocationHandler.access$notifyCacheLocation(this.this$0, this.this$0.getLocationInfo(true));
            }
            {
                this.this$0 = locationHandler;
            }
        });
    }

    @Nullable
    public final LocationInfo getLocationInfo(boolean lastCache) {
        if (this.mLocationInfo == null) {
            this.checkLocationInfo();
        }
        if (this.mLocationInfo != null) {
            return this.mLocationInfo;
        }
        if (lastCache) {
            return this.mLocationInfoCache;
        }
        return null;
    }

    private final void checkLocationInfo() {
        boolean permission = LocationHelper.checkLocationPermission();
        if (permission && this.mLocationInfo == null) {
            YYTaskExecutor.removeTask((Runnable)this.mStartRunnable);
            long l = System.currentTimeMillis() - this.mStartLocationTime;
            boolean bl = false;
            long gap = Math.abs(l);
            long delay = (long)20000 - gap;
            delay = delay < 0L ? 0L : delay;
            YYTaskExecutor.execute((Runnable)this.mStartRunnable, (long)delay);
        }
    }

    private final String getLocationPath() {
        File file = YYFileUtils.getConfigDir((String)"location");
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"YYFileUtils.getConfigDir(\"location\")");
        String dir = file.getAbsolutePath();
        return dir + File.separator + "location_info.txt";
    }

    public final void clearCache() {
        this.mLocationInfo = null;
        if (this.mLocationInfoCache != null) {
            this.mLocationInfoCache = null;
            this.writeToFile(null);
        }
    }

    private final void writeToFile(LocationInfo info) {
        YYTaskExecutor.execute((Runnable)new Runnable(this, info){
            final /* synthetic */ LocationHandler this$0;
            final /* synthetic */ LocationInfo $info;

            public final void run() {
                String path = LocationHandler.access$getLocationPath(this.this$0);
                JsonParser.writeJsonFile((String)path, (Object)this.$info, (Type)((Type)((Object)LocationInfo.class)));
            }
            {
                this.this$0 = locationHandler;
                this.$info = locationInfo;
            }
        });
    }

    private final void readFromFile() {
        if (this.mLocationInfoCache != null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ LocationHandler this$0;

            public final void run() {
                String path = LocationHandler.access$getLocationPath(this.this$0);
                File pathFile = new File(path);
                if (pathFile.exists()) {
                    LocationInfo info = (LocationInfo)JsonParser.parseJsonFile((String)path, (Type)((Type)((Object)LocationInfo.class)));
                    if (LocationHandler.access$checkLocationInfoValid(this.this$0, info)) {
                        LocationHandler.access$setMLocationInfoCache$p(this.this$0, info);
                        LocationHandler.access$notifyCacheLocation(this.this$0, LocationHandler.access$getMLocationInfoCache$p(this.this$0));
                    } else {
                        MLog.error((Object)"LocationHandler", (String)"read location from file failed.", (Object[])new Object[0]);
                    }
                }
            }
            {
                this.this$0 = locationHandler;
            }
        });
    }

    public final void addLocationListener(@Nullable ILocationChangedListener listener) {
        if (listener == null || this.checkListener(listener) != null) {
            return;
        }
        this.mChangedListener.add(new SoftReference<ILocationChangedListener>(listener));
    }

    public final void removeLocationListener(@Nullable ILocationChangedListener listener) {
        if (listener == null) {
            return;
        }
        SoftReference<ILocationChangedListener> sListener = this.checkListener(listener);
        this.mChangedListener.remove(sListener);
    }

    public final boolean isLocationFailed() {
        return this.isLocationFailedWithoutPermission;
    }

    private final SoftReference<ILocationChangedListener> checkListener(ILocationChangedListener listener) {
        Iterator<SoftReference<ILocationChangedListener>> iterator = this.mChangedListener.iterator();
        while (iterator.hasNext()) {
            SoftReference<ILocationChangedListener> sListener;
            SoftReference<ILocationChangedListener> softReference = sListener = iterator.next();
            ILocationChangedListener innerListener = softReference != null ? softReference.get() : null;
            if (innerListener != listener) continue;
            return sListener;
        }
        return null;
    }

    private final void notifyCacheLocation(LocationInfo info) {
        if (info == null) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"notifyCacheLocation info: %s", (Object[])new Object[]{info});
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, info){
            final /* synthetic */ LocationHandler this$0;
            final /* synthetic */ LocationInfo $info;

            public final void run() {
                for (SoftReference sListener : LocationHandler.access$getMChangedListener$p(this.this$0)) {
                    ILocationChangedListener listener;
                    if (sListener.get() == null) continue;
                    ILocationChangedListener iLocationChangedListener = listener = (ILocationChangedListener)sListener.get();
                    if (iLocationChangedListener == null) continue;
                    iLocationChangedListener.onLocationChanged(this.$info, true);
                }
            }
            {
                this.this$0 = locationHandler;
                this.$info = locationInfo;
            }
        });
    }

    private final boolean checkLocationInfoValid(LocationInfo info) {
        if (info == null) {
            return false;
        }
        long time = info.getTime();
        long cur = System.currentTimeMillis();
        long dif = cur - time;
        long l = dif;
        return 1L <= l && 172800000L > l;
    }

    private final void checkAndReport() {
        block1: {
            if (this.mLocationInfo == null || this.mLocationInfoCache == null || this.mAbnormalCallback == null) {
                return;
            }
            LocationAbnormalCallback locationAbnormalCallback = this.mAbnormalCallback;
            if (locationAbnormalCallback == null) break block1;
            locationAbnormalCallback.onLocationAbnormal(this.mLocationInfo, this.mLocationInfoCache);
        }
    }

    public final void setAbnormalCallback(@NotNull LocationAbnormalCallback abnormalCallback) {
        Intrinsics.checkParameterIsNotNull((Object)abnormalCallback, (String)"abnormalCallback");
        this.mAbnormalCallback = abnormalCallback;
        this.checkAndReport();
    }

    private final void destroyLocation() {
        this.getMLocationServiceAdapter().stopRequest(this.mLocationCallback);
    }

    public final void release() {
        YYTaskExecutor.removeTask((Runnable)this.timeoutRunnable);
        this.getMLocationServiceAdapter().stopRequest(this.mLocationCallback);
    }

    public LocationHandler(@NotNull Context mContext, @NotNull ILocationServiceFactory locationFactory) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)locationFactory, (String)"locationFactory");
        this.mContext = mContext;
        this.locationFactory = locationFactory;
        this.mLocationServiceAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocationServiceAdapter>(this){
            final /* synthetic */ LocationHandler this$0;

            @NotNull
            public final LocationServiceAdapter invoke() {
                return LocationHandler.access$getLocationFactory$p(this.this$0).createLocationService(1);
            }
            {
                this.this$0 = locationHandler;
                super(0);
            }
        }));
        this.mNativeLocationServiceAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocationServiceAdapter>(this){
            final /* synthetic */ LocationHandler this$0;

            @NotNull
            public final LocationServiceAdapter invoke() {
                return LocationHandler.access$getLocationFactory$p(this.this$0).createLocationService(2);
            }
            {
                this.this$0 = locationHandler;
                super(0);
            }
        }));
        this.mChangedListener = new ConcurrentLinkedQueue();
        this.timeoutRunnable = new Runnable(this){
            final /* synthetic */ LocationHandler this$0;

            public final void run() {
                LocationHandler.access$getMNativeLocationServiceAdapter$p(this.this$0).startRequest(LocationHandler.access$getNativeLocationCallback$p(this.this$0));
            }
            {
                this.this$0 = locationHandler;
            }
        };
        this.nativeLocationCallback = new LocationCallback(this){
            final /* synthetic */ LocationHandler this$0;

            public void onLocationAvailability(boolean availability) {
                MLog.info((Object)"LocationHandler", (String)("onLocationAvailability2: " + availability), (Object[])new Object[0]);
                YYTaskExecutor.removeTask((Runnable)LocationHandler.access$getTimeoutRunnable$p(this.this$0));
                MLog.info((Object)"LocationHandler", (String)"native location failed", (Object[])new Object[0]);
            }

            public void onLocationResult(@Nullable Location location) {
                block0: {
                    YYTaskExecutor.removeTask((Runnable)LocationHandler.access$getTimeoutRunnable$p(this.this$0));
                    Location location2 = location;
                    if (location2 == null) break block0;
                    Location location3 = location2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Location it = location3;
                    boolean bl3 = false;
                    MLog.info((Object)"LocationHandler", (String)"native location return", (Object[])new Object[0]);
                    LocationHandler.access$handleLocationCallBackInner(this.this$0, it);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mLocationCallback = new LocationCallback(this){
            final /* synthetic */ LocationHandler this$0;

            public void onLocationAvailability(boolean availability) {
                MLog.info((Object)"LocationHandler", (String)("onLocationAvailability: " + availability), (Object[])new Object[0]);
                if (!availability) {
                    try {
                        LocationHandler.access$handleLocationCallBackInner(this.this$0, LocationHandler.access$getMLocationServiceAdapter$p(this.this$0).getLatestLocation());
                    }
                    catch (Throwable e) {
                        MLog.error((Object)"LocationHandler", (Throwable)e);
                    }
                }
            }

            public void onLocationResult(@Nullable Location location) {
                block3: {
                    Object object;
                    block2: {
                        object = location;
                        if (object == null) break block2;
                        Location location2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Location it = location2;
                        boolean bl3 = false;
                        YYTaskExecutor.removeTask((Runnable)LocationHandler.access$getTimeoutRunnable$p(this.this$0));
                        MLog.info((Object)"LocationHandler", (String)("location: " + location), (Object[])new Object[0]);
                        LocationHandler.access$handleLocationCallBackInner(this.this$0, it);
                        object = location2;
                        if (object != null) break block3;
                    }
                    object = ((Function0)new Function0<Unit>(this){
                        final /* synthetic */ mLocationCallback.1 this$0;

                        public final void invoke() {
                            MLog.info((Object)"LocationHandler", (String)"no location!", (Object[])new Object[0]);
                            LocationHandler.access$handleLocationCallBackInner(this.this$0.this$0, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }).invoke();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mStartRunnable = new Runnable(this){
            final /* synthetic */ LocationHandler this$0;

            public final void run() {
                if (LocationHandler.access$getMLocationInfo$p(this.this$0) == null) {
                    this.this$0.initAndStart();
                }
            }
            {
                this.this$0 = locationHandler;
            }
        };
        this.readFromFile();
    }

    public static final /* synthetic */ void access$handleLocationCallBack(LocationHandler $this, Location location) {
        $this.handleLocationCallBack(location);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getMChangedListener$p(LocationHandler $this) {
        return $this.mChangedListener;
    }

    public static final /* synthetic */ LocationInfo access$getMLocationInfo$p(LocationHandler $this) {
        return $this.mLocationInfo;
    }

    public static final /* synthetic */ void access$setMLocationInfo$p(LocationHandler $this, LocationInfo locationInfo) {
        $this.mLocationInfo = locationInfo;
    }

    public static final /* synthetic */ void access$notifyCacheLocation(LocationHandler $this, LocationInfo info) {
        $this.notifyCacheLocation(info);
    }

    public static final /* synthetic */ String access$getLocationPath(LocationHandler $this) {
        return $this.getLocationPath();
    }

    public static final /* synthetic */ boolean access$checkLocationInfoValid(LocationHandler $this, LocationInfo info) {
        return $this.checkLocationInfoValid(info);
    }

    public static final /* synthetic */ LocationInfo access$getMLocationInfoCache$p(LocationHandler $this) {
        return $this.mLocationInfoCache;
    }

    public static final /* synthetic */ void access$setMLocationInfoCache$p(LocationHandler $this, LocationInfo locationInfo) {
        $this.mLocationInfoCache = locationInfo;
    }

    public static final /* synthetic */ ILocationServiceFactory access$getLocationFactory$p(LocationHandler $this) {
        return $this.locationFactory;
    }

    public static final /* synthetic */ LocationServiceAdapter access$getMNativeLocationServiceAdapter$p(LocationHandler $this) {
        return $this.getMNativeLocationServiceAdapter();
    }

    public static final /* synthetic */ LocationCallback access$getNativeLocationCallback$p(LocationHandler $this) {
        return $this.nativeLocationCallback;
    }

    public static final /* synthetic */ Runnable access$getTimeoutRunnable$p(LocationHandler $this) {
        return $this.timeoutRunnable;
    }

    public static final /* synthetic */ void access$handleLocationCallBackInner(LocationHandler $this, Location location) {
        $this.handleLocationCallBackInner(location);
    }

    public static final /* synthetic */ LocationServiceAdapter access$getMLocationServiceAdapter$p(LocationHandler $this) {
        return $this.getMLocationServiceAdapter();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/location/inner/LocationHandler$Companion;", "", "()V", "CACHE_VALID_TIME", "", "RETRY_INTERVAL", "", "TAG", "", "TIMEOUT_THRESHOLD", "location_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

