/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.service;

import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.KTVPopLevelInfo;
import com.yy.hiyo.channel.base.bean.KTVPopularityConfig;
import com.yy.hiyo.channel.base.bean.KTVPopularityData;
import com.yy.hiyo.channel.base.bean.KTVPopularityLevel;
import com.yy.hiyo.channel.base.bean.KTVRoomPopStageInfo;
import com.yy.hiyo.channel.base.bean.KtvPopularityLevelChange;
import com.yy.hiyo.channel.base.bean.KtvPopularitySingEnd;
import com.yy.hiyo.channel.plugins.ktv.service.KTVPopularityNotify;
import com.yy.hiyo.channel.plugins.ktv.service.KTVPopularityService;
import com.yy.hiyo.channel.plugins.ktv.service.OnNotifyCallback;
import com.yy.hiyo.channel.service.ktv.IKTVPopularityService;
import com.yy.hiyo.channel.service.ktv.OnGetPopLevelCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.ktv.srv.popularity.GetKtvPopConfigsReq;
import net.ihago.ktv.srv.popularity.GetKtvPopConfigsRes;
import net.ihago.ktv.srv.popularity.GetRoomPopInfoReq;
import net.ihago.ktv.srv.popularity.GetRoomPopInfoRes;
import net.ihago.ktv.srv.popularity.GetUserCurrentPopLevelReq;
import net.ihago.ktv.srv.popularity.GetUserCurrentPopLevelRes;
import net.ihago.ktv.srv.popularity.LevelDownMsg;
import net.ihago.ktv.srv.popularity.LevelUpMsg;
import net.ihago.ktv.srv.popularity.PopLevelAwardConfig;
import net.ihago.ktv.srv.popularity.PopLevelInfo;
import net.ihago.ktv.srv.popularity.RoomPopStageInfo;
import net.ihago.ktv.srv.popularity.SingBeginMsg;
import net.ihago.ktv.srv.popularity.SingEndMsg;
import net.ihago.ktv.srv.popularity.StageChangeMsg;
import net.ihago.ktv.srv.popularity.StageUpMsg;
import net.ihago.ktv.srv.popularity.ToneQualityConf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\"\u0010%\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0019H\u0002R7\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/service/KTVPopularityService;", "Lcom/yy/hiyo/channel/service/ktv/IKTVPopularityService;", "()V", "mData", "Ljava/util/LinkedHashMap;", "", "Lcom/yy/hiyo/channel/base/bean/KTVPopularityData;", "Lkotlin/collections/LinkedHashMap;", "getMData", "()Ljava/util/LinkedHashMap;", "mData$delegate", "Lkotlin/Lazy;", "mKTVPopularityConfig", "Lcom/yy/hiyo/channel/base/bean/KTVPopularityConfig;", "mNotify", "Lcom/yy/hiyo/channel/plugins/ktv/service/KTVPopularityNotify;", "data", "cid", "getLevelInfoByUid", "Lcom/yy/hiyo/channel/base/bean/KTVPopLevelInfo;", "uid", "", "getPopLevelAwardConfigByLevel", "Lnet/ihago/ktv/srv/popularity/PopLevelAwardConfig;", "level", "", "getPopularityLevelInfo", "", "Lcom/yy/hiyo/channel/base/bean/KTVPopularityLevel;", "getStageInfoByUid", "Lcom/yy/hiyo/channel/base/bean/KTVRoomPopStageInfo;", "songId", "reJoin", "", "registerNotify", "reqKtvPopConfigs", "reqRoomPopInfo", "reqUserCurrentPopLevel", "callback", "Lcom/yy/hiyo/channel/service/ktv/OnGetPopLevelCallback;", "resetData", "url2ThumbnailUrl", "url", "size", "ktv_debug"})
public final class KTVPopularityService
implements IKTVPopularityService {
    private KTVPopularityNotify mNotify;
    private final KTVPopularityConfig mKTVPopularityConfig = new KTVPopularityConfig();
    private final Lazy mData$delegate = LazyKt.lazy((Function0)mData.2.INSTANCE);

    private final LinkedHashMap<String, KTVPopularityData> getMData() {
        Lazy lazy = this.mData$delegate;
        KTVPopularityService kTVPopularityService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LinkedHashMap)lazy.getValue();
    }

    @NotNull
    public KTVPopularityData data(@NotNull String cid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (!this.getMData().containsKey(cid)) {
            ((Map)this.getMData()).put(cid, new KTVPopularityData());
        }
        KTVPopularityData kTVPopularityData = this.getMData().get(cid);
        if (kTVPopularityData == null) {
            Intrinsics.throwNpe();
        }
        return kTVPopularityData;
    }

    @Nullable
    public KTVRoomPopStageInfo getStageInfoByUid(@NotNull String cid, long uid, @NotNull String songId) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        KTVPopularityData data = this.data(cid);
        String key = data.getStageInfoKey(uid, songId);
        if (data.getStageInfo().containsKey(key)) {
            RoomPopStageInfo roomPopStageInfo = (RoomPopStageInfo)data.getStageInfo().get(key);
            if (roomPopStageInfo != null) {
                RoomPopStageInfo roomPopStageInfo2 = roomPopStageInfo;
                boolean bl = false;
                boolean bl2 = false;
                RoomPopStageInfo it = roomPopStageInfo2;
                boolean bl3 = false;
                RoomPopStageInfo roomPopStageInfo3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)roomPopStageInfo3, (String)"it");
                Integer n = it.stage_level;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it.stage_level");
                return new KTVRoomPopStageInfo(roomPopStageInfo3, this.mKTVPopularityConfig.getPopStageConfByLevel(n.intValue()));
            }
        }
        return null;
    }

    @Nullable
    public KTVPopLevelInfo getLevelInfoByUid(@NotNull String cid, long uid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        KTVPopularityData data = this.data(cid);
        if (data.getLevelInfo().containsKey(uid)) {
            PopLevelInfo popLevelInfo = (PopLevelInfo)data.getLevelInfo().get(uid);
            if (popLevelInfo != null) {
                PopLevelInfo popLevelInfo2 = popLevelInfo;
                boolean bl = false;
                boolean bl2 = false;
                PopLevelInfo it = popLevelInfo2;
                boolean bl3 = false;
                PopLevelInfo popLevelInfo3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo3, (String)"it");
                Integer n = it.level;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it.level");
                return new KTVPopLevelInfo(popLevelInfo3, this.mKTVPopularityConfig.getPopLevelAwardConfigByLevel(n.intValue()));
            }
        }
        return null;
    }

    @Nullable
    public PopLevelAwardConfig getPopLevelAwardConfigByLevel(int level) {
        return this.mKTVPopularityConfig.getPopLevelAwardConfigByLevel(level);
    }

    public void reqKtvPopConfigs(@NotNull String cid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (this.mKTVPopularityConfig.isNotEmpty()) {
            MLog.info((Object)"KTVPopularityService", (String)"reqKtvPopConfigs is not empty", (Object[])new Object[0]);
        }
        GetKtvPopConfigsReq req = new GetKtvPopConfigsReq.Builder().build();
        MLog.debug((Object)"KTVPopularityService", (String)("reqKtvPopConfigs: " + cid), (Object[])new Object[0]);
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetKtvPopConfigsRes>(this){
            final /* synthetic */ KTVPopularityService this$0;

            public void onResponse(@NotNull GetKtvPopConfigsRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    KTVPopularityService.access$getMKTVPopularityConfig$p(this.this$0).getPopStageConf().set((Collection)res.pop_stage_conf);
                    KTVPopularityService.access$getMKTVPopularityConfig$p(this.this$0).getPopLevelAwardConfig().set((Collection)res.pop_level_award_config);
                } else {
                    MLog.error((Object)"KTVPopularityService", (String)("reqKtvPopConfigs code: " + code + ", msg: " + msgTip), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"KTVPopularityService", (String)("reqKtvPopConfigs code: " + code + ", msg: " + reason), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void reqRoomPopInfo(@NotNull String cid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        GetRoomPopInfoReq req = new GetRoomPopInfoReq.Builder().build();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoomPopInfoRes>(this, cid){
            final /* synthetic */ KTVPopularityService this$0;
            final /* synthetic */ String $cid;

            public void onResponse(@NotNull GetRoomPopInfoRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    KTVPopularityData data = this.this$0.data(this.$cid);
                    if (res.room_pop_stage_info.uid > 0L) {
                        RoomPopStageInfo roomPopStageInfo = res.room_pop_stage_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)roomPopStageInfo, (String)"res.room_pop_stage_info");
                        data.putStageInfo(roomPopStageInfo);
                        data.setValue("kvo_roomPopStageInfo", (Object)res.room_pop_stage_info);
                    }
                    if (res.pop_level_info.uid > 0L) {
                        Map map = data.getLevelInfo();
                        Long l = res.pop_level_info.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"res.pop_level_info.uid");
                        PopLevelInfo popLevelInfo = res.pop_level_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo, (String)"res.pop_level_info");
                        map.put(l, popLevelInfo);
                        data.setValue("kvo_popLevelInfo", (Object)res.pop_level_info);
                    }
                } else {
                    MLog.error((Object)"KTVPopularityService", (String)("reqKtvPopConfigs code: " + code + ", msg: " + msgTip), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"KTVPopularityService", (String)("reqRoomPopInfo code: " + code + ", msg: " + reason), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
                this.$cid = $captured_local_variable$1;
            }
        });
    }

    public void reqUserCurrentPopLevel(@NotNull String cid, long uid, @Nullable OnGetPopLevelCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        GetUserCurrentPopLevelReq req = new GetUserCurrentPopLevelReq.Builder().uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetUserCurrentPopLevelRes>(this, cid, uid, callback){
            final /* synthetic */ KTVPopularityService this$0;
            final /* synthetic */ String $cid;
            final /* synthetic */ long $uid;
            final /* synthetic */ OnGetPopLevelCallback $callback;

            public void onResponse(@NotNull GetUserCurrentPopLevelRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    PopLevelInfo levelInfo;
                    PopLevelInfo popLevelInfo;
                    PopLevelInfo info;
                    KTVPopularityData data = this.this$0.data(this.$cid);
                    PopLevelInfo.Builder infoBuilder = new PopLevelInfo.Builder().uid(Long.valueOf(this.$uid)).level(res.current_level);
                    if (!data.getLevelInfo().containsKey(this.$uid)) {
                        info = infoBuilder.build();
                        data.getLevelInfo().put(this.$uid, info);
                        data.setValue("kvo_popLevelInfo", (Object)info);
                        popLevelInfo = info;
                    } else {
                        Object object = (PopLevelInfo)data.getLevelInfo().get(this.$uid);
                        if (object == null || (object = object.score) == null) {
                            object = 0L;
                        }
                        infoBuilder.score((Long)object);
                        popLevelInfo = infoBuilder.build();
                    }
                    PopLevelInfo popLevelInfo2 = levelInfo = popLevelInfo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo2, (String)"levelInfo");
                    KTVPopularityConfig kTVPopularityConfig = KTVPopularityService.access$getMKTVPopularityConfig$p(this.this$0);
                    Integer n = levelInfo.level;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"levelInfo.level");
                    info = new KTVPopLevelInfo(popLevelInfo2, kTVPopularityConfig.getPopLevelAwardConfigByLevel(n.intValue()));
                    OnGetPopLevelCallback onGetPopLevelCallback = this.$callback;
                    if (onGetPopLevelCallback != null) {
                        onGetPopLevelCallback.onResponse((KTVPopLevelInfo)info);
                    }
                } else {
                    MLog.error((Object)"KTVPopularityService", (String)("reqUserCurrentPopLevel code: " + code + ", msg: " + msgTip), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"KTVPopularityService", (String)("reqUserCurrentPopLevel code: " + code + ", msg: " + reason), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
                this.$cid = $captured_local_variable$1;
                this.$uid = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    @NotNull
    public List<KTVPopularityLevel> getPopularityLevelInfo(int level) {
        List list;
        block1: {
            boolean bl = false;
            list = new ArrayList();
            PopLevelAwardConfig config = this.mKTVPopularityConfig.getPopLevelAwardConfigByLevel(level);
            if (config == null) break block1;
            int size = ResolutionUtils.dip2Px((float)80.0f);
            String string2 = config.icon_text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"config.icon_text");
            String string3 = config.icon_url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"config.icon_url");
            list.add(new KTVPopularityLevel(string2, this.url2ThumbnailUrl(string3, size)));
            String string4 = config.record_text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"config.record_text");
            String string5 = config.record_url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"config.record_url");
            list.add(new KTVPopularityLevel(string4, this.url2ThumbnailUrl(string5, size)));
            ToneQualityConf toneQualityConf = this.mKTVPopularityConfig.getTopToneQualityConf(config);
            if (toneQualityConf != null) {
                ToneQualityConf toneQualityConf2 = toneQualityConf;
                boolean bl2 = false;
                boolean bl3 = false;
                ToneQualityConf it = toneQualityConf2;
                boolean bl4 = false;
                String string6 = it.text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.text");
                String string7 = it.url;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.url");
                list.add(new KTVPopularityLevel(string6, this.url2ThumbnailUrl(string7, size)));
            }
        }
        return list;
    }

    private final String url2ThumbnailUrl(String url, int size) {
        return StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null) ? url : url + YYImageUtils.getThumbnailPostfix((int)size);
    }

    public void registerNotify() {
        if (this.mNotify == null) {
            this.mNotify = new KTVPopularityNotify(new OnNotifyCallback(this){
                final /* synthetic */ KTVPopularityService this$0;

                public void onHandlePopSingBeginMsg(@NotNull String cid, @NotNull SingBeginMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    if (msg.user_pop_level.uid > 0L) {
                        MLog.debug((Object)"KTVPopularityService", (String)("onHandlePopSingBeginMsg uid:" + msg.user_pop_level.uid), (Object[])new Object[0]);
                        KTVPopularityData data = this.this$0.data(cid);
                        data.getLevelInfo().put(msg.user_pop_level.uid, msg.user_pop_level);
                        data.setValue("kvo_popLevelInfo", (Object)msg.user_pop_level);
                    } else {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopSingBeginMsg uid is 0", (Object[])new Object[0]);
                    }
                }

                public void onHandlePopStageChanged(@NotNull String cid, @NotNull StageChangeMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    if (msg.cur_pop_stage.uid > 0L) {
                        KTVPopularityData data = this.this$0.data(cid);
                        RoomPopStageInfo roomPopStageInfo = msg.cur_pop_stage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)roomPopStageInfo, (String)"msg.cur_pop_stage");
                        data.putStageInfo(roomPopStageInfo);
                        data.setValue("kvo_roomPopStageInfo", (Object)msg.cur_pop_stage);
                    } else {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopStageChanged uid is 0", (Object[])new Object[0]);
                    }
                }

                public void onHandlePopStageUp(@NotNull String cid, @NotNull StageUpMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    if (msg.pop_stage_info.uid > 0L) {
                        KTVPopularityData data = this.this$0.data(cid);
                        RoomPopStageInfo roomPopStageInfo = msg.pop_stage_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)roomPopStageInfo, (String)"msg.pop_stage_info");
                        data.putStageInfo(roomPopStageInfo);
                        data.setValue("kvo_roomPopStageInfo", (Object)msg.pop_stage_info);
                        data.setValue("kvo_stageUp", (Object)(data.getStageUpVersion() + 1));
                    } else {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopStageUp uid is 0", (Object[])new Object[0]);
                    }
                }

                public void onHandlePopSingEnd(@NotNull String cid, @NotNull SingEndMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    KTVPopularityData data = this.this$0.data(cid);
                    if (msg.stage_info.uid > 0L) {
                        RoomPopStageInfo roomPopStageInfo = msg.stage_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)roomPopStageInfo, (String)"msg.stage_info");
                        data.putStageInfo(roomPopStageInfo);
                        data.setValue("kvo_roomPopStageInfo", (Object)msg.stage_info);
                    }
                    if (msg.level_info.uid > 0L) {
                        data.getLevelInfo().put(msg.level_info.uid, msg.level_info);
                        data.setValue("kvo_popLevelInfo", (Object)msg.level_info);
                    }
                    KtvPopularitySingEnd singEndInfo = new KtvPopularitySingEnd();
                    Long l = msg.stage_info.uid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"msg.stage_info.uid");
                    singEndInfo.setUid(l.longValue());
                    String string2 = msg.stage_info.song_id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"msg.stage_info.song_id");
                    singEndInfo.setSongId(string2);
                    data.setValue("kvo_singEnd", (Object)singEndInfo);
                    if (msg.stage_info.uid <= 0L && msg.level_info.uid <= 0L) {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopSingEnd uid is 0", (Object[])new Object[0]);
                    } else {
                        MLog.debug((Object)"KTVPopularityService", (String)("onHandlePopSingEnd uid:" + msg.stage_info.uid), (Object[])new Object[0]);
                    }
                }

                public void onHandlePopLevelUp(@NotNull String cid, @NotNull LevelUpMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    MLog.info((Object)"KTVPopularityService", (String)("onHandlePopLevelUp uid=" + msg.pop_level_info.uid), (Object[])new Object[0]);
                    if (msg.pop_level_info.uid > 0L) {
                        KTVPopularityData data = this.this$0.data(cid);
                        Map map = data.getLevelInfo();
                        Long l = msg.pop_level_info.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"msg.pop_level_info.uid");
                        PopLevelInfo popLevelInfo = msg.pop_level_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo, (String)"msg.pop_level_info");
                        map.put(l, popLevelInfo);
                        data.setValue("kvo_popLevelInfo", (Object)msg.pop_level_info);
                        KtvPopularityLevelChange levelChange = new KtvPopularityLevelChange();
                        Long l2 = msg.pop_level_info.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"msg.pop_level_info.uid");
                        levelChange.setUid(l2.longValue());
                        Integer n = msg.pop_level_info.level;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"msg.pop_level_info.level");
                        levelChange.setLevel(n.intValue());
                        data.setValue("kvo_levelUp", (Object)levelChange);
                    } else {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopLevelUp uid is 0", (Object[])new Object[0]);
                    }
                }

                public void onHandlePopLevelDown(@NotNull String cid, @NotNull LevelDownMsg msg) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                    if (msg.current_level.uid > 0L) {
                        MLog.debug((Object)"KTVPopularityService", (String)("onHandlePopLevelDown uid:" + msg.current_level.uid), (Object[])new Object[0]);
                        KTVPopularityData data = this.this$0.data(cid);
                        Map map = data.getLevelInfo();
                        Long l = msg.current_level.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"msg.current_level.uid");
                        PopLevelInfo popLevelInfo = msg.current_level;
                        Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo, (String)"msg.current_level");
                        map.put(l, popLevelInfo);
                        Map map2 = data.getLastLevelInfo();
                        Long l2 = msg.last_level.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"msg.last_level.uid");
                        PopLevelInfo popLevelInfo2 = msg.last_level;
                        Intrinsics.checkExpressionValueIsNotNull((Object)popLevelInfo2, (String)"msg.last_level");
                        map2.put(l2, popLevelInfo2);
                        data.setValue("kvo_popLevelInfo", (Object)msg.current_level);
                        data.setValue("kvo_levelDown", (Object)(data.getLevelDownVersion() + 1));
                    } else {
                        MLog.error((Object)"KTVPopularityService", (String)"onHandlePopLevelDown uid is 0", (Object[])new Object[0]);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mNotify);
        }
    }

    public void resetData(@NotNull String cid) {
        block2: {
            KTVPopularityData item;
            Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
            if (this.mNotify != null) {
                ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mNotify);
                this.mNotify = null;
            }
            if (!this.getMData().containsKey(cid)) break block2;
            KTVPopularityData kTVPopularityData = item = (KTVPopularityData)this.getMData().remove(cid);
            if (kTVPopularityData != null) {
                kTVPopularityData.clear();
            }
        }
    }

    public void reJoin(@NotNull String cid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (!this.mKTVPopularityConfig.isNotEmpty()) {
            this.reqKtvPopConfigs(cid);
        }
        this.reqRoomPopInfo(cid);
    }

    public static final /* synthetic */ KTVPopularityConfig access$getMKTVPopularityConfig$p(KTVPopularityService $this) {
        return $this.mKTVPopularityConfig;
    }
}

