/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AIDenoiseConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVRoomService;
import com.yy.hiyo.channel.plugins.ktv.ABTestPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVModelLifecycle;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.IKTVDownloader;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.KTVDownloader;
import com.yy.hiyo.channel.plugins.ktv.model.extra.KTVExtHandler;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVChannelListener;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVPlayer;
import com.yy.hiyo.channel.plugins.ktv.model.player.KTVPlayer;
import com.yy.hiyo.channel.plugins.ktv.model.record.IKTVRecorder;
import com.yy.hiyo.channel.plugins.ktv.model.record.KTVRecorder;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.model.songList.IKTVMusicList;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ihago.ktv.api.search.ABTestBucket;

public class KTVRoomManager
implements IKTVManager,
INotify {
    public static final int MODE_KTV = 0;
    public static final int MODE_RADIO = 1;
    private KTVDownloader mKTVDownloader;
    private KTVPlayer mKTVPlayer;
    private KTVRecorder mKTVRecorder;
    private KTVMusicListProvider mKTVMusicListProvider;
    private KTVRoomServices mKTVRoomStatuManager;
    private KTVExtHandler mKTVExtHandler;
    private List<KTVBaseModel> mModelList = new ArrayList<KTVBaseModel>();
    private KTVBaseContext mContext;
    private int mMode;
    private Set<IKTVManager.IKTVServiceLifecycle> iKTVServiceLifecycleSet = new HashSet<IKTVManager.IKTVServiceLifecycle>();

    public KTVRoomManager() {
        this.mMode = 0;
    }

    public KTVRoomManager(int mode) {
        this.mMode = mode;
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        this.mContext = context;
        this.initDownloader(context);
        this.initKTVRoom(context);
        this.initPlayer(context);
        this.initRecorder(context);
        this.initSongList(context);
        this.initKTVExtHandler();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.WSCLIENT_CONNECT_SUCCESS, (INotify)this);
        for (IKTVModelLifecycle iKTVModelLifecycle : this.mModelList) {
            iKTVModelLifecycle.onCreate(context);
        }
        for (IKTVManager.IKTVServiceLifecycle iKTVServiceLifecycle : this.iKTVServiceLifecycleSet) {
            iKTVServiceLifecycle.onCreate(this.getContext().getRoomData().getRoomId());
        }
        String channelId = this.mContext.getRoomData().getRoomId();
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableMediaMode(channelId, true);
        if (this.mMode == 1) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(channelId, VoiceConstant.SCENE_ID_RADIO);
        } else {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(channelId, VoiceConstant.SCENE_ID_KTV);
        }
        if (this.enableAIDenoise()) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableAIDenoise(true);
            RoomTrack.INSTANCE.reportAIDenoise(this.getContext().getRoomData().getRoomId());
        }
    }

    private boolean enableAIDenoise() {
        AIDenoiseConfig aiDenoiseConfig;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.AI_DENOISE);
        if (config instanceof AIDenoiseConfig && (aiDenoiseConfig = (AIDenoiseConfig)config).isAIDenoiseEnable()) {
            ABTestPresenter abTestPresenter = (ABTestPresenter)this.getContext().getRoomContext().getPresenter(ABTestPresenter.class);
            ABTestBucket bucket = abTestPresenter.getBucket(abTestPresenter.GROUP_AI_DENOISE);
            MLog.info((Object)"KTVRoomManager", (String)("ai denoise bucket " + bucket), (Object[])new Object[0]);
            return ABTestBucket.kABTestBucketA == bucket || ABTestBucket.kABTestBucketB == bucket;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        for (IKTVModelLifecycle iKTVModelLifecycle : this.mModelList) {
            iKTVModelLifecycle.onDestroy();
        }
        for (IKTVManager.IKTVServiceLifecycle iKTVServiceLifecycle : this.iKTVServiceLifecycleSet) {
            iKTVServiceLifecycle.onDestory(this.getContext().getRoomData().getRoomId());
        }
        this.reportSingerExitRoom();
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.WSCLIENT_CONNECT_SUCCESS, (INotify)this);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableMediaMode(this.mContext.getRoomData().getRoomId(), false);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(this.mContext.getRoomData().getRoomId(), VoiceConstant.SCENE_ID_MULTI_AUDIO);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableAIDenoise(false);
    }

    private synchronized void initDownloader(KTVBaseContext context) {
        if (this.mKTVDownloader == null) {
            this.mKTVDownloader = new KTVDownloader(this);
            this.mModelList.add(this.mKTVDownloader);
        }
    }

    private synchronized void initPlayer(KTVBaseContext context) {
        if (this.mKTVPlayer == null) {
            this.mKTVPlayer = new KTVPlayer(this, new IKTVChannelListener(){

                @Override
                public boolean isOnlyInOtherSeat() {
                    if (KTVRoomManager.this.mContext != null && KTVRoomManager.this.mContext.getRoomData() != null) {
                        return KTVRoomManager.this.mContext.getRoomData().getSeatData().isOnlyInOtherSeat(AccountUtil.getUid());
                    }
                    return false;
                }
            });
            this.mModelList.add(this.mKTVPlayer);
        }
    }

    private synchronized void initRecorder(KTVBaseContext context) {
        if (this.mKTVRecorder == null) {
            this.mKTVRecorder = new KTVRecorder(this);
            this.mModelList.add(this.mKTVRecorder);
        }
    }

    private synchronized void initSongList(KTVBaseContext context) {
        if (this.mKTVMusicListProvider == null) {
            this.mKTVMusicListProvider = new KTVMusicListProvider(this);
            this.mModelList.add(this.mKTVMusicListProvider);
        }
    }

    private synchronized void initKTVRoom(KTVBaseContext context) {
        if (this.mKTVRoomStatuManager == null) {
            this.mKTVRoomStatuManager = new KTVRoomServices(this);
            this.mModelList.add(this.mKTVRoomStatuManager);
        }
    }

    private synchronized void initKTVExtHandler() {
        if (this.mKTVExtHandler == null) {
            this.mKTVExtHandler = new KTVExtHandler(this);
            this.mModelList.add(this.mKTVExtHandler);
        }
    }

    @Override
    @NonNull
    public IKTVDownloader getKTVDownloader() {
        if (this.mKTVDownloader == null) {
            this.initDownloader(this.mContext);
        }
        return this.mKTVDownloader;
    }

    @Override
    @NonNull
    public IKTVPlayer getKTVPlayer() {
        if (this.mKTVPlayer == null) {
            this.initPlayer(this.mContext);
        }
        return this.mKTVPlayer;
    }

    @Override
    @NonNull
    public IKTVRecorder getKTVRecorder() {
        if (this.mKTVRecorder == null) {
            this.initRecorder(this.mContext);
        }
        return this.mKTVRecorder;
    }

    @Override
    @NonNull
    public IKTVMusicList getKTVMusicListProvider() {
        if (this.mKTVMusicListProvider == null) {
            this.initSongList(this.mContext);
        }
        return this.mKTVMusicListProvider;
    }

    @NonNull
    public IKTVRoomService getKTVRoomServices() {
        if (this.mKTVRoomStatuManager == null) {
            this.initKTVRoom(this.mContext);
        }
        return this.mKTVRoomStatuManager;
    }

    @Override
    public KTVBaseContext getContext() {
        return this.mContext;
    }

    @Override
    public void registerKTVLifecycle(IKTVManager.IKTVServiceLifecycle iktvServiceLifecycle) {
        if (iktvServiceLifecycle != null && !this.iKTVServiceLifecycleSet.contains(iktvServiceLifecycle)) {
            this.iKTVServiceLifecycleSet.add(iktvServiceLifecycle);
        }
    }

    @Override
    public void unRegisterKTVLifecycle(IKTVManager.IKTVServiceLifecycle iktvServiceLifecycle) {
        if (iktvServiceLifecycle != null && this.iKTVServiceLifecycleSet.contains(iktvServiceLifecycle)) {
            this.iKTVServiceLifecycleSet.remove(iktvServiceLifecycle);
        }
    }

    private void reportSingerExitRoom() {
        long singerUid;
        if (this.getKTVRoomServices().getCurrentKTVRoomData() != null && this.getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null && (singerUid = this.getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getUid()) == AccountUtil.getUid()) {
            KTVEventReportUtil.reportChangeSongClick("4");
        }
    }

    public void notify(Notification notification) {
        block7: {
            int notificationId;
            block6: {
                if (notification == null) {
                    return;
                }
                notificationId = notification.id;
                if (notificationId != NotificationDef.N_NETWORK_STATE_CHANGE) break block6;
                boolean networkAvailable = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
                if (networkAvailable) {
                    for (KTVBaseModel ktvBaseModel : this.mModelList) {
                        ktvBaseModel.onNetChanged(1);
                    }
                } else {
                    for (KTVBaseModel ktvBaseModel : this.mModelList) {
                        ktvBaseModel.onNetChanged(2);
                    }
                }
                break block7;
            }
            if (notificationId != NotificationDef.WSCLIENT_CONNECT_SUCCESS) break block7;
            for (KTVBaseModel ktvBaseModel : this.mModelList) {
                ktvBaseModel.onNetChanged(3);
            }
        }
    }
}

