/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.im.base.PushTagManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import com.yy.hiyo.proto.callback.ICIMProtoNotify;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.im.cim.f;
import com.yy.im.cim.g;
import com.yy.im.cim.h;
import com.yy.im.cim.i;
import com.yy.im.cim.j;
import com.yy.im.protocol.MsgProtocolSwitch;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.ihago.base.srv.pubsubgroup.ClearGroupReq;
import net.ihago.im.api.imcheck.CheckUseCimRequest;

public enum CIMModule {
    INSTANCE;

    private static final String TAG = "[Hago-CIM]";
    private static boolean sInitSuccess;
    private static Channel sChannel;
    private long mConnectedTS = 0L;
    private long mAppId = 0L;
    private String region;
    private Channel.StateChangedListener mChanneStateListener;
    protected final a mNotifyListener = new a(1);
    protected final a mGroupNotifyListener = new a(2);
    private final Set<Channel.NotificationHandler> handlers = new HashSet<Channel.NotificationHandler>();
    private long mMySelfUid = 0L;
    private final int period = 300000;
    private final Runnable inspector = new h(this);
    private long mSeq = System.currentTimeMillis();

    public boolean init(Context context, long l2, String string3) {
        if (sChannel == null) {
            Log.setLogger((n2, string2) -> {
                if (6 == n2) {
                    MLog.error((Object)TAG, (String)string2, (Object[])new Object[0]);
                } else if (4 == n2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)string2, (Object[])new Object[0]);
                    }
                } else if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)TAG, (String)string2, (Object[])new Object[0]);
                }
            });
            try {
                sChannel = new com.yy.im.cim.a(this);
                ServiceProvider.register(Channel.class, (ServiceProvider.Service)sChannel);
                if (!sInitSuccess) {
                    HMR.init((Context)context, (long)l2, null);
                }
                j.d();
                this.region = string3;
                YYTaskExecutor.execute((Runnable)this.inspector, (long)20000L);
                sInitSuccess = true;
            }
            catch (Throwable throwable) {
                sInitSuccess = false;
                MLog.error((Object)TAG, (String)("Init CIM error:" + throwable), (Object[])new Object[0]);
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"channel: %@", (Object[])new Object[]{HMR.getService(Channel.class)});
        }
        return sInitSuccess;
    }

    public void notifyChannelConncected() {
        this.mConnectedTS = System.currentTimeMillis();
        if (this.mChanneStateListener != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"notify ws connected", (Object[])new Object[0]);
            }
            this.mChanneStateListener.onChannelConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(Channel.NotificationHandler notificationHandler) {
        Set<Channel.NotificationHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(notificationHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandler(Channel.NotificationHandler notificationHandler) {
        Set<Channel.NotificationHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(notificationHandler);
        }
    }

    public void open(long l2, b b2) {
        if (!sInitSuccess) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            }
            if (b2 != null) {
                b2.a(-1, "cim not init!");
            }
            return;
        }
        if (l2 <= 0L) {
            if (b2 != null) {
                b2.a(-1, "no uid for cim!");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"no uid for cim", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mMySelfUid == l2 && HMR.getState() == HMR.State.Opened) {
            if (b2 != null) {
                b2.a();
            }
            return;
        }
        this.clearSubscribe(l2);
        this.mMySelfUid = l2;
        MLog.info((Object)TAG, (String)("open for cim, uid:" + l2), (Object[])new Object[0]);
        boolean bl2 = MsgProtocolSwitch.INSTANCE.loadSwitch(l2);
        if (bl2) {
            this.open(l2, MQService.FetchStrategy.Continuously, b2);
        } else if (!MsgProtocolSwitch.INSTANCE.hasFetch()) {
            this.requestSwitch(b2);
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"The switch is not open for cim.", (Object[])new Object[0]);
            }
            if (b2 != null) {
                b2.a(-1, "switch is not open for cim");
            }
        }
        ProtoManager.getInstance().registerCIMNotify((ICIMProtoNotify)this.mNotifyListener);
        ProtoManager.getInstance().registerCIMNotify((ICIMProtoNotify)this.mGroupNotifyListener);
    }

    private void clearSubscribe(long l2) {
        ClearGroupReq clearGroupReq = new ClearGroupReq.Builder().seqid(Long.valueOf(this.uniqueSeq())).uid(Long.valueOf(l2)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)clearGroupReq, (IProtoCallback)new f(this, l2));
    }

    public void reset() {
        if (!sInitSuccess) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"reset cim", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().unregisterCIMNotify((ICIMProtoNotify)this.mNotifyListener);
        ProtoManager.getInstance().unregisterCIMNotify((ICIMProtoNotify)this.mGroupNotifyListener);
        this.mMySelfUid = 0L;
        HMR.close(null);
        sChannel = null;
        YYTaskExecutor.removeTask((Runnable)this.inspector);
    }

    private void open(long l2, MQService.FetchStrategy fetchStrategy, b b2) {
        List list;
        if (!sInitSuccess) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            }
            if (b2 != null) {
                b2.a(-1, "cim init fail!");
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("start open cim:" + l2 + ",msg sync strategy:" + fetchStrategy), (Object[])new Object[0]);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(SystemUtils.getLang());
        if (!PushTagManager.isInited()) {
            PushTagManager.initTag();
        }
        if ((list = PushTagManager.getTagList()) != null && !list.isEmpty()) {
            int n2 = list.size();
            for (int i2 = 1; i2 < n2; i2 += 2) {
                String string2 = (String)list.get(i2);
                if (string2 != null && string2.contains("country_")) {
                    string2 = string2.toLowerCase();
                }
                hashSet.add(string2);
            }
        } else {
            MLog.error((Object)TAG, (String)("no push tags for uid:" + l2), (Object[])new Object[0]);
        }
        g g2 = new g(this, b2);
        HMR.open((long)l2, (String)this.region, hashSet, (HMR.Completion)g2);
    }

    private void reportTemporary(long l2, String string2, long l3, int n2, String string3, long l4) {
        if (!ProtoManager.getInstance().isWSConnected() || this.mConnectedTS == 0L) {
            return;
        }
        if (l2 < this.mConnectedTS && this.mConnectedTS - l2 > 5000L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"may be no net work for cim", (Object[])new Object[0]);
            }
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("report one uri:" + string2 + ",code:" + n2), (Object[])new Object[0]);
        }
        HiidoStatis.reportReturnCode((int)50216, (String)string2, (long)l3, (String)String.format(Locale.US, "%d", n2));
    }

    private void requestSwitch(b b2) {
        long l2 = System.currentTimeMillis();
        CheckUseCimRequest checkUseCimRequest = new CheckUseCimRequest.Builder().self_uid(Long.valueOf(AccountUtil.getUid())).log_id(Long.valueOf(l2)).os_type("Android").os_version(Build.VERSION.RELEASE).model_name(Build.MODEL).cim_sdk_version(HMR.getVersion()).hago_app_version(VersionUtil.getVersionWithoutSnpashot((Context)RuntimeContext.sApplicationContext)).build();
        User user = HMR.getMe();
        boolean bl2 = MsgProtocolSwitch.INSTANCE.isSwitch();
        Integer[] integerArray = new Integer[]{0, 0};
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("CIM Check Switch logId=" + l2 + ",cimver=" + checkUseCimRequest.cim_sdk_version + ",appver=" + checkUseCimRequest.hago_app_version), (Object[])new Object[0]);
        }
        long l3 = System.currentTimeMillis();
        String string2 = "CheckUseCim";
        ProtoManager.getInstance().sendCIMRpc("net.ihago.im.srv.imcheck", "ImCheck.CheckUseCim", checkUseCimRequest.encode(), (ICIMProtoCallback)new i(this, user, l3, l2, bl2, b2, integerArray));
    }

    public synchronized long uniqueSeq() {
        long l2 = System.currentTimeMillis();
        this.mSeq = l2 > this.mSeq ? l2 : ++this.mSeq;
        return this.mSeq;
    }

    static /* synthetic */ Channel.StateChangedListener access$002(CIMModule cIMModule, Channel.StateChangedListener stateChangedListener) {
        cIMModule.mChanneStateListener = stateChangedListener;
        return cIMModule.mChanneStateListener;
    }

    static /* synthetic */ boolean access$200() {
        return sInitSuccess;
    }

    static /* synthetic */ void access$300(CIMModule cIMModule, b b2) {
        cIMModule.requestSwitch(b2);
    }

    static /* synthetic */ long access$400(CIMModule cIMModule) {
        return cIMModule.mAppId;
    }

    static /* synthetic */ void access$500(CIMModule cIMModule, long l2, String string2, long l3, int n2, String string3, long l4) {
        cIMModule.reportTemporary(l2, string2, l3, n2, string3, l4);
    }

    static /* synthetic */ void access$600(CIMModule cIMModule, long l2, MQService.FetchStrategy fetchStrategy, b b2) {
        cIMModule.open(l2, fetchStrategy, b2);
    }

    static {
        sInitSuccess = false;
        sChannel = null;
    }

    public static interface b {
        public void a();

        public void a(int var1, String var2);
    }

    private class a
    implements ICIMProtoNotify<byte[]> {
        private int b;

        public a(int n2) {
            this.b = n2;
        }

        public int uri() {
            return this.b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(@NonNull byte[] byArray) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)CIMModule.TAG, (String)"on new cim msg notify", (Object[])new Object[0]);
            }
            Set set = CIMModule.this.handlers;
            synchronized (set) {
                for (Channel.NotificationHandler notificationHandler : CIMModule.this.handlers) {
                    if (this.b == 1) {
                        notificationHandler.onNotify("service_api_gateway", "cim.proto.PushService.IMPushMsg", byArray);
                        continue;
                    }
                    if (this.b != 2) continue;
                    notificationHandler.onNotify("service_api_gateway", "cim.proto.PushService.IMPushGroupSysMsg", byArray);
                }
            }
        }

        public /* synthetic */ void onNotify(@NonNull Object object) {
            this.a((byte[])object);
        }
    }
}

