/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.hiido;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.VersionUtil;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import com.yy.yylite.hiido.HiidoExecutor;
import com.yy.yylite.hiido.HiidoInitParam;

public enum HiidoStatisticHelper {
    INSTANCE;

    private static final String TAG = "HiidoStatisticHelper";
    private static volatile boolean hadInit;
    private HiidoInitParam mInitParam;
    private String mPushToken = "";

    public void initHiidoSdk(String abJson) {
        this.initHiidoSdkInner(abJson);
    }

    public void initHiidoOptions(@NonNull HiidoInitParam param) {
        this.mInitParam = param;
        this.updateOptions();
    }

    private void updateOptions() {
        HiidoSDK.Options options = new HiidoSDK.Options();
        if (!TextUtils.isEmpty((CharSequence)this.mInitParam.getTestServer())) {
            options.behaviorSendThreshold = 0;
            options.testServer = this.mInitParam.getTestServer();
        }
        options.isOpenCrashMonitor = this.mInitParam.isOpenCrashMonitor();
        options.setOpenSensorMonitor(this.mInitParam.isOpenSensorMonitor());
        options.isNewMac = false;
        options.isAbroad = true;
        options.isLogOn = this.mInitParam.isOpenLog();
        HiidoSDK.instance().setOptions(options);
        options.setTaskExecutor((IYYTaskExecutor)new HiidoExecutor());
    }

    public void updateUid(long uid) {
        if (this.mInitParam != null) {
            this.mInitParam.updateUid(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHiidoSdkInner(String abJson) {
        if (hadInit) {
            return;
        }
        if (this.mInitParam == null) {
            MLog.error((Object)TAG, (String)"init hiido sdk with param is null, please call initHiidoSdk(@NonNull HiidoInitParam param) before", (Object[])new Object[0]);
            return;
        }
        HiidoStatisticHelper hiidoStatisticHelper = this;
        synchronized (hiidoStatisticHelper) {
            try {
                long uid;
                StatisOption sOption = new StatisOption();
                sOption.setAppId(this.mInitParam.getAppId());
                sOption.setAppkey(this.mInitParam.getAppkey());
                sOption.setFrom(AppMetaDataUtil.getChannelID((Context)RuntimeContext.sApplicationContext));
                if (TextUtils.isEmpty((CharSequence)this.mInitParam.getVersion())) {
                    sOption.setVer(this.mInitParam.getVersion());
                } else {
                    sOption.setVer(VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getOriginalVersion());
                }
                HiidoSDK.instance().getOptions().setActLogEnable(false);
                HiidoSDK.instance().getOptions().setLogOn(this.mInitParam.isOpenLog());
                if (!this.mInitParam.isOpenLog()) {
                    HiidoSDK.instance().setLogWriter(null);
                }
                HiidoSDK.instance().appStartLaunchWithAppKey(this.mInitParam.getContext(), sOption, this.mInitParam.getStatisListener());
                if (this.mInitParam.getActAdditionListener() != null) {
                    HiidoSDK.instance().addActAdditionListener((ActListener)this.mInitParam.getActAdditionListener());
                }
                HiidoSDK.instance().setABTest(new String[]{abJson});
                if (!TextUtils.isEmpty((CharSequence)this.mPushToken)) {
                    HiidoSDK.instance().reportPushToken(this.mPushToken);
                }
                hadInit = true;
                long l = uid = this.mInitParam.getUid() > 0L ? this.mInitParam.getUid() : 0L;
                if (RuntimeContext.sIsActivityStarted && !RuntimeContext.isHagoPartySdk()) {
                    HiidoSDK.instance().onResume(uid, "com.yy.hiyo.MainActivity");
                }
                if (uid > 0L) {
                    HiidoSDK.instance().reportLogin(uid);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"initHiidoSdk reportLogin uid: %s", (Object[])new Object[]{uid});
                    }
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("initHiidoSdk reportLogin uid:" + uid), (Object[])new Object[0]);
                }
                this.mInitParam = null;
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
        }
    }

    public void reportPushToken(String pushToken) {
        this.mPushToken = pushToken;
        HiidoSDK.instance().reportPushToken(pushToken);
    }

    public void reportLogin(long uid) {
        if (hadInit && uid > 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"reportLogin uid: %s", (Object[])new Object[]{uid});
            }
            HiidoSDK.instance().reportLogin(uid);
        }
    }

    public boolean isHadInit() {
        return hadInit;
    }

    static {
        hadInit = false;
    }
}

