/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.hiido;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.defs.listener.ActAdditionListener;

public class HiidoInitParam {
    private Context context;
    private String appkey;
    private String appId;
    private String fromChannel;
    private String version;
    private OnStatisListener statisListener;
    private ActAdditionListener actAdditionListener;
    private String testServer;
    private boolean isOpenCrashMonitor = true;
    private boolean isOpenSensorMonitor = true;
    private boolean isOpenLog;
    private long uid;

    private HiidoInitParam() {
    }

    private HiidoInitParam(Builder builder) {
        this.context = builder.context;
        this.appkey = builder.appkey;
        this.appId = builder.appId;
        this.fromChannel = builder.fromChannel;
        this.version = builder.version;
        this.statisListener = builder.statisListener;
        this.actAdditionListener = builder.actAdditionListener;
        this.testServer = builder.testServer;
        this.isOpenCrashMonitor = builder.isOpenCrashMonitor;
        this.isOpenSensorMonitor = builder.isOpenSensorMonitor;
        this.isOpenLog = builder.isOpenLog;
    }

    public static Builder getBuilder(@NonNull Context context) {
        return new Builder(context);
    }

    public Context getContext() {
        return this.context;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getFromChannel() {
        return this.fromChannel;
    }

    public String getVersion() {
        return this.version;
    }

    public OnStatisListener getStatisListener() {
        return this.statisListener;
    }

    public ActAdditionListener getActAdditionListener() {
        return this.actAdditionListener;
    }

    public String getTestServer() {
        return this.testServer;
    }

    public boolean isOpenCrashMonitor() {
        return this.isOpenCrashMonitor;
    }

    public boolean isOpenSensorMonitor() {
        return this.isOpenSensorMonitor;
    }

    public boolean isOpenLog() {
        return this.isOpenLog;
    }

    public long getUid() {
        return this.uid;
    }

    public void updateUid(long uid) {
        this.uid = uid;
    }

    public String toString() {
        return "HiidoInitParam{context=" + this.context + ", appkey='" + this.appkey + '\'' + ", appId='" + this.appId + '\'' + ", fromChannel='" + this.fromChannel + '\'' + ", version='" + this.version + '\'' + ", statisListener=" + this.statisListener + ", actAdditionListener=" + this.actAdditionListener + ", testServer='" + this.testServer + '\'' + ", isOpenCrashMonitor=" + this.isOpenCrashMonitor + ", isOpenSensorMonitor=" + this.isOpenSensorMonitor + ", uid=" + this.uid + '}';
    }

    public static class Builder {
        private final Context context;
        private String appkey;
        private String appId;
        private String fromChannel;
        private String version;
        private OnStatisListener statisListener;
        private ActAdditionListener actAdditionListener;
        private String testServer;
        private boolean isOpenCrashMonitor;
        private boolean isOpenSensorMonitor;
        private boolean isOpenLog;
        private long uid;

        public Builder(@NonNull Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder appkey(String appkey) {
            this.appkey = appkey;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder fromChannel(String fromChannel) {
            this.fromChannel = fromChannel;
            return this;
        }

        public Builder version(String ver) {
            this.version = ver;
            return this;
        }

        public Builder statisListener(OnStatisListener statisListener) {
            this.statisListener = statisListener;
            return this;
        }

        public Builder actAdditionListener(ActAdditionListener actAdditionListener) {
            this.actAdditionListener = actAdditionListener;
            return this;
        }

        public Builder testServer(String testServer) {
            this.testServer = testServer;
            return this;
        }

        public Builder isOpenCrashMonitor(boolean isOpenCrashMonitor) {
            this.isOpenCrashMonitor = isOpenCrashMonitor;
            return this;
        }

        public Builder isOpenSensorMonitor(boolean isOpenSensorMonitor) {
            this.isOpenSensorMonitor = isOpenSensorMonitor;
            return this;
        }

        public Builder uid(long uid) {
            this.uid = uid;
            return this;
        }

        public Builder isOpenLog(boolean open) {
            this.isOpenLog = open;
            return this;
        }

        public HiidoInitParam build() {
            HiidoInitParam param = new HiidoInitParam();
            param.context = this.context;
            param.appkey = this.appkey;
            param.appId = this.appId;
            param.fromChannel = this.fromChannel;
            param.version = this.version;
            param.statisListener = this.statisListener;
            param.actAdditionListener = this.actAdditionListener;
            param.testServer = this.testServer;
            param.isOpenCrashMonitor = this.isOpenCrashMonitor;
            param.isOpenSensorMonitor = this.isOpenSensorMonitor;
            param.uid = this.uid;
            param.isOpenLog = this.isOpenLog;
            return param;
        }
    }
}

