/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.seat;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.press.PressAlpha;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.gradienttextview.GradientColor;
import com.yy.framework.core.ui.gradienttextview.TextGradientHelper;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.widget.StrokeTextView;
import com.yy.hiyo.channel.plugins.general.R;
import com.yy.hiyo.wallet.base.privilege.bean.NobleColorConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.uinfo.api.uinfo.ESexType;
import okhttp3.Call;

public class VoiceSeatView
extends HorizontalScrollView {
    private static final String TAG = "VoiceSeatView";
    private List<View> mSeatViewList = new ArrayList<View>();
    private static final String IMAGE_POSTFIX = YYImageUtils.getThumbnailPostfix((int)75);
    private SeatMvp.IView.OnSeatItemListener mOnSeatItemListener;
    private HeadFrameType mHeadFrameType;
    @ColorInt
    private static final int SPEAK_COLOR = Color.parseColor((String)"#28d5a5");
    @ColorInt
    private static final int HOST_SPEAK_COLOR = Color.parseColor((String)"#ffc102");
    @ColorInt
    private static final int WAVE_COLOR = Color.parseColor((String)"#38B95F");
    private IChannelPageContext mPageContext;
    private static final int DEFAULT_SIZE = (ScreenUtils.getInstance().getWidthPixels() - ResolutionUtils.dip2Px((float)64.0f) - ResolutionUtils.dip2Px((float)54.0f)) / 7;
    private static final int AVATAR_WIDTH = DEFAULT_SIZE - ResolutionUtils.dip2Px((float)6.0f);
    private YYLinearLayout mRoot;

    public VoiceSeatView(Context context) {
        super(context);
        this.initView();
    }

    public VoiceSeatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public VoiceSeatView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        this.setHorizontalScrollBarEnabled(false);
        this.mHeadFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
        this.mRoot = new YYLinearLayout(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.mRoot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mRoot.setOrientation(0);
        this.mRoot.setPadding(ResolutionUtils.dip2Px((float)13.0f), 0, 0, 0);
        this.addView((View)this.mRoot);
        Kvo.addKvoBinding((KvoSource)this.mHeadFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
    }

    public void updateSeat(int index, SeatItem seatData) {
        if (this.mSeatViewList.size() <= index) {
            return;
        }
        if (PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid) != null && StringUtils.isNotEmpty((String)PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid).getColor())) {
            this.updateNickColor(PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid).getColor(), index);
        }
    }

    public void setSeatData(List<SeatItem> seatDataList) {
        if (seatDataList == null || seatDataList.size() == 0) {
            MLog.info((Object)TAG, (String)"setSeatCount zero", (Object[])new Object[0]);
            return;
        }
        int count = seatDataList.size();
        int singleLayoutWidth = DEFAULT_SIZE;
        this.mRoot.removeAllViews();
        for (int i = 0; i < count; ++i) {
            final SeatItem seatItem = seatDataList.get(i);
            View seatView = null;
            if (this.mSeatViewList.size() == 0) {
                seatView = View.inflate((Context)this.getContext(), (int)R.layout.item_voice_seat_view_channel, null);
                this.mSeatViewList.add(seatView);
            } else if (this.mSeatViewList.size() > i) {
                seatView = this.mSeatViewList.get(i);
            } else {
                seatView = View.inflate((Context)this.getContext(), (int)R.layout.item_voice_seat_view_channel, null);
                this.mSeatViewList.add(seatView);
            }
            this.mRoot.addView(seatView);
            seatView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (VoiceSeatView.this.mOnSeatItemListener != null) {
                        VoiceSeatView.this.mOnSeatItemListener.onAvatarClick(seatItem);
                    }
                }
            });
            LinearLayout.LayoutParams seatViewLayoutParams = (LinearLayout.LayoutParams)seatView.getLayoutParams();
            seatViewLayoutParams.width = singleLayoutWidth;
            if (i > 0) {
                seatViewLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)9.0f);
            }
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)seatViewLayoutParams);
            HeadFrameImageView avatar = (HeadFrameImageView)seatView.findViewById(R.id.iv_voice_seat_avatar);
            int avatarLayoutWidth = AVATAR_WIDTH;
            avatar.setFrameWidthAndHeight(avatarLayoutWidth);
            this.initAvatar(seatItem, avatar);
            StrokeTextView tvNick = (StrokeTextView)seatView.findViewById(R.id.tv_nick_name);
            tvNick.setMaxWidth(avatarLayoutWidth);
            this.initNick(seatItem, tvNick);
            RecycleImageView rvMic = (RecycleImageView)seatView.findViewById(R.id.rv_micIcon);
            this.initMic(seatItem, rvMic);
            WaveView wvSpeak = (WaveView)seatView.findViewById(R.id.wv_speak_anim);
            ViewGroup.LayoutParams waveParams = wvSpeak.getLayoutParams();
            waveParams.width = avatarLayoutWidth;
            waveParams.height = avatarLayoutWidth;
            this.initSpeakAnimation(wvSpeak, waveParams.width);
        }
    }

    public void startSpeakAnim(int index) {
        if (this.mSeatViewList.size() <= index) {
            return;
        }
        WaveView wvSpeak = (WaveView)this.mSeatViewList.get(index).findViewById(R.id.wv_speak_anim);
        wvSpeak.setColor(WAVE_COLOR);
        wvSpeak.start();
        HeadFrameImageView avatar = (HeadFrameImageView)this.mSeatViewList.get(index).findViewById(R.id.iv_voice_seat_avatar);
        avatar.getCircleImageView().setBorderColor(WAVE_COLOR);
    }

    public void stopSpeakAnim(int index) {
        if (this.mSeatViewList.size() <= index) {
            return;
        }
        WaveView wvSpeak = (WaveView)this.mSeatViewList.get(index).findViewById(R.id.wv_speak_anim);
        wvSpeak.stop();
        HeadFrameImageView avatar = (HeadFrameImageView)this.mSeatViewList.get(index).findViewById(R.id.iv_voice_seat_avatar);
        avatar.getCircleImageView().setBorderColor(17170445);
    }

    private void initSpeakAnimation(WaveView wvSpeak, int size) {
        if (wvSpeak == null) {
            return;
        }
        wvSpeak.setDuration(2000L);
        wvSpeak.setStyle(Paint.Style.FILL);
        wvSpeak.setMaxRadiusRate(1.4f);
        wvSpeak.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        wvSpeak.setInitialRadius((float)(size / 2));
    }

    private void initMic(SeatItem seatData, RecycleImageView rvMic) {
        if (seatData == null || rvMic == null) {
            return;
        }
        if (seatData.isMicForbidden()) {
            rvMic.setVisibility(0);
            rvMic.setImageResource(R.drawable.icon_voiceforbid);
        } else if (!seatData.isMicOpen()) {
            rvMic.setImageResource(R.drawable.icon_voiceoff);
            rvMic.setVisibility(0);
        } else {
            rvMic.setVisibility(8);
        }
    }

    private void initNick(SeatItem seatData, StrokeTextView tvNick) {
        if (tvNick == null) {
            return;
        }
        this.setNick(seatData.userInfo.nick, tvNick, (NobleColorConfig)seatData.nobleColor.getValue());
        if (PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid) != null && StringUtils.isNotEmpty((String)PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid).getColor())) {
            tvNick.setTextColor(ColorUtils.parseColor((String)PrivilegeHelper.INSTANCE.getNickColorConfig(seatData.uid).getColor()));
        }
        if (this.mPageContext != null) {
            seatData.nickNameColor.observe((LifecycleOwner)this.mPageContext.getLifecycleOwner(), color2 -> {
                if (StringUtils.isNotEmpty((String)color2)) {
                    tvNick.setTextColor(ColorUtils.parseColor((String)color2));
                }
            });
            seatData.isNoble.observe((LifecycleOwner)this.mPageContext.getLifecycleOwner(), isNoble -> {
                if (isNoble.booleanValue()) {
                    tvNick.setStrokeWidth(ResolutionUtils.dip2Px((float)1.0f));
                    tvNick.setTextColor(ColorUtils.parseColor((String)"#FF4A6D"));
                    tvNick.setStrokeColor(-1);
                    tvNick.setNeedStroke(true);
                } else {
                    tvNick.setTextColor(ColorUtils.parseColor((String)"#999999"));
                    tvNick.setNeedStroke(false);
                }
            });
            seatData.nobleColor.observe((LifecycleOwner)this.mPageContext.getLifecycleOwner(), nobleColorConfig -> this.setNickColor(tvNick, (NobleColorConfig)nobleColorConfig));
        }
    }

    private void setNickColor(StrokeTextView tvNick, NobleColorConfig nobleColorConfig) {
        if (PrivilegeHelper.INSTANCE.getNobleColorService().isValid(nobleColorConfig)) {
            tvNick.setStrokeWidth(ResolutionUtils.dip2Px((float)1.0f));
            tvNick.setStrokeColor(-1);
            tvNick.setNeedStroke(true);
            tvNick.setGradientColor(this.getGradientColor(nobleColorConfig));
        } else {
            tvNick.setTextColor(ColorUtils.parseColor((String)"#999999"));
            tvNick.setNeedStroke(false);
            TextGradientHelper.INSTANCE.clearGradient((TextView)tvNick);
        }
    }

    private void setNick(String nick, StrokeTextView tvNick, NobleColorConfig nobleColorConfig) {
        tvNick.setText((CharSequence)nick);
        this.setNickColor(tvNick, nobleColorConfig);
    }

    private GradientColor getGradientColor(NobleColorConfig nobleColorConfig) {
        ArrayList<Integer> colorList = new ArrayList<Integer>();
        if (!FP.empty((Collection)nobleColorConfig.getColors())) {
            for (String color2 : nobleColorConfig.getColors()) {
                colorList.add(ColorUtils.parseColor((String)color2));
            }
        }
        return new GradientColor(nobleColorConfig.getType(), nobleColorConfig.getDirection(), colorList, nobleColorConfig.isRoll());
    }

    public void updateNickColor(String color2, int index) {
        if (this.mSeatViewList.size() <= index) {
            return;
        }
        TextView tvNick = (TextView)this.mSeatViewList.get(index).findViewById(R.id.tv_nick_name);
        if (StringUtils.isNotEmpty((String)color2)) {
            tvNick.setTextColor(ColorUtils.parseColor((String)color2));
        }
    }

    private void initAvatar(final SeatItem seatData, final HeadFrameImageView avatar) {
        if (seatData == null || avatar == null) {
            return;
        }
        avatar.setTag((Object)seatData.uid);
        ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(seatData.uid, new OnGetHeadFrameCallback(){

            public void onGetHeadFrameSuccess(List<Integer> list) {
                if (list == null) {
                    MLog.info((Object)VoiceSeatView.TAG, (String)"initAvatar getSingleHeadFrame list null", (Object[])new Object[0]);
                    return;
                }
                if (list.size() == 0) {
                    MLog.info((Object)VoiceSeatView.TAG, (String)"initAvatar getSingleHeadFrame list size 0", (Object[])new Object[0]);
                    return;
                }
                if (avatar != null) {
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)VoiceSeatView.TAG, (String)"initAvatar getSingleHeadFrame uid:%s, headFrame:%s", (Object[])new Object[]{seatData.uid, list.get(0)});
                    }
                    if (list.get(0) == 0) {
                        avatar.setHeadFrame(null);
                        return;
                    }
                    avatar.setFrameWidthAndHeight(AVATAR_WIDTH);
                    avatar.setHeadFrame(((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(list.get(0).intValue()), 0.9f);
                }
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)VoiceSeatView.TAG, (String)"initAvatar getSingleHeadFrame exception:%s", (Object[])new Object[]{e});
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.info((Object)VoiceSeatView.TAG, (String)"initAvatar getSingleHeadFrame message:%s", (Object[])new Object[]{message});
            }
        });
        this.loadAvatar(seatData, avatar);
        PressAlpha.of((View)avatar.getCircleImageView(), (float)1.0f);
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mSeatViewList.size() == 0) {
            return;
        }
        HeadFrameImageView avatar = (HeadFrameImageView)this.mSeatViewList.get(0).findViewById(R.id.iv_voice_seat_avatar);
        long uid = (Long)avatar.getTag();
        if (uid != AccountUtil.getUid()) {
            return;
        }
        if (avatar != null) {
            MLog.info((Object)TAG, (String)"SeatItemHolder onMyHeadFrameTypeUpdate:%s", (Object[])new Object[]{(int)((HeadFrameType)event.source()).headFrameType});
            avatar.setHeadFrame(((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache((int)((HeadFrameType)event.source()).headFrameType), 0.9f);
        }
    }

    public void setOnSeatItemListener(SeatMvp.IView.OnSeatItemListener onSeatItemListener) {
        this.mOnSeatItemListener = onSeatItemListener;
    }

    public void destroy() {
        if (this.mHeadFrameType != null) {
            Kvo.removeKvoBinding((KvoSource)this.mHeadFrameType, (Object)((Object)this), (String)"onMyHeadFrameTypeUpdate");
        }
    }

    public int getViewSize() {
        return this.mSeatViewList.size();
    }

    public View getAvatar(int index) {
        if (this.mSeatViewList.size() <= index) {
            return null;
        }
        HeadFrameImageView avatar = (HeadFrameImageView)this.mSeatViewList.get(index).findViewById(R.id.iv_voice_seat_avatar);
        return avatar;
    }

    private void loadAvatar(SeatItem seatData, HeadFrameImageView avatar) {
        if (avatar.getTag(R.id.channel_seat_view_id) != null && ((String)avatar.getTag(R.id.channel_seat_view_id)).equals(seatData.userInfo.avatar)) {
            return;
        }
        int defaultAvatar = seatData.userInfo.sex == ESexType.ESTFemale.getValue() ? R.drawable.icon_avatar_default_female : R.drawable.icon_avatar_default_male;
        ImageLoader.with((ImageView)avatar.getCircleImageView(), (String)(seatData.userInfo.avatar + IMAGE_POSTFIX)).placeholder(ResourceUtils.getDrawable((int)defaultAvatar)).error(defaultAvatar).load();
        avatar.setTag(R.id.channel_seat_view_id, (Object)seatData.userInfo.avatar);
    }

    public void setPageContext(IChannelPageContext pageContext) {
        this.mPageContext = pageContext;
    }

    public View getItemView(int index) {
        return index >= 0 && index < this.mSeatViewList.size() ? this.mSeatViewList.get(index) : null;
    }
}

