/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.seat;

import com.yy.appbase.account.AccountUtil;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IBeforeSeatUpdateListener;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.general.innerpresenter.InviteVoiceCallPresenter;
import com.yy.hiyo.channel.plugins.general.seat.VoiceChatSeatViewWrapper;
import java.util.ArrayList;
import java.util.List;

public class VoiceChatSeatPresenter
extends SeatPresenter<VoiceChatSeatViewWrapper> {
    private IBeforeSeatUpdateListener mBeforeSeatUpdateListener = new IBeforeSeatUpdateListener(){

        public void beforeSeatUpdate(List<SeatUser> seatList) {
            List seatData = VoiceChatSeatPresenter.this.genSeatData(seatList);
            seatList.clear();
            seatList.addAll(seatData);
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        List seatList = this.getChannel().getSeatService().getSeatList();
        this.getChannel().getSeatService().update(this.genSeatData(seatList), true);
    }

    public void onDestroy() {
        super.onDestroy();
        this.getChannel().getSeatService().removeBeforeUpdateSeatListener(this.mBeforeSeatUpdateListener);
        if (null != this.getVoiceCallSeatViewWrapper()) {
            this.getVoiceCallSeatViewWrapper().destroy();
        }
    }

    private List<SeatUser> genSeatData(List<SeatUser> list) {
        ArrayList<SeatUser> seatData = new ArrayList<SeatUser>();
        for (SeatUser seat : list) {
            if (seat.uid == AccountUtil.getUid()) {
                seatData.add(0, seat);
                continue;
            }
            seatData.add(seat);
        }
        return seatData;
    }

    protected VoiceChatSeatViewWrapper createSeatViewWrapper() {
        VoiceChatSeatViewWrapper wrapper = new VoiceChatSeatViewWrapper((IChannelPageContext)this.getMvpContext(), (SeatMvp.IView.OnSeatItemListener)this);
        wrapper.setPresenter((SeatMvp.IPresenter)this);
        return wrapper;
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        super.onSeatUpdate(seatUserList);
        if (this.getChannel().getSeatService().hasUserInSeat()) {
            this.setSeatVisibility(true);
        } else {
            this.setSeatVisibility(false);
        }
    }

    protected List<SeatItem> createSeatItems(List<SeatUser> seatList) {
        ArrayList<SeatItem> seatItems = new ArrayList<SeatItem>();
        for (SeatUser seatUser : seatList) {
            if (seatUser.uid <= 0L) continue;
            SeatItem item = new SeatItem();
            this.initSeat(item, seatUser);
            if (seatUser.uid == AccountUtil.getUid()) {
                seatItems.add(0, item);
                continue;
            }
            seatItems.add(item);
        }
        return seatItems;
    }

    public void updateSeatState(int state, int myRole) {
        if (this.getVoiceCallSeatViewWrapper() != null) {
            this.getVoiceCallSeatViewWrapper().updateSeatState(state, myRole);
        }
    }

    public void viewCreated() {
        this.getPresenter(InviteVoiceCallPresenter.class);
    }

    public VoiceChatSeatViewWrapper getVoiceCallSeatViewWrapper() {
        return (VoiceChatSeatViewWrapper)this.mSeatViewWrapper;
    }

    public void clickJoin() {
        if (this.getChannel().getMediaService().getMediaIntercepter() != null) {
            this.getChannel().getMediaService().getMediaIntercepter().tryJoinVoiceChat(true, (IChannel)this.getChannel(), new Runnable(){

                @Override
                public void run() {
                    ((InviteVoiceCallPresenter)VoiceChatSeatPresenter.this.getPresenter(InviteVoiceCallPresenter.class)).clickJoin();
                }
            }, new Runnable(){

                @Override
                public void run() {
                }
            });
        } else {
            ((InviteVoiceCallPresenter)this.getPresenter(InviteVoiceCallPresenter.class)).clickJoin();
        }
    }

    protected void seatVisibilityChanged(boolean visiable) {
        super.seatVisibilityChanged(visiable);
        this.getVoiceCallSeatViewWrapper().seatVisibilityChanged(visiable);
    }
}

