/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.util.Log;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.CacheController;
import com.yy.mobile.http.DateParseException;
import com.yy.mobile.http.DateUtils;
import com.yy.mobile.http.DefaultCacheController;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.ResponseData;
import java.util.Map;

public class HttpHeaderParser {
    private static final String[] MY_DEFAULT_DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss"};

    public static Cache.Entry parseCacheHeaders(ResponseData response, Request request) {
        return HttpHeaderParser.parseCacheHeaders(response, new DefaultCacheController(), request);
    }

    public static Cache.Entry parseCacheHeaders(ResponseData response, CacheController cacheController, Request request) {
        long now = System.currentTimeMillis();
        Map<String, String> headers = response.headers;
        long serverDate = 0L;
        long serverExpires = 0L;
        long calExpire = 0L;
        long maxAge = 0L;
        boolean hasCacheControl = false;
        String serverEtag = null;
        String headerValue = headers.get("Date");
        if (headerValue != null) {
            serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        if ((headerValue = headers.get("Cache-Control")) != null) {
            hasCacheControl = true;
            String[] tokens = headerValue.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (token.equals("no-cache") || token.equals("no-store")) {
                    return null;
                }
                if (token.startsWith("max-age=")) {
                    try {
                        maxAge = Long.parseLong(token.substring(8));
                    }
                    catch (Exception e) {
                        Log.e((String)"HttpHeaderParser", (String)"Empty Catch on parseCacheHeaders", (Throwable)e);
                    }
                    continue;
                }
                if (!token.equals("must-revalidate") && !token.equals("proxy-revalidate")) continue;
                maxAge = 0L;
            }
        }
        if ((headerValue = headers.get("Expires")) != null) {
            serverExpires = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        serverEtag = HttpHeaderParser.getETag(headers);
        if (hasCacheControl) {
            calExpire = now + maxAge * 1000L;
        } else if (serverDate > 0L && serverExpires >= serverDate) {
            calExpire = now + (serverExpires - serverDate);
        }
        Cache.Entry entry = new Cache.Entry();
        entry.data = response.data;
        entry.etag = serverEtag;
        entry.softTtl = calExpire;
        entry.ttl = calExpire;
        entry.serverDate = serverDate;
        entry.responseHeaders = headers;
        entry = cacheController.onIntercept(request, entry);
        return entry;
    }

    public static long parseDateAsEpoch(String dateStr) {
        try {
            return DateUtils.parseDate(dateStr).getTime();
        }
        catch (DateParseException e) {
            try {
                return DateUtils.parseDate(dateStr, MY_DEFAULT_DATE_PATTERNS).getTime();
            }
            catch (DateParseException e1) {
                HttpLog.e(e1, "Parse server date error", new Object[0]);
                return 0L;
            }
        }
    }

    public static String parseCharset(Map<String, String> headers) {
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            String[] params = contentType.split(";");
            for (int i = 1; i < params.length; ++i) {
                String[] pair = params[i].trim().split("=");
                if (pair.length != 2 || !pair[0].equals("charset")) continue;
                return pair[1];
            }
        }
        return "UTF-8";
    }

    public static String getETag(Map<String, String> headers) {
        String serverEtag = headers.get("ETag");
        if (serverEtag == null) {
            serverEtag = headers.get("Etag");
        }
        if (serverEtag != null) {
            serverEtag = serverEtag.replace("\"", "");
        }
        return serverEtag;
    }
}

