/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.network;

import com.yy.base.net.NetworkConnection;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequest;
import com.yy.mobile.http.DownloadNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ServerError;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MyDownloadNetwork
extends DownloadNetwork {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private DownloadRequest mRequest;

    public MyDownloadNetwork(String downloadFilePath, DownloadRequest request) {
        super(downloadFilePath);
        this.mRequest = request;
    }

    public void deleteTempFile() {
        File tempFile = new File(this.mDownloadFileTempPath);
        if (tempFile.exists() && tempFile.isFile()) {
            tempFile.delete();
        }
    }

    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        if (this.mRequest != null) {
            this.mRequest.onPerform();
        }
        ResponseData result = null;
        try {
            result = super.performRequest(request);
            if (this.mRequest != null) {
                this.mRequest.onPerformEnd(null);
            }
            if (request.isCanceled()) {
                this.deleteTempFile();
            }
            return result;
        }
        catch (RequestError e) {
            if (this.mRequest != null) {
                this.mRequest.onPerformEnd(e);
            }
            if (request.isCanceled()) {
                this.deleteTempFile();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] entityToBytes(Request<?> request, NetworkConnection.Connected connected, int httpCode) throws IOException, ServerError {
        int statusCode = connected.getResponseCode();
        if (request != null && this.mRequest != null) {
            this.mRequest.onHttpResponsed(statusCode, request, connected);
        }
        if (statusCode < 200 || statusCode > 299) {
            if (HttpLog.isDebug()) {
                HttpLog.d("Download error: %d", statusCode);
            }
            return super.entityToBytes(request, connected, statusCode);
        }
        if (request == null || request.getRequestProcessor() == null) {
            throw new IOException("request params error httpcode = " + statusCode);
        }
        File file = new File(this.mDownloadFileTempPath);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[4096];
        InputStream in = null;
        try {
            int count;
            in = connected.getInputStream();
            if (in == null) {
                throw new ServerError("input stream is null", 111, statusCode);
            }
            long total = connected.getContentLength();
            if (HttpLog.isDebug()) {
                HttpLog.d("Download content length %d", total);
            }
            long progress = 0L;
            while ((count = in.read(buffer)) != -1) {
                if (request.isCanceled()) {
                    if (HttpLog.isDebug()) {
                        HttpLog.d("MyDownloadNetwork Download cancel. %s ", request.getUrl());
                    }
                    connected.cancel();
                    this.onCancel(progress);
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                ((OutputStream)outputStream).write(buffer, 0, count);
                progress += (long)count;
                if (this.mRequest != null) {
                    this.mRequest.onReceivedSizeUpdated(progress);
                }
                if (progress != total && !this.needProgress(count, total, request, progress)) continue;
                ProgressInfo progressInfo = new ProgressInfo(progress, total);
                request.postProgress(progressInfo);
            }
            if (progress != total || total == 0L) {
                HttpLog.e("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
                HttpLog.e("contentLength %d, downloaded size %d", total, progress);
            } else if (HttpLog.isDebug()) {
                HttpLog.d("Downloaded size:" + String.valueOf(progress), new Object[0]);
            }
            if (HttpLog.isDebug()) {
                HttpLog.d("File download completed", new Object[0]);
            }
            boolean tempFileExisted = file.exists() && file.isFile();
            long tempFileSize = file.length();
            boolean renameFileReulst = file.renameTo(new File(this.mDownloadFilePath));
            if (!renameFileReulst) {
                if (this.mRequest != null) {
                    this.mRequest.onRenameError(tempFileExisted, tempFileSize);
                }
                HttpLog.e("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
                HttpLog.e("File rename failed", new Object[0]);
            } else if (HttpLog.isDebug()) {
                HttpLog.d("File rename completed", new Object[0]);
            }
            byte[] byArray = this.mDownloadFilePath.getBytes();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
            ((OutputStream)outputStream).close();
        }
    }
}

