/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.base;

import android.content.Context;
import android.os.Environment;
import android.os.SystemClock;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYNormalThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.UnzipError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DownloadUtil {
    public static final String GOOGLE_URL = "www.google.com";
    public static final String UNZIP_DIR_NAME = "unzip";
    public static final String ZIP = ".zip";
    public static final int MAX_FILE_LENGTH = 255;
    public static final String SEGMENT_INFO_POSIX = ".temp";
    public static final int MAX_DOWNLOAD_FILE_NAME_LENGTH = 255 - ".temp".length();
    private static final String[] FILE_NAME_FILTER_CHARS = new String[]{"'", "<", ">", "%", "\"\"", ",", ";", "||", "[", "]", "&", "*", "/", "|", "\"", ":", "\\", "?", "\u3010", "\u3011"};
    private static volatile OkHttpClient sCheckClient = null;
    private static boolean sConnectedGoogleResult = false;
    private static long sLastConnectedGoogle = -1L;
    private static final int FILE_INTERCEPT_LENGTH = 64;

    public static String verifyDownloadFileName(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        if (!FileUtils.isFileNameCorrect((String)fileName)) {
            fileName = FileUtils.fixFileName((String)fileName);
        }
        for (String fileNameFilterChar : FILE_NAME_FILTER_CHARS) {
            fileName = fileName.replace(fileNameFilterChar, " ");
        }
        if ((fileName = fileName.trim()).startsWith(".")) {
            fileName = "YYDownload_temp" + fileName;
        }
        int maxFileNameLen = MAX_DOWNLOAD_FILE_NAME_LENGTH;
        if (fileName.length() >= maxFileNameLen) {
            fileName = DownloadUtil.reduceFileName(fileName, maxFileNameLen);
        }
        return fileName;
    }

    public static String reduceFileName(String fileName, int maxLen) {
        if (null == fileName || fileName.length() < maxLen) {
            return fileName;
        }
        if (maxLen <= 0) {
            return fileName;
        }
        String extension = DownloadUtil.getExtension(fileName);
        if (null == extension) {
            return fileName.substring(0, maxLen);
        }
        int nameEndIndex = maxLen - extension.length() - 1;
        if (nameEndIndex < 0) {
            return fileName.substring(0, maxLen);
        }
        return fileName.substring(0, nameEndIndex) + "." + extension;
    }

    public static String getExtension(String fileName) {
        if (null == fileName) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex <= 0 || dotIndex == fileName.length() - 1) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    public static void unzip(String fileFullPath, String destFileFullPath) throws UnzipError {
        String parentPath;
        boolean result;
        if (StringUtils.isEmpty((String)fileFullPath) || StringUtils.isEmpty((String)destFileFullPath)) {
            throw new UnzipError("filePath empty", 72, 200);
        }
        File fileToUnzip = new File(fileFullPath);
        if (!fileToUnzip.exists()) {
            throw new UnzipError("file to unzip " + fileToUnzip.getPath() + "not existed", 72, 200);
        }
        File realFileToUnZip = fileToUnzip;
        if (StringUtils.equals((String)destFileFullPath, (String)fileFullPath) && !(result = fileToUnzip.renameTo(realFileToUnZip = new File(parentPath = fileToUnzip.getParent(), fileToUnzip.getName() + ZIP)))) {
            throw new UnzipError("renameTo error:" + fileToUnzip.getPath() + " realFileToUnZip:" + realFileToUnZip.getPath(), 72, 200);
        }
        File unzipDestDir = new File(destFileFullPath);
        if (unzipDestDir.exists()) {
            if (unzipDestDir.isFile()) {
                unzipDestDir.delete();
                unzipDestDir.mkdir();
            } else if (unzipDestDir.isDirectory()) {
                FileUtils.deleteFile((File)new File(unzipDestDir.getPath()));
            }
        } else {
            unzipDestDir.mkdirs();
        }
        try {
            YYFileUtils.getFileMD5String((File)realFileToUnZip, (long)0L);
            YYFileUtils.unZip((String)realFileToUnZip.getPath(), (String)unzipDestDir.getPath());
        }
        catch (Exception e) {
            DownloadUtil.deleteDir(unzipDestDir);
            if (realFileToUnZip != fileToUnzip) {
                realFileToUnZip.renameTo(fileToUnzip);
            }
            MLog.error((Object)"DownloadUtil", (String)("DynamicLoad, unzip so error: " + e.toString()), (Object[])new Object[0]);
            throw new UnzipError(null, (Throwable)e, 72, 200);
        }
    }

    public static void deleteDir(File dir) {
        if (dir != null) {
            if (dir.isDirectory()) {
                FileUtils.deleteFile((File)new File(dir.getPath()));
            }
            dir.delete();
        }
    }

    public static File getTaskFile(DownloadTask task) {
        if (task == null) {
            return null;
        }
        String filePath = task.getString("path");
        String fileName = task.getString("filename");
        if (StringUtils.isEmpty((String)filePath) || StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        return new File(filePath, fileName);
    }

    public static String getHostFromUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return "";
        }
        try {
            URL uri = new URL(url);
            return uri.getHost();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static long getAvailableInternalSpace() {
        File path = Environment.getDataDirectory();
        return path.getUsableSpace() / 1024L;
    }

    public static long getUsableSpace(File path) {
        return path.getUsableSpace() / 1024L;
    }

    public static long getTotalInternalSpace() {
        File path = Environment.getDataDirectory();
        return path.getTotalSpace() / 1024L;
    }

    public static boolean isNetWorkOkByConnectedGoogle() {
        long curTime = -1L;
        if (sLastConnectedGoogle == -1L) {
            curTime = SystemClock.elapsedRealtime();
            sConnectedGoogleResult = DownloadUtil.isNetWorkOkByConnectedUrl("https://www.google.com");
            sLastConnectedGoogle = curTime;
        } else {
            curTime = SystemClock.elapsedRealtime();
            if (sLastConnectedGoogle + 30000L < curTime) {
                sConnectedGoogleResult = DownloadUtil.isNetWorkOkByConnectedUrl("https://www.google.com");
                sLastConnectedGoogle = curTime;
            }
        }
        return sConnectedGoogleResult;
    }

    public static boolean isNetWorkOkByConnectedUrl(String connectUrl) {
        if (StringUtils.isEmpty((String)connectUrl)) {
            return false;
        }
        try {
            OkHttpClient client = sCheckClient;
            if (client == null) {
                OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(3, 30L, TimeUnit.SECONDS));
                builder.retryOnConnectionFailure(false);
                builder.dispatcher(new Dispatcher((ExecutorService)new YYNormalThreadPoolExecutor(2)));
                client = builder.build();
            }
            Request request = new Request.Builder().url(connectUrl).get().build();
            Call call = client.newCall(request);
            Response response = call.execute();
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    sCheckClient = null;
                }
            }, (long)60000L);
            if (response != null && response.isSuccessful()) {
                response.close();
                return true;
            }
            response.close();
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadUtil", (Throwable)e);
        }
        return false;
    }

    public static boolean isScreenOn(Context context) {
        try {
            return SystemServiceUtils.getPowerManager((Context)context).isScreenOn();
        }
        catch (Exception e) {
            MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlContent(String strUrl) {
        if (strUrl == null) {
            return null;
        }
        int maxreadnum = 2500;
        InputStream stream = null;
        HttpURLConnection conn = null;
        String result = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            stream = conn.getInputStream();
            byte[] data = new byte[2500];
            int length = stream.read(data, 0, 2500);
            if (length > 0) {
                result = new String(data, 0, length);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {
                    MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileHead(File file) {
        if (file == null) {
            return null;
        }
        boolean success = true;
        FileInputStream in = null;
        int readSize = file.length() > 64L ? 64 : (int)file.length();
        byte[] data = new byte[readSize];
        try {
            in = new FileInputStream(file);
            in.read(data, 0, readSize);
        }
        catch (Exception e) {
            success = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (success) {
            return Hex.encodeHexStr(data, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileTail(File file) {
        if (file == null || file.length() <= 0L) {
            return null;
        }
        boolean success = true;
        long fileLength = file.length();
        long startIndex = fileLength - 64L > 0L ? fileLength - 64L : 0L;
        int readSize = (int)(fileLength - startIndex);
        byte[] data = new byte[readSize];
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(startIndex);
            randomAccessFile.read(data, 0, readSize);
        }
        catch (Exception e) {
            success = false;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    MLog.error((Object)"downloadutils", (String)(" error ignore: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (success) {
            return Hex.encodeHexStr(data, false);
        }
        return null;
    }

    public static class Hex {
        private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        protected static char[] encodeHex(byte[] data, char[] toDigits) {
            int l = data.length;
            char[] out = new char[l << 1];
            int j = 0;
            for (int i = 0; i < l; ++i) {
                out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
                out[j++] = toDigits[0xF & data[i]];
            }
            return out;
        }

        public static String encodeHexStr(byte[] data, boolean toLowerCase) {
            return Hex.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
        }

        protected static String encodeHexStr(byte[] data, char[] toDigits) {
            return new String(Hex.encodeHex(data, toDigits));
        }
    }
}

