/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.channellist.content.viewmodel;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import biz.CInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.architecture.Resource;
import com.yy.base.logger.MLog;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.bbs.base.callback.IGetTagListCallback;
import com.yy.hiyo.bbs.base.service.ITopicService;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.component.channellist.ChannelDrawerContext;
import com.yy.hiyo.channel.component.channellist.content.viewmodel.CommonContentViewModel;
import com.yy.hiyo.channel.module.selectgroup.data.SelectChannelInfo;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.ihago.channel.srv.mgr.GetRelateChannelReq;
import net.ihago.channel.srv.mgr.GetRelateChannelRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \"2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ0\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00142\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00112\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u0011H\u0002R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/yy/hiyo/channel/component/channellist/content/viewmodel/CommonContentViewModel;", "Lcom/yy/hiyo/mvp/base/BasePresenter;", "Lcom/yy/hiyo/channel/component/channellist/ChannelDrawerContext;", "Lcom/yy/hiyo/mvp/base/BaseViewModel;", "()V", "_channelList", "Landroidx/lifecycle/MutableLiveData;", "Lcom/yy/architecture/Resource;", "", "Lcom/yy/hiyo/channel/module/selectgroup/data/SelectChannelInfo;", "channelList", "Landroidx/lifecycle/LiveData;", "getChannelList", "()Landroidx/lifecycle/LiveData;", "loadChannelData", "", "data", "", "loadChannelList", "loadTagList", "Lcom/yy/hiyo/channel/base/bean/ChannelListData;", "next", "Lkotlin/Function1;", "requestSelectChannelData", "uid", "", "cid", "", "set", "", "updateChannelListItem", "totalCounts", "", "limitCounts", "Companion", "channel-subpage_debug"})
public class CommonContentViewModel
extends BasePresenter<ChannelDrawerContext> {
    private final MutableLiveData<Resource<List<SelectChannelInfo>>> _channelList = new MutableLiveData();
    @NotNull
    public static final String TAG = "CommonContentViewModel";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LiveData<Resource<List<SelectChannelInfo>>> getChannelList() {
        return (LiveData)this._channelList;
    }

    public final void loadChannelList() {
        block0: {
            this._channelList.setValue((Object)Resource.loading(null));
            IDataService iDataService = ((ChannelDrawerContext)this.getMvpContext()).getChannel().getDataService();
            if (iDataService == null) break block0;
            iDataService.getTopAndSubChannelInfos(new IDataService.IGetTopAndSubInfosCallBack(this){
                final /* synthetic */ CommonContentViewModel this$0;

                public void onSuccess(@NotNull String channelId2, @NotNull ChannelListData data, @Nullable List<Integer> totalCounts, @Nullable List<Integer> limitCounts, @Nullable ThemeItemBean themeItemBean) {
                    Intrinsics.checkParameterIsNotNull((Object)channelId2, (String)"channelId");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    MLog.info((Object)"CommonContentViewModel", (String)("loadChannelList onSuccess channelId: " + channelId2), (Object[])new Object[0]);
                    CommonContentViewModel.access$loadTagList(this.this$0, data, (Function1)new Function1<ChannelListData, Unit>(this, totalCounts, limitCounts){
                        final /* synthetic */ loadChannelList.1 this$0;
                        final /* synthetic */ List $totalCounts;
                        final /* synthetic */ List $limitCounts;

                        public final void invoke(@NotNull ChannelListData it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            CommonContentViewModel.access$updateChannelListItem(this.this$0.this$0, it, this.$totalCounts, this.$limitCounts);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$totalCounts = list;
                            this.$limitCounts = list2;
                            super(1);
                        }
                    });
                }

                public void onError(@Nullable String channelId2, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    MLog.error((Object)"CommonContentViewModel", (String)("loadChannelList onError channelId: " + channelId2 + " , errorCode: " + errorCode + " , error: " + e), (Object[])new Object[0]);
                    CommonContentViewModel.access$get_channelList$p(this.this$0).setValue((Object)Resource.error((String)errorTips, null));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void loadTagList(ChannelListData data, Function1<? super ChannelListData, Unit> next) {
        ArrayList arrayList = data.channels;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"data.channels");
        Sequence tags2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)arrayList), (Function1)loadTagList.tags.1.INSTANCE), (Function1)loadTagList.tags.2.INSTANCE), (Function1)loadTagList.tags.3.INSTANCE);
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        ((ITopicService)iServiceManager.getService(ITopicService.class)).getTagList(CollectionsKt.toList((Iterable)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)tags2, (Function1)loadTagList.1.INSTANCE))), new IGetTagListCallback(tags2, next, data){
            final /* synthetic */ Sequence $tags;
            final /* synthetic */ Function1 $next;
            final /* synthetic */ ChannelListData $data;

            public void onSuccess(@NotNull List<TagBean> tagInfoList, @Nullable String token) {
                Intrinsics.checkParameterIsNotNull(tagInfoList, (String)"tagInfoList");
                Map map2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)this.$tags, (Function1)loadTagList.onSuccess.map.1.INSTANCE));
                Iterable $this$forEach$iv = tagInfoList;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TagBean it = (TagBean)element$iv;
                    boolean bl = false;
                    ChannelTagItem channelTagItem = (ChannelTagItem)map2.get(it.getMId());
                    if (channelTagItem == null) continue;
                    channelTagItem.setName(it.getMText());
                }
                this.$next.invoke((Object)this.$data);
            }

            public void onError() {
                this.$next.invoke((Object)this.$data);
            }
            {
                this.$tags = $captured_local_variable$0;
                this.$next = $captured_local_variable$1;
                this.$data = $captured_local_variable$2;
            }

            public void onPartialSuccess(@NotNull List<TagBean> tagBeanList) {
                Intrinsics.checkParameterIsNotNull(tagBeanList, (String)"tagBeanList");
                IGetTagListCallback.DefaultImpls.onPartialSuccess((IGetTagListCallback)this, tagBeanList);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateChannelListItem(ChannelListData data, List<Integer> totalCounts, List<Integer> limitCounts) {
        Resource resource;
        MutableLiveData<Resource<List<SelectChannelInfo>>> mutableLiveData = this._channelList;
        if (data == null) {
            resource = Resource.error((String)"no response", null);
        } else if (data.channels == null) {
            resource = Resource.success((Object)CollectionsKt.emptyList());
        } else if (data.channels.isEmpty()) {
            resource = Resource.success((Object)CollectionsKt.emptyList());
        } else {
            void $this$forEachIndexed$iv;
            List list;
            MutableLiveData<Resource<List<SelectChannelInfo>>> mutableLiveData2 = mutableLiveData;
            boolean bl = false;
            List dataList = list = (List)new ArrayList();
            ArrayList arrayList = data.channels;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"data.channels");
            Iterable iterable = arrayList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void channelDetailInfo;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                ChannelDetailInfo channelDetailInfo2 = (ChannelDetailInfo)item$iv;
                int index = n2;
                boolean bl3 = false;
                SelectChannelInfo selectChannelInfo = new SelectChannelInfo();
                if (totalCounts != null && totalCounts.size() > index) {
                    selectChannelInfo.setTotalNum(((Number)totalCounts.get(index)).intValue());
                }
                if (limitCounts != null && limitCounts.size() > index) {
                    selectChannelInfo.setLimitNum(((Number)limitCounts.get(index)).intValue());
                }
                if (channelDetailInfo.baseInfo.firstType != 0) {
                    selectChannelInfo.setTagId(channelDetailInfo.baseInfo.firstType);
                } else if (channelDetailInfo.baseInfo.secondType != 0) {
                    selectChannelInfo.setTagId(channelDetailInfo.baseInfo.secondType);
                }
                selectChannelInfo.getTagId();
                GroupChatClassificationData groupData = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getGroupCategoryFromCache(selectChannelInfo.getTagId());
                selectChannelInfo.setTagData(groupData);
                String string2 = channelDetailInfo.baseInfo.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channelDetailInfo.baseInfo.name");
                selectChannelInfo.setName(string2);
                String string3 = channelDetailInfo.baseInfo.avatar;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"channelDetailInfo.baseInfo.avatar");
                selectChannelInfo.setAvatar(string3);
                ChannelInfo channelInfo = channelDetailInfo.baseInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelInfo, (String)"channelDetailInfo.baseInfo");
                String string4 = channelInfo.getChannelId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"channelDetailInfo.baseInfo.channelId");
                selectChannelInfo.setCid(string4);
                String string5 = channelDetailInfo.baseInfo.password;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"channelDetailInfo.baseInfo.password");
                selectChannelInfo.setPassword(string5);
                selectChannelInfo.setShowDivider(false);
                selectChannelInfo.setVersion(channelDetailInfo.baseInfo.version);
                String string6 = channelDetailInfo.baseInfo.pid;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"channelDetailInfo.baseInfo.pid");
                selectChannelInfo.setPid(string6);
                dataList.add(selectChannelInfo);
            }
            mutableLiveData = mutableLiveData2;
            resource = Resource.success((Object)dataList);
        }
        mutableLiveData.setValue((Object)resource);
    }

    public final void requestSelectChannelData(long uid, @NotNull String cid, boolean set) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        GetRelateChannelReq req = new GetRelateChannelReq.Builder().uid(Long.valueOf(uid)).from_cid(cid).set(Boolean.valueOf(set)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetRelateChannelRes>(this){
            final /* synthetic */ CommonContentViewModel this$0;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull GetRelateChannelRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    boolean bl = false;
                    List dataList = new ArrayList<E>();
                    List cinfoList = message.cinfos;
                    if (cinfoList != null) {
                        Iterable $this$forEachIndexed$iv = cinfoList;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            List totalCountList;
                            void cInfo;
                            int n = index$iv++;
                            boolean bl2 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n2 = n;
                            CInfo cInfo2 = (CInfo)item$iv;
                            int index = n2;
                            boolean bl3 = false;
                            SelectChannelInfo data = new SelectChannelInfo();
                            String string2 = cInfo.avatar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cInfo.avatar");
                            data.setAvatar(string2);
                            String string3 = cInfo.name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cInfo.name");
                            data.setName(string3);
                            Boolean bl4 = cInfo.relate;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"cInfo.relate");
                            data.setSelect(bl4.booleanValue());
                            Integer n3 = cInfo.version;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"cInfo.version");
                            data.setVersion(n3.intValue());
                            String string4 = cInfo.cid;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"cInfo.cid");
                            data.setCid(string4);
                            String string5 = cInfo.password;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"cInfo.password");
                            data.setPassword(string5);
                            Integer n4 = cInfo.first_type;
                            if (n4 == null || n4 != 0) {
                                Integer n5 = cInfo.first_type;
                                Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"cInfo.first_type");
                                data.setTagId(n5.intValue());
                            } else {
                                Integer n6 = cInfo.second_type;
                                if (n6 == null || n6 != 0) {
                                    Integer n7 = cInfo.second_type;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"cInfo.second_type");
                                    data.setTagId(n7.intValue());
                                }
                            }
                            List totalLimitList = message.role_limit;
                            if (totalLimitList != null && totalLimitList.size() > index) {
                                E e = message.role_limit.get(index);
                                Intrinsics.checkExpressionValueIsNotNull(e, (String)"message.role_limit[index]");
                                data.setLimitNum(((Number)e).intValue());
                            }
                            if ((totalCountList = message.role_count) != null && totalCountList.size() > index) {
                                E e = message.role_count.get(index);
                                Intrinsics.checkExpressionValueIsNotNull(e, (String)"message.role_count[index]");
                                data.setTotalNum(((Number)e).intValue());
                            }
                            dataList.add(data);
                        }
                        MLog.info((Object)"CommonContentViewModel", (String)"getSelectChannelData, success, data:%s", (Object[])new Object[]{dataList});
                    }
                    this.this$0.loadChannelData(dataList);
                } else {
                    MLog.info((Object)"CommonContentViewModel", (String)"getSelectChannelData, fail, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"CommonContentViewModel", (String)"getSelectChannelData, fail, code:%s, msg:%s", (Object[])new Object[]{-1, "timeout"});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.info((Object)"CommonContentViewModel", (String)"getSelectChannelData, fail, code:%s, msg:%s", (Object[])new Object[]{code, reason});
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void loadChannelData(@NotNull List<SelectChannelInfo> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this._channelList.setValue((Object)(data.isEmpty() ? Resource.success((Object)CollectionsKt.emptyList()) : Resource.success(data)));
    }

    public static final /* synthetic */ MutableLiveData access$get_channelList$p(CommonContentViewModel $this) {
        return $this._channelList;
    }

    public static final /* synthetic */ void access$loadTagList(CommonContentViewModel $this, ChannelListData data, Function1 next) {
        $this.loadTagList(data, (Function1<? super ChannelListData, Unit>)next);
    }

    public static final /* synthetic */ void access$updateChannelListItem(CommonContentViewModel $this, ChannelListData data, List totalCounts, List limitCounts) {
        $this.updateChannelListItem(data, totalCounts, limitCounts);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/channellist/content/viewmodel/CommonContentViewModel$Companion;", "", "()V", "TAG", "", "channel-subpage_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

