/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.service;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.callback.IAdapterNotify;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JoinChannelUnreadManager {
    private CopyOnWriteArrayList<JoinedChannelInfo> mGroupInfos = new CopyOnWriteArrayList();
    private IAdapterNotify mNotify;
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener channelsListener;

    private IChannelCenterService.IControlConfigOrJoinedChannelsListener getChannelsListener() {
        if (this.channelsListener != null) {
            return this.channelsListener;
        }
        this.channelsListener = new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

            @Override
            public void onMyJoinedChannelsUnreadNumChange(HashMap<String, LastMsgAndUnreadData> datas) {
                if (datas == null) {
                    return;
                }
                for (JoinedChannelInfo groupInfo : JoinChannelUnreadManager.this.mGroupInfos) {
                    LastMsgAndUnreadData item;
                    if (!datas.containsKey(groupInfo.cid) || (item = datas.get(groupInfo.cid)) == null) continue;
                    groupInfo.unreadCount = item.unreadMsgNum;
                    JoinChannelUnreadManager.this.mNotify.notifyItem(JoinChannelUnreadManager.this.mGroupInfos.indexOf(groupInfo));
                }
            }

            @Override
            public void onMyJoinedChannelsUnreadNumChange(String cid, LastMsgAndUnreadData data) {
                if (StringUtils.isEmpty((String)cid) || data == null) {
                    return;
                }
                for (JoinedChannelInfo groupInfo : JoinChannelUnreadManager.this.mGroupInfos) {
                    if (groupInfo == null || !StringUtils.equal((String)groupInfo.cid, (String)cid)) continue;
                    groupInfo.unreadCount = data.unreadMsgNum;
                    JoinChannelUnreadManager.this.mNotify.notifyItem(JoinChannelUnreadManager.this.mGroupInfos.indexOf(groupInfo));
                    break;
                }
            }
        };
        return this.channelsListener;
    }

    public void init(List<JoinedChannelInfo> groupInfos, IAdapterNotify notify) {
        this.mNotify = notify;
        this.mGroupInfos.clear();
        if (groupInfos != null && !groupInfos.isEmpty()) {
            this.mGroupInfos.addAll(groupInfos);
        }
        if (this.channelsListener == null) {
            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).addConfigOrMyJoinedChannelsListener(this.getChannelsListener());
        }
    }
}

