/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel;

import android.os.SystemClock;
import androidx.annotation.MainThread;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.logger.MLog;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.ChannelListLocalStatHelper;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0007H\u0007J&\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0012H\u0007J*\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/yy/hiyo/channel/ChannelTimingStat;", "", "()V", "channelPageFirstFrameMillis", "", "enterChannelStartTimeMillis", "hasReport", "", "isCdnStream", "joinChannelRequestEndMillis", "joinLiveRoomEndMillis", "traceTag", "", "videoStreamOpenMills", "getEntryValue", "entry", "", "onChannelPageFirstFrame", "", "onJoinChannelRequestEnd", "onJoinLiveRoomEnd", "isCdn", "onLeave", "pluginMode", "isVideo", "fromTabType", "onVideoStreamOpen", "report", "pluginId", "reset", "start", "channelId", "Companion", "channel-base_release"})
public final class ChannelTimingStat {
    private long enterChannelStartTimeMillis;
    private long joinChannelRequestEndMillis;
    private long channelPageFirstFrameMillis;
    private long videoStreamOpenMills;
    private long joinLiveRoomEndMillis;
    private boolean hasReport;
    private boolean isCdnStream;
    private String traceTag = "";
    @NotNull
    public static final String TAG = "ChannelTimingStat";
    private static final int screenWidth;
    private static final int screenHeight;
    public static final Companion Companion;

    @MainThread
    public final void start(@NotNull String channelId) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        this.reset();
        this.enterChannelStartTimeMillis = SystemClock.elapsedRealtime();
        MLog.debug((Object)TAG, (String)("start join channel " + channelId), (Object[])new Object[0]);
        this.traceTag = "Channel:" + channelId;
        TimingTracer.beginTrace((String)this.traceTag);
        TimingTracer.addSplit((String)this.traceTag, (String)"enterChannel");
    }

    @MainThread
    public final void report(int pluginMode, @Nullable String pluginId, boolean isVideo, int entry) {
        MLog.debug((Object)TAG, (String)("end, pluginId: " + pluginId + ", isVideo: " + isVideo + ", entry: " + entry), (Object[])new Object[0]);
        TimingTracer.stopTrace((String)this.traceTag);
        if (this.hasReport || this.enterChannelStartTimeMillis <= 0L) {
            return;
        }
        this.hasReport = true;
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "channel_time");
        String string2 = pluginId;
        if (string2 == null) {
            string2 = "";
        }
        statContent.put("sfield", string2);
        statContent.put("sfieldtwo", isVideo ? "1" : "0");
        if (this.joinChannelRequestEndMillis > 0L) {
            statContent.put("ifield", this.joinChannelRequestEndMillis - this.enterChannelStartTimeMillis);
        }
        if (this.channelPageFirstFrameMillis > 0L) {
            statContent.put("ifieldtwo", this.channelPageFirstFrameMillis - this.enterChannelStartTimeMillis);
        }
        if (this.videoStreamOpenMills > 0L) {
            statContent.put("ifieldthree", this.videoStreamOpenMills - this.enterChannelStartTimeMillis);
        }
        statContent.put("sfieldfive", this.isCdnStream ? "1" : "0");
        statContent.put("ifieldfive", entry);
        if (this.joinLiveRoomEndMillis > 0L) {
            long duration = this.joinLiveRoomEndMillis - this.enterChannelStartTimeMillis;
            if (duration > (long)15000) {
                duration = 15000L;
            }
            statContent.put("ifieldfour", duration);
            if (pluginMode == 15) {
                HiidoStatis.reportAppMonitorReturnCode((String)"channel/multivideostart", (long)duration, (String)"0");
            } else {
                String fromSwip = this.getEntryValue(entry);
                IAB testValue = NewABDefine.VIDEO_WATCH_CDN_SOURCE_SWITCH.getTest();
                if (testValue == null || Intrinsics.areEqual((Object)testValue, (Object)NAB.B)) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("channel/videostart/2" + fromSwip), (long)duration, (String)"0");
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("channel/videostart/1" + fromSwip), (long)duration, (String)"0");
                }
            }
            statContent.put("sfieldthree", screenWidth);
            statContent.put("sfieldfour", screenHeight);
        }
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private final String getEntryValue(int entry) {
        return entry == 24 ? "/1" : "/0";
    }

    @MainThread
    public final void onJoinChannelRequestEnd() {
        if (this.hasReport || this.enterChannelStartTimeMillis <= 0L) {
            return;
        }
        this.joinChannelRequestEndMillis = SystemClock.elapsedRealtime();
        TimingTracer.addSplit((String)this.traceTag, (String)"onJoinChannelRequestEnd");
    }

    @MainThread
    public final void onChannelPageFirstFrame() {
        MLog.debug((Object)TAG, (String)"onChannelPageFirstFrame", (Object[])new Object[0]);
        if (this.hasReport || this.enterChannelStartTimeMillis <= 0L) {
            return;
        }
        this.channelPageFirstFrameMillis = SystemClock.elapsedRealtime();
        TimingTracer.addSplit((String)this.traceTag, (String)"onChannelPageFirstFrame");
    }

    @MainThread
    public final void onVideoStreamOpen() {
        MLog.debug((Object)TAG, (String)"onVideoStreamOpen ", (Object[])new Object[0]);
        if (this.hasReport || this.enterChannelStartTimeMillis <= 0L) {
            return;
        }
        this.videoStreamOpenMills = SystemClock.elapsedRealtime();
        TimingTracer.addSplit((String)this.traceTag, (String)"onVideoStreamOpen");
    }

    @MainThread
    public final void onJoinLiveRoomEnd(boolean isCdn) {
        MLog.debug((Object)TAG, (String)("onJoinLiveRoomEnd :" + isCdn), (Object[])new Object[0]);
        if (this.hasReport || this.enterChannelStartTimeMillis <= 0L) {
            return;
        }
        this.isCdnStream = isCdn;
        this.joinLiveRoomEndMillis = SystemClock.elapsedRealtime();
        TimingTracer.addSplit((String)this.traceTag, (String)"onJoinLiveRoomEnd");
    }

    public final void onLeave(int pluginMode, boolean isVideo, int fromTabType, int entry) {
        MLog.debug((Object)TAG, (String)("pluginMode: " + pluginMode + ", isVideo: " + isVideo + ", fromTabType: " + fromTabType + ", " + "entry:" + entry), (Object[])new Object[0]);
        String uri = "";
        String fromSwip = this.getEntryValue(entry);
        if (pluginMode == 15) {
            uri = "channel/multivideoleave";
        } else if (pluginMode == 14 && isVideo) {
            uri = "channel/leavevideo" + fromSwip;
        }
        if (this.enterChannelStartTimeMillis > 0L) {
            long duration;
            long l;
            String returnCode = null;
            if (this.joinLiveRoomEndMillis > 0L) {
                returnCode = "0";
                l = this.joinLiveRoomEndMillis - this.enterChannelStartTimeMillis;
            } else {
                returnCode = "1";
                l = duration = SystemClock.elapsedRealtime() - this.enterChannelStartTimeMillis;
            }
            if (!FP.empty((CharSequence)uri)) {
                HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)duration, (String)returnCode);
            }
            long stayDuration = SystemClock.elapsedRealtime() - this.enterChannelStartTimeMillis;
            if (fromTabType != -1 && stayDuration > 60000L) {
                MLog.debug((Object)TAG, (String)("stay " + stayDuration / (long)1000 + 's'), (Object[])new Object[0]);
                ChannelListLocalStatHelper.INSTANCE.onRoomStayAtTab(fromTabType);
            }
        }
        if (this.joinChannelRequestEndMillis > 0L && this.joinLiveRoomEndMillis <= 0L) {
            long duration = SystemClock.elapsedRealtime() - this.enterChannelStartTimeMillis;
            if (duration > (long)15000) {
                duration = 15000L;
            }
            if (pluginMode == 15) {
                HiidoStatis.reportAppMonitorReturnCode((String)"channel/multivideostart", (long)duration, (String)"1");
            } else if (isVideo) {
                IAB testValue = NewABDefine.VIDEO_WATCH_CDN_SOURCE_SWITCH.getTest();
                if (testValue == null || Intrinsics.areEqual((Object)testValue, (Object)NAB.B)) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("channel/videostart/2" + fromSwip), (long)duration, (String)"1");
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("channel/videostart/1" + fromSwip), (long)duration, (String)"1");
                }
            }
        }
        this.joinChannelRequestEndMillis = 0L;
    }

    private final void reset() {
        this.enterChannelStartTimeMillis = 0L;
        this.joinChannelRequestEndMillis = 0L;
        this.channelPageFirstFrameMillis = 0L;
        this.videoStreamOpenMills = 0L;
        this.joinLiveRoomEndMillis = 0L;
        this.isCdnStream = false;
    }

    static {
        Companion = new Companion(null);
        screenWidth = ResolutionUtils.getScreenWidth();
        screenHeight = ResolutionUtils.getScreenHeight();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/yy/hiyo/channel/ChannelTimingStat$Companion;", "", "()V", "TAG", "", "screenHeight", "", "getScreenHeight", "()I", "screenWidth", "getScreenWidth", "channel-base_release"})
    public static final class Companion {
        public final int getScreenWidth() {
            return screenWidth;
        }

        public final int getScreenHeight() {
            return screenHeight;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

