/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel;

import android.content.Context;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.Size;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.ResultGiftItemData;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameContainerListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameStatusChangeListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.IGamePanel;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.AutoStartPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.GameStartedPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.IPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.ReadyPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.ResultPublishPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.ResultWaitPanelPage;
import java.util.ArrayList;
import java.util.List;

public class BocaiGamePanel
extends YYRelativeLayout
implements IGamePanel {
    private static final String TAG = "FTWealthBocaiGamePanel";
    private FrameLayout mFlBgContainer;
    private TextView mTvGameInfo;
    private ImageView mIvClose;
    private ImageView mIvRule;
    private ImageView mIvRecord;
    private ImageView mIvPanelBg;
    private IPanelPage mCurrPanelPage;
    private IGameContainerListener mGameContainerListener;
    private IGameStatusChangeListener mGameStatusChangeListener;
    private int mGameStatus = 0;

    public BocaiGamePanel(Context context) {
        super(context);
        this.createView();
    }

    public BocaiGamePanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public BocaiGamePanel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView();
    }

    private void createView() {
        BocaiGamePanel.inflate((Context)this.getContext(), (int)R.layout.layout_bocai_base_game_panel_channel, (ViewGroup)this);
        this.mFlBgContainer = (FrameLayout)this.findViewById(R.id.fl_bg_container);
        this.mIvClose = (ImageView)this.findViewById(R.id.iv_close);
        this.mIvRule = (ImageView)this.findViewById(R.id.iv_rule);
        this.mIvRecord = (ImageView)this.findViewById(R.id.iv_record);
        this.mIvPanelBg = (ImageView)this.findViewById(R.id.iv_panel_bg);
        this.mTvGameInfo = (TextView)this.findViewById(R.id.tv_game_info);
        this.mIvRecord.setOnClickListener(v -> {
            if (this.mGameContainerListener != null) {
                this.mGameContainerListener.onHistoryClick();
            }
        });
        this.mIvRule.setOnClickListener(v -> {
            if (this.mGameContainerListener != null) {
                this.mGameContainerListener.onRuleClick();
            }
        });
        this.mIvClose.setOnClickListener(v -> this.confirmClose());
    }

    public void setStatusListener(IGameStatusChangeListener listener) {
        this.mGameStatusChangeListener = listener;
    }

    public void setContainerListener(IGameContainerListener listener) {
        this.mGameContainerListener = listener;
    }

    public void updateStatus(int status) {
        if (status == this.mGameStatus) {
            MLog.info((Object)TAG, (String)"updateStatus, same status, status=%d", (Object[])new Object[]{status});
            return;
        }
        MLog.info((Object)TAG, (String)"updateStatus, status=%d", (Object[])new Object[]{status});
        if (this.mCurrPanelPage != null) {
            this.mCurrPanelPage.onDetachFromPanel(this);
            this.mCurrPanelPage = null;
        }
        if (status == 1) {
            ReadyPanelPage readyPanelPage = new ReadyPanelPage();
            readyPanelPage.setCallback(new ReadyPanelPage.PageCallback(){

                @Override
                public void onReadyClick() {
                    if (BocaiGamePanel.this.mGameStatusChangeListener != null) {
                        BocaiGamePanel.this.mGameStatusChangeListener.onReadyClick();
                    }
                }

                @Override
                public void onCancelReadyClick() {
                    if (BocaiGamePanel.this.mGameStatusChangeListener != null) {
                        BocaiGamePanel.this.mGameStatusChangeListener.onCancelReadyClick();
                    }
                }

                @Override
                public void onStartClick() {
                    if (BocaiGamePanel.this.mGameStatusChangeListener != null) {
                        BocaiGamePanel.this.mGameStatusChangeListener.onStartClick();
                    }
                }
            });
            this.mCurrPanelPage = readyPanelPage;
        } else if (status == 3) {
            AutoStartPanelPage autoStartPanelPage = new AutoStartPanelPage();
            autoStartPanelPage.setCallback(new AutoStartPanelPage.PageCallback(){

                @Override
                public void onReadyClick() {
                    if (BocaiGamePanel.this.mGameStatusChangeListener != null) {
                        BocaiGamePanel.this.mGameStatusChangeListener.onReadyClick();
                    }
                }

                @Override
                public void onCancelReadyClick() {
                    if (BocaiGamePanel.this.mGameStatusChangeListener != null) {
                        BocaiGamePanel.this.mGameStatusChangeListener.onCancelReadyClick();
                    }
                }
            });
            this.mCurrPanelPage = autoStartPanelPage;
        } else if (status == 4) {
            ResultWaitPanelPage resultWaitPanelPage = new ResultWaitPanelPage();
            this.mCurrPanelPage = resultWaitPanelPage;
        } else if (status == 2) {
            ResultPublishPanelPage resultPublishPanelPage = new ResultPublishPanelPage();
            int resultCount = WealthDataService.INSTANCE.getWealthDataModel().getGameResult().size();
            resultPublishPanelPage.setResultCount(resultCount);
            this.mCurrPanelPage = resultPublishPanelPage;
        } else if (status == 5) {
            GameStartedPanelPage gameStartedPanelPage = new GameStartedPanelPage();
            this.mCurrPanelPage = gameStartedPanelPage;
        }
        if (this.mCurrPanelPage != null) {
            this.mCurrPanelPage.onAttachToPanel(this);
        }
        this.mGameStatus = status;
    }

    public void setDimondConfig(int count) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.short_title_bocai_name)).append((CharSequence)" ").append((CharSequence)String.valueOf(count), new Object[]{new ForegroundColorSpan(ColorUtils.parseColor((String)"#F8E71C"))}).append(R.drawable.icon_diamond_36, Size.of((int)ResolutionUtils.dip2Px((float)12.0f), (int)ResolutionUtils.dip2Px((float)12.0f))).onFinish(data -> {
            if (this.mTvGameInfo != null) {
                this.mTvGameInfo.setText((CharSequence)data);
            }
        }).build();
    }

    public void setCloseVisibility(boolean visiable) {
        if (visiable) {
            this.mIvClose.setVisibility(0);
        } else {
            this.mIvClose.setVisibility(8);
        }
    }

    public void showGameResult(GameResultInfo resultInfo, boolean isLast) {
        if (this.mGameStatus != 2) {
            return;
        }
        if (resultInfo == null) {
            FeatureLog.i((String)"FTWealth", (String)"showGameResult null", (Object[])new Object[0]);
            return;
        }
        if (this.mCurrPanelPage instanceof ResultPublishPanelPage) {
            boolean isInSeat = WealthDataService.INSTANCE.getWealthDataModel().isInSeat(resultInfo.getUid());
            ((ResultPublishPanelPage)this.mCurrPanelPage).addResultGiftItem(new ResultGiftItemData(resultInfo, isInSeat));
        }
        if (isLast) {
            YYTaskExecutor.postToMainThread(this::showWinnerAnim, (long)1500L);
        }
    }

    public void showAllGameResult(List<GameResultInfo> resultInfoList) {
        if (this.mGameStatus != 2) {
            return;
        }
        if (this.mCurrPanelPage instanceof ResultPublishPanelPage) {
            ArrayList<ResultGiftItemData> dataList = new ArrayList<ResultGiftItemData>(resultInfoList.size());
            for (GameResultInfo resultInfo : resultInfoList) {
                boolean isInSeat = WealthDataService.INSTANCE.getWealthDataModel().isInSeat(resultInfo.getUid());
                dataList.add(new ResultGiftItemData(resultInfo, isInSeat));
            }
            ((ResultPublishPanelPage)this.mCurrPanelPage).setResultGiftItemList(dataList);
        }
    }

    public void showWinnerAnim() {
        if (this.mGameStatus != 2) {
            return;
        }
        if (this.mCurrPanelPage instanceof ResultPublishPanelPage) {
            ((ResultPublishPanelPage)this.mCurrPanelPage).startWinnerAnim();
        }
    }

    private void confirmClose() {
        DialogLinkManager manager = new DialogLinkManager(this.getContext());
        OkCancelDialog dialog = new OkCancelDialog.Builder().cancelable(true).message((CharSequence)ResourceUtils.getString((int)R.string.short_tips_close_prepare)).listener(new OkCancelDialogListener(){

            public void onCancel() {
                MLog.info((Object)BocaiGamePanel.TAG, (String)"\u53d6\u6d88 \u5173\u95ed\u6e38\u620f", (Object[])new Object[0]);
            }

            public void onOk() {
                MLog.info((Object)BocaiGamePanel.TAG, (String)"\u786e\u8ba4 \u5173\u95ed\u6e38\u620f", (Object[])new Object[0]);
                if (BocaiGamePanel.this.mGameContainerListener != null) {
                    BocaiGamePanel.this.mGameContainerListener.onCloseClick();
                }
            }
        }).build();
        manager.showDialog((BaseDialog)dialog);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void destroy() {
        if (this.mCurrPanelPage != null) {
            this.mCurrPanelPage.onDetachFromPanel(this);
            this.mCurrPanelPage = null;
        }
    }

    @Override
    public RelativeLayout getRootPanelView() {
        return this;
    }

    @Override
    public ImageView getPanelBgView() {
        return this.mIvPanelBg;
    }

    @Override
    public FrameLayout getBgContainer() {
        return this.mFlBgContainer;
    }
}

