/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting.DiamondSettingAdapter;
import java.util.List;

public class DiamondSettingPanel
extends YYLinearLayout {
    private RecyclerView mRvDiamond;
    private IDiamondSelectListener mListener;
    private DiamondSettingAdapter mAdapter;

    public DiamondSettingPanel(Context context, IDiamondSelectListener listener) {
        super(context);
        this.mListener = listener;
        this.createView();
    }

    private void createView() {
        LinearLayout.LayoutParams rootParams = new LinearLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)rootParams);
        LayoutUtil.setPadding((View)this, (int)0, (int)0, (int)0, (int)ResolutionUtils.dip2Px((float)20.0f));
        this.setBackgroundColor(Color.parseColor((String)"#E6272735"));
        this.setOrientation(1);
        YYTextView tvTitle = new YYTextView(this.getContext());
        tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.short_title_bocai_name));
        tvTitle.setTextColor(ResourceUtils.getColor((int)R.color.white));
        tvTitle.setTextSize(15.0f);
        LinearLayout.LayoutParams titleLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        titleLayoutParams.topMargin = ResolutionUtils.dip2Px((float)25.0f);
        titleLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)15.0f);
        titleLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)15.0f);
        if (Build.VERSION.SDK_INT >= 17) {
            titleLayoutParams.setMarginStart(ResolutionUtils.dip2Px((float)15.0f));
            titleLayoutParams.setMarginEnd(ResolutionUtils.dip2Px((float)15.0f));
        }
        tvTitle.setLayoutParams((ViewGroup.LayoutParams)titleLayoutParams);
        this.addView((View)tvTitle);
        YYTextView tvDesc = new YYTextView(this.getContext());
        tvDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_wealth_diamond_setting));
        tvDesc.setTextColor(Color.parseColor((String)"#80ffffff"));
        tvDesc.setTextSize(9.0f);
        LinearLayout.LayoutParams descLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        descLayoutParams.topMargin = ResolutionUtils.dip2Px((float)12.0f);
        descLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)15.0f);
        descLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)15.0f);
        if (Build.VERSION.SDK_INT >= 17) {
            descLayoutParams.setMarginStart(ResolutionUtils.dip2Px((float)15.0f));
            descLayoutParams.setMarginEnd(ResolutionUtils.dip2Px((float)15.0f));
        }
        tvDesc.setLayoutParams((ViewGroup.LayoutParams)descLayoutParams);
        this.addView((View)tvDesc);
        this.mRvDiamond = new YYRecyclerView(this.getContext(), "DiamondSettingPanel");
        LinearLayout.LayoutParams diamondLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        diamondLayoutParams.topMargin = ResolutionUtils.dip2Px((float)15.0f);
        diamondLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)5.0f);
        diamondLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)5.0f);
        if (Build.VERSION.SDK_INT >= 17) {
            diamondLayoutParams.setMarginStart(ResolutionUtils.dip2Px((float)5.0f));
            diamondLayoutParams.setMarginEnd(ResolutionUtils.dip2Px((float)5.0f));
        }
        this.mRvDiamond.setLayoutParams((ViewGroup.LayoutParams)diamondLayoutParams);
        GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 4);
        this.mRvDiamond.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.addView((View)this.mRvDiamond);
        YYTextView tvOk = new YYTextView(this.getContext());
        tvOk.setTextSize(18.0f);
        tvOk.setText((CharSequence)ResourceUtils.getString((int)R.string.ok));
        tvOk.setTextColor(ResourceUtils.getColor((int)R.color.white));
        tvOk.setBackgroundResource(R.drawable.shape_ffc102_24);
        tvOk.setGravity(17);
        LinearLayout.LayoutParams okLayoutParams = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)200.0f), ResolutionUtils.dip2Px((float)40.0f));
        okLayoutParams.gravity = 1;
        okLayoutParams.topMargin = ResolutionUtils.dip2Px((float)20.0f);
        tvOk.setLayoutParams((ViewGroup.LayoutParams)okLayoutParams);
        tvOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DiamondSettingPanel.this.mListener != null && DiamondSettingPanel.this.mAdapter != null) {
                    DiamondSettingPanel.this.mListener.onSelect(DiamondSettingPanel.this.mAdapter.getData(DiamondSettingPanel.this.mAdapter.getSelectIndex()));
                }
            }
        });
        this.addView((View)tvOk);
    }

    public void setData(List<WealthConfigData> list) {
        this.mAdapter = new DiamondSettingAdapter(list);
        if (this.mRvDiamond != null) {
            this.mRvDiamond.setAdapter((RecyclerView.Adapter)this.mAdapter);
        }
        int selectIndex = SettingFlags.getIntValue((String)"key_wealth_config_select", (int)0);
        this.mAdapter.setSelectIndex(selectIndex);
    }

    public static interface IDiamondSelectListener {
        public void onSelect(WealthConfigData var1);
    }
}

