/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.base;

import android.content.Context;
import android.widget.FrameLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.base.ProxyPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.bocai.DR;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.base.AbsWealthPlayManager;
import com.yy.hiyo.channel.plugins.bocai.base.BocaiStatis;
import com.yy.hiyo.channel.plugins.bocai.base.IWealthViewManager;
import com.yy.hiyo.channel.plugins.bocai.base.WealthNotifyDispatchService;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.HistoryRecord;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.data.proto.INotifyHandlerListener;
import com.yy.hiyo.channel.plugins.bocai.data.proto.ProtoServiceManager;
import com.yy.hiyo.channel.plugins.bocai.data.proto.WealthNotifyHandler;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameContainerListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameStatusChangeListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.history.HistoryDialog;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.base.CallbackExt;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.user.base.freeze.IUserFreezeService;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.ihago.money.api.spinach.NotPaidType;
import net.ihago.money.api.spinach.SpinachNotify;

public class WealthPlayManager
extends AbsWealthPlayManager
implements IGameContainerListener,
IGameStatusChangeListener,
INotifyHandlerListener,
HistoryDialog.IHistoryLoadListener {
    private static final int LIMIT_COUNT = 20;
    private WealthNotifyDispatchService mNotifyDispatchService;
    private WealthNotifyHandler mHandler;
    private IChannelPageContext mRoomPageContext;
    private boolean destroyed;
    private INotifyDispatchService.INotifyHandler<SpinachNotify> mNotifyHandler = new INotifyDispatchService.INotifyHandler<SpinachNotify>(){

        public void onHandleNotify(final SpinachNotify notify) {
            if (notify == null) {
                FeatureLog.i((String)"FTWealth", (String)"onHandleNotify notify null", (Object[])new Object[0]);
                return;
            }
            if (notify.header == null) {
                FeatureLog.i((String)"FTWealth", (String)"onHandleNotify header null", (Object[])new Object[0]);
                return;
            }
            if (WealthPlayManager.this.destroyed) {
                return;
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WealthPlayManager.this.mHandler != null) {
                        WealthPlayManager.this.mHandler.handle(notify);
                    }
                }
            });
        }
    };
    private ISeatUpdateListener mSeatUpdateListener = new ISeatUpdateListener(){

        public void onSeatUpdate(List<SeatUser> seatUserList) {
            int currentStatus = WealthDataService.INSTANCE.getWealthDataModel().getGameStatus();
            if (currentStatus == 1 && WealthPlayManager.this.mViewManager != null) {
                WealthPlayManager.this.mViewManager.getGameViewManager().reset(1);
            }
        }
    };

    public WealthPlayManager(IChannelPageContext roomPageContext) {
        this.mHandler = new WealthNotifyHandler(this);
        this.mNotifyDispatchService = new WealthNotifyDispatchService();
        this.mRoomPageContext = roomPageContext;
        this.downloadSvga();
        this.initGift();
        this.mRoomPageContext.getChannel().getSeatService().addSeatUpdateListener(this.mSeatUpdateListener);
    }

    @Override
    public void enterGame(String roomId) {
        this.mRoomId = roomId;
        this.getInfo(roomId);
    }

    private void initGift() {
        ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).loadGiftList(this.mRoomId, AccountUtil.getUid(), GiftChannel.USER_ALL_CHANNEL.getChannel(), true, null);
        ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).loadPackageList(GiftChannel.USER_ALL_CHANNEL.getChannel(), AccountUtil.getUid(), null);
    }

    private void downloadSvga() {
        DyResLoader.INSTANCE.getResFilePath(DR.first_chest, null);
        DyResLoader.INSTANCE.getResFilePath(DR.second_chest, null);
        DyResLoader.INSTANCE.getResFilePath(DR.third_chest, null);
        DyResLoader.INSTANCE.getResFilePath(DR.four_chest, null);
    }

    @Override
    public void bind(IChannelPageContext pageContext, AbsRoomPage page, FrameLayout gameContainer, IWealthViewManager wealthViewManager) {
        this.mViewManager = wealthViewManager;
        this.mViewManager.init(pageContext, gameContainer, page);
        this.mViewManager.getGameViewManager().setGameContainerListener(this);
        this.mViewManager.getGameViewManager().setGameStatusChangeListener(this);
        this.mPage = page;
        this.mRoomPageContext = pageContext;
    }

    private int getGameStatus(int status) {
        if (1 == status) {
            return 1;
        }
        if (4 == status) {
            return 3;
        }
        if (3 == status) {
            return 2;
        }
        if (2 == status) {
            return 6;
        }
        return 0;
    }

    private void getInfo(final String roomId) {
        WealthDataService.INSTANCE.getProtoServiceManager().getInfo(roomId, new ProtoServiceManager.IGetInfoCallback(){

            @Override
            public void onSuccess(String roomId2, long recordId, long stateChangedSec, WealthConfigData wealthConfigData, List<GameResultInfo> list, int status, int maxDiamond) {
                if (WealthPlayManager.this.destroyed) {
                    return;
                }
                WealthPlayManager.this.registerNotify(roomId2);
                WealthDataService.INSTANCE.getWealthDataModel().setResultBeginTime(stateChangedSec);
                WealthDataService.INSTANCE.getWealthDataModel().setGameResult(list);
                WealthDataService.INSTANCE.getWealthDataModel().setConfigData(wealthConfigData);
                WealthDataService.INSTANCE.getWealthDataModel().setMaxDiamond(maxDiamond);
                int gameStatus = WealthPlayManager.this.getGameStatus(status);
                WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(gameStatus);
                FeatureLog.i((String)"FTWealth", (String)"getInfo, status:%s", (Object[])new Object[]{gameStatus});
                if (gameStatus != 0) {
                    if (gameStatus == 6) {
                        WealthDataService.INSTANCE.getWealthDataModel().setRecordId(0L);
                    } else {
                        WealthDataService.INSTANCE.getWealthDataModel().setRecordId(recordId);
                        if (WealthPlayManager.this.mViewManager != null) {
                            WealthPlayManager.this.mViewManager.getGameViewManager().show(WealthPlayManager.this.getGameStatus(status));
                        }
                        boolean isSelfJoin = false;
                        ArrayList<Long> memberList = new ArrayList<Long>();
                        if (list != null && list.size() > 0) {
                            for (GameResultInfo info : list) {
                                if (info == null) continue;
                                if (info.getUid() == AccountUtil.getUid()) {
                                    isSelfJoin = true;
                                    FeatureLog.i((String)"FTWealth", (String)"self in game", (Object[])new Object[0]);
                                    WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(true);
                                }
                                memberList.add(info.getUid());
                            }
                        }
                        if (!isSelfJoin) {
                            WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
                        }
                        WealthDataService.INSTANCE.getWealthDataModel().setCurrentJoinMembers(memberList);
                        if (gameStatus == 2) {
                            if (WealthPlayManager.this.mViewManager != null) {
                                WealthPlayManager.this.mViewManager.resume(WealthPlayManager.this.mRoomPageContext);
                            }
                        } else if (WealthPlayManager.this.mViewManager != null) {
                            WealthPlayManager.this.mViewManager.updateSeat(memberList);
                        }
                    }
                }
            }

            @Override
            public void onFail(long code, String reason) {
                if (WealthPlayManager.this.destroyed) {
                    return;
                }
                WealthPlayManager.this.registerNotify(roomId);
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (int)R.string.check_network_and_retry);
            }
        });
    }

    @Override
    public void onDestroy() {
        FeatureLog.i((String)"FTWealth", (String)"WealthPlayManager onDestroy", (Object[])new Object[0]);
        this.destroyed = true;
        if (this.mViewManager != null) {
            this.mViewManager.destroy();
        }
        this.unregisterNotify();
    }

    private void registerNotify(String roomId) {
        if (this.destroyed) {
            return;
        }
        if (this.mNotifyDispatchService != null && this.mNotifyHandler != null) {
            this.mNotifyDispatchService.addHandler(this.mNotifyHandler);
            this.mNotifyDispatchService.setRoomId(roomId);
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mNotifyDispatchService);
        }
    }

    private void unregisterNotify() {
        if (this.mNotifyDispatchService != null && this.mNotifyHandler != null) {
            this.mNotifyDispatchService.removeHandler(this.mNotifyHandler);
            ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mNotifyDispatchService);
        }
        this.mRoomPageContext.getChannel().getSeatService().removeSeatUpdateListener(this.mSeatUpdateListener);
    }

    @Override
    public void onHistoryClick() {
        BocaiStatis.reportAwardRecordClick(this.mRoomId);
        WealthDataService.INSTANCE.getProtoServiceManager().getHistoryRecord(AccountUtil.getUid(), "", 20, new ProtoServiceManager.IGetRecordsCallback(){

            @Override
            public void onSuccess(String cursor, List<HistoryRecord> list) {
                if (WealthPlayManager.this.mViewManager != null) {
                    WealthPlayManager.this.mViewManager.showHistoryView(list, cursor, WealthPlayManager.this);
                }
            }

            @Override
            public void onFail(long code, String reason) {
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    @Override
    public void onNotifyAutoStart(String roomId, long recordId, WealthConfigData wealthConfigData) {
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).stopAudio("wealth_open");
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).stopAudio("wealth_winner");
        }
        WealthDataService.INSTANCE.getWealthDataModel().setWealthSeatItemLiveData(null);
        WealthDataService.INSTANCE.getWealthDataModel().setRecordId(recordId);
        WealthDataService.INSTANCE.getWealthDataModel().setConfigData(wealthConfigData);
        WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
        WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(3);
        if (this.mViewManager != null) {
            this.mViewManager.updateSeat(null);
            this.mViewManager.getGameViewManager().show(3);
        }
    }

    @Override
    public void onNotifyCancel(String roomId, long cancelUid, long recordId, List<Long> memberList) {
        WealthDataService.INSTANCE.getWealthDataModel().setCurrentJoinMembers(memberList);
        if (this.mViewManager != null) {
            this.mViewManager.updateSeat(memberList);
        }
    }

    @Override
    public void onNotifyClose(String roomId, long recordId) {
        this.closeGame();
    }

    private void closeGame() {
        if (this.mRoomPageContext != null) {
            ((ProxyPresenter)this.mRoomPageContext.getPresenter(ProxyPresenter.class)).closeCurrentPlugin(null);
        }
        WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(6);
        WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
        this.unregisterNotify();
        if (this.mViewManager != null) {
            this.mViewManager.destroy();
        }
    }

    @Override
    public void onNotifyJoin(String roomId, long joinUid, long recordId, List<Long> memberList) {
        WealthDataService.INSTANCE.getWealthDataModel().setCurrentJoinMembers(memberList);
        if (this.mViewManager != null) {
            this.mViewManager.updateSeat(memberList);
        }
    }

    @Override
    public void onNotifyNoEnoughMoney(String roomId, long recordId, long noEnoughMoneyUid, int type) {
        if (type == NotPaidType.NotPaidTypeNoEnoughMoney.getValue()) {
            this.showNoEnoughView();
        } else if (type == NotPaidType.NotPaidTypePaidFail.getValue()) {
            ToastUtils.showToast((Context)this.mRoomPageContext.getContext(), (int)R.string.tips_wealth_take_off);
        } else if (type == NotPaidType.NotPaidTypeFreeze.getValue()) {
            ServiceManagerProxy.getInstance().observeService(IUserFreezeService.class, service -> service.showAccountFreezeDialog(1));
        }
    }

    private void showNoEnoughView() {
        if (this.mViewManager != null) {
            this.mViewManager.showNoEnoughView();
        }
    }

    @Override
    public void onNotifyOpen(String roomId, long recordId, WealthConfigData wealthConfigData) {
        WealthDataService.INSTANCE.getWealthDataModel().setWealthSeatItemLiveData(null);
        WealthDataService.INSTANCE.getWealthDataModel().setRecordId(recordId);
        WealthDataService.INSTANCE.getWealthDataModel().setConfigData(wealthConfigData);
        WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
        WealthDataService.INSTANCE.getWealthDataModel().setCurrentJoinMembers(null);
        WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(1);
        if (this.mViewManager != null) {
            this.mViewManager.getGameViewManager().show(1);
        }
        if (this.mViewManager != null) {
            this.mViewManager.updateSeat(null);
        }
    }

    @Override
    public void onNotifyResult(String roomId, long recordId, List<GameResultInfo> memberInfos, long resultBeginTime) {
        List seatUidList;
        WealthDataService.INSTANCE.getWealthDataModel().setResultBeginTime(resultBeginTime);
        SeatData seatData = WealthDataService.INSTANCE.getWealthDataModel().getSeatData();
        ArrayList<GameResultInfo> result = new ArrayList<GameResultInfo>();
        if (seatData != null && (seatUidList = seatData.getSeatUidsList()) != null && memberInfos != null) {
            Iterator iterator = seatUidList.iterator();
            block0: while (iterator.hasNext()) {
                long uid = (Long)iterator.next();
                int size = memberInfos.size();
                for (int i = 0; i < size; ++i) {
                    GameResultInfo gameResultInfo = memberInfos.get(i);
                    if (gameResultInfo == null || gameResultInfo.getUid() != uid) continue;
                    result.add(gameResultInfo);
                    continue block0;
                }
            }
        }
        FeatureLog.i((String)"FTWealth", (String)"onNotifyResult:%s", (Object[])new Object[]{result});
        WealthDataService.INSTANCE.getWealthDataModel().setGameResult(result);
        WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(2);
        if (this.mViewManager != null) {
            this.mViewManager.getGameViewManager().show(2);
        }
        if (this.mViewManager != null) {
            this.mViewManager.showResult();
        }
    }

    @Override
    public void onReadyClick() {
        boolean isInSeat = WealthDataService.INSTANCE.getWealthDataModel().isInSeat(AccountUtil.getUid());
        if (!isInSeat) {
            if (WealthDataService.INSTANCE.getWealthDataModel().isFullSeat()) {
                FeatureLog.i((String)"FTWealth", (String)"onReadyClick full seat", (Object[])new Object[0]);
                ToastUtils.showToast((Context)this.mRoomPageContext.getContext(), (int)R.string.tips_wealth_full_seat);
                return;
            }
            ((SeatPresenter)this.mRoomPageContext.getPresenter(SeatPresenter.class)).onSitDown(-1, (Callback)new CallbackExt<Integer>(){

                public void onResponse(Integer data) {
                    FeatureLog.i((String)"FTWealth", (String)"data:%s", (Object[])new Object[]{data});
                    if (data != null) {
                        WealthPlayManager.this.joinGame();
                    }
                }
            });
        } else {
            this.joinGame();
        }
        String roomId = WealthDataService.INSTANCE.getWealthDataModel().getRoomId();
        BocaiStatis.reportReadyClick(roomId);
    }

    private void joinGame() {
        WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(true);
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        WealthDataService.INSTANCE.getProtoServiceManager().join(this.mRoomId, recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                BocaiStatis.reportReadyResultBack(roomId, "1");
                WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(false);
                WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(true);
            }

            @Override
            public void onFail(long code, String reason) {
                BocaiStatis.reportReadyResultBack(WealthPlayManager.this.mRoomId, code + "");
                WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(false);
                if (code == 3L) {
                    ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.tips_wealth_already), (int)0);
                    WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(true);
                } else if (code == 7L) {
                    WealthPlayManager.this.showNoEnoughView();
                } else if (code == 6L) {
                    ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.tips_wealth_no_join), (int)0);
                } else if (code == 10001L) {
                    ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_mora_not_same_region), (int)0);
                } else {
                    ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                }
            }
        });
    }

    @Override
    public void onStartClick() {
        WealthDataService.INSTANCE.getWealthDataModel().setStartRequestingData(true);
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        WealthDataService.INSTANCE.getProtoServiceManager().start(this.mRoomId, recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                WealthDataService.INSTANCE.getWealthDataModel().setStartRequestingData(false);
                WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(4);
                if (WealthPlayManager.this.mViewManager != null) {
                    WealthPlayManager.this.mViewManager.getGameViewManager().show(4);
                }
            }

            @Override
            public void onFail(long code, String reason) {
                WealthDataService.INSTANCE.getWealthDataModel().setStartRequestingData(false);
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
        String roomId = WealthDataService.INSTANCE.getWealthDataModel().getRoomId();
        BocaiStatis.reportStartClick(roomId);
    }

    @Override
    public void onCancelReadyClick() {
        WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(true);
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        WealthDataService.INSTANCE.getProtoServiceManager().cancel(this.mRoomId, recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(false);
                WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
            }

            @Override
            public void onFail(long code, String reason) {
                WealthDataService.INSTANCE.getWealthDataModel().setReadyRequestingData(false);
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    @Override
    public void onRuleClick() {
        if (this.mViewManager != null) {
            this.mViewManager.showRuleView();
        }
    }

    @Override
    public void onCloseClick() {
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        WealthDataService.INSTANCE.getProtoServiceManager().close(this.mRoomId, recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                WealthPlayManager.this.closeGame();
            }

            @Override
            public void onFail(long code, String reason) {
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
        String roomId = WealthDataService.INSTANCE.getWealthDataModel().getRoomId();
        BocaiStatis.reportCloseClick(roomId);
    }

    @Override
    public void onLoad(String cursor) {
        WealthDataService.INSTANCE.getProtoServiceManager().getHistoryRecord(AccountUtil.getUid(), cursor, 20, new ProtoServiceManager.IGetRecordsCallback(){

            @Override
            public void onSuccess(String cursor, List<HistoryRecord> list) {
                if (WealthPlayManager.this.mViewManager != null) {
                    WealthPlayManager.this.mViewManager.addHistoryRecord(list, cursor);
                }
            }

            @Override
            public void onFail(long code, String reason) {
                ToastUtils.showToast((Context)WealthPlayManager.this.mRoomPageContext.getContext(), (int)R.string.check_network_and_retry);
            }
        });
    }
}

