/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.IntStream;

public class NodeJsGlobal {
    static SharedLibFolder sharedLibs = new SharedLibFolder(ThrowingEx.get(() -> Files.createTempDirectory("spotless-nodejs", new FileAttribute[0])));

    public static void setSharedLibFolder(File sharedLibFolder) {
        sharedLibs = new SharedLibFolder(sharedLibFolder.toPath());
    }

    static {
        sharedLibs.root.deleteOnExit();
    }

    static class SharedLibFolder {
        private final File root = ThrowingEx.get(() -> root.toFile().getCanonicalFile());
        static final int MAX_CLASSLOADERS_PER_CLEAN = 1000;

        private SharedLibFolder(Path root) {
        }

        synchronized File nextDynamicLib(ClassLoader loader, String resource) {
            Optional<File> nextLibOpt = IntStream.range(0, 1000).mapToObj(i -> new File(this.root, i + "_" + resource)).filter(file -> !file.exists()).findFirst();
            if (!nextLibOpt.isPresent()) {
                throw new IllegalArgumentException("Overflow, delete the spotless nodeJs cache: " + this.root);
            }
            File nextLib = nextLibOpt.get();
            try {
                Files.createDirectories(nextLib.getParentFile().toPath(), new FileAttribute[0]);
                try (FileOutputStream fileOut = new FileOutputStream(nextLib);
                     InputStream resourceIn = loader.loadClass("com.eclipsesource.v8.LibraryLoader").getResourceAsStream("/" + resource);){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = resourceIn.read(buf)) != -1) {
                        fileOut.write(buf, 0, r);
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw ThrowingEx.asRuntime(e);
            }
            if (LineEnding.PLATFORM_NATIVE.str().equals("\n")) {
                ThrowingEx.run(() -> Runtime.getRuntime().exec(new String[]{"chmod", "755", nextLib.getAbsolutePath()}).waitFor());
            }
            return nextLib;
        }
    }
}

