/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.scalariform;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.scalastyle.Checker;
import org.scalastyle.FileSpec;
import org.scalastyle.Level;
import org.scalastyle.Lines;
import org.scalastyle.Message;
import org.scalastyle.PositionError;
import org.scalastyle.PositionError$;
import org.scalastyle.ScalariformChecker;
import org.scalastyle.ScalastyleError;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalariform.lexer.Token;
import scalariform.lexer.TokenType;
import scalariform.lexer.Tokens$;
import scalariform.parser.CompilationUnit;

@ScalaSignature(bytes="\u0006\u000154AAD\b\u0001-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003B\u0002\u001a\u0001A\u0003%q\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\r}\u0002\u0001\u0015!\u00036\u0011\u001d\u0001\u0005A1A\u0005\nQBa!\u0011\u0001!\u0002\u0013)\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002#\t\u0011!\u0003\u0001R1A\u0005\u0002\rCQ!\u0013\u0001\u0005B)CQ\u0001\u0019\u0001\u0005\n\u0005DQA\u001b\u0001\u0005\n-\u0014\u0001DT8o\u0003N\u001b\u0015*S\"iCJ\f7\r^3s\u0007\",7m[3s\u0015\t\u0001\u0012#A\u0006tG\u0006d\u0017M]5g_Jl'B\u0001\n\u0014\u0003)\u00198-\u00197bgRLH.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u0012\u0013\t\u0001\u0013C\u0001\nTG\u0006d\u0017M]5g_Jl7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0010\u0003!)'O]8s\u0017\u0016LX#A\u0014\u0011\u0005!zcBA\u0015.!\tQ\u0013$D\u0001,\u0015\taS#\u0001\u0004=e>|GOP\u0005\u0003]e\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011a&G\u0001\nKJ\u0014xN]&fs\u0002\nA\"Y:dS&\u0004\u0016\r\u001e;fe:,\u0012!\u000e\t\u0003muj\u0011a\u000e\u0006\u0003qe\nQA]3hKbT!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002y\u0005!!.\u0019<b\u0013\tqtGA\u0004QCR$XM\u001d8\u0002\u001b\u0005\u001c8-[5QCR$XM\u001d8!\u0003U\u0019HO]5oO2KG/\u001a:bYN\u0004\u0016\r\u001e;fe:\fac\u001d;sS:<G*\u001b;fe\u0006d7\u000fU1ui\u0016\u0014h\u000eI\u0001\u001bI\u00164\u0017-\u001e7u\u00032dwn^*ue&tw\rT5uKJ\fGn]\u000b\u0002\tB\u0011\u0001$R\u0005\u0003\rf\u0011qAQ8pY\u0016\fg.A\u000eeK\u001a\fW\u000f\u001c;BY2|wo\u0015;sS:<G*\u001b;fe\u0006d7\u000fI\u0001\u0014C2dwn^*ue&tw\rT5uKJ\fGn]\u0001\u0007m\u0016\u0014\u0018NZ=\u0015\u0005-;\u0006c\u0001'R):\u0011Qj\u0014\b\u0003U9K\u0011AG\u0005\u0003!f\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n!A*[:u\u0015\t\u0001\u0016\u0004\u0005\u0002\u001f+&\u0011a+\u0005\u0002\u0010'\u000e\fG.Y:us2,WI\u001d:pe\")\u0001l\u0003a\u00013\u0006\u0019\u0011m\u001d;\u0011\u0005isV\"A.\u000b\u0005qk\u0016A\u00029beN,'OC\u0001\u0011\u0013\ty6LA\bD_6\u0004\u0018\u000e\\1uS>tWK\\5u\u0003AA\u0017m\u001d(p]\u0006\u001b8-[5DQ\u0006\u00148\u000f\u0006\u0002EE\")1\r\u0004a\u0001I\u0006\t\u0001\u0010\u0005\u0002fQ6\taM\u0003\u0002h;\u0006)A.\u001a=fe&\u0011\u0011N\u001a\u0002\u0006)>\\WM\\\u0001\u0013m\u0006d\u0017\u000eZ*ue&tw\rT5uKJ\fG\u000e\u0006\u0002EY\")1-\u0004a\u0001I\u0002")
public class NonASCIICharacterChecker
implements ScalariformChecker {
    private boolean allowStringLiterals;
    private final String errorKey;
    private final Pattern asciiPattern;
    private final Pattern stringLiteralsPattern;
    private final boolean defaultAllowStringLiterals;
    private Map<String, String> parameters;
    private Level level;
    private Option<String> customMessage;
    private Option<String> customErrorKey;
    private volatile boolean bitmap$0;

    @Override
    public void setParameters(Map<String, String> parameters) {
        Checker.setParameters$(this, parameters);
    }

    @Override
    public void setLevel(Level level) {
        Checker.setLevel$(this, level);
    }

    @Override
    public void setCustomErrorKey(Option<String> customErrorKey) {
        Checker.setCustomErrorKey$(this, customErrorKey);
    }

    @Override
    public void setCustomMessage(Option<String> customMessage) {
        Checker.setCustomMessage$(this, customMessage);
    }

    @Override
    public int getInt(String parameter, int defaultValue) {
        return Checker.getInt$(this, parameter, defaultValue);
    }

    @Override
    public String getString(String parameter, String defaultValue) {
        return Checker.getString$(this, parameter, defaultValue);
    }

    @Override
    public boolean getBoolean(String parameter, boolean defaultValue) {
        return Checker.getBoolean$(this, parameter, defaultValue);
    }

    @Override
    public <T extends FileSpec> Message<T> toStyleError(T file, ScalastyleError p, Level level, Lines lines) {
        return Checker.toStyleError$(this, file, p, level, lines);
    }

    @Override
    public int charsBetweenTokens(Token left, Token right) {
        return Checker.charsBetweenTokens$(this, left, right);
    }

    @Override
    public List verify(FileSpec file, Level level, Object ast, Lines lines) {
        return Checker.verify$(this, file, level, ast, lines);
    }

    @Override
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Override
    public void parameters_$eq(Map<String, String> x$1) {
        this.parameters = x$1;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public void level_$eq(Level x$1) {
        this.level = x$1;
    }

    @Override
    public Option<String> customMessage() {
        return this.customMessage;
    }

    @Override
    public void customMessage_$eq(Option<String> x$1) {
        this.customMessage = x$1;
    }

    @Override
    public Option<String> customErrorKey() {
        return this.customErrorKey;
    }

    @Override
    public void customErrorKey_$eq(Option<String> x$1) {
        this.customErrorKey = x$1;
    }

    @Override
    public String errorKey() {
        return this.errorKey;
    }

    private Pattern asciiPattern() {
        return this.asciiPattern;
    }

    private Pattern stringLiteralsPattern() {
        return this.stringLiteralsPattern;
    }

    public boolean defaultAllowStringLiterals() {
        return this.defaultAllowStringLiterals;
    }

    private boolean allowStringLiterals$lzycompute() {
        NonASCIICharacterChecker nonASCIICharacterChecker = this;
        synchronized (nonASCIICharacterChecker) {
            if (!this.bitmap$0) {
                this.allowStringLiterals = this.getBoolean("allowStringLiterals", this.defaultAllowStringLiterals());
                this.bitmap$0 = true;
            }
        }
        return this.allowStringLiterals;
    }

    public boolean allowStringLiterals() {
        return !this.bitmap$0 ? this.allowStringLiterals$lzycompute() : this.allowStringLiterals;
    }

    @Override
    public List<ScalastyleError> verify(CompilationUnit ast) {
        return (List)((List)ast.tokens().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.hasNonAsciiChars(x)))).map((Function1 & Serializable & scala.Serializable)x -> new PositionError(x.offset(), PositionError$.MODULE$.apply$default$2(), PositionError$.MODULE$.apply$default$3()), List$.MODULE$.canBuildFrom());
    }

    private boolean hasNonAsciiChars(Token x) {
        return new StringOps(Predef$.MODULE$.augmentString(x.rawText().trim())).nonEmpty() && !this.validStringLiteral(x) && !this.asciiPattern().matcher(x.rawText().trim()).matches();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validStringLiteral(Token x) {
        if (!this.allowStringLiterals()) return false;
        TokenType tokenType = x.tokenType();
        TokenType tokenType2 = Tokens$.MODULE$.STRING_LITERAL();
        if (tokenType == null) {
            if (tokenType2 != null) {
                return false;
            }
        } else if (!tokenType.equals(tokenType2)) return false;
        if (!this.stringLiteralsPattern().matcher(x.rawText().trim()).matches()) return false;
        return true;
    }

    public NonASCIICharacterChecker() {
        Checker.$init$(this);
        this.errorKey = "non.ascii.character.disallowed";
        this.asciiPattern = Pattern.compile("\\p{ASCII}+", 32);
        this.stringLiteralsPattern = Pattern.compile("[\\p{Alnum}\\p{Punct}\\p{Sc}\\p{Space}]+", 256);
        this.defaultAllowStringLiterals = false;
    }
}

