/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.file;

import java.io.Serializable;
import org.scalastyle.Checker;
import org.scalastyle.FileChecker;
import org.scalastyle.FileSpec;
import org.scalastyle.Level;
import org.scalastyle.LineError;
import org.scalastyle.Lines;
import org.scalastyle.Message;
import org.scalastyle.ScalastyleError;
import org.scalastyle.file.NormalizedLine;
import org.scalastyle.file.NormalizedLine$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalariform.lexer.Token;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\n\u0014\u0001iAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u0004/\u0001\u0001\u0006Ia\u000b\u0005\b_\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\u0001\u0004\u0001)A\u0005W!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB\u001e\u0001A\u0003%1\u0007C\u0003=\u0001\u0011%Q\bC\u0003G\u0001\u0011%q\tC\u0003J\u0001\u0011%!\nC\u0003M\u0001\u0011%Q\nC\u0003P\u0001\u0011%\u0001\u000bC\u0003U\u0001\u0011%Q\u000bC\u0003m\u0001\u0011%Q\u000eC\u0003s\u0001\u0011%1\u000fC\u0003x\u0001\u0011%\u0001\u0010C\u0003}\u0001\u0011\u0005QP\u0001\nJ]\u0012,g\u000e^1uS>t7\t[3dW\u0016\u0014(B\u0001\u000b\u0016\u0003\u00111\u0017\u000e\\3\u000b\u0005Y9\u0012AC:dC2\f7\u000f^=mK*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005)\u0012B\u0001\u0013\u0016\u0005-1\u0015\u000e\\3DQ\u0016\u001c7.\u001a:\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0019\u0012A\u0004#fM\u0006,H\u000e\u001e+bENK'0Z\u000b\u0002WA\u0011A\u0004L\u0005\u0003[u\u00111!\u00138u\u0003=!UMZ1vYR$\u0016MY*ju\u0016\u0004\u0013\u0001\u0007#fM\u0006,H\u000e^\"mCN\u001c\b+\u0019:b[R\u000b'mU5{K\u0006IB)\u001a4bk2$8\t\\1tgB\u000b'/Y7UC\n\u001c\u0016N_3!\u0003!)'O]8s\u0017\u0016LX#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\f\u0011\"\u001a:s_J\\U-\u001f\u0011\u0002!5,H\u000e^5MS:,7i\\7nK:$HC\u0001 B!\tar(\u0003\u0002A;\t9!i\\8mK\u0006t\u0007\"\u0002\"\t\u0001\u0004\u0019\u0015\u0001\u00027j]\u0016\u0004\"\u0001\u000b#\n\u0005\u0015\u001b\"A\u0004(pe6\fG.\u001b>fI2Kg.Z\u0001\u0010gR\f'\u000f^:QCJ\fW\u000eT5tiR\u0011a\b\u0013\u0005\u0006\u0005&\u0001\raQ\u0001\u0010gR\f'\u000f^:NKRDw\u000e\u001a#fMR\u0011ah\u0013\u0005\u0006\u0005*\u0001\raQ\u0001\u000eSN$\u0016MY!mY&<g.\u001a3\u0015\u0005yr\u0005\"\u0002\"\f\u0001\u0004\u0019\u0015AD5t'&tw\r\\3J]\u0012,g\u000e\u001e\u000b\u0004}E\u0013\u0006\"\u0002\"\r\u0001\u0004\u0019\u0005\"B*\r\u0001\u0004\u0019\u0015!\u00029sS>\u0014\u0018!\u0004<fe&4\u0017\u0010V1c'R|\u0007\u000f\u0006\u0002W?B\u0019qK\u0017/\u000e\u0003aS!!W\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\1\n\u00191+Z9\u0011\u0005\tj\u0016B\u00010\u0016\u0005%a\u0015N\\3FeJ|'\u000fC\u0003a\u001b\u0001\u0007\u0011-A\u0003mS:,7\u000fE\u0002cU\u000es!a\u00195\u000f\u0005\u0011<W\"A3\u000b\u0005\u0019L\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\tIW$A\u0004qC\u000e\\\u0017mZ3\n\u0005m['BA5\u001e\u0003I1XM]5gsNKgn\u001a7f\u0013:$WM\u001c;\u0015\u00059\f\bcA,p9&\u0011\u0001\u000f\u0017\u0002\t\u0013R,'/\u0019;pe\")\u0001M\u0004a\u0001C\u0006\tb/\u001a:jMf\u001cE.Y:t\u0013:$WM\u001c;\u0015\u00079$X\u000fC\u0003a\u001f\u0001\u0007\u0011\rC\u0003w\u001f\u0001\u00071&\u0001\u000bdY\u0006\u001c8\u000fU1sC6Le\u000eZ3oiNK'0Z\u0001\u0013m\u0016\u0014\u0018NZ=NKRDw\u000eZ%oI\u0016tG\u000fF\u0002osjDQ\u0001\u0019\tA\u0002\u0005DQa\u001f\tA\u0002-\nQ#\\3uQ>$\u0007+\u0019:b[&sG-\u001a8u'&TX-\u0001\u0004wKJLg-\u001f\u000b\u0004}\u0006%\u0001\u0003\u00022\u0000\u0003\u0007I1!!\u0001l\u0005\u0011a\u0015n\u001d;\u0011\u0007\t\n)!C\u0002\u0002\bU\u0011qbU2bY\u0006\u001cH/\u001f7f\u000bJ\u0014xN\u001d\u0005\u0007AF\u0001\r!a\u0003\u0011\u0007\t\ni!C\u0002\u0002\u0010U\u0011Q\u0001T5oKN\u0004")
public class IndentationChecker
implements FileChecker {
    private final int DefaultTabSize;
    private final int DefaultClassParamTabSize;
    private final String errorKey;
    private Map<String, String> parameters;
    private Level level;
    private Option<String> customMessage;
    private Option<String> customErrorKey;

    @Override
    public void setParameters(Map<String, String> parameters) {
        Checker.setParameters$(this, parameters);
    }

    @Override
    public void setLevel(Level level) {
        Checker.setLevel$(this, level);
    }

    @Override
    public void setCustomErrorKey(Option<String> customErrorKey) {
        Checker.setCustomErrorKey$(this, customErrorKey);
    }

    @Override
    public void setCustomMessage(Option<String> customMessage) {
        Checker.setCustomMessage$(this, customMessage);
    }

    @Override
    public int getInt(String parameter, int defaultValue) {
        return Checker.getInt$(this, parameter, defaultValue);
    }

    @Override
    public String getString(String parameter, String defaultValue) {
        return Checker.getString$(this, parameter, defaultValue);
    }

    @Override
    public boolean getBoolean(String parameter, boolean defaultValue) {
        return Checker.getBoolean$(this, parameter, defaultValue);
    }

    @Override
    public <T extends FileSpec> Message<T> toStyleError(T file, ScalastyleError p, Level level, Lines lines) {
        return Checker.toStyleError$(this, file, p, level, lines);
    }

    @Override
    public int charsBetweenTokens(Token left, Token right) {
        return Checker.charsBetweenTokens$(this, left, right);
    }

    @Override
    public List verify(FileSpec file, Level level, Object ast, Lines lines) {
        return Checker.verify$(this, file, level, ast, lines);
    }

    @Override
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Override
    public void parameters_$eq(Map<String, String> x$1) {
        this.parameters = x$1;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public void level_$eq(Level x$1) {
        this.level = x$1;
    }

    @Override
    public Option<String> customMessage() {
        return this.customMessage;
    }

    @Override
    public void customMessage_$eq(Option<String> x$1) {
        this.customMessage = x$1;
    }

    @Override
    public Option<String> customErrorKey() {
        return this.customErrorKey;
    }

    @Override
    public void customErrorKey_$eq(Option<String> x$1) {
        this.customErrorKey = x$1;
    }

    public int DefaultTabSize() {
        return this.DefaultTabSize;
    }

    public int DefaultClassParamTabSize() {
        return this.DefaultClassParamTabSize;
    }

    @Override
    public String errorKey() {
        return this.errorKey;
    }

    private boolean multiLineComment(NormalizedLine line) {
        return line.body().startsWith("*");
    }

    private boolean startsParamList(NormalizedLine line) {
        return line.body().matches(".*(class|object|trait) .*\\([^\\)]*");
    }

    private boolean startsMethodDef(NormalizedLine line) {
        return line.body().matches(".*def .*\\([^\\)]*");
    }

    private boolean isTabAlligned(NormalizedLine line) {
        return line.indentDepth() % line.tabSize() == (this.multiLineComment(line) ? 1 : 0);
    }

    private boolean isSingleIndent(NormalizedLine line, NormalizedLine prior) {
        return line.indentDepth() - prior.indentDepth() > line.tabSize();
    }

    private Seq<LineError> verifyTabStop(Seq<NormalizedLine> lines) {
        return (Seq)lines.withFilter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifyTabStop$1(this, line))).map((Function1 & Serializable & scala.Serializable)line -> line.mkError(line.mkError$default$1()), Seq$.MODULE$.canBuildFrom());
    }

    private Iterator<LineError> verifySingleIndent(Seq<NormalizedLine> lines) {
        return lines.sliding(2).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifySingleIndent$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifySingleIndent$2(this, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Seq seq = x$4;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
            LineError lineError = l2.mkError(l2.mkError$default$1());
            return lineError;
        });
    }

    private Iterator<LineError> verifyClassIndent(Seq<NormalizedLine> lines, int classParamIndentSize) {
        return lines.sliding(2).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifyClassIndent$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifyClassIndent$2(this, classParamIndentSize, x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Seq seq = x$6;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
            LineError lineError = l2.mkError(l2.mkError$default$1());
            return lineError;
        });
    }

    private Iterator<LineError> verifyMethodIndent(Seq<NormalizedLine> lines, int methodParamIndentSize) {
        return lines.sliding(2).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifyMethodIndent$1(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)IndentationChecker.$anonfun$verifyMethodIndent$2(this, methodParamIndentSize, x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Seq seq = x$8;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
            LineError lineError = l2.mkError(l2.mkError$default$1());
            return lineError;
        });
    }

    @Override
    public List<ScalastyleError> verify(Lines lines) {
        int tabSize = this.getInt("tabSize", this.DefaultTabSize());
        int classParamIndentSize = this.getInt("classParamIndentSize", this.DefaultClassParamTabSize());
        int methodParamIndentSize = this.getInt("methodParamIndentSize", tabSize);
        Seq normalizedLines = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])NormalizedLine$.MODULE$.normalize(lines, tabSize))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isBlank())))).toSeq();
        Seq<LineError> tabErrors = this.verifyTabStop((Seq<NormalizedLine>)normalizedLines);
        Iterator<LineError> indentErrors = this.verifySingleIndent((Seq<NormalizedLine>)normalizedLines);
        Iterator<LineError> classParamListErrors = this.verifyClassIndent((Seq<NormalizedLine>)normalizedLines, classParamIndentSize);
        Iterator<LineError> methodParamListErrors = this.verifyMethodIndent((Seq<NormalizedLine>)normalizedLines, methodParamIndentSize);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)tabErrors.$plus$plus(indentErrors, Seq$.MODULE$.canBuildFrom())).$plus$plus(classParamListErrors, Seq$.MODULE$.canBuildFrom())).$plus$plus(methodParamListErrors, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTabStop$1(IndentationChecker $this, NormalizedLine line) {
        return !$this.isTabAlligned(line);
    }

    private final boolean isInvalid$1(NormalizedLine l1, NormalizedLine l2) {
        return this.isSingleIndent(l2, l1) && !this.startsParamList(l1) && !this.startsMethodDef(l1);
    }

    public static final /* synthetic */ boolean $anonfun$verifySingleIndent$1(Seq check$ifrefutable$1) {
        Seq seq = check$ifrefutable$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifySingleIndent$2(IndentationChecker $this, Seq x$3) {
        Seq seq = x$3;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        NormalizedLine l1 = (NormalizedLine)((SeqLike)some.get()).apply(0);
        NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
        boolean bl = $this.isInvalid$1(l1, l2);
        return bl;
    }

    private final boolean isInvalid$2(NormalizedLine l1, NormalizedLine l2, int classParamIndentSize$1) {
        return this.startsParamList(l1) && !l1.normalizedText().contains(" extends ") ? l2.indentDepth() - l1.indentDepth() != classParamIndentSize$1 : false;
    }

    public static final /* synthetic */ boolean $anonfun$verifyClassIndent$1(Seq check$ifrefutable$2) {
        Seq seq = check$ifrefutable$2;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyClassIndent$2(IndentationChecker $this, int classParamIndentSize$1, Seq x$5) {
        Seq seq = x$5;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        NormalizedLine l1 = (NormalizedLine)((SeqLike)some.get()).apply(0);
        NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
        boolean bl = $this.isInvalid$2(l1, l2, classParamIndentSize$1);
        return bl;
    }

    private final boolean isInvalid$3(NormalizedLine l1, NormalizedLine l2, int methodParamIndentSize$1) {
        return this.startsMethodDef(l1) ? l2.indentDepth() - l1.indentDepth() != methodParamIndentSize$1 : false;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMethodIndent$1(Seq check$ifrefutable$3) {
        Seq seq = check$ifrefutable$3;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMethodIndent$2(IndentationChecker $this, int methodParamIndentSize$1, Seq x$7) {
        Seq seq = x$7;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        NormalizedLine l1 = (NormalizedLine)((SeqLike)some.get()).apply(0);
        NormalizedLine l2 = (NormalizedLine)((SeqLike)some.get()).apply(1);
        boolean bl = $this.isInvalid$3(l1, l2, methodParamIndentSize$1);
        return bl;
    }

    public IndentationChecker() {
        Checker.$init$(this);
        this.DefaultTabSize = 2;
        this.DefaultClassParamTabSize = 4;
        this.errorKey = "indentation";
    }
}

