/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.PointF;
import androidx.annotation.FloatRange;
import com.airbnb.lottie.L;
import com.airbnb.lottie.model.CubicCurveData;
import com.airbnb.lottie.utils.MiscUtils;
import java.util.ArrayList;
import java.util.List;

public class ShapeData {
    private final List<CubicCurveData> curves;
    private PointF initialPoint;
    private boolean closed;

    public ShapeData(PointF initialPoint, boolean closed, List<CubicCurveData> curves) {
        this.initialPoint = initialPoint;
        this.closed = closed;
        this.curves = new ArrayList<CubicCurveData>(curves);
    }

    public ShapeData() {
        this.curves = new ArrayList<CubicCurveData>();
    }

    private void setInitialPoint(float x, float y) {
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        this.initialPoint.set(x, y);
    }

    public PointF getInitialPoint() {
        return this.initialPoint;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List<CubicCurveData> getCurves() {
        return this.curves;
    }

    public void interpolateBetween(ShapeData shapeData1, ShapeData shapeData2, @FloatRange(from=0.0, to=1.0) float percentage) {
        int i;
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        boolean bl = this.closed = shapeData1.isClosed() || shapeData2.isClosed();
        if (shapeData1.getCurves().size() != shapeData2.getCurves().size()) {
            L.warn("Curves must have the same number of control points. Shape 1: " + shapeData1.getCurves().size() + "\tShape 2: " + shapeData2.getCurves().size());
        }
        int points = Math.min(shapeData1.getCurves().size(), shapeData2.getCurves().size());
        if (this.curves.size() < points) {
            for (i = this.curves.size(); i < points; ++i) {
                this.curves.add(new CubicCurveData());
            }
        } else if (this.curves.size() > points) {
            for (i = this.curves.size() - 1; i >= points; --i) {
                this.curves.remove(this.curves.size() - 1);
            }
        }
        PointF initialPoint1 = shapeData1.getInitialPoint();
        PointF initialPoint2 = shapeData2.getInitialPoint();
        this.setInitialPoint(MiscUtils.lerp(initialPoint1.x, initialPoint2.x, percentage), MiscUtils.lerp(initialPoint1.y, initialPoint2.y, percentage));
        for (int i2 = this.curves.size() - 1; i2 >= 0; --i2) {
            CubicCurveData curve1 = shapeData1.getCurves().get(i2);
            CubicCurveData curve2 = shapeData2.getCurves().get(i2);
            PointF cp11 = curve1.getControlPoint1();
            PointF cp21 = curve1.getControlPoint2();
            PointF vertex1 = curve1.getVertex();
            PointF cp12 = curve2.getControlPoint1();
            PointF cp22 = curve2.getControlPoint2();
            PointF vertex2 = curve2.getVertex();
            this.curves.get(i2).setControlPoint1(MiscUtils.lerp(cp11.x, cp12.x, percentage), MiscUtils.lerp(cp11.y, cp12.y, percentage));
            this.curves.get(i2).setControlPoint2(MiscUtils.lerp(cp21.x, cp22.x, percentage), MiscUtils.lerp(cp21.y, cp22.y, percentage));
            this.curves.get(i2).setVertex(MiscUtils.lerp(vertex1.x, vertex2.x, percentage), MiscUtils.lerp(vertex1.y, vertex2.y, percentage));
        }
    }

    public String toString() {
        return "ShapeData{numCurves=" + this.curves.size() + "closed=" + this.closed + '}';
    }
}

