/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.report.cache;

import java.util.LinkedList;
import java.util.ListIterator;
import tv.athena.live.component.business.report.cache.AudioCacheConfig;
import tv.athena.live.component.business.report.cache.AudioCacheFrame;

public class UserCachedAudio {
    private int mCurCachedSize;
    private LinkedList<AudioCacheFrame> mDataList = new LinkedList();
    private static final int MAX_CHCHED_SIZE = 0x100000;
    private long mCurCachedDuration;

    public synchronized void addData(byte[] data, long endTime, long duration) {
        if (data != null && data.length > 0) {
            AudioCacheFrame frame = AudioCacheFrame.obtain(data, endTime, duration);
            this.mDataList.addLast(frame);
            this.mCurCachedSize += data.length;
            this.mCurCachedDuration += duration;
            AudioCacheConfig.mCurCachedSize += (long)data.length;
        }
    }

    public synchronized void discardExpiredData(long expiredTime) {
        AudioCacheFrame frame;
        while (null != (frame = this.mDataList.peekFirst())) {
            if (frame.mEndTime > expiredTime) {
                return;
            }
            this.discardFirstFrame();
        }
        return;
    }

    public synchronized byte[] getCachedAudio(long expiredTime) {
        if (this.mDataList.isEmpty() || this.mCurCachedDuration < 1000L) {
            return null;
        }
        int capbility = this.mCurCachedSize;
        if (capbility > 0x100000) {
            capbility = 0x100000;
        }
        byte[] byteBuf = new byte[capbility];
        int storedSize = 0;
        ListIterator it = this.mDataList.listIterator();
        while (it.hasNext()) {
            byte[] data;
            AudioCacheFrame frame = (AudioCacheFrame)it.next();
            if (frame == null || frame.mEndTime <= expiredTime || (data = frame.mData) == null || data.length <= 0) continue;
            if (byteBuf.length - storedSize < data.length) break;
            System.arraycopy(data, 0, byteBuf, storedSize, data.length);
            storedSize += data.length;
        }
        if (0 == storedSize) {
            return null;
        }
        if (storedSize < byteBuf.length) {
            byte[] actualBuf = new byte[storedSize];
            System.arraycopy(byteBuf, 0, actualBuf, 0, storedSize);
            return actualBuf;
        }
        return byteBuf;
    }

    private synchronized void discardFirstFrame() {
        AudioCacheFrame frame = this.mDataList.removeFirst();
        if (frame != null) {
            if (frame.mData != null) {
                this.mCurCachedSize -= frame.mData.length;
                AudioCacheConfig.mCurCachedSize -= (long)frame.mData.length;
            }
            this.mCurCachedDuration -= frame.mDuration;
            frame.recycle();
        }
    }
}

